/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.internal.util;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.internal.util.BolocXppParser;
import com.businessobjects.visualization.internal.util.ResourceFormat;
import com.businessobjects.visualization.internal.util.Resources;
import com.businessobjects.visualization.internal.util.Strings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

abstract class ResourceFormatHandler {
    private static final ILogger LOG = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$internal$util$ResourceFormatHandler == null ? (class$com$businessobjects$visualization$internal$util$ResourceFormatHandler = ResourceFormatHandler.class$("com.businessobjects.visualization.internal.util.ResourceFormatHandler")) : class$com$businessobjects$visualization$internal$util$ResourceFormatHandler).getName());
    private String[] baseNames_;
    private Locale locale_;
    private static final String[] BOLOC_RESOURCE_FORMATS = new String[]{"", "xml"};
    static /* synthetic */ Class class$com$businessobjects$visualization$internal$util$ResourceFormatHandler;
    static /* synthetic */ Class class$com$businessobjects$visualization$internal$util$BolocXppParser;

    protected ResourceFormatHandler(String[] baseNames, Locale locale) {
        this.baseNames_ = baseNames;
        this.locale_ = locale;
    }

    abstract Resources getBundle();

    protected Locale getLocale() {
        return this.locale_;
    }

    protected String[] getBaseNames() {
        return this.baseNames_;
    }

    protected InputStream loadResource(String baseName, String[] formats, boolean reload) throws IOException {
        int iFormatCount = formats.length;
        for (int iFormatIndex = 0; iFormatIndex < iFormatCount; ++iFormatIndex) {
            InputStream stream;
            URLConnection connection;
            String resourceName = formats[iFormatIndex].equals("") ? baseName : this.toResourceName(baseName, formats[iFormatIndex]);
            URL url = (class$com$businessobjects$visualization$internal$util$BolocXppParser == null ? ResourceFormatHandler.class$("com.businessobjects.visualization.internal.util.BolocXppParser") : class$com$businessobjects$visualization$internal$util$BolocXppParser).getClassLoader().getResource(resourceName);
            if (url == null || (connection = url.openConnection()) == null) continue;
            if (reload) {
                connection.setUseCaches(false);
            }
            if ((stream = connection.getInputStream()) == null) continue;
            return new BufferedInputStream(stream);
        }
        return null;
    }

    private String toResourceName(String bundleName, String format) {
        StringBuffer sb = new StringBuffer(bundleName.length() + 1 + format.length());
        sb.append(bundleName.replace('.', '/')).append('.').append(format);
        return sb.toString();
    }

    static ResourceFormatHandler getHandler(String[] baseNames, Locale locale, ResourceFormat format) {
        if (format == ResourceFormat.DEFAULT) {
            return new DefaultResourceFormatHandler(baseNames, locale);
        }
        if (format == ResourceFormat.BOLOC) {
            return new BolocResourceFormatHandler(baseNames, locale);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BolocResourceFormatHandler
    extends ResourceFormatHandler {
        protected BolocResourceFormatHandler(String[] baseNames, Locale locale) {
            super(baseNames, locale);
        }

        public Resources getBundle() {
            String[] baseNames = this.getBaseNames();
            int iNameCount = baseNames.length;
            InputStream stream = null;
            for (int iNameIndex = 0; iNameIndex < iNameCount; ++iNameIndex) {
                block5: {
                    try {
                        stream = this.loadResource(baseNames[iNameIndex], BOLOC_RESOURCE_FORMATS, false);
                    }
                    catch (IOException objIOException) {
                        if (!LOG.isWarnEnabled()) break block5;
                        LOG.warn((Object)Strings.concatenate(new String[]{"Cannot find resource ", baseNames[iNameIndex], " - IOException: ", objIOException.getMessage()}));
                    }
                }
                if (stream == null) continue;
                try {
                    BolocXppParser parser = new BolocXppParser();
                    Map map = parser.parse(this.getLocale(), stream);
                    if (map == null) continue;
                    return new Resources.BolocResources(baseNames[iNameIndex], this.getLocale(), map);
                }
                catch (IOException objIOException) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Strings.concatenate(new String[]{"Cannot read resource ", baseNames[iNameIndex], " - IOException: ", objIOException.getMessage()}));
                }
            }
            return null;
        }
    }

    public static class DefaultResourceFormatHandler
    extends ResourceFormatHandler {
        protected DefaultResourceFormatHandler(String[] baseNames, Locale locale) {
            super(baseNames, locale);
        }

        public Resources getBundle() {
            String[] baseNames = this.getBaseNames();
            int iNameCount = baseNames.length;
            ResourceBundle bundle = null;
            for (int iNameIndex = 0; iNameIndex < iNameCount; ++iNameIndex) {
                block3: {
                    try {
                        bundle = ResourceBundle.getBundle(baseNames[iNameIndex], this.getLocale());
                    }
                    catch (MissingResourceException objMissingResourceException) {
                        if (!LOG.isWarnEnabled()) break block3;
                        LOG.warn((Object)Strings.concatenate(new String[]{"Cannot find resource ", baseNames[iNameIndex], " - MissingResourceException: ", objMissingResourceException.getMessage()}));
                    }
                }
                if (bundle == null) continue;
                return new Resources.DefaultResources(baseNames[iNameIndex], this.getLocale(), bundle);
            }
            return null;
        }
    }
}

