/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.internal.classloader;

import java.io.InputStream;
import java.net.URL;

public class ClassLoaderHelper {
    private static final IClassLoader s_classLoader;

    public static Class loadClass(String name) throws ClassNotFoundException {
        return s_classLoader.loadClass(name);
    }

    public static InputStream getResourceAsStream(String name) {
        return s_classLoader.getResourceAsStream(name);
    }

    public static URL getResource(String resource) {
        return s_classLoader.getResource(resource);
    }

    static {
        String version = System.getProperty("java.version");
        s_classLoader = version == null || version.startsWith("1.1") ? new IClassLoader(){

            public Class loadClass(String name) throws ClassNotFoundException {
                return Class.forName(name);
            }

            public InputStream getResourceAsStream(String name) {
                InputStream stream = this.getClass().getResourceAsStream(name);
                if (stream == null) {
                    stream = ClassLoader.getSystemResourceAsStream(name);
                }
                return stream;
            }

            public URL getResource(String resource) {
                URL url = this.getClass().getResource(resource);
                if (url == null) {
                    url = ClassLoader.getSystemResource(resource);
                }
                return url;
            }
        } : new IClassLoader(){

            public Class loadClass(String name) throws ClassNotFoundException {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(name);
                }
                catch (Exception e) {
                    return Class.forName(name);
                }
            }

            public InputStream getResourceAsStream(String name) {
                InputStream result = null;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    result = cl.getResourceAsStream(name);
                }
                if (result == null && (result = this.getClass().getClassLoader().getResourceAsStream(name)) == null) {
                    result = ClassLoader.getSystemResourceAsStream(name);
                }
                return result;
            }

            public URL getResource(String resource) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                URL result = null;
                if (cl != null) {
                    result = cl.getResource(resource);
                }
                if (result == null && (result = this.getClass().getClassLoader().getResource(resource)) == null) {
                    result = ClassLoader.getSystemResource(resource);
                }
                return result;
            }
        };
    }

    private static interface IClassLoader {
        public Class loadClass(String var1) throws ClassNotFoundException;

        public InputStream getResourceAsStream(String var1);

        public URL getResource(String var1);
    }
}

