/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.graphic.Palette;
import com.businessobjects.visualization.graphic.RGBHSL;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuColorEffectType;
import com.businessobjects.visualization.graphic.VisuColorType;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLColors;

public class ColorManager
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$ColorManager == null ? (class$com$businessobjects$visualization$graphic$ColorManager = ColorManager.class$("com.businessobjects.visualization.graphic.ColorManager")) : class$com$businessobjects$visualization$graphic$ColorManager));
    private int globalAlpha_;
    private int globalBrightness_;
    private Palette palette_ = new Palette();
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$ColorManager;

    ColorManager() {
    }

    public void setAlpha(int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new VisualizationRuntimeException("VIZ_00085_ERR_INVALID_ALPHA_VALUE_", new Object[]{new Integer(alpha)});
        }
        this.globalAlpha_ = alpha;
    }

    public void setBrightness(int b) {
        if (b < -100 || b > 100) {
            throw new VisualizationRuntimeException("VIZ_00086_ERR_INVALID_BRIGHTNESS_V", new Object[]{new Integer(b)});
        }
        this.globalBrightness_ = b;
    }

    public void setPalette(Palette p) {
        if (p == null) {
            this.palette_ = Palette.DEFAULT_PALETTE;
            LOGGER.warn((Object)"Palette set is null. Using default Palette...");
        }
        this.palette_ = (Palette)p.clone();
    }

    Palette getPalette() {
        Palette vp = (Palette)this.palette_.clone();
        return vp;
    }

    public int addPaletteColor(VisuColor vc) {
        return this.palette_.addColor(vc);
    }

    public void setColor(int index, VisuColor vc) {
        this.palette_.setColor(index, vc);
    }

    public VisuColor getColor(int index) {
        return this.palette_.getColor(index);
    }

    public VisuColor getColor(int index, VisuColorEffectType effect) {
        VisuColor vc = this.getColor(index);
        if (vc != null && vc.getColorType() == VisuColorType.RGBA) {
            VisuRGBA vrgba = (VisuRGBA)vc.getValue();
            if (effect == VisuColorEffectType.ALPHA) {
                vc = new VisuColor(vrgba.getRed(), vrgba.getGreen(), vrgba.getBlue(), this.globalAlpha_);
            } else if (effect == VisuColorEffectType.BRIGHTNESS) {
                double b = (double)this.globalBrightness_ / 100.0 + 1.0;
                vc = new VisuColor(RGBHSL.modifyBrightness(vrgba, b));
            }
        }
        return vc;
    }

    public Object getXMLDelegate() {
        XMLColors xcs = new XMLColors();
        xcs.m_a_alpha = this.globalAlpha_;
        xcs.m_a_brightness = this.globalBrightness_;
        xcs.m_a_palette = this.getPalette().getXmlValue();
        return xcs;
    }

    public int getPaletteSize() {
        return this.palette_.getSize();
    }

    void init(XMLColors xc) {
        if (xc != null) {
            this.globalAlpha_ = xc.m_a_alpha;
            this.globalBrightness_ = xc.m_a_brightness;
            this.palette_ = new Palette(xc.m_a_palette);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

