/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.impl;

import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IMember;
import com.businessobjects.visualization.dataexchange.common.DataType;
import com.businessobjects.visualization.dataexchange.data.InvalidDataTypeException;
import com.businessobjects.visualization.dataexchange.data.impl.DimensionLabelsBaseIterator;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNode;
import com.businessobjects.visualization.formatting.IDateFormatter;
import com.businessobjects.visualization.formatting.IFormatter;
import com.businessobjects.visualization.formatting.INumericFormatter;
import java.util.Date;
import java.util.Properties;

public class TreeMemberImpl
implements IMember {
    private final TreeNode treeNode_;
    private final IDimensionLabelsIterator dimIterator_;
    private int startIndex_;
    private int indexRange_;
    private boolean isValuated_;
    private IDimensionLabelsIterator memberChildIterator_;
    private TreeMemberImpl parentMember_;
    private TreeMemberImpl[] childMembers_;

    protected TreeMemberImpl(TreeNode treeNode, IDimensionLabelsIterator dimIterator) {
        this.treeNode_ = treeNode;
        this.dimIterator_ = dimIterator;
        this.isValuated_ = false;
        this.indexRange_ = 0;
        this.startIndex_ = -1;
    }

    public Object getValue() {
        return this.treeNode_.getValue();
    }

    public String getFormattedValue() {
        return null;
    }

    public DataType getDataType() {
        return this.treeNode_.getType();
    }

    public boolean isLeaf() {
        return this.treeNode_.isLeaf() && this.dimIterator_.getChildDimensionLabelsIterator() == null;
    }

    public boolean isValuated() {
        return this.isValuated_;
    }

    public IMember getParentMember() {
        if (this.parentMember_ == null) {
            this.parentMember_ = new TreeMemberImpl(this.treeNode_.getParent(), this.dimIterator_);
        }
        return this.parentMember_;
    }

    public IMember[] getChildMembers() {
        if (this.childMembers_ == null) {
            // empty if block
        }
        return this.childMembers_;
    }

    public int getDimensionIndex() {
        return this.dimIterator_.getDimensionIndex();
    }

    public int getLevel() {
        return this.treeNode_.getLevel();
    }

    public int getStartIndex() {
        return this.startIndex_;
    }

    public int getIndexRange() {
        return this.indexRange_;
    }

    public IDimensionLabelsIterator getNextStackedDimensionIterator() {
        if (this.memberChildIterator_ == null && this.dimIterator_.getChildDimensionLabelsIterator() != null) {
            this.memberChildIterator_ = ((DimensionLabelsBaseIterator)this.dimIterator_.getChildDimensionLabelsIterator()).createFramedIterator(this.startIndex_, this.indexRange_);
        }
        return this.memberChildIterator_;
    }

    public Properties getProperties() {
        return this.treeNode_.getProperties();
    }

    public void setIndexRange(int indexRange) {
        this.indexRange_ = indexRange;
    }

    public void setValuated(boolean isValuated) {
        this.isValuated_ = isValuated;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex_ = startIndex;
    }

    TreeNode getTreeNode() {
        return this.treeNode_;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof TreeMemberImpl)) {
            return false;
        }
        return this.treeNode_.equals(((TreeMemberImpl)oThat).treeNode_);
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeHelper.hash(result, this.treeNode_);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TreeMemberImpl[");
        buffer.append("indexRange = ").append(this.indexRange_);
        buffer.append(" startIndex = ").append(this.startIndex_);
        buffer.append(" treeNode = ").append(this.treeNode_);
        buffer.append("]");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedValue(IFormatter formatter) {
        if (this.treeNode_.getType().equals(DataType.DOUBLE) && !(formatter instanceof INumericFormatter)) {
            throw new InvalidDataTypeException("VIZ_00023_ERR_FORMATTER_REQUIRED_S");
        }
        if (this.treeNode_.getType().equals(DataType.DATE) && !(formatter instanceof IDateFormatter)) {
            throw new InvalidDataTypeException("VIZ_00024_ERR_FORMATTER_REQUIRED_S");
        }
        if (this.treeNode_.getType().equals(DataType.STRING) || this.treeNode_.getType().equals(DataType.UNKNOWN)) {
            throw new InvalidDataTypeException("VIZ_00025_ERR_THIS_MEMBER_TYPE_DOE");
        }
        TreeNode treeNode = this.treeNode_;
        synchronized (treeNode) {
            if (formatter instanceof INumericFormatter) {
                ((INumericFormatter)formatter).format((Double)this.treeNode_.getValue());
            } else if (formatter instanceof IDateFormatter) {
                ((IDateFormatter)formatter).format((Date)this.treeNode_.getValue());
            }
            return formatter.out();
        }
    }

    public Object getArrayValueImpl() {
        return this.treeNode_;
    }
}

