/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data.graph.impl;

import com.businessobjects.visualization.common.internal.HashCodeHelper;
import com.businessobjects.visualization.dataexchange.common.DataStructure;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.Data;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.DimensionLabelsAdapter;
import com.businessobjects.visualization.dataexchange.data.graph.IAxisTree;
import com.businessobjects.visualization.dataexchange.data.graph.impl.AxisTreeImpl;
import com.businessobjects.visualization.dataexchange.data.graph.impl.NodeImpl;
import com.businessobjects.visualization.dataexchange.data.impl.TreeNode;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AxisTreeBuilder {
    static final String DUMMY_ROOT = "Dummy Root";
    private Data[] stackedData_;
    private LinkedHashMap valuesToNodeNestedMapList_;
    private AxisTreeImpl axisTree_;
    private NodeImpl rootNode_;
    private NodeEntry rootNodeEntry_;
    private int nRows_;
    private int nCols_;
    private int nodeCount_;
    private DataRange[] dataRangeList_;

    public AxisTreeBuilder(Data[] stackedData) {
        this(stackedData, null);
    }

    public AxisTreeBuilder(Data[] stackedData, DataRange[] dataRangeList) {
        this.dataRangeList_ = dataRangeList;
        this.init(stackedData);
    }

    public AxisTreeBuilder(AnalysisAxisAdapter adapter) {
        this(adapter, 0, null);
    }

    public AxisTreeBuilder(AnalysisAxisAdapter adapter, int startDimIndex, DataRange[] dataRangeList) {
        DimensionLabelsAdapter[] dlaList = adapter.getDimensionLabelsList();
        if (startDimIndex >= dlaList.length) {
            throw new IllegalArgumentException("invalid start dim index:" + startDimIndex);
        }
        this.dataRangeList_ = dataRangeList;
        Data[] dataList = new Data[dlaList.length];
        for (int i = startDimIndex; i < dataList.length; ++i) {
            dataList[i] = dlaList[i].getData();
        }
        this.init(dataList);
    }

    private void init(Data[] stackedData) {
        this.stackedData_ = stackedData;
        this.valuesToNodeNestedMapList_ = new LinkedHashMap();
        this.nRows_ = this.stackedData_[0].getValuesCount(1);
        this.nCols_ = this.stackedData_.length;
        this.nodeCount_ = 0;
        this.process();
    }

    private NodeEntry getValuesToNodeMap(Object[] values, int row) {
        NodeEntry currEntry = this.getRoot();
        for (int i = 0; i < values.length - 1; ++i) {
            MergeableNodeKeyImpl nodeKey = new MergeableNodeKeyImpl(values[i]);
            if (currEntry.map_.get(nodeKey) == null) {
                NodeImpl node = null;
                if (values[i] instanceof TreeNode) {
                    TreeNode tnode = (TreeNode)values[i];
                    node = new NodeImpl(-1, tnode.getType(), i, tnode.getValue(), tnode.getProperties(), tnode.getLevel());
                } else {
                    node = new NodeImpl(-1, this.stackedData_[i].getType(), i, values[i], null, 0);
                }
                ++this.nodeCount_;
                currEntry.map_.put(nodeKey, new NodeEntry(node, new LinkedHashMap()));
            }
            currEntry = (NodeEntry)currEntry.map_.get(nodeKey);
        }
        return currEntry;
    }

    private boolean putNode(Object[] values, NodeImpl node, int row) {
        NodeEntry entry = this.getValuesToNodeMap(values, row);
        LeafNodeKeyImpl leafKey = new LeafNodeKeyImpl(row, values[values.length - 1]);
        if (entry.map_.containsKey(leafKey)) {
            return false;
        }
        entry.map_.put(leafKey, node);
        return true;
    }

    private NodeEntry getRoot() {
        if (this.rootNode_ == null) {
            if (this.stackedData_[0].getStructure() == DataStructure.SIMPLE) {
                this.rootNode_ = new NodeImpl(-1, null, -1, DUMMY_ROOT, null, 0);
            } else {
                TreeNode[] firstList = (TreeNode[])this.stackedData_[0].getValues();
                TreeNode currTreeNode = firstList[0].getRoot();
                int absIndex = -1;
                if (this.stackedData_.length == 1) {
                    for (int i = 0; i < firstList.length; ++i) {
                        if (currTreeNode != firstList[i]) continue;
                        absIndex = i;
                        break;
                    }
                }
                this.rootNode_ = new NodeImpl(absIndex, currTreeNode.getType(), 0, currTreeNode.getValue(), currTreeNode.getProperties(), currTreeNode.getLevel());
                this.valuesToNodeNestedMapList_.put(new MergeableNodeKeyImpl(currTreeNode), new NodeEntry(this.rootNode_, new LinkedHashMap()));
            }
            this.rootNodeEntry_ = new NodeEntry(this.rootNode_, this.valuesToNodeNestedMapList_);
            ++this.nodeCount_;
        }
        return this.rootNodeEntry_;
    }

    private void putNode(Object[] values, int row) {
        NodeImpl node = null;
        if (values[this.nCols_ - 1] instanceof TreeNode) {
            TreeNode tnode = (TreeNode)values[this.nCols_ - 1];
            node = new NodeImpl(row, tnode.getType(), this.nCols_ - 1, tnode.getValue(), tnode.getProperties(), tnode.getLevel());
        } else {
            Properties[] props = (Properties[])this.stackedData_[this.nCols_ - 1].getProperties();
            node = new NodeImpl(row, this.stackedData_[this.nCols_ - 1].getType(), this.nCols_ - 1, values[this.nCols_ - 1], props != null ? props[row] : null, 0);
        }
        if (this.putNode(values, node, row)) {
            ++this.nodeCount_;
        }
    }

    private void process() {
        int nRange;
        int startIdx = 0;
        int endIdx = this.nRows_;
        int n = nRange = this.dataRangeList_ == null ? 1 : this.dataRangeList_.length;
        for (int currRange = 0; currRange < nRange; ++currRange) {
            if (this.dataRangeList_ != null) {
                startIdx = this.dataRangeList_[currRange].getLower();
                endIdx = this.dataRangeList_[currRange].getUpper() + 1;
            }
            for (int i = startIdx; i < endIdx; ++i) {
                Object[] rowValues = new Object[this.nCols_];
                for (int j = 0; j < this.nCols_; ++j) {
                    rowValues[j] = ((Object[])this.stackedData_[j].getValues())[i];
                }
                this.putNode(rowValues, i);
            }
        }
        this.axisTree_ = new AxisTreeImpl(null, this.nodeCount_ + 1, this.rootNode_);
        this.resolveHierarchies(this.getRoot());
        this.recurseMaps(this.getRoot());
    }

    private NodeImpl getNodeFromMap(Object mapValueEntry) {
        NodeImpl currNodeImpl = null;
        if (mapValueEntry instanceof NodeEntry) {
            currNodeImpl = ((NodeEntry)mapValueEntry).node_;
        } else if (mapValueEntry != null) {
            currNodeImpl = (NodeImpl)mapValueEntry;
        }
        return currNodeImpl;
    }

    private void resolveHierarchies(NodeEntry nodeEntry) {
        Set entrySet = nodeEntry.map_.entrySet();
        Iterator iter = entrySet.iterator();
        LinkedHashMap<INodeKey, NodeImpl> newMap = new LinkedHashMap<INodeKey, NodeImpl>();
        while (iter.hasNext()) {
            INodeKey nodeKey;
            Map.Entry entry = iter.next();
            if (entry.getValue() instanceof NodeEntry) {
                this.resolveHierarchies((NodeEntry)entry.getValue());
            }
            if (!((nodeKey = (INodeKey)entry.getKey()).getValue() instanceof TreeNode)) continue;
            TreeNode node = (TreeNode)nodeKey.getValue();
            NodeImpl currNodeImpl = this.getNodeFromMap(entry.getValue());
            for (TreeNode pnode = node.getParent(); pnode != null; pnode = pnode.getParent()) {
                NodeImpl nodeimpl = null;
                INodeKey pnodeKey = nodeEntry.searchKey(pnode);
                if (pnodeKey == null) {
                    pnodeKey = nodeKey instanceof LeafNodeKeyImpl ? new LeafNodeKeyImpl(-1, pnode) : new MergeableNodeKeyImpl(pnode);
                }
                if (!nodeEntry.map_.containsKey(pnodeKey)) {
                    if (!newMap.containsKey(pnodeKey)) {
                        nodeimpl = new NodeImpl(-1, pnode.getType(), currNodeImpl.getDimensionIndex(), pnode.getValue(), pnode.getProperties(), pnode.getLevel());
                        newMap.put(pnodeKey, nodeimpl);
                    } else {
                        nodeimpl = (NodeImpl)newMap.get(pnodeKey);
                    }
                } else {
                    nodeimpl = this.getNodeFromMap(nodeEntry.map_.get(pnodeKey));
                }
                if (!this.axisTree_.areBoundNodes(nodeimpl, currNodeImpl)) {
                    this.axisTree_.insertEdge(nodeimpl, currNodeImpl);
                }
                currNodeImpl = nodeimpl;
            }
        }
        nodeEntry.map_.putAll(newMap);
    }

    private void recurseMaps(NodeEntry nodeEntry) {
        Set entrySet = nodeEntry.map_.entrySet();
        NodeImpl parentNode = nodeEntry.node_;
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            NodeImpl childNode = null;
            if (entry.getValue() instanceof NodeEntry) {
                this.recurseMaps((NodeEntry)entry.getValue());
            }
            if ((childNode = this.getNodeFromMap(entry.getValue())).getDimensionIndex() != parentNode.getDimensionIndex() + 1) continue;
            INodeKey nodeKey = (INodeKey)entry.getKey();
            if (nodeKey.getValue() instanceof TreeNode) {
                TreeNode t = (TreeNode)nodeKey.getValue();
                INodeKey daRootKey = nodeEntry.searchKey(t.getRoot());
                childNode = this.getNodeFromMap(nodeEntry.map_.get(daRootKey));
            }
            if (this.axisTree_.areBoundNodes(parentNode, childNode)) continue;
            this.axisTree_.insertEdge(parentNode, childNode);
        }
    }

    public IAxisTree getAxisTree() {
        return this.axisTree_;
    }

    private class NodeEntry {
        private NodeImpl node_;
        private LinkedHashMap map_;

        public NodeEntry(NodeImpl node, LinkedHashMap map) {
            this.node_ = node;
            this.map_ = map;
        }

        public INodeKey searchKey(Object value) {
            INodeKey key = null;
            Set keySet = this.map_.keySet();
            Iterator keyIter = keySet.iterator();
            while (keyIter.hasNext()) {
                INodeKey akey = (INodeKey)keyIter.next();
                if (akey == null) continue;
                if (akey.getValue() == null) {
                    if (value != null) continue;
                    key = akey;
                    break;
                }
                if (!akey.getValue().equals(value)) continue;
                key = akey;
                break;
            }
            return key;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("NodeImpl Value:" + (this.node_ != null ? this.node_.getValue() : null) + "\n");
            sb.append("LinkedHashMap Value:");
            if (this.map_ == null) {
                sb.append("null\n");
            } else {
                sb.append("\n");
                Iterator iter = this.map_.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    sb.append("  key=" + entry.getKey().toString() + "=");
                    sb.append(entry.getValue().toString() + "\n");
                }
            }
            return sb.toString();
        }
    }

    private class LeafNodeKeyImpl
    implements INodeKey {
        private Object value_;
        private int ordinal_;

        public LeafNodeKeyImpl(int ordinal, Object value) {
            this.value_ = value;
            this.ordinal_ = ordinal;
        }

        public Object getValue() {
            return this.value_;
        }

        public boolean equals(Object oThat) {
            if (this == oThat) {
                return true;
            }
            if (!(oThat instanceof LeafNodeKeyImpl)) {
                return false;
            }
            return this.value_.equals(((LeafNodeKeyImpl)oThat).value_) && this.ordinal_ == ((LeafNodeKeyImpl)oThat).ordinal_;
        }

        public int hashCode() {
            int result = 23;
            result = HashCodeHelper.hash(result, this.value_);
            result = HashCodeHelper.hash(result, this.ordinal_);
            return result;
        }
    }

    private class MergeableNodeKeyImpl
    implements INodeKey {
        private Object value_;

        public MergeableNodeKeyImpl(Object value) {
            this.value_ = value;
        }

        public Object getValue() {
            return this.value_;
        }

        public boolean equals(Object oThat) {
            if (this == oThat) {
                return true;
            }
            if (!(oThat instanceof MergeableNodeKeyImpl)) {
                return false;
            }
            return this.value_.equals(((MergeableNodeKeyImpl)oThat).value_);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }
    }

    private static interface INodeKey {
        public Object getValue();
    }
}

