/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.dataexchange.data;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.callbacks.IDimensionLabelsIterator;
import com.businessobjects.visualization.dataexchange.callbacks.IValuesGrid;
import com.businessobjects.visualization.dataexchange.data.AnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.DataRange;
import com.businessobjects.visualization.dataexchange.data.MeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.SubDatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLAnalysisAxisAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLDatasetAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLMeasureValuesGroupAdapter;
import com.businessobjects.visualization.dataexchange.data.generated.XMLSubDatasetAdapter;
import java.util.Iterator;

public class DatasetAdapter
implements IXMLDelegator {
    private static final ILogger LOGGER = LoggerManager.getLogger((String)(class$com$businessobjects$visualization$dataexchange$data$DatasetAdapter == null ? (class$com$businessobjects$visualization$dataexchange$data$DatasetAdapter = DatasetAdapter.class$("com.businessobjects.visualization.dataexchange.data.DatasetAdapter")) : class$com$businessobjects$visualization$dataexchange$data$DatasetAdapter).getName());
    public static final int ALL_LABELS_MODE = -1;
    private AnalysisAxisAdapter[] axes_;
    private MeasureValuesGroupAdapter[] valueGroups_;
    private DatasetAdapter[] subDatasets_;
    private boolean isFlat_;
    static /* synthetic */ Class class$com$businessobjects$visualization$dataexchange$data$DatasetAdapter;

    public DatasetAdapter() {
        this.axes_ = new AnalysisAxisAdapter[0];
        this.valueGroups_ = new MeasureValuesGroupAdapter[0];
        this.subDatasets_ = new DatasetAdapter[0];
    }

    public DatasetAdapter(XMLDatasetAdapter xmlDataset, SerializationHelper sh) {
        this();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Deserializing DatasetAdapter (current version:" + sh.getCurrentVersion() + ") from stream (serialized version:" + sh.getSerializedVersion() + ")"));
        }
        Iterator iter = null;
        iter = xmlDataset.m_list_subDatasetListAdapter.iterator();
        this.subDatasets_ = new SubDatasetAdapter[xmlDataset.m_list_subDatasetListAdapter.size()];
        int i = 0;
        while (iter.hasNext()) {
            SubDatasetAdapter sds = new SubDatasetAdapter((XMLSubDatasetAdapter)iter.next(), sh);
            sds.setDependentDataset(this);
            this.subDatasets_[i++] = sds;
        }
        iter = xmlDataset.m_list_analysisAxisListAdapter.iterator();
        this.axes_ = new AnalysisAxisAdapter[xmlDataset.m_list_analysisAxisListAdapter.size()];
        i = 0;
        while (iter.hasNext()) {
            AnalysisAxisAdapter ax = new AnalysisAxisAdapter((XMLAnalysisAxisAdapter)iter.next(), sh);
            this.axes_[i++] = ax;
        }
        iter = xmlDataset.m_list_measureValuesGroupListAdapter.iterator();
        this.valueGroups_ = new MeasureValuesGroupAdapter[xmlDataset.m_list_measureValuesGroupListAdapter.size()];
        i = 0;
        while (iter.hasNext()) {
            MeasureValuesGroupAdapter mvg = new MeasureValuesGroupAdapter((XMLMeasureValuesGroupAdapter)iter.next(), sh);
            this.valueGroups_[i++] = mvg;
        }
    }

    public DatasetAdapter(AnalysisAxisAdapter[] axes, MeasureValuesGroupAdapter[] valueGroups, DatasetAdapter[] subDatasets) {
        this.axes_ = axes;
        this.valueGroups_ = valueGroups;
        this.subDatasets_ = subDatasets;
    }

    public AnalysisAxisAdapter[] getAxisList() {
        return this.axes_;
    }

    public MeasureValuesGroupAdapter[] getValueGroupList() {
        return this.valueGroups_;
    }

    public DatasetAdapter[] getSubDatasets() {
        return this.subDatasets_;
    }

    public int getCardinality() {
        return this.axes_.length;
    }

    public void setAxisList(AnalysisAxisAdapter[] axes) {
        this.axes_ = axes;
    }

    public void setSubDatasets(DatasetAdapter[] subDatasets) {
        this.subDatasets_ = subDatasets;
    }

    public void setValueGroups(MeasureValuesGroupAdapter[] valueGroups) {
        this.valueGroups_ = valueGroups;
    }

    public Object getXMLDelegate() {
        int i;
        XMLDatasetAdapter xmlDataset = new XMLDatasetAdapter();
        for (i = 0; i < this.subDatasets_.length; ++i) {
            xmlDataset.m_list_subDatasetListAdapter.add(this.subDatasets_[i].getXMLDelegate());
        }
        for (i = 0; i < this.axes_.length; ++i) {
            xmlDataset.m_list_analysisAxisListAdapter.add(this.axes_[i].getXMLDelegate());
        }
        for (i = 0; i < this.valueGroups_.length; ++i) {
            xmlDataset.m_list_measureValuesGroupListAdapter.add(this.valueGroups_[i].getXMLDelegate());
        }
        return xmlDataset;
    }

    public IDimensionLabelsIterator getLabelsIterator(int axis, int dimensionLabelsIndex, DataRange dataRange, int maxDepth) {
        return this.getLabelsIterator(axis, dimensionLabelsIndex, dataRange, maxDepth, -1);
    }

    public IDimensionLabelsIterator getLabelsIterator(int axis, int dimensionLabelsIndex, DataRange dataRange, int maxDepth, int maxLevel) {
        return this.axes_[axis].getDimensionLabelsIterator(this, axis, dimensionLabelsIndex, dataRange, maxDepth, maxLevel);
    }

    public IDimensionLabelsIterator getLabelsIterator(int axis, int dimensionLabelsIndex, DataRange dataRange) {
        return this.getLabelsIterator(axis, dimensionLabelsIndex, dataRange, -1, -1);
    }

    public IDimensionLabelsIterator getLabelsIterator(int axis, int dimensionLabelsIndex) {
        return this.getLabelsIterator(axis, dimensionLabelsIndex, null);
    }

    public IValuesGrid getValuesGrid(int measureGroup, int measureValuesIndex) {
        return this.valueGroups_[measureGroup].getMeasureValuesList()[measureValuesIndex].getGridCallback();
    }

    public boolean isFlat() {
        return this.isFlat_;
    }

    public void setFlat(boolean bValue) {
        this.isFlat_ = bValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

