/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(BLOB blob, byte[] pattern, long startPos) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long __result__ = LobPlsqlUtil.hasPattern(blob.getInternalConnection(), blob, 2004, pattern, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long isSubLob(BLOB blob, BLOB subLob, long startPos) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(blob) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long __result__ = LobPlsqlUtil.isSubLob(blob.getInternalConnection(), blob, 2004, subLob, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var9_11 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable2) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long hasPattern(CLOB clob, char[] pattern, long startPos) throws SQLException {
        try {
            block47: {
                if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                        var5_3 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var4_6) {
                        var5_4 = null;
                        OracleLog.recursiveExit();
                        throw var4_6;
                    }
                }
                if (pattern != null && startPos > 0L) ** GOTO lbl38
                if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        var7_9 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var6_12) {
                        var7_10 = null;
                        OracleLog.recursiveExit();
                        throw var6_12;
                    }
                }
                var4_7 = 0L;
                var28_13 = null;
                if (LobPlsqlUtil.TRACE == false) return var4_7;
                if (OracleLog.recursiveEnter() == false) return var4_7;
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var30_21 = null;
                OracleLog.recursiveExit();
                return var4_7;
lbl38:
                // 1 sources

                conn = clob.getInternalConnection();
                patternLen = pattern.length;
                lobLen = LobPlsqlUtil.length(conn, clob, 2005);
                if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            var10_45 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable var9_49) {
                            var10_46 = null;
                            OracleLog.recursiveExit();
                            throw var9_49;
                        }
                    }
                    var9_50 = 0L;
                    var28_14 = null;
                    if (LobPlsqlUtil.TRACE == false) return var9_50;
                    if (OracleLog.recursiveEnter() == false) return var9_50;
                    ** try [egrp 10[TRYBLOCK] [26 : 939->956)] { 
lbl60:
                    // 1 sources

                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    var30_23 = null;
                    OracleLog.recursiveExit();
                    return var9_50;
                }
                if (patternLen > (long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn)) break block47;
                cstmt = null;
                cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                cstmt.registerOutParameter(1, 2);
                if (clob.isNCLOB()) {
                    cstmt.setFormOfUse(2, (short)2);
                    cstmt.setFormOfUse(3, (short)2);
                }
                cstmt.setCLOB(2, clob);
                cstmt.setString(3, new String(pattern));
                cstmt.setLong(4, startPos);
                cstmt.execute();
                __result__ = cstmt.getLong(1);
                if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        var13_53 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var12_56) {
                        var13_54 = null;
                        OracleLog.recursiveExit();
                        throw var12_56;
                    }
                }
                var12_57 = __result__;
                var15_59 = null;
                catch (Throwable var14_62) {
                    var15_60 = null;
                    cstmt.close();
                    cstmt = null;
                    throw var14_62;
                }
                {
                    cstmt.close();
                    cstmt = null;
                    var28_15 = null;
                    if (LobPlsqlUtil.TRACE == false) return var12_57;
                    if (OracleLog.recursiveEnter() == false) return var12_57;
                    ** try [egrp 10[TRYBLOCK] [26 : 939->956)] { 
lbl107:
                    // 1 sources

                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    var30_25 = null;
                    OracleLog.recursiveExit();
                    return var12_57;
                }
                catch (Throwable var29_37) {
                    var30_22 = null;
                    OracleLog.recursiveExit();
                    throw var29_37;
                }
lbl117:
                // 1 sources

                catch (Throwable var29_38) {
                    var30_24 = null;
                    OracleLog.recursiveExit();
                    throw var29_38;
                }
lbl122:
                // 1 sources

                catch (Throwable var29_39) {
                    var30_26 = null;
                    OracleLog.recursiveExit();
                    throw var29_39;
                }
            }
            matchedLen = 0;
            subStartPos = startPos;
            done = false;
            matchedPos = 0L;
            block29: while (true) {
                if (!done) {
                    if (patternLen > lobLen - subStartPos + 1L) {
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var20_70 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable var19_66) {
                                var20_71 = null;
                                OracleLog.recursiveExit();
                                throw var19_66;
                            }
                        }
                        var19_67 = 0L;
                        var28_16 = null;
                        if (LobPlsqlUtil.TRACE == false) return var19_67;
                        if (OracleLog.recursiveEnter() == false) return var19_67;
                        ** try [egrp 10[TRYBLOCK] [26 : 939->956)] { 
lbl153:
                        // 1 sources

                        LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                        var30_27 = null;
                        OracleLog.recursiveExit();
                        return var19_67;
                    }
                    matchedLen = 0;
                    subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                    subPattern = new char[subPatternLen];
                    System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                    subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                    if (subMatchedPos == 0L) {
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var22_73 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable var21_75) {
                                var22_74 = null;
                                OracleLog.recursiveExit();
                                throw var21_75;
                            }
                        }
                        var19_68 = 0L;
                        var28_17 = null;
                        if (LobPlsqlUtil.TRACE == false) return var19_68;
                        if (OracleLog.recursiveEnter() == false) return var19_68;
                        ** try [egrp 10[TRYBLOCK] [26 : 939->956)] { 
lbl182:
                        // 1 sources

                        LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                        var30_29 = null;
                        OracleLog.recursiveExit();
                        return var19_68;
                    }
                    matchedPos = subMatchedPos;
                    matchedLen += subPatternLen;
                } else {
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                            var26_79 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable var25_81) {
                            var26_80 = null;
                            OracleLog.recursiveExit();
                            throw var25_81;
                        }
                    }
                    var19_69 = matchedPos;
                    var28_19 = null;
                    if (LobPlsqlUtil.TRACE == false) return var19_69;
                    if (OracleLog.recursiveEnter() == false) return var19_69;
                    ** try [egrp 10[TRYBLOCK] [26 : 939->956)] { 
lbl208:
                    // 1 sources

                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    var30_33 = null;
                    OracleLog.recursiveExit();
                    return var19_69;
lbl213:
                    // 1 sources

                    catch (Throwable var29_40) {
                        var30_28 = null;
                        OracleLog.recursiveExit();
                        throw var29_40;
                    }
lbl218:
                    // 1 sources

                    catch (Throwable var29_41) {
                        var30_30 = null;
                        OracleLog.recursiveExit();
                        throw var29_41;
                    }
                }
                subStartPos = subMatchedPos + (long)subPatternLen;
                moreChunks = true;
                while (true) {
                    if (!moreChunks) continue block29;
                    subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                    subPattern = new char[subPatternLen];
                    System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                    subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                    if (subMatchedPos == subStartPos) {
                        subStartPos += (long)subPatternLen;
                        if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                        moreChunks = false;
                        done = true;
                        continue;
                    }
                    if (subMatchedPos == 0L) {
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var24_76 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable var23_78) {
                                var24_77 = null;
                                OracleLog.recursiveExit();
                                throw var23_78;
                            }
                        }
                        var20_72 = 0L;
                        var28_18 = null;
                        if (LobPlsqlUtil.TRACE == false) return var20_72;
                        if (OracleLog.recursiveEnter() == false) return var20_72;
                        ** try [egrp 10[TRYBLOCK] [26 : 939->956)] { 
lbl256:
                        // 1 sources

                        LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                        var30_31 = null;
                        OracleLog.recursiveExit();
                        return var20_72;
                    }
                    subStartPos = subMatchedPos - (long)matchedLen;
                    moreChunks = false;
                }
                break;
            }
        }
        catch (Throwable var27_82) {
            var28_20 = null;
            if (LobPlsqlUtil.TRACE == false) throw var27_82;
            if (OracleLog.recursiveEnter() == false) throw var27_82;
            try {}
            catch (Throwable var29_44) {
                var30_36 = null;
                OracleLog.recursiveExit();
                throw var29_44;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            var30_35 = null;
            OracleLog.recursiveExit();
            throw var27_82;
lbl280:
            // 1 sources

            catch (Throwable var29_42) {
                var30_32 = null;
                OracleLog.recursiveExit();
                throw var29_42;
            }
lbl285:
            // 1 sources

            catch (Throwable var29_43) {
                var30_34 = null;
                OracleLog.recursiveExit();
                throw var29_43;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long isSubLob(CLOB clob, CLOB subLob, long startPos) throws SQLException {
        try {
            block48: {
                block47: {
                    block46: {
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                                var5_3 = null;
                            }
                            catch (Throwable var4_6) {
                                var5_4 = null;
                                OracleLog.recursiveExit();
                                throw var4_6;
                            }
                            OracleLog.recursiveExit();
                        }
                        if (subLob != null && startPos > 0L) break block46;
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var7_9 = null;
                            }
                            catch (Throwable var6_12) {
                                var7_10 = null;
                                OracleLog.recursiveExit();
                                throw var6_12;
                            }
                            OracleLog.recursiveExit();
                        }
                        var4_7 = 0L;
                        var28_13 = null;
                        if (LobPlsqlUtil.TRACE == false) return var4_7;
                        ** GOTO lbl197
                    }
                    conn = clob.getInternalConnection();
                    patternLen = LobPlsqlUtil.length(conn, subLob, 2005);
                    lobLen = LobPlsqlUtil.length(conn, clob, 2005);
                    if (patternLen != 0L && patternLen <= lobLen - startPos + 1L && startPos <= lobLen) break block47;
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            var10_45 = null;
                        }
                        catch (Throwable var9_49) {
                            var10_46 = null;
                            OracleLog.recursiveExit();
                            throw var9_49;
                        }
                        OracleLog.recursiveExit();
                    }
                    var9_50 = 0L;
                    ** GOTO lbl210
                }
                if (patternLen > (long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn)) break block48;
                pattern = new char[(int)patternLen];
                subLob.getChars(1L, (int)patternLen, pattern);
                __result__ = LobPlsqlUtil.hasPattern(clob, pattern, startPos);
                if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        var13_53 = null;
                    }
                    catch (Throwable var12_56) {
                        var13_54 = null;
                        OracleLog.recursiveExit();
                        throw var12_56;
                    }
                    OracleLog.recursiveExit();
                }
                var12_57 = __result__;
                ** GOTO lbl225
            }
            matchedLen = 0;
            subStartPos = startPos;
            done = false;
            matchedPos = 0L;
            while (!done) {
                block50: {
                    block49: {
                        if (patternLen <= lobLen - subStartPos + 1L) break block49;
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var20_67 = null;
                            }
                            catch (Throwable var19_63) {
                                var20_68 = null;
                                OracleLog.recursiveExit();
                                throw var19_63;
                            }
                            OracleLog.recursiveExit();
                        }
                        var19_64 = 0L;
                        ** GOTO lbl240
                    }
                    matchedLen = 0;
                    subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                    subPattern = new char[subPatternLen];
                    subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
                    subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                    if (subMatchedPos != 0L) break block50;
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            var22_70 = null;
                        }
                        catch (Throwable var21_72) {
                            var22_71 = null;
                            OracleLog.recursiveExit();
                            throw var21_72;
                        }
                        OracleLog.recursiveExit();
                    }
                    var19_65 = 0L;
                    ** GOTO lbl255
                }
                matchedPos = subMatchedPos;
                matchedLen += subPatternLen;
                subStartPos = subMatchedPos + (long)subPatternLen;
                moreChunks = true;
                while (moreChunks) {
                    subPatternLen = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(conn), patternLen - (long)matchedLen);
                    subPattern = new char[subPatternLen];
                    subLob.getChars(matchedLen + 1, subPatternLen, subPattern);
                    subMatchedPos = LobPlsqlUtil.hasPattern(clob, subPattern, subStartPos);
                    if (subMatchedPos == subStartPos) {
                        subStartPos += (long)subPatternLen;
                        if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                        moreChunks = false;
                        done = true;
                        continue;
                    }
                    if (subMatchedPos == 0L) {
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var24_73 = null;
                            }
                            catch (Throwable var23_75) {
                                var24_74 = null;
                                OracleLog.recursiveExit();
                                throw var23_75;
                            }
                            OracleLog.recursiveExit();
                        }
                        var20_69 = 0L;
                        var28_18 = null;
                        if (LobPlsqlUtil.TRACE == false) return var20_69;
                        if (OracleLog.recursiveEnter() == false) return var20_69;
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                            var30_31 = null;
                        }
                        catch (Throwable var29_42) {
                            var30_32 = null;
                            OracleLog.recursiveExit();
                            throw var29_42;
                        }
                        OracleLog.recursiveExit();
                        return var20_69;
                    }
                    subStartPos = subMatchedPos - (long)matchedLen;
                    moreChunks = false;
                }
            }
            if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                    var26_76 = null;
                }
                catch (Throwable var25_78) {
                    var26_77 = null;
                    OracleLog.recursiveExit();
                    throw var25_78;
                }
                OracleLog.recursiveExit();
            }
            var19_66 = matchedPos;
            ** GOTO lbl270
        }
        catch (Throwable var27_79) {
            block51: {
                var28_20 = null;
                if (LobPlsqlUtil.TRACE == false) throw var27_79;
                if (OracleLog.recursiveEnter() == false) throw var27_79;
                try {}
                catch (Throwable var29_44) {
                    var30_36 = null;
                    OracleLog.recursiveExit();
                    throw var29_44;
                }
                break block51;
lbl197:
                // 1 sources

                if (OracleLog.recursiveEnter() == false) return var4_7;
                try {}
                catch (Throwable var29_37) {
                    var30_22 = null;
                    OracleLog.recursiveExit();
                    throw var29_37;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var30_21 = null;
                OracleLog.recursiveExit();
                return var4_7;
lbl210:
                // 1 sources

                var28_14 = null;
                if (LobPlsqlUtil.TRACE == false) return var9_50;
                if (OracleLog.recursiveEnter() == false) return var9_50;
                try {}
                catch (Throwable var29_38) {
                    var30_24 = null;
                    OracleLog.recursiveExit();
                    throw var29_38;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var30_23 = null;
                OracleLog.recursiveExit();
                return var9_50;
lbl225:
                // 1 sources

                var28_15 = null;
                if (LobPlsqlUtil.TRACE == false) return var12_57;
                if (OracleLog.recursiveEnter() == false) return var12_57;
                try {}
                catch (Throwable var29_39) {
                    var30_26 = null;
                    OracleLog.recursiveExit();
                    throw var29_39;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var30_25 = null;
                OracleLog.recursiveExit();
                return var12_57;
lbl240:
                // 1 sources

                var28_16 = null;
                if (LobPlsqlUtil.TRACE == false) return var19_64;
                if (OracleLog.recursiveEnter() == false) return var19_64;
                try {}
                catch (Throwable var29_40) {
                    var30_28 = null;
                    OracleLog.recursiveExit();
                    throw var29_40;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var30_27 = null;
                OracleLog.recursiveExit();
                return var19_64;
lbl255:
                // 1 sources

                var28_17 = null;
                if (LobPlsqlUtil.TRACE == false) return var19_65;
                if (OracleLog.recursiveEnter() == false) return var19_65;
                try {}
                catch (Throwable var29_41) {
                    var30_30 = null;
                    OracleLog.recursiveExit();
                    throw var29_41;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var30_29 = null;
                OracleLog.recursiveExit();
                return var19_65;
lbl270:
                // 1 sources

                var28_19 = null;
                if (LobPlsqlUtil.TRACE == false) return var19_66;
                if (OracleLog.recursiveEnter() == false) return var19_66;
                try {}
                catch (Throwable var29_43) {
                    var30_34 = null;
                    OracleLog.recursiveExit();
                    throw var29_43;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var30_33 = null;
                OracleLog.recursiveExit();
                return var19_66;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            var30_35 = null;
            OracleLog.recursiveExit();
            throw var27_79;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(BFILE bfile, byte[] pattern, long startPos) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long __result__ = LobPlsqlUtil.hasPattern(bfile.getInternalConnection(), bfile, -13, pattern, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long isSubLob(BFILE bfile, BFILE subLob, long startPos) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long __result__ = LobPlsqlUtil.isSubLob(bfile.getInternalConnection(), bfile, -13, subLob, startPos);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static String fileGetName(BFILE bfile) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile));
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleCallableStatement cstmt = null;
            String ret = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
                cstmt.setBFILE(1, bfile);
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 12);
                cstmt.execute();
                ret = cstmt.getString(3);
                Object var4_5 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (cstmt == null) throw throwable;
                cstmt.close();
                cstmt = null;
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            string = ret;
            Object var8_12 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            return string;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static String fileGetDirAlias(BFILE bfile) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(bfile));
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleCallableStatement cstmt = null;
            String ret = null;
            try {
                cstmt = (OracleCallableStatement)bfile.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
                cstmt.setBFILE(1, bfile);
                cstmt.registerOutParameter(2, 12);
                cstmt.registerOutParameter(3, 12);
                cstmt.execute();
                ret = cstmt.getString(2);
                Object var4_5 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (cstmt == null) throw throwable;
                cstmt.close();
                cstmt = null;
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            string = ret;
            Object var8_12 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            return string;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPlsqlMaxInstrSize(OracleConnection conn) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(conn));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean isCharSetMultibyte = conn.isCharSetMultibyte(conn.getDriverCharSet());
            int maxCharbyteSize = conn.getMaxCharbyteSize();
            int ret = 32512;
            if (isCharSetMultibyte) {
                ret = 32512 / (conn.getC2SNlsRatio() * maxCharbyteSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: " + ret);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = ret;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static long read(OracleConnection conn, Datum lob, int type, long pos, long length, byte[] bytes_read) throws SQLException {
        try {
            if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(length) + ", " + OracleLog.argument(bytes_read));
                    var9_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable var8_9) {
                    var9_7 = null;
                    OracleLog.recursiveExit();
                    throw var8_9;
                }
            }
            cstmt = null;
            totalSizeRead = 0;
            try {
                try {
                    cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.read (:1, :2, :3, :4); end;");
                    readThisTime = 0;
                    chunkSize = 0;
                    if (LobPlsqlUtil.isNCLOB(lob)) {
                        cstmt.setFormOfUse(1, (short)2);
                        cstmt.setFormOfUse(4, (short)2);
                    }
                    cstmt.setObject(1, (Object)lob, type);
                    cstmt.registerOutParameter(2, 2);
                    cstmt.registerOutParameter(4, -3);
                    while ((long)totalSizeRead < length) {
                        chunkSize = Math.min((int)length, 32512);
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug: read chunks: chunkSize=" + chunkSize);
                                var14_16 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable var13_18) {
                                var14_16 = null;
                                OracleLog.recursiveExit();
                                throw var13_18;
                            }
                        }
                        cstmt.setInt(2, chunkSize);
                        cstmt.setInt(3, (int)pos + totalSizeRead);
                        cstmt.execute();
                        readThisTime = cstmt.getInt(2);
                        bytesThisTime = cstmt.getBytes(4);
                        readThisTime = Math.min(readThisTime, bytesThisTime.length);
                        System.arraycopy(bytesThisTime, 0, bytes_read, totalSizeRead, readThisTime);
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug:  sizeRead=" + readThisTime);
                                var16_17 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable var15_19) {
                                var16_17 = null;
                                OracleLog.recursiveExit();
                                throw var15_19;
                            }
                        }
                        totalSizeRead += readThisTime;
                        length -= (long)readThisTime;
                    }
                    var22_20 = null;
                    ** if (cstmt == null) goto lbl-1000
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 1403) {
                        if (LobPlsqlUtil.TRACE == false) throw e;
                        if (OracleLog.recursiveEnter() == false) throw e;
                        try {
                            LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug: Exception caught and thrown." + e.getMessage());
                            var18_23 = null;
                            OracleLog.recursiveExit();
                            throw e;
                        }
                        catch (Throwable var17_25) {
                            var18_24 = null;
                            OracleLog.recursiveExit();
                            throw var17_25;
                        }
                    }
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(OracleLog.TRACE_20, "         Debug: ORA-1403 No data found end of file");
                            var20_26 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable var19_28) {
                            var20_27 = null;
                            OracleLog.recursiveExit();
                            throw var19_28;
                        }
                    }
                    var22_21 = null;
                    if (cstmt != null) {
                        cstmt.close();
                        cstmt = null;
                    }
                }
lbl-1000:
                // 1 sources

                {
                    cstmt.close();
                    cstmt = null;
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var21_29) {
                var22_22 = null;
                if (cstmt == null) throw var21_29;
                cstmt.close();
                cstmt = null;
                throw var21_29;
            }
            if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + (long)totalSizeRead);
                    var24_30 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable var23_32) {
                    var24_31 = null;
                    OracleLog.recursiveExit();
                    throw var23_32;
                }
            }
            var10_13 = totalSizeRead;
            var26_33 = null;
            if (LobPlsqlUtil.TRACE == false) return var10_13;
        }
        catch (Throwable var25_41) {
            var26_34 = null;
            if (LobPlsqlUtil.TRACE == false) throw var25_41;
            if (OracleLog.recursiveEnter() == false) throw var25_41;
            try {}
            catch (Throwable var27_40) {
                var28_38 = null;
                OracleLog.recursiveExit();
                throw var27_40;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            var28_37 = null;
            OracleLog.recursiveExit();
            throw var25_41;
        }
        if (OracleLog.recursiveEnter() == false) return var10_13;
        try {
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            var28_35 = null;
            OracleLog.recursiveExit();
            return var10_13;
        }
        catch (Throwable var27_39) {
            var28_36 = null;
            OracleLog.recursiveExit();
            throw var27_39;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long length(OracleConnection conn, Datum lob, int type) throws SQLException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            long lob_length = 0L;
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := dbms_lob.getLength (:2); end;");
                if (LobPlsqlUtil.isNCLOB(lob)) {
                    cstmt.setFormOfUse(2, (short)2);
                }
                cstmt.setObject(2, (Object)lob, type);
                cstmt.registerOutParameter(1, 2);
                cstmt.execute();
                lob_length = cstmt.getLong(1);
                Object var7_8 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (cstmt == null) throw throwable;
                cstmt.close();
                cstmt = null;
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + lob_length);
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            l2 = lob_length;
            Object var11_15 = null;
            if (!TRACE) return l2;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var13_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return l2;
        try {
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var13_17 = null;
            OracleLog.recursiveExit();
            return l2;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long hasPattern(OracleConnection conn, Datum lob, int type, byte[] pattern, long startPos) throws SQLException {
        block47: {
            try {
                if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(pattern) + ", " + OracleLog.argument(startPos));
                        var7_5 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var6_7) {
                        var7_6 = null;
                        OracleLog.recursiveExit();
                        throw var6_7;
                    }
                }
                if (pattern == null || startPos <= 0L) {
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            var9_10 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable var8_12) {
                            var9_11 = null;
                            OracleLog.recursiveExit();
                            throw var8_12;
                        }
                    }
                    var6_8 = 0L;
                    var29_14 = null;
                    if (LobPlsqlUtil.TRACE == false) return var6_8;
                    if (OracleLog.recursiveEnter() == false) return var6_8;
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                        var31_22 = null;
                        OracleLog.recursiveExit();
                        return var6_8;
                    }
                    catch (Throwable var30_38) {
                        var31_23 = null;
                        OracleLog.recursiveExit();
                        throw var30_38;
                    }
                }
                patternLen = pattern.length;
                lobLen = LobPlsqlUtil.length(conn, lob, type);
                if (patternLen == 0L || patternLen > lobLen - startPos + 1L || startPos > lobLen) {
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            var11_46 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable var10_50) {
                            var11_47 = null;
                            OracleLog.recursiveExit();
                            throw var10_50;
                        }
                    }
                    var10_51 = 0L;
                    var29_15 = null;
                    if (LobPlsqlUtil.TRACE == false) return var10_51;
                    if (OracleLog.recursiveEnter() == false) return var10_51;
                    try {}
                    catch (Throwable var30_39) {
                        var31_25 = null;
                        OracleLog.recursiveExit();
                        throw var30_39;
                    }
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    var31_24 = null;
                    OracleLog.recursiveExit();
                    return var10_51;
                }
                if (patternLen <= 32512L) {
                    cstmt = null;
                    try {
                        cstmt = (OracleCallableStatement)conn.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                        cstmt.registerOutParameter(1, 2);
                        cstmt.setObject(2, (Object)lob, type);
                        cstmt.setBytes(3, pattern);
                        cstmt.setLong(4, startPos);
                        cstmt.execute();
                        __result__ = cstmt.getLong(1);
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                                var14_54 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable var13_57) {
                                var14_55 = null;
                                OracleLog.recursiveExit();
                                throw var13_57;
                            }
                        }
                        var13_58 = __result__;
                        var16_60 = null;
                    }
                    catch (Throwable var15_63) {
                        var16_61 = null;
                        cstmt.close();
                        cstmt = null;
                        throw var15_63;
                    }
                    cstmt.close();
                    cstmt = null;
                    var29_16 = null;
                    if (LobPlsqlUtil.TRACE == false) return var13_58;
                    if (OracleLog.recursiveEnter() == false) return var13_58;
                    try {}
                    catch (Throwable var30_40) {
                        var31_27 = null;
                        OracleLog.recursiveExit();
                        throw var30_40;
                    }
                    LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                    var31_26 = null;
                    OracleLog.recursiveExit();
                    return var13_58;
                }
                matchedLen = 0;
                subStartPos = startPos;
                done = false;
                matchedPos = 0L;
                while (true) {
                    if (!done) {
                        if (patternLen > lobLen - subStartPos + 1L) {
                            if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                    var21_71 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable var20_67) {
                                    var21_72 = null;
                                    OracleLog.recursiveExit();
                                    throw var20_67;
                                }
                            }
                            var20_68 = 0L;
                            var29_17 = null;
                            if (LobPlsqlUtil.TRACE == false) return var20_68;
                            if (OracleLog.recursiveEnter() == false) return var20_68;
                            try {}
                            catch (Throwable var30_41) {
                                var31_29 = null;
                                OracleLog.recursiveExit();
                                throw var30_41;
                            }
                            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                            var31_28 = null;
                            OracleLog.recursiveExit();
                            return var20_68;
                        }
                        matchedLen = 0;
                        subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                        subPattern = new byte[subPatternLen];
                        System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
                        subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                        if (subMatchedPos == 0L) {
                            if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                    var23_74 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable var22_76) {
                                    var23_75 = null;
                                    OracleLog.recursiveExit();
                                    throw var22_76;
                                }
                            }
                            var20_69 = 0L;
                            var29_18 = null;
                            if (LobPlsqlUtil.TRACE == false) return var20_69;
                            if (OracleLog.recursiveEnter() == false) return var20_69;
                            try {}
                            catch (Throwable var30_42) {
                                var31_31 = null;
                                OracleLog.recursiveExit();
                                throw var30_42;
                            }
                            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                            var31_30 = null;
                            OracleLog.recursiveExit();
                            return var20_69;
                        }
                        matchedPos = subMatchedPos;
                        matchedLen += subPatternLen;
                        subStartPos = subMatchedPos + (long)subPatternLen;
                        moreChunks = true;
                        break block47;
                    }
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                            var27_80 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable var26_82) {
                            var27_81 = null;
                            OracleLog.recursiveExit();
                            throw var26_82;
                        }
                    }
                    var20_70 = matchedPos;
                    var29_20 = null;
                    if (LobPlsqlUtil.TRACE == false) return var20_70;
                    break;
                }
            }
            catch (Throwable var28_83) {
                var29_21 = null;
                if (LobPlsqlUtil.TRACE == false) throw var28_83;
                if (OracleLog.recursiveEnter() == false) throw var28_83;
                try {}
                catch (Throwable var30_45) {
                    var31_37 = null;
                    OracleLog.recursiveExit();
                    throw var30_45;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_36 = null;
                OracleLog.recursiveExit();
                throw var28_83;
            }
            {
                if (OracleLog.recursiveEnter() == false) return var20_70;
                try {}
                catch (Throwable var30_44) {
                    var31_35 = null;
                    OracleLog.recursiveExit();
                    throw var30_44;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_34 = null;
                OracleLog.recursiveExit();
                return var20_70;
            }
        }
        while (true) lbl-1000:
        // 4 sources

        {
            if (!moreChunks) ** continue;
            subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
            subPattern = new byte[subPatternLen];
            System.arraycopy(pattern, matchedLen, subPattern, 0, subPatternLen);
            subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
            if (subMatchedPos == subStartPos) {
                subStartPos += (long)subPatternLen;
                if ((long)(matchedLen += subPatternLen) != patternLen) ** continue;
                moreChunks = false;
                done = true;
                ** continue;
            }
            if (subMatchedPos == 0L) {
                if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                        var25_77 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable var24_79) {
                        var25_78 = null;
                        OracleLog.recursiveExit();
                        throw var24_79;
                    }
                }
                var21_73 = 0L;
                var29_19 = null;
                if (LobPlsqlUtil.TRACE == false) return var21_73;
                if (OracleLog.recursiveEnter() == false) return var21_73;
                try {}
                catch (Throwable var30_43) {
                    var31_33 = null;
                    OracleLog.recursiveExit();
                    throw var30_43;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_32 = null;
                OracleLog.recursiveExit();
                return var21_73;
            }
            subStartPos = subMatchedPos - (long)matchedLen;
            moreChunks = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long isSubLob(OracleConnection conn, Datum lob, int type, Datum subLob, long startPos) throws SQLException {
        try {
            block48: {
                block47: {
                    block46: {
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(lob) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(subLob) + ", " + OracleLog.argument(startPos));
                                var7_5 = null;
                            }
                            catch (Throwable var6_7) {
                                var7_6 = null;
                                OracleLog.recursiveExit();
                                throw var6_7;
                            }
                            OracleLog.recursiveExit();
                        }
                        if (subLob != null && startPos > 0L) break block46;
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var9_10 = null;
                            }
                            catch (Throwable var8_12) {
                                var9_11 = null;
                                OracleLog.recursiveExit();
                                throw var8_12;
                            }
                            OracleLog.recursiveExit();
                        }
                        var6_8 = 0L;
                        var29_14 = null;
                        if (LobPlsqlUtil.TRACE == false) return var6_8;
                        ** GOTO lbl196
                    }
                    patternLen = LobPlsqlUtil.length(conn, subLob, type);
                    lobLen = LobPlsqlUtil.length(conn, lob, type);
                    if (patternLen != 0L && patternLen <= lobLen - startPos + 1L && startPos <= lobLen) break block47;
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            var11_46 = null;
                        }
                        catch (Throwable var10_50) {
                            var11_47 = null;
                            OracleLog.recursiveExit();
                            throw var10_50;
                        }
                        OracleLog.recursiveExit();
                    }
                    var10_51 = 0L;
                    ** GOTO lbl209
                }
                if (patternLen > 32512L) break block48;
                pattern = new byte[(int)patternLen];
                LobPlsqlUtil.read(conn, subLob, type, 1L, patternLen, pattern);
                __result__ = LobPlsqlUtil.hasPattern(conn, lob, type, pattern, startPos);
                if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + __result__);
                        var14_54 = null;
                    }
                    catch (Throwable var13_57) {
                        var14_55 = null;
                        OracleLog.recursiveExit();
                        throw var13_57;
                    }
                    OracleLog.recursiveExit();
                }
                var13_58 = __result__;
                ** GOTO lbl224
            }
            matchedLen = 0;
            subStartPos = startPos;
            done = false;
            matchedPos = 0L;
            while (!done) {
                block50: {
                    block49: {
                        if (patternLen <= lobLen - subStartPos + 1L) break block49;
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var21_68 = null;
                            }
                            catch (Throwable var20_64) {
                                var21_69 = null;
                                OracleLog.recursiveExit();
                                throw var20_64;
                            }
                            OracleLog.recursiveExit();
                        }
                        var20_65 = 0L;
                        ** GOTO lbl239
                    }
                    matchedLen = 0;
                    subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                    subPattern = new byte[subPatternLen];
                    LobPlsqlUtil.read(conn, subLob, type, matchedLen + 1, subPatternLen, subPattern);
                    subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                    if (subMatchedPos != 0L) break block50;
                    if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                            var23_71 = null;
                        }
                        catch (Throwable var22_73) {
                            var23_72 = null;
                            OracleLog.recursiveExit();
                            throw var22_73;
                        }
                        OracleLog.recursiveExit();
                    }
                    var20_66 = 0L;
                    ** GOTO lbl254
                }
                matchedPos = subMatchedPos;
                matchedLen += subPatternLen;
                subStartPos = subMatchedPos + (long)subPatternLen;
                moreChunks = true;
                while (moreChunks) {
                    subPatternLen = (int)Math.min(32512L, patternLen - (long)matchedLen);
                    subPattern = new byte[subPatternLen];
                    LobPlsqlUtil.read(conn, subLob, type, matchedLen + 1, subPatternLen, subPattern);
                    subMatchedPos = LobPlsqlUtil.hasPattern(conn, lob, type, subPattern, subStartPos);
                    if (subMatchedPos == subStartPos) {
                        subStartPos += (long)subPatternLen;
                        if ((long)(matchedLen += subPatternLen) != patternLen) continue;
                        moreChunks = false;
                        done = true;
                        continue;
                    }
                    if (subMatchedPos == 0L) {
                        if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                LobPlsqlUtil.logger().log(Level.FINER, "         Return: 0");
                                var25_74 = null;
                            }
                            catch (Throwable var24_76) {
                                var25_75 = null;
                                OracleLog.recursiveExit();
                                throw var24_76;
                            }
                            OracleLog.recursiveExit();
                        }
                        var21_70 = 0L;
                        var29_19 = null;
                        if (LobPlsqlUtil.TRACE == false) return var21_70;
                        if (OracleLog.recursiveEnter() == false) return var21_70;
                        try {
                            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                            var31_32 = null;
                        }
                        catch (Throwable var30_43) {
                            var31_33 = null;
                            OracleLog.recursiveExit();
                            throw var30_43;
                        }
                        OracleLog.recursiveExit();
                        return var21_70;
                    }
                    subStartPos = subMatchedPos - (long)matchedLen;
                    moreChunks = false;
                }
            }
            if (LobPlsqlUtil.TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + matchedPos);
                    var27_77 = null;
                }
                catch (Throwable var26_79) {
                    var27_78 = null;
                    OracleLog.recursiveExit();
                    throw var26_79;
                }
                OracleLog.recursiveExit();
            }
            var20_67 = matchedPos;
            ** GOTO lbl269
        }
        catch (Throwable var28_80) {
            block51: {
                var29_21 = null;
                if (LobPlsqlUtil.TRACE == false) throw var28_80;
                if (OracleLog.recursiveEnter() == false) throw var28_80;
                try {}
                catch (Throwable var30_45) {
                    var31_37 = null;
                    OracleLog.recursiveExit();
                    throw var30_45;
                }
                break block51;
lbl196:
                // 1 sources

                if (OracleLog.recursiveEnter() == false) return var6_8;
                try {}
                catch (Throwable var30_38) {
                    var31_23 = null;
                    OracleLog.recursiveExit();
                    throw var30_38;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_22 = null;
                OracleLog.recursiveExit();
                return var6_8;
lbl209:
                // 1 sources

                var29_15 = null;
                if (LobPlsqlUtil.TRACE == false) return var10_51;
                if (OracleLog.recursiveEnter() == false) return var10_51;
                try {}
                catch (Throwable var30_39) {
                    var31_25 = null;
                    OracleLog.recursiveExit();
                    throw var30_39;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_24 = null;
                OracleLog.recursiveExit();
                return var10_51;
lbl224:
                // 1 sources

                var29_16 = null;
                if (LobPlsqlUtil.TRACE == false) return var13_58;
                if (OracleLog.recursiveEnter() == false) return var13_58;
                try {}
                catch (Throwable var30_40) {
                    var31_27 = null;
                    OracleLog.recursiveExit();
                    throw var30_40;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_26 = null;
                OracleLog.recursiveExit();
                return var13_58;
lbl239:
                // 1 sources

                var29_17 = null;
                if (LobPlsqlUtil.TRACE == false) return var20_65;
                if (OracleLog.recursiveEnter() == false) return var20_65;
                try {}
                catch (Throwable var30_41) {
                    var31_29 = null;
                    OracleLog.recursiveExit();
                    throw var30_41;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_28 = null;
                OracleLog.recursiveExit();
                return var20_65;
lbl254:
                // 1 sources

                var29_18 = null;
                if (LobPlsqlUtil.TRACE == false) return var20_66;
                if (OracleLog.recursiveEnter() == false) return var20_66;
                try {}
                catch (Throwable var30_42) {
                    var31_31 = null;
                    OracleLog.recursiveExit();
                    throw var30_42;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_30 = null;
                OracleLog.recursiveExit();
                return var20_66;
lbl269:
                // 1 sources

                var29_20 = null;
                if (LobPlsqlUtil.TRACE == false) return var20_67;
                if (OracleLog.recursiveEnter() == false) return var20_67;
                try {}
                catch (Throwable var30_44) {
                    var31_35 = null;
                    OracleLog.recursiveExit();
                    throw var30_44;
                }
                LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
                var31_34 = null;
                OracleLog.recursiveExit();
                return var20_67;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            var31_36 = null;
            OracleLog.recursiveExit();
            throw var28_80;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNCLOB(Datum lob) {
        block26: {
            Class<?> cl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(lob));
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                cl = null;
                try {
                    cl = Class.forName("oracle.sql.CLOB");
                }
                catch (ClassNotFoundException exp) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(Level.FINEST, "         Debug: Could not find class oracle.sql.CLOB ");
                            Object var4_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: false");
                            Object var6_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    boolean bl = false;
                    Object var12_16 = null;
                    if (!TRACE) return bl;
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit");
                        Object var14_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var14_26 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                    throw throwable;
                }
            }
            if (cl.isInstance(lob)) break block26;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: false");
                    Object var8_32 = null;
                }
                catch (Throwable throwable) {
                    Object var8_33 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean exp = false;
            Object var12_17 = null;
            if (!TRACE) return exp;
            if (!OracleLog.recursiveEnter()) return exp;
            try {
                LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var14_22 = null;
            }
            catch (Throwable throwable) {
                Object var14_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            return exp;
        }
        CLOB clob = (CLOB)lob;
        boolean __result__ = clob.isNCLOB();
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                Object var10_35 = null;
            }
            catch (Throwable throwable) {
                Object var10_36 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = __result__;
        Object var12_18 = null;
        if (!TRACE) return bl;
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            LobPlsqlUtil.logger().log(OracleLog.TRACE_30, "         Exit");
            Object var14_24 = null;
        }
        catch (Throwable throwable) {
            Object var14_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static Datum createTemporaryLob(Connection conn, boolean cache, int duration, int type, short form_of_use) throws SQLException {
        Datum datum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(cache) + ", " + OracleLog.argument(duration) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(form_of_use));
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Statement cstmt = null;
            Datum ret = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.createTemporary (:1," + (cache ? "TRUE" : "FALSE") + ", :2); end;");
                cstmt.registerOutParameter(1, type);
                cstmt.setFormOfUse(1, form_of_use);
                cstmt.setInt(2, duration);
                cstmt.execute();
                ret = cstmt.getOracleObject(1);
                Object var8_9 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (cstmt == null) throw throwable;
                cstmt.close();
                cstmt = null;
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            datum = ret;
            Object var12_16 = null;
            if (!TRACE) return datum;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_21 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var14_20 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return datum;
        try {
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var14_18 = null;
            OracleLog.recursiveExit();
            return datum;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void freeTemporaryLob(Connection conn, Datum temp_lob, int type) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    LobPlsqlUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(temp_lob) + ", " + OracleLog.argument(type));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            OracleCallableStatement cstmt = null;
            try {
                cstmt = (OracleCallableStatement)conn.prepareCall("begin dbms_lob.freeTemporary (:1); end;");
                cstmt.registerOutParameter(1, type);
                if (LobPlsqlUtil.isNCLOB(temp_lob)) {
                    cstmt.setFormOfUse(1, (short)2);
                }
                cstmt.setOracleObject(1, temp_lob);
                cstmt.execute();
                Datum ret = cstmt.getOracleObject(1);
                byte[] locator = ret.shareBytes();
                temp_lob.setShareBytes(locator);
                Object var7_8 = null;
                if (cstmt != null) {
                    cstmt.close();
                    cstmt = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (cstmt == null) throw throwable;
                cstmt.close();
                cstmt = null;
                throw throwable;
            }
            Object var9_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            LobPlsqlUtil.logger().log(Level.FINER, "         Exit");
            Object var11_13 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.LobPlsqlUtil"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

