/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTFE
extends CharacterSet
implements CharacterRepConstants {
    static final int MAXBYTEPERCHAR = 4;
    static byte[][] utf8m2utfe = new byte[][]{{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15}, {16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31}, {64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97}, {-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111}, {124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42}, {-41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109}, {121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106}, {-105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7}, {32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27}, {48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1}, {65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 81, 82, 83, 84, 85, 86}, {87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114, 115}, {116, 117, 118, 119, 120, -128, -118, -117, -116, -115, -114, -113, -112, -102, -101, -100}, {-99, -98, -97, -96, -86, -85, -84, -82, -81, -80, -79, -78, -77, -76, -75, -74}, {-73, -72, -71, -70, -69, -68, -66, -65, -54, -53, -52, -51, -50, -49, -38, -37}, {-36, -35, -34, -33, -31, -22, -21, -20, -19, -18, -17, -6, -5, -4, -3, -2}};
    static byte[][] utfe2utf8m = new byte[][]{{0, 1, 2, 3, -100, 9, -122, 127, -105, -115, -114, 11, 12, 13, 14, 15}, {16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31}, {-128, -127, -126, -125, -124, -123, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7}, {-112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26}, {32, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, 46, 60, 40, 43, 124}, {38, -86, -85, -84, -83, -82, -81, -80, -79, -78, 33, 36, 42, 41, 59, 94}, {45, 47, -77, -76, -75, -74, -73, -72, -71, -70, -69, 44, 37, 95, 62, 63}, {-68, -67, -66, -65, -64, -63, -62, -61, -60, 96, 58, 35, 64, 39, 61, 34}, {-59, 97, 98, 99, 100, 101, 102, 103, 104, 105, -58, -57, -56, -55, -54, -53}, {-52, 106, 107, 108, 109, 110, 111, 112, 113, 114, -51, -50, -49, -48, -47, -46}, {-45, 126, 115, 116, 117, 118, 119, 120, 121, 122, -44, -43, -42, 88, -41, -40}, {-39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, 93, -26, -25}, {123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -24, -23, -22, -21, -20, -19}, {13, 74, 75, 76, 77, 78, 79, 80, 81, 82, -18, -17, -16, -15, -14, -13}, {92, -12, 83, 84, 85, 86, 87, 88, 89, 90, -11, -10, -9, -8, -7, -6}, {48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -5, -4, -3, -2, -1, -97}};
    private static int[] m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 2, 2, 3, 4};
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetUTFE(int id) {
        super(id);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(id));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.rep = 3;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLossyFrom(CharacterSet from) {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = !from.isUnicode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConvertibleFrom(CharacterSet source) {
        boolean bl;
        try {
            boolean ok;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(source));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = ok = source.rep <= 1024;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ok);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = ok;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnicode() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = true;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            char[] chars = new char[bytes.length];
            int chars_index = this.UTFEToJavaChar(bytes, offset, count, chars, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
            String __result__ = new String(chars, 0, chars_index);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var8_10 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = __result__;
            Object var10_14 = null;
            if (!TRACE) return string;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_18 = null;
            }
            catch (Throwable throwable2) {
                Object var12_19 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return string;
        try {
            CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                char[] chars = new char[bytes.length];
                int chars_index = this.UTFEToJavaChar(bytes, offset, count, chars, CharacterSet.CharacterConverterBehavior.REPLACEMENT);
                String __result__ = new String(chars, 0, chars_index);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                string = __result__;
            }
            catch (SQLException e2) {
                if (!TRACE) throw new IllegalStateException(e2.getMessage());
                if (!OracleLog.recursiveEnter()) throw new IllegalStateException(e2.getMessage());
                try {
                    CharacterSetUTFE.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing java.lang.IllegalStateException: " + e2.getMessage());
                    Object var10_23 = null;
                    OracleLog.recursiveExit();
                    throw new IllegalStateException(e2.getMessage());
                }
                catch (Throwable throwable) {
                    Object var10_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var12_15 = null;
            if (!TRACE) return string;
            if (!OracleLog.recursiveEnter()) return string;
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
                OracleLog.recursiveExit();
                return string;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_20 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_19 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int UTFEToJavaChar(byte[] bytes, int offset, int count, char[] chars, CharacterSet.CharacterConverterBehavior ccb) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(chars) + ", " + OracleLog.argument(ccb));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int bytes_index = offset;
            int bytes_end = offset + count;
            int chars_index = 0;
            block16: while (bytes_index < bytes_end) {
                byte c1 = utfe2utf8m[CharacterSetUTFE.high(bytes[bytes_index])][CharacterSetUTFE.low(bytes[bytes_index++])];
                switch (c1 >>> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        chars[chars_index++] = (char)(c1 & 0x7F);
                        continue block16;
                    }
                    case 8: 
                    case 9: {
                        chars[chars_index++] = (char)(c1 & 0x1F);
                        continue block16;
                    }
                    case 12: 
                    case 13: {
                        if (bytes_index >= bytes_end) {
                            ccb.onFailConversion();
                            bytes_index = bytes_end;
                            continue block16;
                        }
                        c1 = (byte)(c1 & 0x1F);
                        byte c2 = utfe2utf8m[CharacterSetUTFE.high(bytes[bytes_index])][CharacterSetUTFE.low(bytes[bytes_index++])];
                        if (!CharacterSetUTFE.is101xxxxx(c2)) {
                            ccb.onFailConversion();
                            chars[chars_index++] = 65533;
                            continue block16;
                        }
                        chars[chars_index++] = (char)(c1 << 5 | c2 & 0x1F);
                        continue block16;
                    }
                    case 14: {
                        if (bytes_index + 1 >= bytes_end) {
                            ccb.onFailConversion();
                            bytes_index = bytes_end;
                            continue block16;
                        }
                        c1 = (byte)(c1 & 0xF);
                        byte c2 = utfe2utf8m[CharacterSetUTFE.high(bytes[bytes_index])][CharacterSetUTFE.low(bytes[bytes_index++])];
                        byte c3 = utfe2utf8m[CharacterSetUTFE.high(bytes[bytes_index])][CharacterSetUTFE.low(bytes[bytes_index++])];
                        if (!CharacterSetUTFE.is101xxxxx(c2) || !CharacterSetUTFE.is101xxxxx(c3)) {
                            ccb.onFailConversion();
                            chars[chars_index++] = 65533;
                            continue block16;
                        }
                        chars[chars_index++] = (char)(c1 << 10 | (c2 & 0x1F) << 5 | c3 & 0x1F);
                        continue block16;
                    }
                    case 15: {
                        if (bytes_index + 2 >= bytes_end) {
                            ccb.onFailConversion();
                            bytes_index = bytes_end;
                            continue block16;
                        }
                        c1 = (byte)(c1 & 1);
                        byte c2 = utfe2utf8m[CharacterSetUTFE.high(bytes[bytes_index])][CharacterSetUTFE.low(bytes[bytes_index++])];
                        byte c3 = utfe2utf8m[CharacterSetUTFE.high(bytes[bytes_index])][CharacterSetUTFE.low(bytes[bytes_index++])];
                        byte c4 = utfe2utf8m[CharacterSetUTFE.high(bytes[bytes_index])][CharacterSetUTFE.low(bytes[bytes_index++])];
                        if (!(CharacterSetUTFE.is101xxxxx(c2) && CharacterSetUTFE.is101xxxxx(c3) && CharacterSetUTFE.is101xxxxx(c4))) {
                            ccb.onFailConversion();
                            chars[chars_index++] = 65533;
                            continue block16;
                        }
                        chars[chars_index++] = (char)(c1 << 15 | (c2 & 0x1F) << 10 | (c3 & 0x1F) << 5 | c4 & 0x1F);
                        continue block16;
                    }
                }
                ccb.onFailConversion();
                chars[chars_index++] = 65533;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + chars_index);
                    Object var14_16 = null;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = chars_index;
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var18_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_22 = null;
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] convertWithReplacement(String str) {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(str));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            char[] chararr = str.toCharArray();
            byte[] bytearr = new byte[chararr.length * 4];
            int byte_len = this.javaCharsToUTFE(chararr, 0, chararr.length, bytearr, 0);
            byte[] rbytearr = new byte[byte_len];
            System.arraycopy(bytearr, 0, rbytearr, 0, byte_len);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rbytearr);
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = rbytearr;
            Object var9_12 = null;
            if (!TRACE) return byArray;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable2) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return byArray;
        try {
            CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convert(String str) throws SQLException {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] __result__ = this.convertWithReplacement(str);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = __result__;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        byte[] byArray;
        try {
            byte[] result;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(from) + ", " + OracleLog.argument(source) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(count));
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (from.rep == 3) {
                result = CharacterSetUTFE.useOrCopy(source, offset, count);
            } else {
                String s2 = from.toString(source, offset, count);
                result = this.convert(s2);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = result;
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int javaCharsToUTFE(char[] chars, int chars_offset, int chars_count, byte[] bytes, int bytes_begin) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(chars) + ", " + OracleLog.argument(chars_offset) + ", " + OracleLog.argument(chars_count) + ", " + OracleLog.argument(bytes) + ", " + OracleLog.argument(bytes_begin));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int chars_end = chars_offset + chars_count;
            int bytes_index = 0;
            for (int i2 = chars_offset; i2 < chars_end; ++i2) {
                char c2 = chars[i2];
                if (c2 <= '\u001f') {
                    int temp = c2 | 0x80;
                    bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                    continue;
                }
                if (c2 <= '\u007f') {
                    bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(c2)][CharacterSetUTFE.low(c2)];
                    continue;
                }
                if (c2 <= '\u03ff') {
                    int temp = (c2 & 0x3E0) >> 5 | 0xC0;
                    bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                    temp = c2 & 0x1F | 0xA0;
                    bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                    continue;
                }
                if (c2 <= '\u3fff') {
                    int temp = (c2 & 0x3C00) >> 10 | 0xE0;
                    bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                    temp = (c2 & 0x3E0) >> 5 | 0xA0;
                    bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                    temp = c2 & 0x1F | 0xA0;
                    bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                    continue;
                }
                int temp = (c2 & 0x8000) >> 15 | 0xF0;
                bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = (c2 & 0x7C00) >> 10 | 0xA0;
                bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = (c2 & 0x3E0) >> 5 | 0xA0;
                bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = c2 & 0x1F | 0xA0;
                bytes[bytes_index++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bytes_index);
                    Object var12_17 = null;
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = bytes_index;
            Object var14_20 = null;
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var16_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var16_22 = null;
            }
            catch (Throwable throwable) {
                Object var16_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    int decode(CharacterWalker walker) throws SQLException {
        try {
            char[] chars;
            block24: {
                char c2;
                byte c3;
                int len;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                        Object var3_2 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                byte[] bytes = walker.bytes;
                int bytes_index = walker.next;
                int bytes_end = walker.end;
                int result = 0;
                if (bytes_index >= bytes_end) {
                    CharacterSetUTFE.failUTFConversion();
                }
                if ((len = CharacterSetUTFE.getUTFByteLength(c3 = bytes[bytes_index])) == 0 || bytes_index + (len - 1) >= bytes_end) {
                    CharacterSetUTFE.failUTFConversion();
                }
                try {
                    chars = new char[2];
                    int chars_len = this.UTFEToJavaChar(bytes, bytes_index, len, chars, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
                    walker.next += len;
                    if (chars_len != 1) break block24;
                    char __result__ = chars[0];
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            Object var12_17 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var12_18 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    c2 = __result__;
                }
                catch (SQLException e2) {
                    CharacterSetUTFE.failUTFConversion();
                    walker.next = bytes_index;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                            Object var16_41 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var16_42 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    int n2 = result;
                    Object var18_24 = null;
                    if (!TRACE) return n2;
                    if (!OracleLog.recursiveEnter()) return n2;
                    try {}
                    catch (Throwable throwable) {
                        Object var20_31 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var20_30 = null;
                    OracleLog.recursiveExit();
                    return n2;
                }
                Object var18_22 = null;
                if (!TRACE) return c2;
                if (!OracleLog.recursiveEnter()) return c2;
                try {
                    CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var20_26 = null;
                    OracleLog.recursiveExit();
                    return c2;
                }
                catch (Throwable throwable) {
                    Object var20_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int __result__ = chars[0] << 16 | chars[1];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var14_38 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var14_39 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int n3 = __result__;
            Object var18_23 = null;
            if (!TRACE) return n3;
            if (!OracleLog.recursiveEnter()) return n3;
            try {}
            catch (Throwable throwable) {
                Object var20_29 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_28 = null;
            OracleLog.recursiveExit();
            return n3;
        }
        catch (Throwable throwable) {
            Object var18_25 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var20_33 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var20_32 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((c2 & 0xFFFF0000) != 0) {
                CharacterSetUTFE.failUTFConversion();
            } else if (c2 <= 31) {
                CharacterSetUTFE.need(buffer, 1);
                int temp = c2 | 0x80;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
            } else if (c2 <= 127) {
                CharacterSetUTFE.need(buffer, 1);
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(c2)][CharacterSetUTFE.low(c2)];
            } else if (c2 <= 1023) {
                CharacterSetUTFE.need(buffer, 2);
                int temp = (c2 & 0x3E0) >> 5 | 0xC0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = c2 & 0x1F | 0xA0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
            } else if (c2 <= 16383) {
                CharacterSetUTFE.need(buffer, 3);
                int temp = (c2 & 0x3C00) >> 10 | 0xE0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = (c2 & 0x3E0) >> 5 | 0xA0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = c2 & 0x1F | 0xA0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
            } else {
                CharacterSetUTFE.need(buffer, 4);
                int temp = (c2 & 0x8000) >> 15 | 0xF0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = (c2 & 0x7C00) >> 10 | 0xA0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = (c2 & 0x3E0) >> 5 | 0xA0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
                temp = c2 & 0x1F | 0xA0;
                buffer.bytes[buffer.next++] = utf8m2utfe[CharacterSetUTFE.high(temp)][CharacterSetUTFE.low(temp)];
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int high(int b2) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(b2));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = b2 >> 4 & 0xF;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int low(int b2) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(b2));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = b2 & 0xF;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
                Object var8_13 = null;
            }
            catch (Throwable throwable2) {
                Object var8_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean is101xxxxx(byte c2) {
        boolean bl;
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(c2));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            boolean bl2 = __result__ = (c2 & 0xFFFFFFE0) == -96;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getUTFByteLength(byte b2) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(b2));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = m_byteLen[utfe2utf8m[CharacterSetUTFE.high(b2)][CharacterSetUTFE.low(b2)] >>> 4 & 0xF];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetUTFE.logger().log(Level.FINER, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetUTFE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

