/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetShift
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterShift";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final byte SHIFT_OUT = 14;
    static final byte SHIFT_IN = 15;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharacterSetShift(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetShift.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CharacterSetShift getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        block19: {
            CharacterSetShift characterSetShift;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetShift.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(oracleId) + ", " + OracleLog.argument(charConverter));
                        characterSetShift = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (charConverter.getGroupId() != 7) break block19;
                CharacterSetShift __result__ = new CharacterSetShift(oracleId, charConverter);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetShift.logger().log(Level.FINER, "         Return: " + __result__);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                characterSetShift = __result__;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetShift.logger().log(Level.FINER, "         Exit");
                        Object var11_17 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(Level.FINER, "         Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return characterSetShift;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetShift.logger().log(Level.FINER, "         Return: " + null);
                Object var7_22 = null;
            }
            catch (Throwable throwable) {
                Object var7_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        CharacterSetShift characterSetShift = null;
        Object var9_11 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetShift.logger().log(Level.FINER, "         Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return characterSetShift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int decode(CharacterWalker walker) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(walker));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int c2 = walker.bytes[walker.next] & 0xFF;
            ++walker.next;
            if (c2 > 223 || c2 > 127 && c2 < 161) {
                if (walker.bytes.length > walker.next) {
                    c2 = c2 << 8 | walker.bytes[walker.next];
                    ++walker.next;
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            CharacterSetShift.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
                            Object var5_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + c2);
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = c2;
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encode(CharacterBuffer buffer, int c2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(buffer) + ", " + OracleLog.argument(c2));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int pos = buffer.next;
            boolean isShiftIn = true;
            while (pos <= 0) {
                if (buffer.bytes[pos] == 15) {
                    isShiftIn = true;
                    break;
                }
                if (buffer.bytes[pos] != 14) continue;
                isShiftIn = false;
                break;
            }
            int bytesToShift = 0;
            int bytesNeeded = 1;
            while (c2 >> bytesToShift != 0) {
                bytesToShift = (short)(bytesToShift + 8);
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            if (bytesNeeded > 2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetShift.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "Character invalid + too many bytes");
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "Character invalid,too many bytes");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            boolean addShiftIn = false;
            boolean addShiftOut = false;
            if (bytesNeeded == 1 && !isShiftIn) {
                addShiftIn = true;
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            if (bytesNeeded == 2 && isShiftIn) {
                addShiftOut = true;
                bytesNeeded = (short)(bytesNeeded + 1);
            }
            CharacterSetShift.need(buffer, bytesNeeded);
            if (addShiftIn) {
                buffer.bytes[buffer.next++] = 15;
            }
            if (addShiftOut) {
                buffer.bytes[buffer.next++] = 14;
            }
            while (bytesToShift >= 0) {
                buffer.bytes[buffer.next++] = (byte)(c2 >> bytesToShift & 0xFF);
                bytesToShift = (short)(bytesToShift - 8);
            }
            Object var10_16 = null;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetShift.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetShift"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

