/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.REF;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class ArrayDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Array,
Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayDescriptor createDescriptor(String name, Connection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor __result__ = ArrayDescriptor.createDescriptor(name, conn, false, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayDescriptor createDescriptor(String name, Connection conn, boolean recurse, boolean force) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(recurse) + ", " + OracleLog.argument(force));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (name == null || name.length() == 0 || conn == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 60ArrayDescriptor.createDescriptor: Invalid argument + 'name' should not be an empty string and 'conn' should not be null.");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 60, "ArrayDescriptor.createDescriptor: Invalid argument,'name' should not be an empty string and 'conn' should not be null.");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            SQLName sqlName = new SQLName(name, (oracle.jdbc.OracleConnection)conn);
            ArrayDescriptor __result__ = ArrayDescriptor.createDescriptor(sqlName, conn);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayDescriptor createDescriptor(SQLName sqlName, Connection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor __result__ = ArrayDescriptor.createDescriptor(sqlName, conn, false, false);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayDescriptor createDescriptor(SQLName sqlName, Connection conn, boolean recurse, boolean force) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(conn) + ", " + OracleLog.argument(recurse) + ", " + OracleLog.argument(force));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String qualifiedName = sqlName.getName();
            ArrayDescriptor descriptor = null;
            if (!force) {
                descriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)conn).getDescriptor(qualifiedName);
            }
            if (descriptor == null) {
                descriptor = new ArrayDescriptor(sqlName, conn);
                if (recurse) {
                    descriptor.initNamesRecursively();
                }
                ((oracle.jdbc.OracleConnection)conn).putDescriptor(qualifiedName, descriptor);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + descriptor);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = descriptor;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION otype) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(otype));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String fullName = otype.getFullName();
            OracleConnection conn = otype.getConnection();
            ArrayDescriptor descriptor = (ArrayDescriptor)conn.getDescriptor(fullName);
            if (descriptor == null) {
                SQLName sqlName = new SQLName(otype.getSchemaName(), otype.getSimpleName(), otype.getConnection());
                descriptor = new ArrayDescriptor(sqlName, otype, (Connection)conn);
                conn.putDescriptor(fullName, (Object)descriptor);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + descriptor);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = descriptor;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayDescriptor createDescriptor(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(typoid) + ", " + OracleLog.argument(version) + ", " + OracleLog.argument(tds) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeADT interimPickler = new OracleTypeADT(sqlName, typoid, version, tds, conn);
            interimPickler.init(tds, conn);
            OracleTypeCOLLECTION pickler = (OracleTypeCOLLECTION)interimPickler.cleanup();
            ArrayDescriptor __result__ = new ArrayDescriptor(sqlName, pickler, (Connection)conn);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ArrayDescriptor arrayDescriptor = __result__;
            return arrayDescriptor;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDescriptor(String name, Connection conn) throws SQLException {
        super((short)122, name, conn);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.initPickler();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDescriptor(SQLName sqlName, Connection conn) throws SQLException {
        super((short)122, sqlName, conn);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.initPickler();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDescriptor(SQLName sqlName, OracleTypeCOLLECTION type, Connection conn) throws SQLException {
        block12: {
            super((short)122, sqlName, type, conn);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(sqlName) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayDescriptor(OracleTypeCOLLECTION type, Connection conn) throws SQLException {
        block12: {
            super((short)122, type, conn);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)122);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(_toid) + ", " + OracleLog.argument(_toidVersion) + ", " + OracleLog.argument(conn));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.toid = _toid;
            this.toidVersion = _toidVersion;
            this.setPhysicalConnectionOf(conn);
            this.initPickler();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeMetaData.Kind getKind() {
        OracleTypeMetaData.Kind kind;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)OracleTypeMetaData.Kind.ARRAY));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            kind = OracleTypeMetaData.Kind.ARRAY;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBaseType() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseName() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String ret = null;
            switch (this.getBaseType()) {
                case 12: {
                    ret = "VARCHAR";
                    break;
                }
                case 1: {
                    ret = "CHAR";
                    break;
                }
                case -2: {
                    ret = "RAW";
                    break;
                }
                case 6: {
                    ret = "FLOAT";
                    break;
                }
                case 2: {
                    ret = "NUMBER";
                    break;
                }
                case 8: {
                    ret = "DOUBLE";
                    break;
                }
                case 3: {
                    ret = "DECIMAL";
                    break;
                }
                case 91: {
                    ret = "DATE";
                    break;
                }
                case 93: {
                    ret = "TIMESTAMP";
                    break;
                }
                case -101: {
                    ret = "TIMESTAMP WITH TIME ZONE";
                    break;
                }
                case -102: {
                    ret = "TIMESTAMP WITH LOCAL TIME ZONE";
                    break;
                }
                case 2004: {
                    ret = "BLOB";
                    break;
                }
                case 2005: {
                    ret = "CLOB";
                    break;
                }
                case -13: {
                    ret = "BFILE";
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    ret = otype.getFullName();
                    break;
                }
                case 2006: {
                    OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    ret = "REF " + ((OracleTypeREF)otype).getFullName();
                    break;
                }
                case 100: {
                    ret = "BINARY_FLOAT";
                    break;
                }
                case 101: {
                    ret = "BINARY_DOUBLE";
                    break;
                }
                default: {
                    ret = null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (OracleTypeCOLLECTION)this.pickler);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.pickler;
            return oracleTypeCOLLECTION;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public OracleTypeMetaData.ArrayStorage getArrayStorage() throws SQLException {
        return OracleTypeMetaData.ArrayStorage.withCode(this.getArrayType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getArrayType() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int __result__ = ((OracleTypeCOLLECTION)this.pickler).getUserCode();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLength() throws SQLException {
        long l2;
        try {
            long __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = __result__ = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            l2 = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String descType() throws SQLException {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer strBuf = new StringBuffer();
            String __result__ = this.descType(strBuf, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String descType(StringBuffer strBuf, int level) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(strBuf) + ", " + OracleLog.argument(level));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String level_one = "";
            for (int i2 = 0; i2 < level; ++i2) {
                level_one = level_one + "  ";
            }
            String level_two = level_one + "  ";
            strBuf.append(level_one);
            strBuf.append(this.getTypeName());
            strBuf.append("\n");
            int tcode = this.getBaseType();
            if (tcode == 2002 || tcode == 2008) {
                StructDescriptor adt_desc = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
                adt_desc.descType(strBuf, level + 1);
            } else if (tcode == 2003) {
                ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
                array_desc.descType(strBuf, level + 1);
            } else if (tcode == 2007) {
                OpaqueDescriptor opaque_desc = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
                opaque_desc.descType(strBuf, level + 1);
            } else {
                strBuf.append(level_two);
                strBuf.append(this.getBaseName());
                strBuf.append("\n");
            }
            String __result__ = strBuf.substring(0, strBuf.length());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = __result__;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int toLength(ARRAY array) throws SQLException {
        try {
            block35: {
                block46: {
                    block45: {
                        block37: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block40: {
                                                block39: {
                                                    block38: {
                                                        block36: {
                                                            if (TRACE && OracleLog.recursiveEnter()) {
                                                                try {
                                                                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(array));
                                                                }
                                                                finally {
                                                                    OracleLog.recursiveExit();
                                                                }
                                                            }
                                                            if (array.numElems != -1) break block35;
                                                            if (array.datumArray == null) break block36;
                                                            array.numElems = array.datumArray.length;
                                                            break block35;
                                                        }
                                                        if (array.objArray == null) break block37;
                                                        if (!(array.objArray instanceof Object[])) break block38;
                                                        array.numElems = ((Object[])array.objArray).length;
                                                        break block35;
                                                    }
                                                    if (!(array.objArray instanceof int[])) break block39;
                                                    array.numElems = ((long[])array.objArray).length;
                                                    break block35;
                                                }
                                                if (!(array.objArray instanceof long[])) break block40;
                                                array.numElems = ((float[])array.objArray).length;
                                                break block35;
                                            }
                                            if (!(array.objArray instanceof float[])) break block41;
                                            array.numElems = ((double[])array.objArray).length;
                                            break block35;
                                        }
                                        if (!(array.objArray instanceof double[])) break block42;
                                        array.numElems = ((boolean[])array.objArray).length;
                                        break block35;
                                    }
                                    if (!(array.objArray instanceof boolean[])) break block43;
                                    array.numElems = ((int[])array.objArray).length;
                                    break block35;
                                }
                                if (!(array.objArray instanceof byte[])) break block44;
                                array.numElems = ((byte[])array.objArray).length;
                                break block35;
                            }
                            if (array.objArray instanceof short[]) {
                                array.numElems = ((short[])array.objArray).length;
                                break block35;
                            } else if (array.objArray instanceof char[]) {
                                array.numElems = ((char[])array.objArray).length;
                            }
                            break block35;
                        }
                        if (array.locator == null) break block45;
                        array.numElems = this.toLengthFromLocator(array.locator);
                        break block35;
                    }
                    if (array.shareBytes() == null) break block46;
                    this.pickler.unlinearize(array.shareBytes(), array.imageOffset, array, 0, null);
                    if (array.numElems != -1) break block35;
                    if (array.locator != null) {
                        array.numElems = this.toLengthFromLocator(array.locator);
                        break block35;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Unable to get array length");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to get array length");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + array.numElems);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = array.numElems;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] toBytes(ARRAY s2, boolean keepLocalCopy) throws SQLException {
        try {
            byte[] bytes;
            block40: {
                block38: {
                    block39: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(s2) + ", " + OracleLog.argument(keepLocalCopy));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if ((bytes = s2.shareBytes()) != null) break block38;
                        if (s2.datumArray == null && s2.locator == null) break block39;
                        bytes = this.pickler.linearize(s2);
                        if (!keepLocalCopy) {
                            s2.setShareBytes(null);
                        }
                        break block40;
                    }
                    if (s2.objArray != null) {
                        s2.datumArray = this.toOracleArray(s2.objArray, 1L, -1);
                        bytes = this.pickler.linearize(s2);
                        if (!keepLocalCopy) {
                            s2.datumArray = null;
                            s2.setShareBytes(null);
                        }
                        break block40;
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (s2.imageLength != 0L && (s2.imageOffset != 0L || s2.imageLength != (long)bytes.length)) {
                    byte[] image = new byte[(int)s2.imageLength];
                    System.arraycopy(bytes, (int)s2.imageOffset, image, 0, (int)s2.imageLength);
                    s2.setImage(image, 0L, 0L);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + image);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    byte[] byArray = image;
                    return byArray;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bytes);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Datum[] toOracleArray(ARRAY s, long beginIdx, int count, boolean keepLocalCopy) throws SQLException {
        block36: {
            try {
                block42: {
                    block45: {
                        block44: {
                            block43: {
                                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        ArrayDescriptor.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(s) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(keepLocalCopy));
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                if ((datumArray = s.datumArray) != null) break block42;
                                if (s.objArray == null) break block43;
                                datumArray = this.toOracleArray(s.objArray, beginIdx, count);
                                ** GOTO lbl75
                            }
                            if (s.locator == null) break block44;
                            datumArray = this.toOracleArrayFromLocator(s.locator, beginIdx, count, null);
                            ** GOTO lbl75
                        }
                        if (s.shareBytes() == null) break block45;
                        this.pickler.unlinearize(s.shareBytes(), s.imageOffset, s, beginIdx, count, 1, null);
                        datumArray = s.locator != null ? this.toOracleArrayFromLocator(s.locator, beginIdx, count, null) : s.datumArray;
                        if (!keepLocalCopy) {
                            s.datumArray = null;
                        }
                        ** GOTO lbl75
                    }
                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status.");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (beginIdx <= (long)datumArray.length) break block36;
                __result__ = new Datum[]{};
                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var8_13 = __result__;
            }
            catch (Throwable var12_18) {
                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw var12_18;
            }
            if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var8_13;
        }
        length = (int)(count == -1 ? (long)datumArray.length - beginIdx + 1L : Math.min((long)datumArray.length - beginIdx + 1L, (long)count));
        datumArray = new Datum[length];
        System.arraycopy(s.datumArray, (int)beginIdx - 1, datumArray, 0, length);
lbl75:
        // 4 sources

        ret = null;
        if (keepLocalCopy) {
            s.datumArray = datumArray;
            ret = (Datum[])datumArray.clone();
        } else {
            ret = datumArray;
        }
        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var8_14 = ret;
        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var8_14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Object[] toJavaArray(ARRAY s, long beginIdx, int count, Map map, boolean saveLocalCopy) throws SQLException {
        block45: {
            block38: {
                try {
                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(s) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map) + ", " + OracleLog.argument(saveLocalCopy));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    objArray = null;
                    if (s.objArray == null) ** GOTO lbl50
                    objArray = (Object[])((Object[])s.objArray).clone();
                    nbElem = objArray.length;
                    length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
                    if (length > 0) break block38;
                    ret = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var11_14 = ret;
                }
                catch (Throwable var16_19) {
                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var16_19;
                }
                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var11_14;
            }
            objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
            System.arraycopy(s.objArray, (int)beginIdx - 1, objArray, 0, length);
            break block45;
lbl50:
            // 1 sources

            if (s.datumArray != null) {
                objArray = (Object[])this.toJavaArray(s.datumArray, beginIdx, count, map);
            } else if (s.locator != null) {
                objArray = this.toArrayFromLocator(s.locator, beginIdx, count, map);
            } else if (s.shareBytes() != null) {
                this.pickler.unlinearize(s.shareBytes(), s.imageOffset, s, beginIdx, count, 2, map);
                objArray = s.locator != null ? this.toArrayFromLocator(s.locator, beginIdx, count, map) : (Object[])s.objArray;
            } else {
                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            s.objArray = saveLocalCopy != false && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objArray != null ? objArray.clone() : null;
        }
        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objArray);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var8_10 = objArray;
        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var8_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Datum[] toOracleArrayFromLocator(byte[] locator_bytes, long beginIdx, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int nbElem = this.toLengthFromLocator(locator_bytes);
            int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
            Datum[] datumArray = null;
            if (length <= 0) {
                datumArray = new Datum[]{};
            } else {
                datumArray = new Datum[length];
                ResultSet rset = this.toResultSetFromLocator(locator_bytes, beginIdx, count, map);
                int i2 = 0;
                while (rset.next()) {
                    datumArray[i2] = ((OracleResultSet)rset).getOracleObject(2);
                    ++i2;
                }
                rset.close();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray2 = datumArray;
            return datumArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] toArrayFromLocator(byte[] locator_bytes, long beginIdx, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int nbElem = this.toLengthFromLocator(locator_bytes);
            int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
            Object[] objArray = null;
            if (length <= 0) {
                objArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
            } else {
                objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
                ResultSet rset = this.toResultSetFromLocator(locator_bytes, beginIdx, count, map);
                int i2 = 0;
                while (rset.next()) {
                    objArray[i2] = ((OracleResultSet)rset).getObject(2, map);
                    ++i2;
                }
                rset.close();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = objArray;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet toResultSet(ARRAY array, long index, int count, Map map, boolean saveLocalCopy) throws SQLException {
        ResultSet resultSet;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(array) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet rset = null;
            if (array.datumArray != null) {
                rset = this.toResultSet(array.datumArray, index, count, map);
            } else if (array.locator != null) {
                rset = this.toResultSetFromLocator(array.locator, index, count, map);
            } else if (array.objArray != null) {
                rset = this.toResultSet(this.toOracleArray(array.objArray, index, count), 1L, -1, map);
            } else if (array.shareBytes() != null) {
                if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(array.shareBytes(), (int)array.imageOffset)) {
                    rset = this.toResultSetFromImage(array, index, count, map);
                } else {
                    this.pickler.unlinearize(array.shareBytes(), array.imageOffset, array, 1, null);
                    if (array.locator != null) {
                        rset = this.toResultSetFromLocator(array.locator, index, count, map);
                    } else {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Array is in inconsistent status");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
            }
            if (rset == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Unable to create array ResultSet");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rset);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            resultSet = rset;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet toResultSet(Datum[] data, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(data) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet ret = null;
            ret = count == -1 ? this.connection.newArrayDataResultSet(data, index, data.length, map) : this.connection.newArrayDataResultSet(data, index, count, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet = ret;
            return resultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet toResultSetFromLocator(byte[] locator, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet ret = this.connection.newArrayLocatorResultSet(this, locator, index, count, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet = ret;
            return resultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet toResultSetFromImage(ARRAY array, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(array) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet ret = this.connection.newArrayDataResultSet(array, index, count, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet = ret;
            return resultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] makeJavaArray(int length, int otype) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(length) + ", " + OracleLog.argument(otype));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] ret = null;
            switch (otype) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ret = new BigDecimal[length];
                    break;
                }
                case 1: 
                case 12: {
                    ret = new String[length];
                    break;
                }
                case -102: 
                case -101: 
                case 91: 
                case 92: 
                case 93: {
                    ret = new Timestamp[length];
                    break;
                }
                case 2002: 
                case 2008: {
                    ret = new Object[length];
                    break;
                }
                case -13: {
                    ret = new BFILE[length];
                    break;
                }
                case 2004: {
                    ret = new BLOB[length];
                    break;
                }
                case 2005: {
                    ret = new CLOB[length];
                    break;
                }
                case -3: 
                case -2: {
                    ret = (Object[])new byte[length][];
                    break;
                }
                case 2006: {
                    ret = new REF[length];
                    break;
                }
                case 2003: {
                    ret = new Object[length];
                    break;
                }
                case 100: {
                    ret = new Float[length];
                    break;
                }
                case 101: {
                    ret = new Double[length];
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 1" + "makeJavaArray doesn't support type " + otype);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 1, "makeJavaArray doesn't support type " + otype);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int toLengthFromLocator(byte[] locator_bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY tmpObj = new ARRAY(this, this.connection, (Object)null);
            tmpObj.setLocator(locator_bytes);
            int numElems = 0;
            OraclePreparedStatement pstmt = null;
            OracleResultSet rs = null;
            pstmt = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
            pstmt.setArray(1, tmpObj);
            rs = (OracleResultSet)pstmt.executeQuery();
            if (!rs.next()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 1 + "Fail to access array storage table");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            numElems = rs.getInt(1);
            rs.close();
            pstmt.close();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + numElems);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = numElems;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum[] toOracleArray(Object elements, long beginIdx, int count) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(elements) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] ret = null;
            if (elements != null) {
                OracleType otype = this.getElementType();
                ret = otype.toDatumArray(elements, this.connection, beginIdx, count);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = ret;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toJavaArray(Datum[] elements, long beginIdx, int count, Map map) throws SQLException {
        try {
            int length;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(elements) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((length = (int)(count == -1 ? (long)elements.length - beginIdx + 1L : Math.min((long)elements.length - beginIdx + 1L, (long)count))) < 0) {
                length = 0;
            }
            Object[] objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
            if (this.getBaseType() == 2002) {
                STRUCT s2 = null;
                for (int i2 = 0; i2 < length; ++i2) {
                    s2 = (STRUCT)elements[(int)beginIdx + i2 - 1];
                    objArray[i2] = s2 != null ? s2.toJdbc(map) : null;
                }
            } else {
                Datum d2 = null;
                for (int i3 = 0; i3 < length; ++i3) {
                    d2 = elements[(int)beginIdx + i3 - 1];
                    objArray[i3] = d2 != null ? d2.toJdbc() : null;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objArray);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = objArray;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toNumericArray(Datum[] darray, long beginIdx, int count, int type) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(darray) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(type));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] ret = null;
            int length = (int)(count == -1 ? (long)darray.length - beginIdx + 1L : Math.min((long)darray.length - beginIdx + 1L, (long)count));
            if (length < 0) {
                length = 0;
            }
            switch (type) {
                case 4: {
                    Object[] objArray = new int[length];
                    for (int i2 = 0; i2 < length; ++i2) {
                        Datum d2 = darray[(int)beginIdx + i2 - 1];
                        if (d2 == null) continue;
                        objArray[i2] = d2.intValue();
                    }
                    ret = objArray;
                    break;
                }
                case 5: {
                    Object[] objArray = new double[length];
                    for (int i3 = 0; i3 < length; ++i3) {
                        Datum d3 = darray[(int)beginIdx + i3 - 1];
                        if (d3 == null) continue;
                        objArray[i3] = (int)d3.doubleValue();
                    }
                    ret = objArray;
                    break;
                }
                case 6: {
                    Object[] objArray = new float[length];
                    for (int i4 = 0; i4 < length; ++i4) {
                        Datum d4 = darray[(int)beginIdx + i4 - 1];
                        if (d4 == null) continue;
                        objArray[i4] = (int)d4.floatValue();
                    }
                    ret = objArray;
                    break;
                }
                case 7: {
                    Object[] objArray = new long[length];
                    for (int i5 = 0; i5 < length; ++i5) {
                        Datum d5 = darray[(int)beginIdx + i5 - 1];
                        if (d5 == null) continue;
                        objArray[i5] = (int)d5.longValue();
                    }
                    ret = objArray;
                    break;
                }
                case 8: {
                    Object[] objArray = new short[length];
                    for (int i6 = 0; i6 < length; ++i6) {
                        Datum d6 = darray[(int)beginIdx + i6 - 1];
                        if (d6 == null) continue;
                        objArray[i6] = ((NUMBER)d6).shortValue();
                    }
                    ret = objArray;
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toNumericArrayFromLocator(byte[] locator_bytes, long beginIdx, int count, int type) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(locator_bytes) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(type));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] ret = null;
            int nbElem = this.toLengthFromLocator(locator_bytes);
            ResultSet rs = this.toResultSetFromLocator(locator_bytes, beginIdx, count, null);
            int idx = 0;
            switch (type) {
                case 4: {
                    Object[] objArray = new int[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = ((OracleResultSet)rs).getInt(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 5: {
                    Object[] objArray = new double[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = (int)((OracleResultSet)rs).getDouble(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 6: {
                    Object[] objArray = new float[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = (int)((OracleResultSet)rs).getFloat(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 7: {
                    Object[] objArray = new long[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = (int)((OracleResultSet)rs).getLong(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 8: {
                    Object[] objArray = new short[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = ((OracleResultSet)rs).getShort(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Object toNumericArray(ARRAY array, long beginIdx, int count, int type, boolean saveLocalCopy) throws SQLException {
        block100: {
            block93: {
                block90: {
                    block87: {
                        block84: {
                            block81: {
                                try {
                                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            ArrayDescriptor.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(array) + ", " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(type));
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    if (!((elementType = this.getElementType()) instanceof OracleTypeNUMBER) && !(elementType instanceof OracleTypeFLOAT)) {
                                        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                                        __ex__.fillInStackTrace();
                                        throw __ex__;
                                    }
                                    objArray = null;
                                    if (array.objArray == null) ** GOTO lbl180
                                    if (type != 4 || !(array.objArray instanceof int[])) ** GOTO lbl64
                                    length = ((int[])array.objArray).length;
                                    if (beginIdx <= (long)length) break block81;
                                    __result__ = new int[]{};
                                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    var11_25 = __result__;
                                }
                                catch (Throwable var24_42) {
                                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    throw var24_42;
                                }
                                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                return var11_25;
                            }
                            length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                            newOarray = new int[length];
                            System.arraycopy(array.objArray, (int)beginIdx - 1, newOarray, 0, length);
                            objArray = newOarray;
                            ** GOTO lbl205
lbl64:
                            // 1 sources

                            if (type != 5 || !(array.objArray instanceof double[])) ** GOTO lbl93
                            length = ((double[])array.objArray).length;
                            if (beginIdx <= (long)length) break block84;
                            __result__ = new double[]{};
                            if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            var11_26 = __result__;
                            if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            return var11_26;
                        }
                        length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                        newOarray = new double[length];
                        System.arraycopy(array.objArray, (int)beginIdx - 1, newOarray, 0, length);
                        objArray = newOarray;
                        ** GOTO lbl205
lbl93:
                        // 1 sources

                        if (type != 6 || !(array.objArray instanceof float[])) ** GOTO lbl122
                        length = ((float[])array.objArray).length;
                        if (beginIdx <= (long)length) break block87;
                        __result__ = new float[]{};
                        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        var11_27 = __result__;
                        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        return var11_27;
                    }
                    length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                    newOarray = new float[length];
                    System.arraycopy(array.objArray, (int)beginIdx - 1, newOarray, 0, length);
                    objArray = newOarray;
                    ** GOTO lbl205
lbl122:
                    // 1 sources

                    if (type != 7 || !(array.objArray instanceof long[])) ** GOTO lbl151
                    length = ((long[])array.objArray).length;
                    if (beginIdx <= (long)length) break block90;
                    __result__ = new long[]{};
                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var11_28 = __result__;
                    if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    return var11_28;
                }
                length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                newOarray = new long[length];
                System.arraycopy(array.objArray, (int)beginIdx - 1, newOarray, 0, length);
                objArray = newOarray;
                ** GOTO lbl205
lbl151:
                // 1 sources

                if (type != 8 || !(array.objArray instanceof short[])) ** GOTO lbl205
                length = ((short[])array.objArray).length;
                if (beginIdx <= (long)length) break block93;
                __result__ = new short[]{};
                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var11_29 = __result__;
                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var11_29;
            }
            length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
            newOarray = new short[length];
            System.arraycopy(array.objArray, (int)beginIdx - 1, newOarray, 0, length);
            objArray = newOarray;
            break block100;
lbl180:
            // 1 sources

            if (array.datumArray != null) {
                objArray = this.toNumericArray(array.datumArray, beginIdx, count, type);
            } else if (array.locator != null) {
                objArray = this.toNumericArrayFromLocator(array.locator, beginIdx, count, type);
            } else if (array.shareBytes() != null) {
                this.pickler.unlinearize(array.shareBytes(), array.imageOffset, array, beginIdx, count, type, null);
                objArray = array.locator != null ? this.toNumericArrayFromLocator(array.locator, beginIdx, count, type) : array.objArray;
            } else {
                if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createUnsupportedFeatureSqlException();
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (!saveLocalCopy) {
                array.objArray = null;
            }
        }
        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objArray);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        var9_13 = objArray;
        if (ArrayDescriptor.TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return var9_13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPickler() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                OracleTypeADT adt = new OracleTypeADT(this.getName(), (Connection)this.connection);
                adt.init(this.connection);
                this.pickler = (OracleTypeCOLLECTION)adt.cleanup();
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
                this.pickler.setDescriptor(this);
            }
            catch (Exception e2) {
                if (e2 instanceof SQLException) {
                    throw (SQLException)e2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(OracleLog.INTERNAL_ERROR, Integer.toHexString(this.hashCode()).toUpperCase() + "Internal Error: " + 60 + "Unable to resolve type: \"" + this.getName() + "\"");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleType getElementType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleType ret = ((OracleTypeCOLLECTION)this.pickler).getElementType();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleType oracleType = ret;
            return oracleType;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeCode() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int ret = 2003;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = ret;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ArrayDescriptor.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Datum[] attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY s2 = new ARRAY(this, this.connection, attributes);
            byte[] __result__ = this.pickler.linearize(s2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = __result__;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object[] attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datums = this.toArray(attributes);
            byte[] ret = this.toBytes(datums);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length(byte[] bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY tmpObj = new ARRAY(this, this.connection, bytes);
            int ret = this.toLength(tmpObj);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toArray(byte[] bytes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] ret = null;
            if (bytes != null) {
                ARRAY tmpObj = new ARRAY(this, this.connection, bytes);
                ret = this.toOracleArray(tmpObj, 1L, -1, false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = ret;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toArray(Object attributes) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(attributes));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] ret = this.toOracleArray(attributes, 1L, -1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum[] datumArray = ret;
            return datumArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet toResultSet(byte[] bytes, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet ret = null;
            if (bytes != null) {
                ARRAY tmpObj = (ARRAY)this.pickler.unlinearize(bytes, 0L, null, 1, null);
                ret = this.toResultSet(tmpObj, 1L, -1, map, false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet = ret;
            return resultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet toResultSet(byte[] bytes, long index, int count, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(bytes) + ", " + OracleLog.argument(index) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet ret = null;
            if (bytes != null) {
                ARRAY tmpObj = (ARRAY)this.pickler.unlinearize(bytes, 0L, null, 1, null);
                ret = this.toResultSet(tmpObj, index, count, map, false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet = ret;
            return resultSet;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String tagName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + "ArrayDescriptor");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = "ArrayDescriptor";
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCacheStyle(ARRAY array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(array));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int ret = 2;
            if (array.getAutoIndexing() && (array.getAccessDirection() == 2 || array.getAccessDirection() == 3)) {
                ret = 1;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Return: " + ret);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = ret;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ArrayDescriptor.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(out));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block12: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(in));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ArrayDescriptor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.ArrayDescriptor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

