/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.net.jdbc.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected int leftOverFromPreviousRead = 0;
    protected int nextPacketOffset = 0;
    public SessionAtts sAtts;
    StringBuilder sb = null;
    StringBuilder tmpBuf = null;
    public static final String[] toHex = new String[]{" 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF"};
    public static final char[] toChar = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    public static final String DIVIDER = "     |";
    public static final String BLANK_SPACE = "   ";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public Packet(SessionAtts sAtts) {
        this.sAtts = sAtts;
        this.sdu = sAtts.getSDU();
        this.tdu = sAtts.getTDU();
    }

    public Packet(SessionAtts sAtts, int bufferSize) {
        this(sAtts);
        this.createBuffer(bufferSize);
    }

    public Packet(SessionAtts sAtts, int bufferSize, int type, int flags) {
        this(sAtts);
        this.createBuffer(bufferSize, type, flags);
    }

    public Packet(Packet pkt) {
        this(pkt.sAtts);
        this.length = pkt.length;
        this.type = pkt.type;
        this.flags = pkt.flags;
        this.dataLen = pkt.dataLen;
        this.dataOff = pkt.dataOff;
        this.buffer = pkt.buffer;
        this.leftOverFromPreviousRead = pkt.leftOverFromPreviousRead;
        this.nextPacketOffset = pkt.nextPacketOffset;
    }

    protected void createBuffer(int length) {
        this.buffer = new byte[length];
        this.buffer[0] = (byte)(length / 256);
        this.buffer[1] = (byte)(length % 256);
    }

    protected void createBuffer(int length, int type, int flags) {
        this.createBuffer(length);
        this.buffer[5] = (byte)flags;
        this.buffer[4] = (byte)type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receive() throws IOException, NetException {
        block30: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Packet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int bytesRead = 0;
                int nBytes = 0;
                int bytesToRead = this.sdu;
                if (this.sAtts.enableJavaNetFastPath && !this.sAtts.anoActive) {
                    bytesToRead -= 37;
                }
                boolean needToReadHeader = true;
                while (bytesToRead > 0) {
                    if (this.leftOverFromPreviousRead > 0) {
                        System.arraycopy(this.buffer, this.nextPacketOffset, this.buffer, 0, this.leftOverFromPreviousRead);
                        bytesRead = this.leftOverFromPreviousRead;
                        if (bytesRead >= 8) {
                            this.processHeader();
                            needToReadHeader = false;
                            if (this.length >= this.leftOverFromPreviousRead) {
                                bytesToRead = this.length - this.leftOverFromPreviousRead;
                                this.leftOverFromPreviousRead = 0;
                                this.nextPacketOffset = 0;
                            } else {
                                this.leftOverFromPreviousRead -= this.length;
                                bytesToRead = 0;
                                this.nextPacketOffset = this.length;
                            }
                        } else {
                            bytesToRead -= bytesRead;
                            this.leftOverFromPreviousRead -= bytesRead;
                            this.nextPacketOffset = 0;
                        }
                    }
                    try {
                        if (bytesToRead > 0) {
                            nBytes = this.sAtts.ntInputStream.read(this.buffer, bytesRead, bytesToRead);
                            if (nBytes <= 0) {
                                throw new NetException(0);
                            }
                            bytesRead += nBytes;
                        }
                        if (needToReadHeader && bytesRead >= 8) {
                            needToReadHeader = false;
                            this.processHeader();
                            bytesToRead = this.length;
                            if (bytesRead > this.length) {
                                this.leftOverFromPreviousRead = bytesRead - this.length;
                                bytesToRead = 0;
                                this.nextPacketOffset = this.length;
                                continue;
                            }
                            this.leftOverFromPreviousRead = 0;
                            this.nextPacketOffset = 0;
                            bytesToRead -= bytesRead;
                            continue;
                        }
                        bytesToRead -= nBytes;
                    }
                    catch (InterruptedIOException exp) {
                        throw new NetException(504);
                    }
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block30;
                try {
                    Packet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "type=" + this.type + ", length=" + this.length + ", flags=" + this.flags + "\n" + this.dumpBytes(this.buffer, 0, this.length), this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Packet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    void processHeader() throws IOException, NetException {
        this.length = this.buffer[0] & 0xFF;
        this.length <<= 8;
        this.length |= this.buffer[1] & 0xFF;
        this.type = this.buffer[4];
        this.flags = this.buffer[5];
        if (this.type > 19) {
            throw new NetException(204);
        }
        if (this.length > 65535 || this.length > this.sdu) {
            throw new NetException(203);
        }
        if (this.length < 8) {
            throw new NetException(207);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Packet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OutputStream outputStream = this.sAtts.ntOutputStream;
            synchronized (outputStream) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Packet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "\n" + this.dumpBytes(this.buffer, 0, this.buffer.length), this.sAtts.traceId);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Packet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractData() throws IOException, NetException {
        block25: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Packet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument("dataLen=" + this.dataLen));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.dataLen <= 0) {
                    this.data = new String();
                } else if (this.length > this.dataOff) {
                    this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
                } else {
                    byte[] tempBuffer = new byte[this.dataLen + 10];
                    byte[] dataBuffer = new byte[this.dataLen];
                    int count = this.readLocal(tempBuffer, 0, this.dataLen + 10);
                    if (count != 0) {
                        if (count >= 10) {
                            System.arraycopy(tempBuffer, 10, dataBuffer, 0, count -= 10);
                        } else {
                            throw new NetException(207);
                        }
                    }
                    if (count < this.dataLen && this.sAtts.nsInputStream.read(dataBuffer, count, this.dataLen - count) < 0) {
                        throw new NetException(0);
                    }
                    this.data = new String(dataBuffer, 0);
                }
                if (!TRACE || !OracleLog.recursiveEnter()) break block25;
                try {
                    Packet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "data=" + this.data, this.sAtts.traceId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Packet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    protected String getData() {
        return this.data;
    }

    void setFlags(int _flags) throws NetException {
        this.flags = _flags;
        this.buffer[5] = (byte)this.flags;
    }

    void reinitialize(SessionAtts _sAtts) throws NetException {
        this.sAtts = _sAtts;
    }

    public static final int toUb2(byte[] b2, int offset) {
        int x = 0;
        x = b2[offset] & 0xFF;
        x <<= 8;
        return x |= b2[offset + 1] & 0xFF;
    }

    public static final void setUb2ToBytes(byte[] b2, int offset, int value) {
        b2[offset] = (byte)(value << 8 & 0xFF);
        b2[offset + 1] = (byte)(value & 0xFF);
    }

    int available() {
        return this.leftOverFromPreviousRead;
    }

    int readLocal(byte[] userBuffer, int _offset, int size) throws NetException {
        int bytesRead = 0;
        if (this.leftOverFromPreviousRead > 0) {
            if (this.leftOverFromPreviousRead > size) {
                bytesRead = size;
                System.arraycopy(this.buffer, this.nextPacketOffset, userBuffer, _offset, bytesRead);
                this.leftOverFromPreviousRead -= bytesRead;
                this.nextPacketOffset += bytesRead;
            } else {
                bytesRead = this.leftOverFromPreviousRead;
                System.arraycopy(this.buffer, this.nextPacketOffset, userBuffer, _offset, bytesRead);
                this.leftOverFromPreviousRead -= bytesRead;
                this.nextPacketOffset = 0;
            }
        }
        return bytesRead;
    }

    protected String dumpBytes(byte[] b2, int start, int nbytes) {
        if (this.sb == null) {
            this.sb = new StringBuilder(16384);
            this.tmpBuf = new StringBuilder(80);
        }
        return this.dumpBytes(b2, start, nbytes, 8, this.sb, this.tmpBuf);
    }

    public String dumpBytes(byte[] b2, int start, int nBytes, int bytesPerLine, StringBuilder sb, StringBuilder tmpBuf) {
        if (b2 == null) {
            return "NULL";
        }
        sb.delete(0, sb.length());
        tmpBuf.delete(0, tmpBuf.length());
        int length = start + nBytes;
        boolean noOfLines = false;
        int bytesThisLine = 0;
        for (int i2 = start; i2 < length; ++i2) {
            int x = b2[i2] & 0xFF;
            sb.append(toHex[x]);
            tmpBuf.append(toChar[x]);
            if (++bytesThisLine != bytesPerLine) continue;
            sb.append(DIVIDER);
            sb.append(tmpBuf.substring(0, tmpBuf.length()));
            sb.append("|\n");
            tmpBuf.delete(0, tmpBuf.length());
            bytesThisLine = 0;
        }
        if (bytesThisLine > 0) {
            int j2;
            int spaces = bytesPerLine - bytesThisLine - 1;
            for (j2 = 0; j2 <= spaces; ++j2) {
                sb.append(BLANK_SPACE);
            }
            sb.append(DIVIDER);
            sb.append(tmpBuf.substring(0, tmpBuf.length()));
            for (j2 = 0; j2 <= spaces; ++j2) {
                sb.append(" ");
            }
            sb.append("|\n");
            tmpBuf.delete(0, tmpBuf.length());
        }
        return sb.substring(0, sb.length());
    }

    protected void dump(byte[] buffer, int offset, int len) {
        int bytes = 0;
        System.out.println("Packet dump");
        System.out.println("buffer.length=" + buffer.length);
        System.out.println("offset       =" + offset);
        System.out.println("len          =" + len);
        for (int i2 = offset; i2 < len; i2 += 8) {
            System.out.print("|");
            for (int j2 = 0; j2 < 8 && bytes < len - 1; ++j2) {
                bytes = i2 + j2;
                RepConversion.printInHex(buffer[bytes]);
                System.out.print(" ");
            }
            System.out.println("|");
        }
        System.out.println("finish dump");
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.net.ns");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.net.ns.Packet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

