/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class OracleXAException
extends XAException {
    private int xaError = 0;
    private int primary = 0;
    private int secondary = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleXAException() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleXAException(int error) {
        super(OracleXAException.errorConvert(error));
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(error));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.xaError = OracleXAException.errorConvert(error);
            this.primary = error & 0xFFFF;
            this.secondary = error >> 16;
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_9 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAException(int error, int _xaError) {
        super(OracleXAException.errorConvert(error, _xaError));
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(error) + ", " + OracleLog.argument(_xaError));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.xaError = OracleXAException.errorConvert(error, _xaError);
            this.primary = error & 0xFFFF;
            this.secondary = error >> 16;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    public OracleXAException(SQLException sqlex, int _xaError) {
        this(sqlex.getErrorCode(), _xaError);
        this.initCause(sqlex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, int error) {
        OracleXAException oracleXAException;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(error));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((xacode = (xaexc = new OracleXAException(error)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleXAException = xaexc;
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var9_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleXAException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XAException newXAException(OracleConnection conn, int error, int xaerror) {
        OracleXAException oracleXAException;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(error) + ", " + OracleLog.argument(xaerror));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((xacode = (xaexc = new OracleXAException(error, xaerror)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleXAException = xaexc;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleXAException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XAException newXAException(OracleConnection conn, SQLException sqlexc, int xaerror) {
        OracleXAException oracleXAException;
        try {
            OracleXAException xaexc;
            int xacode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(sqlexc) + ", " + OracleLog.argument(xaerror));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((xacode = (xaexc = new OracleXAException(sqlexc, xaerror)).getXAError()) == -7 && conn != null) {
                conn.setUsable(false);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + xaexc);
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            oracleXAException = xaexc;
            Object var8_12 = null;
            if (!TRACE) return oracleXAException;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return oracleXAException;
        try {
            OracleXAException.logger().log(Level.FINER, "         Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            return oracleXAException;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int errorConvert(int err) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(err));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int __result__ = OracleXAException.errorConvert(err, -3);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int errorConvert(int err, int defaultErrorCode) {
        try {
            if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(err) + ", " + OracleLog.argument(defaultErrorCode));
                    var3_2 = null;
                }
                catch (Throwable var2_4) {
                    var3_3 = null;
                    OracleLog.recursiveExit();
                    throw var2_4;
                }
                OracleLog.recursiveExit();
            }
            switch (err & 65535) {
                case 24756: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -4");
                            var5_15 = null;
                        }
                        catch (Throwable var4_17) {
                            var5_16 = null;
                            OracleLog.recursiveExit();
                            throw var4_17;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_5 = -4;
                    var25_18 = null;
                    if (OracleXAException.TRACE == false) return var2_5;
                    ** GOTO lbl193
                }
                case 25351: 
                case 30006: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 4");
                            var7_62 = null;
                        }
                        catch (Throwable var6_64) {
                            var7_63 = null;
                            OracleLog.recursiveExit();
                            throw var6_64;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_6 = 4;
                    ** GOTO lbl206
                }
                case 24764: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 7");
                            var9_65 = null;
                        }
                        catch (Throwable var8_67) {
                            var9_66 = null;
                            OracleLog.recursiveExit();
                            throw var8_67;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_7 = 7;
                    ** GOTO lbl221
                }
                case 24765: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 6");
                            var11_68 = null;
                        }
                        catch (Throwable var10_70) {
                            var11_69 = null;
                            OracleLog.recursiveExit();
                            throw var10_70;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_8 = 6;
                    ** GOTO lbl236
                }
                case 24766: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 5");
                            var13_71 = null;
                        }
                        catch (Throwable var12_73) {
                            var13_72 = null;
                            OracleLog.recursiveExit();
                            throw var12_73;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_9 = 5;
                    ** GOTO lbl251
                }
                case 24767: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 3");
                            var15_74 = null;
                        }
                        catch (Throwable var14_76) {
                            var15_75 = null;
                            OracleLog.recursiveExit();
                            throw var14_76;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_10 = 3;
                    ** GOTO lbl266
                }
                case 28: 
                case 1031: 
                case 1033: 
                case 1034: 
                case 1041: 
                case 1089: 
                case 1090: 
                case 1092: 
                case 3113: 
                case 3114: 
                case 12571: 
                case 17002: 
                case 17008: 
                case 17410: 
                case 24796: 
                case 25400: 
                case 25401: 
                case 25402: 
                case 25403: 
                case 25404: 
                case 25405: 
                case 25406: 
                case 25407: 
                case 25408: 
                case 25409: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -7");
                            var17_77 = null;
                        }
                        catch (Throwable var16_79) {
                            var17_78 = null;
                            OracleLog.recursiveExit();
                            throw var16_79;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_11 = -7;
                    ** GOTO lbl281
                }
                case 2056: 
                case 17448: 
                case 24763: 
                case 24768: 
                case 24769: 
                case 24770: 
                case 24775: 
                case 24776: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: -6");
                            var19_80 = null;
                        }
                        catch (Throwable var18_82) {
                            var19_81 = null;
                            OracleLog.recursiveExit();
                            throw var18_82;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_12 = -6;
                    ** GOTO lbl296
                }
                case 2091: 
                case 2092: 
                case 24761: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: 100");
                            var21_83 = null;
                        }
                        catch (Throwable var20_85) {
                            var21_84 = null;
                            OracleLog.recursiveExit();
                            throw var20_85;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_13 = 100;
                    ** GOTO lbl311
                }
                default: {
                    if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAException.logger().log(Level.FINER, "         Return: " + defaultErrorCode);
                            var23_86 = null;
                        }
                        catch (Throwable var22_88) {
                            var23_87 = null;
                            OracleLog.recursiveExit();
                            throw var22_88;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_14 = defaultErrorCode;
                    break;
                }
            }
            ** GOTO lbl326
        }
        catch (Throwable var24_89) {
            var25_28 = null;
            if (OracleXAException.TRACE == false) throw var24_89;
            if (OracleLog.recursiveEnter() == false) throw var24_89;
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                var27_49 = null;
            }
            catch (Throwable var26_61) {
                var27_50 = null;
                OracleLog.recursiveExit();
                throw var26_61;
            }
lbl193:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return var2_5;
            try {}
            catch (Throwable var26_51) {
                var27_30 = null;
                OracleLog.recursiveExit();
                throw var26_51;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_29 = null;
            OracleLog.recursiveExit();
            return var2_5;
lbl206:
            // 1 sources

            var25_19 = null;
            if (OracleXAException.TRACE == false) return var2_6;
            if (OracleLog.recursiveEnter() == false) return var2_6;
            try {}
            catch (Throwable var26_52) {
                var27_32 = null;
                OracleLog.recursiveExit();
                throw var26_52;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_31 = null;
            OracleLog.recursiveExit();
            return var2_6;
lbl221:
            // 1 sources

            var25_20 = null;
            if (OracleXAException.TRACE == false) return var2_7;
            if (OracleLog.recursiveEnter() == false) return var2_7;
            try {}
            catch (Throwable var26_53) {
                var27_34 = null;
                OracleLog.recursiveExit();
                throw var26_53;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_33 = null;
            OracleLog.recursiveExit();
            return var2_7;
lbl236:
            // 1 sources

            var25_21 = null;
            if (OracleXAException.TRACE == false) return var2_8;
            if (OracleLog.recursiveEnter() == false) return var2_8;
            try {}
            catch (Throwable var26_54) {
                var27_36 = null;
                OracleLog.recursiveExit();
                throw var26_54;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_35 = null;
            OracleLog.recursiveExit();
            return var2_8;
lbl251:
            // 1 sources

            var25_22 = null;
            if (OracleXAException.TRACE == false) return var2_9;
            if (OracleLog.recursiveEnter() == false) return var2_9;
            try {}
            catch (Throwable var26_55) {
                var27_38 = null;
                OracleLog.recursiveExit();
                throw var26_55;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_37 = null;
            OracleLog.recursiveExit();
            return var2_9;
lbl266:
            // 1 sources

            var25_23 = null;
            if (OracleXAException.TRACE == false) return var2_10;
            if (OracleLog.recursiveEnter() == false) return var2_10;
            try {}
            catch (Throwable var26_56) {
                var27_40 = null;
                OracleLog.recursiveExit();
                throw var26_56;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_39 = null;
            OracleLog.recursiveExit();
            return var2_10;
lbl281:
            // 1 sources

            var25_24 = null;
            if (OracleXAException.TRACE == false) return var2_11;
            if (OracleLog.recursiveEnter() == false) return var2_11;
            try {}
            catch (Throwable var26_57) {
                var27_42 = null;
                OracleLog.recursiveExit();
                throw var26_57;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_41 = null;
            OracleLog.recursiveExit();
            return var2_11;
lbl296:
            // 1 sources

            var25_25 = null;
            if (OracleXAException.TRACE == false) return var2_12;
            if (OracleLog.recursiveEnter() == false) return var2_12;
            try {}
            catch (Throwable var26_58) {
                var27_44 = null;
                OracleLog.recursiveExit();
                throw var26_58;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_43 = null;
            OracleLog.recursiveExit();
            return var2_12;
lbl311:
            // 1 sources

            var25_26 = null;
            if (OracleXAException.TRACE == false) return var2_13;
            if (OracleLog.recursiveEnter() == false) return var2_13;
            try {}
            catch (Throwable var26_59) {
                var27_46 = null;
                OracleLog.recursiveExit();
                throw var26_59;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_45 = null;
            OracleLog.recursiveExit();
            return var2_13;
lbl326:
            // 1 sources

            var25_27 = null;
            if (OracleXAException.TRACE == false) return var2_14;
            if (OracleLog.recursiveEnter() == false) return var2_14;
            try {}
            catch (Throwable var26_60) {
                var27_48 = null;
                OracleLog.recursiveExit();
                throw var26_60;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var27_47 = null;
            OracleLog.recursiveExit();
            return var2_14;
            OracleLog.recursiveExit();
            throw var24_89;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int getXAError() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xaError);
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = this.xaError;
            Object var6_8 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
            OracleLog.recursiveExit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    public int getOracleError() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOracleSQLError() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.secondary);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.secondary;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAException.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getXAErrorMessage(int eCode) {
        try {
            if (OracleXAException.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAException.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(eCode));
                    var2_1 = null;
                }
                catch (Throwable var1_3) {
                    var2_2 = null;
                    OracleLog.recursiveExit();
                    throw var1_3;
                }
                OracleLog.recursiveExit();
            }
            switch (eCode) {
                case 7: {
                    var1_4 = "The transaction branch has been heuristically committed.";
                    var4_28 = null;
                    if (OracleXAException.TRACE == false) return var1_4;
                    ** GOTO lbl129
                }
                case 8: {
                    var1_5 = "The transaction branch may have been heuristically completed.";
                    ** GOTO lbl142
                }
                case 5: {
                    var1_6 = "The transaction branch has been heuristically committed and rolled back.";
                    ** GOTO lbl157
                }
                case 6: {
                    var1_7 = "The transaction branch has been heuristically rolled back.";
                    ** GOTO lbl172
                }
                case 9: {
                    var1_8 = "Resumption must occur where suspension occured.";
                    ** GOTO lbl187
                }
                case 100: {
                    var1_9 = "The inclusive lower bound oof the rollback codes.";
                    ** GOTO lbl202
                }
                case 101: {
                    var1_10 = "Rollback was caused by communication failure.";
                    ** GOTO lbl217
                }
                case 102: {
                    var1_11 = "A deadlock was detected.";
                    ** GOTO lbl232
                }
                case 107: {
                    var1_12 = "The inclusive upper bound of the rollback error code.";
                    ** GOTO lbl247
                }
                case 103: {
                    var1_13 = "A condition that violates the integrity of the resource was detected.";
                    ** GOTO lbl262
                }
                case 104: {
                    var1_14 = "The resource manager rolled back the transaction branch for a reason not on this list.";
                    ** GOTO lbl277
                }
                case 105: {
                    var1_15 = "A protocol error occured in the resource manager.";
                    ** GOTO lbl292
                }
                case 106: {
                    var1_16 = "A transaction branch took too long.";
                    ** GOTO lbl307
                }
                case 3: {
                    var1_17 = "The transaction branch has been read-only and has been committed.";
                    ** GOTO lbl322
                }
                case 4: {
                    var1_18 = "Routine returned with no effect and may be reissued.";
                    ** GOTO lbl337
                }
                case -2: {
                    var1_19 = "Asynchronous operation already outstanding.";
                    ** GOTO lbl352
                }
                case -8: {
                    var1_20 = "The XID already exists.";
                    ** GOTO lbl367
                }
                case -5: {
                    var1_21 = "Invalid arguments were given.";
                    ** GOTO lbl382
                }
                case -4: {
                    var1_22 = "The XID is not valid.";
                    ** GOTO lbl397
                }
                case -9: {
                    var1_23 = "The resource manager is doing work outside global transaction.";
                    ** GOTO lbl412
                }
                case -6: {
                    var1_24 = "Routine was invoked in an inproper context.";
                    ** GOTO lbl427
                }
                case -3: {
                    var1_25 = "A resource manager error has occured in the transaction branch.";
                    ** GOTO lbl442
                }
                case -7: {
                    var1_26 = "Resource manager is unavailable.";
                    ** GOTO lbl457
                }
                default: {
                    var1_27 = "Internal XA Error";
                    break;
                }
            }
            ** GOTO lbl472
        }
        catch (Throwable var3_128) {
            var4_52 = null;
            if (OracleXAException.TRACE == false) throw var3_128;
            if (OracleLog.recursiveEnter() == false) throw var3_128;
            try {
                OracleXAException.logger().log(Level.FINER, "         Exit");
                var6_101 = null;
            }
            catch (Throwable var5_127) {
                var6_102 = null;
                OracleLog.recursiveExit();
                throw var5_127;
            }
lbl129:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return var1_4;
            try {}
            catch (Throwable var5_103) {
                var6_54 = null;
                OracleLog.recursiveExit();
                throw var5_103;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_53 = null;
            OracleLog.recursiveExit();
            return var1_4;
lbl142:
            // 1 sources

            var4_29 = null;
            if (OracleXAException.TRACE == false) return var1_5;
            if (OracleLog.recursiveEnter() == false) return var1_5;
            try {}
            catch (Throwable var5_104) {
                var6_56 = null;
                OracleLog.recursiveExit();
                throw var5_104;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_55 = null;
            OracleLog.recursiveExit();
            return var1_5;
lbl157:
            // 1 sources

            var4_30 = null;
            if (OracleXAException.TRACE == false) return var1_6;
            if (OracleLog.recursiveEnter() == false) return var1_6;
            try {}
            catch (Throwable var5_105) {
                var6_58 = null;
                OracleLog.recursiveExit();
                throw var5_105;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_57 = null;
            OracleLog.recursiveExit();
            return var1_6;
lbl172:
            // 1 sources

            var4_31 = null;
            if (OracleXAException.TRACE == false) return var1_7;
            if (OracleLog.recursiveEnter() == false) return var1_7;
            try {}
            catch (Throwable var5_106) {
                var6_60 = null;
                OracleLog.recursiveExit();
                throw var5_106;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_59 = null;
            OracleLog.recursiveExit();
            return var1_7;
lbl187:
            // 1 sources

            var4_32 = null;
            if (OracleXAException.TRACE == false) return var1_8;
            if (OracleLog.recursiveEnter() == false) return var1_8;
            try {}
            catch (Throwable var5_107) {
                var6_62 = null;
                OracleLog.recursiveExit();
                throw var5_107;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_61 = null;
            OracleLog.recursiveExit();
            return var1_8;
lbl202:
            // 1 sources

            var4_33 = null;
            if (OracleXAException.TRACE == false) return var1_9;
            if (OracleLog.recursiveEnter() == false) return var1_9;
            try {}
            catch (Throwable var5_108) {
                var6_64 = null;
                OracleLog.recursiveExit();
                throw var5_108;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_63 = null;
            OracleLog.recursiveExit();
            return var1_9;
lbl217:
            // 1 sources

            var4_34 = null;
            if (OracleXAException.TRACE == false) return var1_10;
            if (OracleLog.recursiveEnter() == false) return var1_10;
            try {}
            catch (Throwable var5_109) {
                var6_66 = null;
                OracleLog.recursiveExit();
                throw var5_109;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_65 = null;
            OracleLog.recursiveExit();
            return var1_10;
lbl232:
            // 1 sources

            var4_35 = null;
            if (OracleXAException.TRACE == false) return var1_11;
            if (OracleLog.recursiveEnter() == false) return var1_11;
            try {}
            catch (Throwable var5_110) {
                var6_68 = null;
                OracleLog.recursiveExit();
                throw var5_110;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_67 = null;
            OracleLog.recursiveExit();
            return var1_11;
lbl247:
            // 1 sources

            var4_36 = null;
            if (OracleXAException.TRACE == false) return var1_12;
            if (OracleLog.recursiveEnter() == false) return var1_12;
            try {}
            catch (Throwable var5_111) {
                var6_70 = null;
                OracleLog.recursiveExit();
                throw var5_111;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_69 = null;
            OracleLog.recursiveExit();
            return var1_12;
lbl262:
            // 1 sources

            var4_37 = null;
            if (OracleXAException.TRACE == false) return var1_13;
            if (OracleLog.recursiveEnter() == false) return var1_13;
            try {}
            catch (Throwable var5_112) {
                var6_72 = null;
                OracleLog.recursiveExit();
                throw var5_112;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_71 = null;
            OracleLog.recursiveExit();
            return var1_13;
lbl277:
            // 1 sources

            var4_38 = null;
            if (OracleXAException.TRACE == false) return var1_14;
            if (OracleLog.recursiveEnter() == false) return var1_14;
            try {}
            catch (Throwable var5_113) {
                var6_74 = null;
                OracleLog.recursiveExit();
                throw var5_113;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_73 = null;
            OracleLog.recursiveExit();
            return var1_14;
lbl292:
            // 1 sources

            var4_39 = null;
            if (OracleXAException.TRACE == false) return var1_15;
            if (OracleLog.recursiveEnter() == false) return var1_15;
            try {}
            catch (Throwable var5_114) {
                var6_76 = null;
                OracleLog.recursiveExit();
                throw var5_114;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_75 = null;
            OracleLog.recursiveExit();
            return var1_15;
lbl307:
            // 1 sources

            var4_40 = null;
            if (OracleXAException.TRACE == false) return var1_16;
            if (OracleLog.recursiveEnter() == false) return var1_16;
            try {}
            catch (Throwable var5_115) {
                var6_78 = null;
                OracleLog.recursiveExit();
                throw var5_115;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_77 = null;
            OracleLog.recursiveExit();
            return var1_16;
lbl322:
            // 1 sources

            var4_41 = null;
            if (OracleXAException.TRACE == false) return var1_17;
            if (OracleLog.recursiveEnter() == false) return var1_17;
            try {}
            catch (Throwable var5_116) {
                var6_80 = null;
                OracleLog.recursiveExit();
                throw var5_116;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_79 = null;
            OracleLog.recursiveExit();
            return var1_17;
lbl337:
            // 1 sources

            var4_42 = null;
            if (OracleXAException.TRACE == false) return var1_18;
            if (OracleLog.recursiveEnter() == false) return var1_18;
            try {}
            catch (Throwable var5_117) {
                var6_82 = null;
                OracleLog.recursiveExit();
                throw var5_117;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_81 = null;
            OracleLog.recursiveExit();
            return var1_18;
lbl352:
            // 1 sources

            var4_43 = null;
            if (OracleXAException.TRACE == false) return var1_19;
            if (OracleLog.recursiveEnter() == false) return var1_19;
            try {}
            catch (Throwable var5_118) {
                var6_84 = null;
                OracleLog.recursiveExit();
                throw var5_118;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_83 = null;
            OracleLog.recursiveExit();
            return var1_19;
lbl367:
            // 1 sources

            var4_44 = null;
            if (OracleXAException.TRACE == false) return var1_20;
            if (OracleLog.recursiveEnter() == false) return var1_20;
            try {}
            catch (Throwable var5_119) {
                var6_86 = null;
                OracleLog.recursiveExit();
                throw var5_119;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_85 = null;
            OracleLog.recursiveExit();
            return var1_20;
lbl382:
            // 1 sources

            var4_45 = null;
            if (OracleXAException.TRACE == false) return var1_21;
            if (OracleLog.recursiveEnter() == false) return var1_21;
            try {}
            catch (Throwable var5_120) {
                var6_88 = null;
                OracleLog.recursiveExit();
                throw var5_120;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_87 = null;
            OracleLog.recursiveExit();
            return var1_21;
lbl397:
            // 1 sources

            var4_46 = null;
            if (OracleXAException.TRACE == false) return var1_22;
            if (OracleLog.recursiveEnter() == false) return var1_22;
            try {}
            catch (Throwable var5_121) {
                var6_90 = null;
                OracleLog.recursiveExit();
                throw var5_121;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_89 = null;
            OracleLog.recursiveExit();
            return var1_22;
lbl412:
            // 1 sources

            var4_47 = null;
            if (OracleXAException.TRACE == false) return var1_23;
            if (OracleLog.recursiveEnter() == false) return var1_23;
            try {}
            catch (Throwable var5_122) {
                var6_92 = null;
                OracleLog.recursiveExit();
                throw var5_122;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_91 = null;
            OracleLog.recursiveExit();
            return var1_23;
lbl427:
            // 1 sources

            var4_48 = null;
            if (OracleXAException.TRACE == false) return var1_24;
            if (OracleLog.recursiveEnter() == false) return var1_24;
            try {}
            catch (Throwable var5_123) {
                var6_94 = null;
                OracleLog.recursiveExit();
                throw var5_123;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_93 = null;
            OracleLog.recursiveExit();
            return var1_24;
lbl442:
            // 1 sources

            var4_49 = null;
            if (OracleXAException.TRACE == false) return var1_25;
            if (OracleLog.recursiveEnter() == false) return var1_25;
            try {}
            catch (Throwable var5_124) {
                var6_96 = null;
                OracleLog.recursiveExit();
                throw var5_124;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_95 = null;
            OracleLog.recursiveExit();
            return var1_25;
lbl457:
            // 1 sources

            var4_50 = null;
            if (OracleXAException.TRACE == false) return var1_26;
            if (OracleLog.recursiveEnter() == false) return var1_26;
            try {}
            catch (Throwable var5_125) {
                var6_98 = null;
                OracleLog.recursiveExit();
                throw var5_125;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_97 = null;
            OracleLog.recursiveExit();
            return var1_26;
lbl472:
            // 1 sources

            var4_51 = null;
            if (OracleXAException.TRACE == false) return var1_27;
            if (OracleLog.recursiveEnter() == false) return var1_27;
            try {}
            catch (Throwable var5_126) {
                var6_100 = null;
                OracleLog.recursiveExit();
                throw var5_126;
            }
            OracleXAException.logger().log(Level.FINER, "         Exit");
            var6_99 = null;
            OracleLog.recursiveExit();
            return var1_27;
            OracleLog.recursiveExit();
            throw var3_128;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleXAException"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

