/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

class OracleRuntimeLoadBalancingEventHandlerThread
extends Thread {
    private Notification event = null;
    private OracleConnectionCacheManager cacheManager = null;
    String m_service;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleRuntimeLoadBalancingEventHandlerThread(String service) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(service));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.m_service = service;
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Subscriber sub = null;
            final String type = "%\"eventType=database/event/servicemetrics/" + this.m_service + "\"";
            while (this.cacheManager.failoverEnabledCacheExists()) {
                block27: {
                    block26: {
                        try {
                            sub = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Object run() {
                                    try {
                                        return new Subscriber(type, "", 30000L);
                                    }
                                    catch (SubscriptionException e2) {
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.WARNING, Integer.toHexString(this.hashCode()).toUpperCase() + " Warning: " + " exception " + e2.getMessage());
                                                Object var3_2 = null;
                                            }
                                            catch (Throwable throwable) {
                                                Object var3_3 = null;
                                                OracleLog.recursiveExit();
                                                throw throwable;
                                            }
                                            OracleLog.recursiveExit();
                                            {
                                            }
                                        }
                                        return null;
                                    }
                                }
                            });
                        }
                        catch (PrivilegedActionException e2) {
                            Object var5_9;
                            if (!TRACE || !OracleLog.recursiveEnter()) break block26;
                            try {
                                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleRuntimeLoadBalancingEventHandlerThread.run()" + " - PrivilegedActionException:" + e2.getMessage());
                                var5_9 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                var5_9 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                    }
                    if (sub != null) {
                        try {
                            while (this.cacheManager.failoverEnabledCacheExists()) {
                                this.event = sub.receive(300000L);
                                if (this.event == null) continue;
                                this.handleEvent(this.event);
                            }
                        }
                        catch (ONSException e3) {
                            Object var7_10;
                            sub.close();
                            if (!TRACE || !OracleLog.recursiveEnter()) break block27;
                            try {
                                OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_10, Integer.toHexString(this.hashCode()).toUpperCase() + " Event: " + "OracleRuntimeLoadBalancingEventHandlerThread.run()-" + " ONSException " + e3.getMessage());
                                var7_10 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                var7_10 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ea) {
                    Object var9_11;
                    if (!TRACE || !OracleLog.recursiveEnter()) continue;
                    try {
                        OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleRuntimeLoadBalancingEventHandlerThread.run Got" + " an InterruptedException" + ea.getMessage());
                        var9_11 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        var9_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var13_18 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_23 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_22 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_20 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleEvent(Notification event) {
        try {
            block12: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(event));
                        Object var3_2 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                try {
                    this.cacheManager.parseRuntimeLoadBalancingEvent(this.m_service, event == null ? null : event.body());
                }
                catch (SQLException e2) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                    try {
                        OracleRuntimeLoadBalancingEventHandlerThread.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleRuntimeLoadBalancingEventHandlerThread" + ".handleEvent() - SQLException:" + e2.getMessage());
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
            }
            Object var7_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleRuntimeLoadBalancingEventHandlerThread.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_11 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleRuntimeLoadBalancingEventHandlerThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

