/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeUPT;

public class TDSPatch {
    static final int S_NORMAL_PATCH = 0;
    static final int S_SIMPLE_PATCH = 1;
    int typeId;
    OracleType owner;
    long position;
    int uptCode;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDSPatch(int type, OracleType owner, long pos, int uptCode) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(owner) + ", " + OracleLog.argument(pos) + ", " + OracleLog.argument(uptCode));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.typeId = type;
            this.owner = owner;
            this.position = pos;
            this.uptCode = uptCode;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getType() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.typeId);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.typeId;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleNamedType getOwner() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleNamedType __result__ = (OracleNamedType)this.owner;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleNamedType oracleNamedType = __result__;
            return oracleNamedType;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPosition() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.position);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l2 = this.position;
            return l2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getUptTypeCode() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte __result__ = (byte)this.uptCode;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = __result__;
            return by;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(OracleType typeValue) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(typeValue));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.apply(typeValue, -1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(OracleType typeValue, int opcode) throws SQLException {
        block22: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(typeValue) + ", " + OracleLog.argument(opcode));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.typeId == 0) {
                    OracleTypeUPT patchElem = (OracleTypeUPT)this.owner;
                    patchElem.realType = (OracleTypeADT)typeValue;
                    if (typeValue instanceof OracleNamedType) {
                        OracleNamedType namedType = (OracleNamedType)typeValue;
                        namedType.setParent(patchElem.getParent());
                        namedType.setOrder(patchElem.getOrder());
                    }
                    break block22;
                }
                if (this.typeId == 1) {
                    OracleTypeCOLLECTION patchElem = (OracleTypeCOLLECTION)this.owner;
                    patchElem.opcode = opcode;
                    patchElem.elementType = typeValue;
                    if (typeValue instanceof OracleNamedType) {
                        OracleNamedType namedType = (OracleNamedType)typeValue;
                        namedType.setParent(patchElem);
                        namedType.setOrder(1);
                    }
                    break block22;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TDSPatch.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        TDSPatch.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleConnection oracleConnection = null;
            return oracleConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TDSPatch.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.TDSPatch"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

