/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class T4CVarcharAccessor
extends VarcharAccessor {
    T4CMAREngine mare;
    static final int t4MaxLength = 4000;
    static final int t4CallMaxLength = 4001;
    static final int t4PlsqlMaxLength = 32766;
    static final int t4SqlMinLength = 32;
    boolean underlyingLong = false;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    final int[] escapeSequenceArr = new int[1];
    final boolean[] readHeaderArr = new boolean[1];
    final boolean[] readAsNonStreamArr = new boolean[1];
    static final int NONE = -1;
    static final int DAY = 1;
    static final int MM_MONTH = 2;
    static final int FULL_MONTH = 3;
    static final int MON_MONTH = 4;
    static final int YY_YEAR = 5;
    static final int RR_YEAR = 6;
    static final int HH_HOUR = 7;
    static final int HH24_HOUR = 8;
    static final int MINUTE = 9;
    static final int SECOND = 10;
    static final int NSECOND = 11;
    static final int AM = 12;
    static final int TZR = 13;
    static final int TZH = 14;
    static final int TZM = 15;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CVarcharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(external_type) + ", " + OracleLog.argument(forBind) + ", " + OracleLog.argument(_mare));
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.calculateSizeTmpByteArray();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T4CVarcharAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form, int _oacmxl, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(max_len) + ", " + OracleLog.argument(nullable) + ", " + OracleLog.argument(flags) + ", " + OracleLog.argument(precision) + ", " + OracleLog.argument(scale) + ", " + OracleLog.argument(contflag) + ", " + OracleLog.argument(total_elems) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(_oacmxl) + ", " + OracleLog.argument(_definedColumnType) + ", " + OracleLog.argument(_definedColumnSize) + ", " + OracleLog.argument(_mare));
                    Object var15_14 = null;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            this.calculateSizeTmpByteArray();
            this.oacmxl = _oacmxl;
            if (this.oacmxl == -1) {
                this.underlyingLong = true;
                this.oacmxl = 4000;
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var19_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var19_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var19_19 = null;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalUB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        byte[] bytesBuffer = this.statement.tmpByteArray;
        int tmpSpaceCharOffset = this.columnIndex + this.lastRowProcessed * this.charLength;
        if (!this.underlyingLong) {
            if (this.rowSpaceIndicator == null) {
                byte[] buff = new byte[16000];
                this.mare.unmarshalCLR(buff, 0, this.meta);
                this.processIndicator(this.meta[0]);
                ++this.lastRowProcessed;
                return false;
            }
            if (this.isNullByDescribe) {
                this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
                this.rowSpaceIndicator[tmpLengthOffset] = 0;
                ++this.lastRowProcessed;
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
                return false;
            }
            if (this.statement.maxFieldSize > 0) {
                this.mare.unmarshalCLR(bytesBuffer, 0, this.meta, this.statement.maxFieldSize);
            } else {
                this.mare.unmarshalCLR(bytesBuffer, 0, this.meta);
            }
        } else {
            this.escapeSequenceArr[0] = this.mare.unmarshalUB1();
            if (this.mare.escapeSequenceNull(this.escapeSequenceArr[0])) {
                this.meta[0] = 0;
                this.mare.processIndicator(false, 0);
                int ignore = this.mare.unmarshalUB2();
            } else {
                int nbBytesReadTemp = 0;
                int nbBytesRead = 0;
                byte[] bufferToUse = bytesBuffer;
                int offset = 0;
                this.readHeaderArr[0] = true;
                this.readAsNonStreamArr[0] = false;
                while (nbBytesReadTemp != -1) {
                    if (bufferToUse == bytesBuffer && nbBytesRead + 255 > bytesBuffer.length) {
                        bufferToUse = new byte[255];
                    }
                    offset = bufferToUse == bytesBuffer ? nbBytesRead : 0;
                    nbBytesReadTemp = T4CLongAccessor.readStreamFromWire(bufferToUse, offset, 255, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer);
                    if (this.statement.connection.calculateChecksum && nbBytesReadTemp != -1) {
                        long _checkSum;
                        this.statement.checkSum = _checkSum = CRC64.updateChecksum(this.statement.checkSum, bufferToUse, offset, nbBytesReadTemp);
                    }
                    if (nbBytesReadTemp == -1) continue;
                    if (bufferToUse == bytesBuffer) {
                        nbBytesRead += nbBytesReadTemp;
                        continue;
                    }
                    if (bytesBuffer.length - nbBytesRead <= 0) continue;
                    int nbBytesAvailable = bytesBuffer.length - nbBytesRead;
                    System.arraycopy(bufferToUse, 0, bytesBuffer, nbBytesRead, nbBytesAvailable);
                    nbBytesRead += nbBytesAvailable;
                }
                if (bufferToUse != bytesBuffer) {
                    bufferToUse = null;
                }
                this.meta[0] = nbBytesRead;
            }
        }
        this.tmp[0] = this.meta[0];
        int nbOfCharsConverted = 0;
        nbOfCharsConverted = this.formOfUse == 2 ? this.statement.connection.conversion.NCHARBytesToJavaChars(bytesBuffer, 0, this.rowSpaceChar, tmpSpaceCharOffset + 1, this.tmp, this.charLength - 1) : this.statement.connection.conversion.CHARBytesToJavaChars(bytesBuffer, 0, this.rowSpaceChar, tmpSpaceCharOffset + 1, this.tmp, this.charLength - 1);
        this.rowSpaceChar[tmpSpaceCharOffset] = (char)(nbOfCharsConverted * 2);
        if (!this.underlyingLong) {
            this.processIndicator(this.meta[0]);
        }
        if (this.meta[0] == 0) {
            this.rowSpaceIndicator[tmpIndicatorOffset] = -1;
            this.rowSpaceIndicator[tmpLengthOffset] = 0;
        } else {
            this.rowSpaceIndicator[tmpLengthOffset] = (short)(this.meta[0] * 2);
            this.rowSpaceIndicator[tmpIndicatorOffset] = 0;
        }
        ++this.lastRowProcessed;
        return false;
    }

    void copyRow() throws SQLException, IOException {
        int lastRowOffset = this.lastRowProcessed == 0 ? this.statement.rowPrefetchInLastFetch - 1 : this.lastRowProcessed - 1;
        int tmpSpaceCharOffset = this.columnIndex + this.lastRowProcessed * this.charLength;
        int tmpSpaceCharOffsetLastRow = this.columnIndex + lastRowOffset * this.charLength;
        int tmpIndicatorOffset = this.indicatorIndex + this.lastRowProcessed;
        int tmpIndicatorOffsetLastRow = this.indicatorIndex + lastRowOffset;
        int tmpLengthOffset = this.lengthIndex + this.lastRowProcessed;
        int tmpLengthOffsetLastRow = this.lengthIndex + lastRowOffset;
        short nbBytes = this.rowSpaceIndicator[tmpLengthOffsetLastRow];
        int indexmetadata = this.metaDataIndex + this.lastRowProcessed * 1;
        int indexmetadataLastRow = this.metaDataIndex + lastRowOffset * 1;
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = this.rowSpaceIndicator[tmpIndicatorOffsetLastRow];
        if (!this.isNullByDescribe) {
            System.arraycopy(this.rowSpaceChar, tmpSpaceCharOffsetLastRow, this.rowSpaceChar, tmpSpaceCharOffset, this.rowSpaceChar[tmpSpaceCharOffsetLastRow] / 2 + 1);
        }
        System.arraycopy(this.rowSpaceMetaData, indexmetadataLastRow, this.rowSpaceMetaData, indexmetadata, 1);
        ++this.lastRowProcessed;
    }

    void saveDataFromOldDefineBuffers(byte[] rowSpaceByteLastRow, char[] rowSpaceCharLastRow, short[] rowSpaceIndicatorLastRow, int oldPrefetchSize, int newPrefetchSize) throws SQLException {
        int tmpSpaceCharOffset = this.columnIndex + (newPrefetchSize - 1) * this.charLength;
        int tmpSpaceCharOffsetLastRow = this.columnIndexLastRow + (oldPrefetchSize - 1) * this.charLength;
        int tmpIndicatorOffset = this.indicatorIndex + newPrefetchSize - 1;
        int tmpIndicatorOffsetLastRow = this.indicatorIndexLastRow + oldPrefetchSize - 1;
        int tmpLengthOffset = this.lengthIndex + newPrefetchSize - 1;
        int tmpLengthOffsetLastRow = this.lengthIndexLastRow + oldPrefetchSize - 1;
        short nbBytes = rowSpaceIndicatorLastRow[tmpLengthOffsetLastRow];
        this.rowSpaceIndicator[tmpLengthOffset] = nbBytes;
        this.rowSpaceIndicator[tmpIndicatorOffset] = rowSpaceIndicatorLastRow[tmpIndicatorOffsetLastRow];
        if (nbBytes != 0) {
            System.arraycopy(rowSpaceCharLastRow, tmpSpaceCharOffsetLastRow, this.rowSpaceChar, tmpSpaceCharOffset, rowSpaceCharLastRow[tmpSpaceCharOffsetLastRow] / 2 + 1);
        } else {
            this.rowSpaceChar[tmpSpaceCharOffset] = '\u0000';
        }
    }

    void calculateSizeTmpByteArray() {
        int maxNbBytes = this.formOfUse == 2 ? (this.charLength - 1) * this.statement.connection.conversion.maxNCharSize : (this.charLength - 1) * this.statement.connection.conversion.cMaxCharSize;
        if (this.statement.sizeTmpByteArray < maxNbBytes) {
            this.statement.sizeTmpByteArray = maxNbBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getString(int currentRow) throws SQLException {
        String string;
        try {
            String ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if ((ret = super.getString(currentRow)) != null && this.definedColumnSize > 0 && ret.length() > this.definedColumnSize) {
                ret = ret.substring(0, this.definedColumnSize);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = ret;
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    NUMBER getNUMBER(int currentRow) throws SQLException {
        NUMBER result = null;
        if (this.definedColumnType == 0) {
            result = super.getNUMBER(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                return T4CVarcharAccessor.StringToNUMBER(s2);
            }
        }
        return result;
    }

    DATE getDATE(int currentRow) throws SQLException {
        DATE result = null;
        if (this.definedColumnType == 0) {
            result = super.getDATE(currentRow);
        } else {
            Date d2 = this.getDate(currentRow);
            if (d2 != null) {
                result = new DATE(d2);
            }
        }
        return result;
    }

    TIMESTAMP getTIMESTAMP(int currentRow) throws SQLException {
        TIMESTAMP result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMP(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMP(ts);
            }
        }
        return result;
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
        TIMESTAMPTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    TIMESTAMPLTZ getTIMESTAMPLTZ(int currentRow) throws SQLException {
        TIMESTAMPLTZ result = null;
        if (this.definedColumnType == 0) {
            result = super.getTIMESTAMPLTZ(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                Timestamp ts = new Timestamp(cal.getTimeInMillis());
                ts.setNanos(nanos[0]);
                result = new TIMESTAMPLTZ((Connection)this.statement.connection, ts, cal);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RAW getRAW(int currentRow) throws SQLException {
        RAW result = null;
        if (this.definedColumnType == 0) {
            result = super.getRAW(currentRow);
        } else {
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CVarcharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                result = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars(currentRow)) : new RAW(super.getBytes(currentRow));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getOracleObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(currentRow);
        }
        Datum result = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            switch (this.definedColumnType) {
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(currentRow);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(currentRow);
                }
                case 91: {
                    return this.getDATE(currentRow);
                }
                case 92: {
                    return this.getDATE(currentRow);
                }
                case 93: {
                    return this.getTIMESTAMP(currentRow);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(currentRow);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(currentRow);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(currentRow);
                }
                case -8: {
                    return this.getROWID(currentRow);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return result;
    }

    byte[] getBytes(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getBytes(currentRow);
        }
        Datum datum = this.getOracleObject(currentRow);
        if (datum != null) {
            return datum.shareBytes();
        }
        return null;
    }

    boolean getBoolean(int currentRow) throws SQLException {
        boolean result = false;
        result = this.definedColumnType == 0 ? super.getBoolean(currentRow) : this.getNUMBER(currentRow).booleanValue();
        return result;
    }

    byte getByte(int currentRow) throws SQLException {
        byte result = 0;
        if (this.definedColumnType == 0) {
            result = super.getByte(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.byteValue();
            }
        }
        return result;
    }

    int getInt(int currentRow) throws SQLException {
        int result = 0;
        if (this.definedColumnType == 0) {
            result = super.getInt(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.intValue();
            }
        }
        return result;
    }

    short getShort(int currentRow) throws SQLException {
        short result = 0;
        if (this.definedColumnType == 0) {
            result = super.getShort(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.shortValue();
            }
        }
        return result;
    }

    long getLong(int currentRow) throws SQLException {
        long result = 0L;
        if (this.definedColumnType == 0) {
            result = super.getLong(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.longValue();
            }
        }
        return result;
    }

    float getFloat(int currentRow) throws SQLException {
        float result = 0.0f;
        if (this.definedColumnType == 0) {
            result = super.getFloat(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.floatValue();
            }
        }
        return result;
    }

    double getDouble(int currentRow) throws SQLException {
        double result = 0.0;
        if (this.definedColumnType == 0) {
            result = super.getDouble(currentRow);
        } else {
            NUMBER tmp = this.getNUMBER(currentRow);
            if (tmp != null) {
                result = tmp.doubleValue();
            }
        }
        return result;
    }

    Date getDate(int currentRow) throws SQLException {
        Date result = null;
        if (this.definedColumnType == 0) {
            result = super.getDate(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                result = new Date(T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nanos).getTimeInMillis());
            }
        }
        return result;
    }

    Timestamp getTimestamp(int currentRow) throws SQLException {
        Timestamp result = null;
        if (this.definedColumnType == 0) {
            result = super.getTimestamp(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                result = new Timestamp(cal.getTimeInMillis());
                result.setNanos(nanos[0]);
            }
        }
        return result;
    }

    Time getTime(int currentRow) throws SQLException {
        Time result = null;
        if (this.definedColumnType == 0) {
            result = super.getTime(currentRow);
        } else {
            String s2 = this.getString(currentRow);
            if (s2 != null) {
                int[] nanos = new int[1];
                Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                result = new Time(cal.getTimeInMillis());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    Object getObject(int currentRow) throws SQLException {
        Object var3_2;
        try {
            SQLException __ex__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(currentRow));
                    var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.definedColumnType == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + super.getObject(currentRow));
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object object = super.getObject(currentRow);
                Object var45_26 = null;
                if (!TRACE) return object;
                if (!OracleLog.recursiveEnter()) return object;
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var47_45 = null;
                    OracleLog.recursiveExit();
                    return object;
                }
                catch (Throwable throwable) {
                    Object var47_46 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object result = null;
            if (this.rowSpaceIndicator == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CVarcharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                        Object var7_102 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_103 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
                switch (this.definedColumnType) {
                    case -1: 
                    case 1: 
                    case 12: {
                        Object __result__ = this.getString(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var9_105 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var9_106 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_27 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_48 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_47 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 2: 
                    case 3: {
                        Object __result__ = this.getBigDecimal(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var11_108 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var11_109 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_28 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_50 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_49 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 4: {
                        Object __result__ = this.getInt(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var13_111 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var13_112 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_29 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_52 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_51 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -6: {
                        Object __result__ = this.getByte(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var15_114 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var15_115 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_30 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_54 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_53 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 5: {
                        Object __result__ = this.getShort(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var17_117 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var17_118 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_31 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_56 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_55 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -7: 
                    case 16: {
                        Object __result__ = this.getBoolean(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var19_120 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var19_121 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_32 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_58 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_57 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -5: {
                        Object __result__ = this.getLong(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var21_123 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var21_124 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_33 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_60 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_59 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 7: {
                        Object __result__ = Float.valueOf(this.getFloat(currentRow));
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var23_126 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var23_127 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_34 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_62 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_61 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 6: 
                    case 8: {
                        Object __result__ = this.getDouble(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var25_129 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var25_130 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_35 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_64 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_63 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 91: {
                        Object __result__ = this.getDate(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var27_132 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var27_133 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_36 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_66 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_65 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 92: {
                        Object __result__ = this.getTime(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var29_135 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var29_136 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_37 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_68 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_67 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case 93: {
                        Object __result__ = this.getTimestamp(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var31_138 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var31_139 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_38 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_70 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_69 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -101: {
                        Object __result__ = this.getTIMESTAMPTZ(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var33_141 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var33_142 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_39 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_72 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_71 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -102: {
                        Object __result__ = this.getTIMESTAMPLTZ(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var35_144 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var35_145 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_40 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_74 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_73 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        Object __result__ = this.getBytesFromHexChars(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var37_147 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var37_148 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_41 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_76 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_75 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                    case -8: {
                        Object __result__ = this.getROWID(currentRow);
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                                Object var39_150 = null;
                                OracleLog.recursiveExit();
                            }
                            catch (Throwable throwable) {
                                Object var39_151 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                        }
                        Object object = __result__;
                        Object var45_42 = null;
                        if (!TRACE) return object;
                        if (!OracleLog.recursiveEnter()) return object;
                        try {}
                        catch (Throwable throwable) {
                            Object var47_78 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var47_77 = null;
                        OracleLog.recursiveExit();
                        return object;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CVarcharAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                        Object var41_153 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var41_154 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    Object var43_156 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var43_157 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            var3_2 = result;
            Object var45_43 = null;
            if (!TRACE) return var3_2;
        }
        catch (Throwable throwable) {
            Object var45_44 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var47_82 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var47_81 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return var3_2;
        try {}
        catch (Throwable throwable) {
            Object var47_80 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        T4CVarcharAccessor.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var47_79 = null;
        OracleLog.recursiveExit();
        return var3_2;
    }

    static final NUMBER StringToNUMBER(String str) throws SQLException {
        return new NUMBER(new BigDecimal(str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Calendar DATEStringToCalendar(String value, String fmt, int[] out) throws SQLException {
        char[] fmtChars = (fmt + " ").toCharArray();
        value = value + " ";
        int sLength = Math.min(value.length(), fmtChars.length);
        int state = -1;
        int oldState = -1;
        int index = 0;
        int prevIndex = 0;
        int vsIndex = 0;
        int veIndex = 0;
        int day = 0;
        int month = 0;
        int year = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nsecond = 0;
        String am = null;
        String tzr = null;
        boolean needToProcessValue = false;
        String[] sMonths = null;
        String[] lMonths = null;
        for (int i2 = 0; i2 < sLength; ++i2) {
            switch (fmtChars[i2]) {
                case 'R': 
                case 'r': {
                    if (state == 6) break;
                    state = 6;
                    index = i2;
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (state == 5) break;
                    state = 5;
                    index = i2;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (state == 1) break;
                    state = 1;
                    index = i2;
                    break;
                }
                case 'M': 
                case 'm': {
                    if (state == 2 && state == 4 && state == 3 && state == 9) break;
                    index = i2;
                    if (!(i2 + 4 >= sLength || fmtChars[i2 + 1] != 'O' && fmtChars[i2 + 1] != 'o' || fmtChars[i2 + 2] != 'N' && fmtChars[i2 + 2] != 'n' || fmtChars[i2 + 3] != 'T' && fmtChars[i2 + 3] != 't' || fmtChars[i2 + 4] != 'H' && fmtChars[i2 + 4] != 'h')) {
                        state = 3;
                        i2 += 4;
                        break;
                    }
                    if (!(i2 + 2 >= sLength || fmtChars[i2 + 1] != 'O' && fmtChars[i2 + 1] != 'o' || fmtChars[i2 + 2] != 'N' && fmtChars[i2 + 2] != 'n')) {
                        state = 4;
                        i2 += 2;
                        break;
                    }
                    if (i2 + 1 < sLength && (fmtChars[i2 + 1] == 'M' || fmtChars[i2 + 1] == 'm')) {
                        state = 2;
                        ++i2;
                        break;
                    }
                    if (i2 + 1 >= sLength || fmtChars[i2 + 1] != 'I' && fmtChars[i2 + 1] != 'i') break;
                    state = 9;
                    ++i2;
                    break;
                }
                case 'H': 
                case 'h': {
                    if (state != 7) {
                        state = 7;
                        index = i2;
                        break;
                    }
                    if (i2 + 2 >= sLength || fmtChars[i2 + 1] != '2' && fmtChars[i2 + 4] != '4') break;
                    state = 8;
                    i2 += 2;
                    break;
                }
                case 'S': 
                case 's': {
                    if (i2 + 1 >= sLength || fmtChars[i2 + 1] != 'S' && fmtChars[i2 + 1] != 's') break;
                    state = 10;
                    index = i2++;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (state == 11) break;
                    state = 11;
                    index = i2;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (i2 + 1 >= sLength || fmtChars[i2 + 1] != 'M' && fmtChars[i2 + 1] != 'm') break;
                    state = 12;
                    index = i2++;
                    break;
                }
                case 'T': 
                case 't': {
                    if (i2 + 2 >= sLength || fmtChars[i2 + 1] != 'Z' && fmtChars[i2 + 1] != 'z' || fmtChars[i2 + 2] != 'R' && fmtChars[i2 + 2] != 'r') break;
                    state = 13;
                    index = i2;
                    i2 += 2;
                    break;
                }
                default: {
                    needToProcessValue = true;
                }
            }
            if (!needToProcessValue || state == -1) continue;
            int length = i2 - index;
            int skip = index - prevIndex;
            vsIndex = veIndex + skip;
            veIndex = vsIndex + length;
            switch (state) {
                case 1: {
                    day = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 2: {
                    month = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 3: {
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && value.charAt(x) != fmtChars[i2]; ++x) {
                    }
                    veIndex = x;
                    String temp = null;
                    if (veIndex == vsIndex) break;
                    temp = value.substring(vsIndex, veIndex);
                    temp = temp.trim();
                    if (lMonths == null) {
                        lMonths = new DateFormatSymbols().getMonths();
                    }
                    for (month = 0; month < lMonths.length && !temp.equalsIgnoreCase(lMonths[month]); ++month) {
                    }
                    if (month < 12) break;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CVarcharAccessor.logger().log(Level.SEVERE, "         Throwing SQLException: 59");
                            Object var30_33 = null;
                        }
                        catch (Throwable throwable) {
                            Object var30_34 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                case 4: {
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && value.charAt(x) != fmtChars[i2]; ++x) {
                    }
                    veIndex = x;
                    String temp = null;
                    if (veIndex == vsIndex) break;
                    temp = value.substring(vsIndex, veIndex);
                    temp = temp.trim();
                    if (sMonths == null) {
                        sMonths = new DateFormatSymbols().getShortMonths();
                    }
                    for (month = 0; month < sMonths.length && !temp.equalsIgnoreCase(sMonths[month]); ++month) {
                    }
                    if (month < 12) break;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CVarcharAccessor.logger().log(Level.SEVERE, "         Throwing SQLException: 59");
                            Object var32_37 = null;
                        }
                        catch (Throwable throwable) {
                            Object var32_38 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 59);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                case 5: {
                    year = Integer.parseInt(value.substring(vsIndex, veIndex));
                    if (length != 2) break;
                    year += 2000;
                    break;
                }
                case 6: {
                    year = Integer.parseInt(value.substring(vsIndex, veIndex));
                    if (length == 2 && year < 50) {
                        year += 2000;
                        break;
                    }
                    year += 1900;
                    break;
                }
                case 7: 
                case 8: {
                    veIndex = vsIndex + 2;
                    hour = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 9: {
                    minute = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 10: {
                    second = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 11: {
                    char c2;
                    int x = vsIndex;
                    veIndex = vsIndex;
                    for (x = vsIndex; x < value.length() && (c2 = value.charAt(x)) >= '0' && c2 <= '9'; ++x) {
                    }
                    if ((veIndex += x - vsIndex) == vsIndex) break;
                    nsecond = Integer.parseInt(value.substring(vsIndex, veIndex));
                    break;
                }
                case 12: {
                    if (veIndex <= 0) break;
                    am = value.substring(vsIndex, veIndex);
                    break;
                }
                case 13: {
                    char c2;
                    int x = vsIndex;
                    veIndex = vsIndex;
                    x = vsIndex;
                    while (x < value.length() && ((c2 = value.charAt(x)) >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                        veIndex = x++;
                    }
                    if (veIndex == vsIndex) break;
                    tzr = value.substring(vsIndex, veIndex);
                    break;
                }
                default: {
                    System.out.println("\n\n\n             ***** ERROR(1) ****\n");
                }
            }
            prevIndex = i2;
            state = -1;
            needToProcessValue = false;
        }
        GregorianCalendar cal = new GregorianCalendar(year, month, day, hour, minute, second);
        if (am != null) {
            cal.set(9, am.equalsIgnoreCase("AM") ? 0 : 1);
        }
        if (tzr != null) {
            // empty if block
        }
        if (nsecond != 0) {
            out[0] = nsecond;
        }
        return cal;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CVarcharAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

