/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

class SensitiveScrollableResultSet
extends ScrollableResultSet {
    int beginLastFetchedIndex;
    int endLastFetchedIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SensitiveScrollableResultSet(ScrollRsetStatement scrollStmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        super(scrollStmt, rset, type, update);
        try {
            int valid_rows;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(scrollStmt) + ", " + OracleLog.argument(rset) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(update));
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if ((valid_rows = rset.getValidRows()) > 0) {
                this.beginLastFetchedIndex = 1;
                this.endLastFetchedIndex = valid_rows;
            } else {
                this.beginLastFetchedIndex = 0;
                this.endLastFetchedIndex = 0;
            }
            Object var8_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_14 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_11 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        Object var3_2 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (super.next()) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            Object var5_7 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl = true;
                    Object var9_10 = null;
                    if (!TRACE) return bl;
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_13 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var7_22 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_23 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl = false;
                Object var9_11 = null;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {}
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
                OracleLog.recursiveExit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean first() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            try {
                block17: {
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            var3_2 = null;
                        }
                        catch (Throwable var2_4) {
                            var3_3 = null;
                            OracleLog.recursiveExit();
                            throw var2_4;
                        }
                        OracleLog.recursiveExit();
                    }
                    if (!super.first()) break block17;
                    this.handle_refetch();
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            var5_7 = null;
                        }
                        catch (Throwable var4_9) {
                            var5_8 = null;
                            OracleLog.recursiveExit();
                            throw var4_9;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_5 = true;
                    var9_10 = null;
                    if (SensitiveScrollableResultSet.TRACE == false) return var2_5;
                    ** GOTO lbl67
                }
                if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        var7_22 = null;
                    }
                    catch (Throwable var6_24) {
                        var7_23 = null;
                        OracleLog.recursiveExit();
                        throw var6_24;
                    }
                    OracleLog.recursiveExit();
                }
                var2_6 = false;
                ** GOTO lbl80
            }
            catch (Throwable var8_25) {
                var9_12 = null;
                if (SensitiveScrollableResultSet.TRACE == false) throw var8_25;
                if (OracleLog.recursiveEnter() == false) throw var8_25;
                try {
                    SensitiveScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var11_17 = null;
                }
                catch (Throwable var10_21) {
                    var11_18 = null;
                    OracleLog.recursiveExit();
                    throw var10_21;
                }
lbl67:
                // 1 sources

                if (OracleLog.recursiveEnter() == false) return var2_5;
                try {}
                catch (Throwable var10_19) {
                    var11_14 = null;
                    OracleLog.recursiveExit();
                    throw var10_19;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_13 = null;
                OracleLog.recursiveExit();
                return var2_5;
lbl80:
                // 1 sources

                var9_11 = null;
                if (SensitiveScrollableResultSet.TRACE == false) return var2_6;
                if (OracleLog.recursiveEnter() == false) return var2_6;
                try {}
                catch (Throwable var10_20) {
                    var11_16 = null;
                    OracleLog.recursiveExit();
                    throw var10_20;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_15 = null;
                OracleLog.recursiveExit();
                return var2_6;
                OracleLog.recursiveExit();
                throw var8_25;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean last() throws SQLException {
        boolean bl;
        PhysicalConnection physicalConnection = this.connection;
        // MONITORENTER : physicalConnection
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SensitiveScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (super.last()) {
                this.handle_refetch();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = true;
                Object var9_10 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_13 = null;
                        OracleLog.recursiveExit();
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                // MONITOREXIT : physicalConnection
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    Object var7_22 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var7_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var9_11 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_17 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var11_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var11_15 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean absolute(int row) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(row));
                        Object var4_3 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                if (super.absolute(row)) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            Object var6_8 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    boolean bl = true;
                    Object var10_11 = null;
                    if (!TRACE) return bl;
                    if (!OracleLog.recursiveEnter()) return bl;
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var12_14 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var8_23 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var8_24 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl = false;
                Object var10_12 = null;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {}
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_16 = null;
                OracleLog.recursiveExit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (!TRACE) throw throwable;
                if (!OracleLog.recursiveEnter()) throw throwable;
                try {}
                catch (Throwable throwable2) {
                    Object var12_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean relative(int rows) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean previous() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            try {
                block17: {
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            var3_2 = null;
                        }
                        catch (Throwable var2_4) {
                            var3_3 = null;
                            OracleLog.recursiveExit();
                            throw var2_4;
                        }
                        OracleLog.recursiveExit();
                    }
                    if (!super.previous()) break block17;
                    this.handle_refetch();
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            var5_7 = null;
                        }
                        catch (Throwable var4_9) {
                            var5_8 = null;
                            OracleLog.recursiveExit();
                            throw var4_9;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_5 = true;
                    var9_10 = null;
                    if (SensitiveScrollableResultSet.TRACE == false) return var2_5;
                    ** GOTO lbl67
                }
                if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        var7_22 = null;
                    }
                    catch (Throwable var6_24) {
                        var7_23 = null;
                        OracleLog.recursiveExit();
                        throw var6_24;
                    }
                    OracleLog.recursiveExit();
                }
                var2_6 = false;
                ** GOTO lbl80
            }
            catch (Throwable var8_25) {
                var9_12 = null;
                if (SensitiveScrollableResultSet.TRACE == false) throw var8_25;
                if (OracleLog.recursiveEnter() == false) throw var8_25;
                try {
                    SensitiveScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var11_17 = null;
                }
                catch (Throwable var10_21) {
                    var11_18 = null;
                    OracleLog.recursiveExit();
                    throw var10_21;
                }
lbl67:
                // 1 sources

                if (OracleLog.recursiveEnter() == false) return var2_5;
                try {}
                catch (Throwable var10_19) {
                    var11_14 = null;
                    OracleLog.recursiveExit();
                    throw var10_19;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_13 = null;
                OracleLog.recursiveExit();
                return var2_5;
lbl80:
                // 1 sources

                var9_11 = null;
                if (SensitiveScrollableResultSet.TRACE == false) return var2_6;
                if (OracleLog.recursiveEnter() == false) return var2_6;
                try {}
                catch (Throwable var10_20) {
                    var11_16 = null;
                    OracleLog.recursiveExit();
                    throw var10_20;
                }
                SensitiveScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_15 = null;
                OracleLog.recursiveExit();
                return var2_6;
                OracleLog.recursiveExit();
                throw var8_25;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (!this.isValidRow(this.currentRow)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                            Object var5_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int direction = this.getFetchDirection();
                int realSz = 0;
                try {
                    realSz = this.refreshRowsInCache(this.currentRow, this.getFetchSize(), direction);
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2 + 90 + "Unsupported syntax for refreshRow()");
                            Object var7_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2, 90, "Unsupported syntax for refreshRow()");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (realSz != 0) {
                    this.beginLastFetchedIndex = this.currentRow;
                    this.endLastFetchedIndex = this.currentRow + realSz - 1;
                }
                Object var9_16 = null;
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var11_20 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var11_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SensitiveScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeRowInCache(int rowIdx) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block18: {
                try {
                    int retval;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowIdx));
                            Object var4_3 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    if ((retval = super.removeRowInCache(rowIdx)) != 0) {
                        if (rowIdx >= this.beginLastFetchedIndex && rowIdx <= this.endLastFetchedIndex && this.beginLastFetchedIndex != this.endLastFetchedIndex) {
                            --this.endLastFetchedIndex;
                        } else {
                            this.endLastFetchedIndex = 0;
                            this.beginLastFetchedIndex = 0;
                        }
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + retval);
                            Object var6_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    n2 = retval;
                    {
                        Object var8_11 = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var10_15 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var10_16 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    throw throwable;
                }
                {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block18;
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var10_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handle_refetch() throws SQLException {
        var1_1 = this.connection;
        synchronized (var1_1) {
            try {
                block17: {
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                            var3_2 = null;
                        }
                        catch (Throwable var2_4) {
                            var3_3 = null;
                            OracleLog.recursiveExit();
                            throw var2_4;
                        }
                        OracleLog.recursiveExit();
                    }
                    if ((this.currentRow < this.beginLastFetchedIndex || this.currentRow > this.endLastFetchedIndex) && (this.currentRow < this.endLastFetchedIndex || this.currentRow > this.beginLastFetchedIndex)) break block17;
                    if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            var5_7 = null;
                        }
                        catch (Throwable var4_9) {
                            var5_8 = null;
                            OracleLog.recursiveExit();
                            throw var4_9;
                        }
                        OracleLog.recursiveExit();
                    }
                    var2_5 = false;
                    var9_10 = null;
                    if (SensitiveScrollableResultSet.TRACE == false) return var2_5;
                    ** GOTO lbl66
                }
                this.refreshRow();
                if (SensitiveScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        var7_22 = null;
                    }
                    catch (Throwable var6_24) {
                        var7_23 = null;
                        OracleLog.recursiveExit();
                        throw var6_24;
                    }
                    OracleLog.recursiveExit();
                }
                var2_6 = true;
                ** GOTO lbl79
            }
            catch (Throwable var8_25) {
                var9_12 = null;
                if (SensitiveScrollableResultSet.TRACE == false) throw var8_25;
                if (OracleLog.recursiveEnter() == false) throw var8_25;
                try {
                    SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var11_17 = null;
                }
                catch (Throwable var10_21) {
                    var11_18 = null;
                    OracleLog.recursiveExit();
                    throw var10_21;
                }
lbl66:
                // 1 sources

                if (OracleLog.recursiveEnter() == false) return var2_5;
                try {}
                catch (Throwable var10_19) {
                    var11_14 = null;
                    OracleLog.recursiveExit();
                    throw var10_19;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_13 = null;
                OracleLog.recursiveExit();
                return var2_5;
lbl79:
                // 1 sources

                var9_11 = null;
                if (SensitiveScrollableResultSet.TRACE == false) return var2_6;
                if (OracleLog.recursiveEnter() == false) return var2_6;
                try {}
                catch (Throwable var10_20) {
                    var11_16 = null;
                    OracleLog.recursiveExit();
                    throw var10_20;
                }
                SensitiveScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var11_15 = null;
                OracleLog.recursiveExit();
                return var2_6;
                OracleLog.recursiveExit();
                throw var8_25;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.SensitiveScrollableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

