/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.CachedRowElement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetCacheImpl;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class ScrollableResultSet
extends BaseResultSet {
    PhysicalConnection connection;
    OracleResultSetImpl resultSet;
    ScrollRsetStatement scrollStmt;
    ResultSetMetaData metadata;
    private int rsetType;
    private int rsetConcurency;
    private int beginColumnIndex;
    private int columnCount;
    private int wasNull;
    OracleResultSetCache rsetCache;
    int currentRow;
    private int numRowsCached;
    private boolean allRowsCached;
    private int lastRefetchSz;
    private Vector refetchRowids;
    private OraclePreparedStatement refetchStmt;
    private int usrFetchDirection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScrollableResultSet(ScrollRsetStatement stmt, OracleResultSetImpl rset, int type, int update) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(rset) + ", " + OracleLog.argument(type) + ", " + OracleLog.argument(update));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.connection = ((OracleStatement)stmt).connection;
            this.resultSet = rset;
            this.metadata = null;
            this.scrollStmt = stmt;
            this.rsetType = type;
            this.rsetConcurency = update;
            this.beginColumnIndex = ScrollableResultSet.needIdentifier(type, update) ? 1 : 0;
            this.columnCount = 0;
            this.wasNull = -1;
            this.rsetCache = stmt.getResultSetCache();
            if (this.rsetCache == null) {
                this.rsetCache = new OracleResultSetCacheImpl();
            } else {
                try {
                    this.rsetCache.clear();
                }
                catch (IOException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            this.currentRow = 0;
            this.numRowsCached = 0;
            this.allRowsCached = false;
            this.lastRefetchSz = 0;
            this.refetchRowids = null;
            this.refetchStmt = null;
            this.usrFetchDirection = 1000;
            this.getInternalMetadata();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block37: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!this.closed) break block37;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.refetchStmt != null) {
                this.refetchStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            if (this.refetchRowids != null) {
                this.refetchRowids.removeAllElements();
            }
            this.resultSet = null;
            this.scrollStmt = null;
            this.refetchStmt = null;
            this.refetchRowids = null;
            this.metadata = null;
            try {
                if (this.rsetCache != null) {
                    this.rsetCache.clear();
                    this.rsetCache.close();
                }
            }
            catch (IOException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            finally {
                this.rsetCache = null;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.wasNull == -1) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 24);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.wasNull == 1));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl = this.wasNull == 1;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getStatement() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Statement statement;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Statement)((Object)this.scrollStmt));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                statement = (Statement)((Object)this.scrollStmt);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return statement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBeginColumnIndex() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.beginColumnIndex = 0;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet getResultSet() {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetImpl oracleResultSetImpl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.resultSet);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSetImpl = this.resultSet;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleResultSetImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int removeRowInCache(int rowIdx) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(rowIdx));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!this.isEmptyResultSet() && this.isValidRow(rowIdx)) {
                    this.removeCachedRowAt(rowIdx);
                    --this.numRowsCached;
                    if (rowIdx >= this.currentRow) {
                        --this.currentRow;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    int n2 = 1;
                    return n2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n3 = 0;
                return n3;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int refreshRowsInCache(int beginIdx, int count, int direction) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(direction));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleResultSetImpl refetchRset = null;
                int actualRefetchSize = 0;
                actualRefetchSize = this.get_refetch_size(beginIdx, count, direction);
                try {
                    if (actualRefetchSize > 0) {
                        if (actualRefetchSize != this.lastRefetchSz) {
                            if (this.refetchStmt != null) {
                                this.refetchStmt.close();
                            }
                            this.refetchStmt = this.prepare_refetch_statement(actualRefetchSize);
                            this.refetchStmt.setQueryTimeout(((OracleStatement)this.scrollStmt).getQueryTimeout());
                            this.lastRefetchSz = actualRefetchSize;
                        }
                        this.prepare_refetch_binds(this.refetchStmt, actualRefetchSize);
                        refetchRset = (OracleResultSetImpl)this.refetchStmt.executeQuery();
                        this.save_refetch_results(refetchRset, beginIdx, actualRefetchSize, direction);
                    }
                }
                finally {
                    if (refetchRset != null) {
                        refetchRset.close();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + actualRefetchSize);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = actualRefetchSize;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block33: {
                boolean __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (!this.isEmptyResultSet()) break block33;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__2 = false;
                    if (!TRACE) return __ex__2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return __ex__2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return __ex__2;
            }
            this.currentRow = this.currentRow < 1 ? 1 : ++this.currentRow;
            boolean __result__ = this.isValidRow(this.currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBeforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                boolean __result__;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                boolean bl2 = __result__ = !this.isEmptyResultSet() && this.currentRow < 1;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                boolean __result__;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                boolean bl2 = __result__ = !this.isEmptyResultSet() && this.currentRow > 0 && !this.isValidRow(this.currentRow);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bl = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.currentRow == 1));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl = this.currentRow == 1;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (!this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1)));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl = !this.isEmptyResultSet() && this.isValidRow(this.currentRow) && !this.isValidRow(this.currentRow + 1);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeFirst() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block24: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (this.isEmptyResultSet()) break block24;
                    this.currentRow = 0;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterLast() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block24: {
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.isEmptyResultSet()) break block24;
                    this.currentRow = this.getLastRow() + 1;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block33: {
                boolean __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (!this.isEmptyResultSet()) break block33;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__2 = false;
                    if (!TRACE) return __ex__2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return __ex__2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return __ex__2;
            }
            this.currentRow = 1;
            boolean __result__ = this.isValidRow(this.currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block33: {
                boolean __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (!this.isEmptyResultSet()) break block33;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__2 = false;
                    if (!TRACE) return __ex__2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return __ex__2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return __ex__2;
            }
            this.currentRow = this.getLastRow();
            boolean __result__ = this.isValidRow(this.currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block33: {
                int n2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                    if (!this.isValidRow(this.currentRow)) break block33;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.currentRow);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    n2 = this.currentRow;
                    if (!TRACE) return n2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return n2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = 0;
            if (!TRACE) return n3;
            if (!OracleLog.recursiveEnter()) return n3;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean absolute(int row) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block42: {
                boolean __ex__3;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(row));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (row == 0) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "absolute(" + row + ")");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__3 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "absolute(" + row + ")");
                        __ex__3.fillInStackTrace();
                        throw __ex__3;
                    }
                    if (!this.isEmptyResultSet()) break block42;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__3 = false;
                    if (!TRACE) return __ex__3;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return __ex__3;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return __ex__3;
            }
            if (row > 0) {
                this.currentRow = row;
            } else if (row < 0) {
                this.currentRow = this.getLastRow() + 1 + row;
            }
            boolean __result__ = this.isValidRow(this.currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean relative(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block41: {
                block38: {
                    boolean __ex__2;
                    try {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rows));
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        if (this.closed) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                            __ex__2.fillInStackTrace();
                            throw __ex__2;
                        }
                        if (!this.isEmptyResultSet()) break block38;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        __ex__2 = false;
                        if (!TRACE) return __ex__2;
                    }
                    catch (Throwable throwable) {
                        if (!TRACE) throw throwable;
                        if (!OracleLog.recursiveEnter()) throw throwable;
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            throw throwable;
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (!OracleLog.recursiveEnter()) return __ex__2;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                    return __ex__2;
                }
                if (!this.isValidRow(this.currentRow)) break block41;
                this.currentRow += rows;
                boolean __result__ = this.isValidRow(this.currentRow);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = __result__;
                if (!TRACE) return bl;
                if (!OracleLog.recursiveEnter()) return bl;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 82 + "relative");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "relative");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block33: {
                boolean __ex__2;
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (this.closed) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                        __ex__2.fillInStackTrace();
                        throw __ex__2;
                    }
                    if (!this.isEmptyResultSet()) break block33;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    __ex__2 = false;
                    if (!TRACE) return __ex__2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return __ex__2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return __ex__2;
            }
            this.currentRow = this.isAfterLast() ? this.getLastRow() : --this.currentRow;
            boolean __result__ = this.isValidRow(this.currentRow);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum getOracleObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                this.wasNull = -1;
                if (!this.isValidRow(this.currentRow)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Datum value = this.getCachedDatumValueAt(this.currentRow, columnIndex + this.beginColumnIndex);
                int n2 = this.wasNull = value == null ? 1 : 0;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + value);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datum = value;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datum;
        }
    }

    /*
     * Exception decompiling
     */
    public String getString(int columnIndex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 41[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBoolean(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                boolean bl;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    boolean __result__ = datum.booleanValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    bl = __result__;
                    if (!TRACE) return bl;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return bl;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            if (!TRACE) return bl;
            if (!OracleLog.recursiveEnter()) return bl;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSet.AuthorizationIndicator authorizationIndicator;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!this.isValidRow(this.currentRow)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                CachedRowElement cachedElement = null;
                OracleResultSet.AuthorizationIndicator indicator = null;
                try {
                    cachedElement = (CachedRowElement)this.rsetCache.get(this.currentRow, columnIndex);
                }
                catch (IOException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (cachedElement != null) {
                    indicator = cachedElement.getIndicator();
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (Object)((Object)indicator));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                authorizationIndicator = indicator;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return authorizationIndicator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte getByte(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                byte by;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    byte __result__ = datum.byteValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    by = __result__;
                    if (!TRACE) return by;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return by;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return by;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by = 0;
            if (!TRACE) return by;
            if (!OracleLog.recursiveEnter()) return by;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            short s2;
            try {
                long result;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((result = this.getLong(columnIndex)) > 65537L || result < -65538L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 26 + "getShort");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (short)result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                s2 = (short)result;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return s2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInt(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                int n2;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    int __result__ = datum.intValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    n2 = __result__;
                    if (!TRACE) return n2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return n2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return n2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = 0;
            if (!TRACE) return n3;
            if (!OracleLog.recursiveEnter()) return n3;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLong(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                long l2;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    long __result__ = datum.longValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    l2 = __result__;
                    if (!TRACE) return l2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return l2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return l2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = 0L;
            if (!TRACE) return l3;
            if (!OracleLog.recursiveEnter()) return l3;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getFloat(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                float f2;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    float __result__ = datum.floatValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    f2 = __result__;
                    if (!TRACE) return f2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return f2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return f2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f3 = 0.0f;
            if (!TRACE) return f3;
            if (!OracleLog.recursiveEnter()) return f3;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return f3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getDouble(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block29: {
                double d2;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block29;
                    double __result__ = datum.doubleValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    d2 = __result__;
                    if (!TRACE) return d2;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return d2;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return d2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 0);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d3 = 0.0;
            if (!TRACE) return d3;
            if (!OracleLog.recursiveEnter()) return d3;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return d3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                BigDecimal bigDecimal;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    BigDecimal __result__ = datum.bigDecimalValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    bigDecimal = __result__;
                    if (!TRACE) return bigDecimal;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return bigDecimal;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return bigDecimal;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal = null;
            if (!TRACE) return bigDecimal;
            if (!OracleLog.recursiveEnter()) return bigDecimal;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            byte[] byArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byte[] result = null;
                Datum datum = this.getOracleObject(columnIndex);
                if (datum != null) {
                    if (datum instanceof RAW) {
                        result = ((RAW)datum).shareBytes();
                    } else if (datum instanceof BLOB) {
                        BLOB blob = (BLOB)datum;
                        long length = blob.length();
                        if (length > Integer.MAX_VALUE) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 151);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
                            __ex__.fillInStackTrace();
                            throw __ex__;
                        }
                        result = blob.getBytes(1L, (int)length);
                        if (blob.isTemporary()) {
                            this.resultSet.statement.addToTempLobsToFree(blob);
                        }
                    } else {
                        result = datum.getBytes();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                byArray = result;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(columnIndex);
                Date d2 = null;
                if (datum != null) {
                    ResultSetMetaData rsmd = this.getInternalMetadata();
                    switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                        case -101: {
                            d2 = ((TIMESTAMPTZ)datum).dateValue(this.connection);
                            break;
                        }
                        case -102: {
                            d2 = ((TIMESTAMPLTZ)datum).dateValue(this.connection);
                            break;
                        }
                        default: {
                            d2 = datum.dateValue();
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = d2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(columnIndex);
                Time d2 = null;
                if (datum != null) {
                    ResultSetMetaData rsmd = this.getInternalMetadata();
                    switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                        case -101: {
                            d2 = ((TIMESTAMPTZ)datum).timeValue(this.connection);
                            break;
                        }
                        case -102: {
                            d2 = ((TIMESTAMPLTZ)datum).timeValue(this.connection, this.connection.getDbTzCalendar());
                            break;
                        }
                        default: {
                            d2 = datum.timeValue();
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = d2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(columnIndex);
                Timestamp d2 = null;
                if (datum != null) {
                    ResultSetMetaData rsmd = this.getInternalMetadata();
                    switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                        case -101: {
                            d2 = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                            break;
                        }
                        case -102: {
                            d2 = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, this.connection.getDbTzCalendar());
                            break;
                        }
                        default: {
                            d2 = datum.timestampValue();
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = d2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                InputStream inputStream;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    InputStream __result__ = datum.asciiStreamValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    inputStream = __result__;
                    if (!TRACE) return inputStream;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return inputStream;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return inputStream;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = null;
            if (!TRACE) return inputStream;
            if (!OracleLog.recursiveEnter()) return inputStream;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            try {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl78
                dbconv = this.connection.conversion;
                bytes = datum.shareBytes();
                if (datum instanceof RAW) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var6_9 = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3);
                    if (ScrollableResultSet.TRACE == false) return var6_9;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var13_18) {
                if (ScrollableResultSet.TRACE == false) throw var13_18;
                if (OracleLog.recursiveEnter() == false) throw var13_18;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    throw var13_18;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (OracleLog.recursiveEnter() == false) return var6_9;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var6_9;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof CHAR)) ** GOTO lbl-1000
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var6_10 = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1);
                if (ScrollableResultSet.TRACE == false) return var6_10;
            }
            if (OracleLog.recursiveEnter() == false) return var6_10;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var6_10;
lbl-1000:
            // 1 sources

            {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getUnicodeStream");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream");
                __ex__.fillInStackTrace();
                throw __ex__;
lbl78:
                // 1 sources

                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = null;
                if (ScrollableResultSet.TRACE == false) return var4_6;
            }
            if (OracleLog.recursiveEnter() == false) return var4_6;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                InputStream inputStream;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    InputStream __result__ = datum.binaryStreamValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    inputStream = __result__;
                    if (!TRACE) return inputStream;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return inputStream;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return inputStream;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = null;
            if (!TRACE) return inputStream;
            if (!OracleLog.recursiveEnter()) return inputStream;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object __result__ = this.getObject(columnIndex, this.connection.getTypeMap());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            object = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block27: {
                Reader reader;
                try {
                    Datum datum;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if ((datum = this.getOracleObject(columnIndex)) == null) break block27;
                    Reader __result__ = datum.characterStreamValue();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    reader = __result__;
                    if (!TRACE) return reader;
                }
                catch (Throwable throwable) {
                    if (!TRACE) throw throwable;
                    if (!OracleLog.recursiveEnter()) throw throwable;
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        throw throwable;
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!OracleLog.recursiveEnter()) return reader;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
                return reader;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader = null;
            if (!TRACE) return reader;
            if (!OracleLog.recursiveEnter()) return reader;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        BigDecimal bigDecimal;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal __result__ = this.getBigDecimal(columnIndex, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            bigDecimal = __result__;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum datum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Object returnValue = null;
                Datum datum2 = this.getOracleObject(columnIndex);
                if (datum2 != null) {
                    int type = this.getInternalMetadata().getColumnType(columnIndex + this.beginColumnIndex);
                    switch (type) {
                        case 2002: {
                            returnValue = ((STRUCT)datum2).toJdbc(map);
                            break;
                        }
                        case 91: {
                            if (this.connection.mapDateToTimestamp) {
                                returnValue = datum2.toJdbc();
                                break;
                            }
                            returnValue = datum2.dateValue();
                            break;
                        }
                        case 93: {
                            if (datum2 instanceof DATE) {
                                if (this.connection.mapDateToTimestamp) {
                                    returnValue = datum2.toJdbc();
                                    break;
                                }
                                returnValue = datum2.dateValue();
                                break;
                            }
                            if (this.connection.j2ee13Compliant) {
                                returnValue = datum2.toJdbc();
                                break;
                            }
                            returnValue = datum2;
                            break;
                        }
                        case -102: 
                        case -101: {
                            returnValue = datum2;
                            break;
                        }
                        default: {
                            returnValue = datum2.toJdbc();
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + returnValue);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datum = returnValue;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ref getRef(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            REF rEF;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                REF __result__ = this.getREF(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                rEF = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return rEF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BLOB bLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BLOB __result__ = this.getBLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CLOB cLOB;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                CLOB __result__ = this.getCLOB(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                cLOB = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return cLOB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array getArray(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ARRAY aRRAY;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                ARRAY __result__ = this.getARRAY(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                aRRAY = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return aRRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Date date;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(columnIndex);
                Date d2 = null;
                if (datum != null) {
                    ResultSetMetaData rsmd = this.getInternalMetadata();
                    switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                        case -101: {
                            d2 = new Date(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                            break;
                        }
                        case -102: {
                            Calendar dbCal = this.connection.getDbTzCalendar();
                            d2 = new Date(((TIMESTAMPLTZ)datum).timestampValue(this.connection, dbCal == null ? cal : dbCal).getTime());
                            break;
                        }
                        default: {
                            d2 = new Date(datum.timestampValue(cal).getTime());
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                date = d2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Time time;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(columnIndex);
                Time d2 = null;
                if (datum != null) {
                    ResultSetMetaData rsmd = this.getInternalMetadata();
                    switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                        case -101: {
                            d2 = new Time(((TIMESTAMPTZ)datum).timestampValue(this.connection).getTime());
                            break;
                        }
                        case -102: {
                            Calendar dbCal = this.connection.getDbTzCalendar();
                            d2 = new Time(((TIMESTAMPLTZ)datum).timestampValue(this.connection, dbCal == null ? cal : dbCal).getTime());
                            break;
                        }
                        default: {
                            d2 = new Time(datum.timestampValue(cal).getTime());
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                time = d2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Timestamp timestamp;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum datum = this.getOracleObject(columnIndex);
                Timestamp ts = null;
                if (datum != null) {
                    ResultSetMetaData rsmd = this.getInternalMetadata();
                    switch (rsmd.getColumnType(columnIndex + this.beginColumnIndex)) {
                        case -101: {
                            ts = ((TIMESTAMPTZ)datum).timestampValue(this.connection);
                            break;
                        }
                        case -102: {
                            Calendar dbCal = this.connection.getDbTzCalendar();
                            ts = ((TIMESTAMPLTZ)datum).timestampValue(this.connection, dbCal == null ? cal : dbCal);
                            break;
                        }
                        default: {
                            ts = datum.timestampValue(cal);
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ts);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                timestamp = ts;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            URL uRL;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                URL result = null;
                int colType = this.getInternalMetadata().getColumnType(columnIndex + this.beginColumnIndex);
                int dbTypeCode = SQLUtil.getInternalType(colType);
                if (dbTypeCode == 96 || dbTypeCode == 1 || dbTypeCode == 8) {
                    try {
                        String val = this.getString(columnIndex);
                        if (val == null) {
                            result = null;
                        }
                        result = new URL(val);
                    }
                    catch (MalformedURLException exc) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 136);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Conversion to java.net.URL not supported.");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Conversion to java.net.URL not supported.");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + result);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                uRL = result;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return uRL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getCursor(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCursor");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ROWID getROWID(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof ROWID)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (ROWID)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (ROWID)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getROWID");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof NUMBER)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (NUMBER)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (NUMBER)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getNUMBER");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DATE getDATE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            try {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl119
                if (datum instanceof DATE) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (DATE)datum);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_6 = (DATE)datum;
                    if (ScrollableResultSet.TRACE == false) return var4_6;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var15_25) {
                if (ScrollableResultSet.TRACE == false) throw var15_25;
                if (OracleLog.recursiveEnter() == false) throw var15_25;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    throw var15_25;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (OracleLog.recursiveEnter() == false) return var4_6;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_6;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof TIMESTAMP)) ** GOTO lbl-1000
                __result__ = TIMESTAMP.toDATE(datum.getBytes());
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var5_13 = __result__;
                if (ScrollableResultSet.TRACE == false) return var5_13;
            }
            if (OracleLog.recursiveEnter() == false) return var5_13;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var5_13;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof TIMESTAMPLTZ)) ** GOTO lbl-1000
                __result__ = TIMESTAMPLTZ.toDATE(this.connection, datum.getBytes());
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var5_14 = __result__;
                if (ScrollableResultSet.TRACE == false) return var5_14;
            }
            if (OracleLog.recursiveEnter() == false) return var5_14;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var5_14;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof TIMESTAMPTZ)) ** GOTO lbl-1000
                __result__ = TIMESTAMPTZ.toDATE(this.connection, datum.getBytes());
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var5_15 = __result__;
                if (ScrollableResultSet.TRACE == false) return var5_15;
            }
            if (OracleLog.recursiveEnter() == false) return var5_15;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var5_15;
lbl-1000:
            // 1 sources

            {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getDATE");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE");
                __ex__.fillInStackTrace();
                throw __ex__;
lbl119:
                // 1 sources

                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_11 = null;
                if (ScrollableResultSet.TRACE == false) return var4_11;
            }
            if (OracleLog.recursiveEnter() == false) return var4_11;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_11;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            try {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl116
                if (datum instanceof TIMESTAMP) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMP)datum);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_6 = (TIMESTAMP)datum;
                    if (ScrollableResultSet.TRACE == false) return var4_6;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var15_22) {
                if (ScrollableResultSet.TRACE == false) throw var15_22;
                if (OracleLog.recursiveEnter() == false) throw var15_22;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    throw var15_22;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (OracleLog.recursiveEnter() == false) return var4_6;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_6;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof TIMESTAMPLTZ)) ** GOTO lbl-1000
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + TIMESTAMPLTZ.toTIMESTAMP(this.connection, datum.getBytes()));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_7 = TIMESTAMPLTZ.toTIMESTAMP(this.connection, datum.getBytes());
                if (ScrollableResultSet.TRACE == false) return var4_7;
            }
            if (OracleLog.recursiveEnter() == false) return var4_7;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_7;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof TIMESTAMPTZ)) ** GOTO lbl-1000
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + TIMESTAMPTZ.toTIMESTAMP(this.connection, datum.getBytes()));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_8 = TIMESTAMPTZ.toTIMESTAMP(this.connection, datum.getBytes());
                if (ScrollableResultSet.TRACE == false) return var4_8;
            }
            if (OracleLog.recursiveEnter() == false) return var4_8;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_8;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof DATE)) ** GOTO lbl-1000
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + new TIMESTAMP((DATE)datum));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_9 = new TIMESTAMP((DATE)datum);
                if (ScrollableResultSet.TRACE == false) return var4_9;
            }
            if (OracleLog.recursiveEnter() == false) return var4_9;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_9;
lbl-1000:
            // 1 sources

            {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMP");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP");
                __ex__.fillInStackTrace();
                throw __ex__;
lbl116:
                // 1 sources

                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_11 = null;
                if (ScrollableResultSet.TRACE == false) return var4_11;
            }
            if (OracleLog.recursiveEnter() == false) return var4_11;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_11;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            try {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl76
                if (datum instanceof TIMESTAMPTZ) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMPTZ)datum);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    var4_6 = (TIMESTAMPTZ)datum;
                    if (ScrollableResultSet.TRACE == false) return var4_6;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var11_16) {
                if (ScrollableResultSet.TRACE == false) throw var11_16;
                if (OracleLog.recursiveEnter() == false) throw var11_16;
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    throw var11_16;
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (OracleLog.recursiveEnter() == false) return var4_6;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_6;
lbl-1000:
            // 1 sources

            {
                if (!(datum instanceof TIMESTAMPLTZ)) ** GOTO lbl-1000
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + TIMESTAMPLTZ.toTIMESTAMPTZ(this.connection, datum.getBytes()));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_7 = TIMESTAMPLTZ.toTIMESTAMPTZ(this.connection, datum.getBytes());
                if (ScrollableResultSet.TRACE == false) return var4_7;
            }
            if (OracleLog.recursiveEnter() == false) return var4_7;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_7;
lbl-1000:
            // 1 sources

            {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPTZ");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ");
                __ex__.fillInStackTrace();
                throw __ex__;
lbl76:
                // 1 sources

                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_9 = null;
                if (ScrollableResultSet.TRACE == false) return var4_9;
            }
            if (OracleLog.recursiveEnter() == false) return var4_9;
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
            return var4_9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof TIMESTAMPLTZ)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (TIMESTAMPLTZ)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (TIMESTAMPLTZ)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getTIMESTAMPLTZ");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof INTERVALDS)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (INTERVALDS)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (INTERVALDS)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getINTERVALDS");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof INTERVALYM)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (INTERVALYM)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (INTERVALYM)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getINTERVALYM");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof ARRAY)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (ARRAY)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (ARRAY)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getARRAY");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof STRUCT)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (STRUCT)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (STRUCT)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getSTRUCT");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof OPAQUE)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (OPAQUE)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (OPAQUE)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getOPAQUE");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public REF getREF(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof REF)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (REF)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (REF)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getREF");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public CHAR getCHAR(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof CHAR)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (CHAR)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (CHAR)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCHAR");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public RAW getRAW(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof RAW)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (RAW)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (RAW)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getRAW");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public BLOB getBLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof BLOB)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BLOB)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (BLOB)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBLOB");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public CLOB getCLOB(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof CLOB)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (CLOB)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (CLOB)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getCLOB");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public BFILE getBFILE(int columnIndex) throws SQLException {
        var2_2 = this.connection;
        synchronized (var2_2) {
            block37: {
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((datum = this.getOracleObject(columnIndex)) == null) ** GOTO lbl48
                if (!(datum instanceof BFILE)) break block37;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (BFILE)datum);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = (BFILE)datum;
                if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return var4_6;
            }
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4 + "getBFILE");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE");
            __ex__.fillInStackTrace();
            throw __ex__;
lbl48:
            // 1 sources

            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            var4_8 = null;
            if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return var4_8;
            {
                catch (Throwable var9_13) {
                    if (ScrollableResultSet.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw var9_13;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE getBfile(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            BFILE bFILE;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                BFILE __result__ = this.getBFILE(columnIndex);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                bFILE = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return bFILE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            CustomDatum customDatum;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum d2 = this.getOracleObject(columnIndex);
                CustomDatum __result__ = factory.create(d2, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                customDatum = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return customDatum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            ORAData oRAData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum d2 = this.getOracleObject(columnIndex);
                ORAData __result__ = factory.create(d2, 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oRAData = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oRAData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int columnIndex, OracleDataFactory factory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleData oracleData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleData __result__ = factory.create(this.getObject(columnIndex), 0);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleData = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleResultSetMetaData oracleResultSetMetaData;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                oracleResultSetMetaData = new OracleResultSetMetaData(this.connection, (OracleStatement)this.scrollStmt, this.beginColumnIndex);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return oracleResultSetMetaData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(columnName));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 10);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                int __result__ = this.resultSet.findColumn(columnName) - this.beginColumnIndex;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int direction) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            block24: {
                try {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(direction));
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    if (direction == 1000) {
                        this.usrFetchDirection = direction;
                        break block24;
                    }
                    if (direction == 1001 || direction == 1002) {
                        this.usrFetchDirection = direction;
                        this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 87);
                        break block24;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "setFetchDirection");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchDirection");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (Throwable throwable) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchDirection() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + 1000);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 1000;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int rows) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rows));
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.resultSet.setFetchSize(rows);
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchSize() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int __result__ = this.resultSet.getFetchSize();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = __result__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rsetType);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.rsetType;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConcurrency() throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rsetConcurency);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.rsetConcurency;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        block32: {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!ScrollableResultSet.needIdentifier(this.rsetType, this.rsetConcurency)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "refreshRow");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "refreshRow");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                if (this.isValidRow(this.currentRow)) {
                    int direction = this.getFetchDirection();
                    try {
                        this.refreshRowsInCache(this.currentRow, this.getFetchSize(), direction);
                        break block32;
                    }
                    catch (SQLException e2) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2 + 90 + "Unsupported syntax for refreshRow()");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2, 90, "Unsupported syntax for refreshRow()");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 82 + "refreshRow");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "refreshRow");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmptyResultSet() throws SQLException {
        try {
            boolean __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.numRowsCached != 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (this.numRowsCached == 0 && this.allRowsCached) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = __result__ = !this.isValidRow(1);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = __result__;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidRow(int idx) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (idx > 0 && idx <= this.numRowsCached) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (idx <= 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean __result__ = this.cacheRowAt(idx);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = __result__;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private void cacheCurrentRow(OracleResultSetImpl _rset, int _rowIndex) throws SQLException {
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            byte[] bytes = _rset.privateGetBytes(i2 + 1);
            OracleResultSet.AuthorizationIndicator securityIndicator = _rset.getAuthorizationIndicator(i2 + 1);
            CachedRowElement cachedElem = new CachedRowElement(_rowIndex, i2 + 1, securityIndicator, bytes);
            int sqlTypeCode = _rset.statement.accessors[i2].internalType;
            if (sqlTypeCode == 112) {
                CLOB clob = _rset.getCLOB(i2 + 1);
                cachedElem.setData(clob);
            } else if (sqlTypeCode == 113) {
                BLOB blob = _rset.getBLOB(i2 + 1);
                cachedElem.setData(blob);
            }
            this.putCachedValueAt(_rowIndex, i2 + 1, cachedElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheRowAt(int idx) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(idx));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            while (this.numRowsCached < idx && this.resultSet.next()) {
                this.cacheCurrentRow(this.resultSet, ++this.numRowsCached);
            }
            if (this.numRowsCached < idx) {
                this.allRowsCached = true;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cacheAllRows() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            while (this.resultSet.next()) {
                this.cacheCurrentRow(this.resultSet, ++this.numRowsCached);
            }
            this.allRowsCached = true;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.numRowsCached);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.numRowsCached;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getColumnCount() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.columnCount == 0) {
                int numberOfArgs = this.resultSet.statement.numberOfDefinePositions;
                this.columnCount = this.resultSet.statement.accessors != null && numberOfArgs > 0 ? numberOfArgs : this.getInternalMetadata().getColumnCount();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.columnCount);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.columnCount;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetMetaData getInternalMetadata() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.metadata == null) {
                this.metadata = this.resultSet.getMetaData();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.metadata);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSetMetaData resultSetMetaData = this.metadata;
            return resultSetMetaData;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastRow() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.allRowsCached) {
                this.cacheAllRows();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.numRowsCached);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.numRowsCached;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int get_refetch_size(int beginIdx, int count, int direction) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(beginIdx) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(direction));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int _direction = direction == 1001 ? -1 : 1;
            int realRefreshSz = 0;
            if (this.refetchRowids == null) {
                this.refetchRowids = new Vector(10);
            } else {
                this.refetchRowids.removeAllElements();
            }
            while (realRefreshSz < count && this.isValidRow(beginIdx + realRefreshSz * _direction)) {
                this.refetchRowids.addElement(this.getCachedDatumValueAt(beginIdx + realRefreshSz * _direction, 1));
                ++realRefreshSz;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + realRefreshSz);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = realRefreshSz;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OraclePreparedStatement prepare_refetch_statement(int realRefreshSz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(realRefreshSz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (realRefreshSz < 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            PreparedStatement pstmt = this.connection.prepareStatement(((OracleStatement)this.scrollStmt).sqlObject.getRefetchSqlForScrollableResultSet(this, realRefreshSz));
            OraclePreparedStatement __result__ = (OraclePreparedStatement)((OraclePreparedStatementWrapper)pstmt).preparedStatement;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OraclePreparedStatement oraclePreparedStatement = __result__;
            return oraclePreparedStatement;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare_refetch_binds(OraclePreparedStatement refetchStmt, int realRefreshSz) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(refetchStmt) + ", " + OracleLog.argument(realRefreshSz));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int _numSubQueryBinds = this.scrollStmt.copyBinds(refetchStmt, 0);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "numSubQueryBinds=" + _numSubQueryBinds);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            for (int i2 = 0; i2 < realRefreshSz; ++i2) {
                refetchStmt.setROWID(_numSubQueryBinds + i2 + 1, (ROWID)this.refetchRowids.elementAt(i2));
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save_refetch_results(OracleResultSetImpl refetchRset, int _beginIdx, int _realFetchSz, int direction) throws SQLException {
        try {
            int _direction;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(refetchRset) + ", " + OracleLog.argument(_beginIdx) + ", " + OracleLog.argument(_realFetchSz) + ", " + OracleLog.argument(direction));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = _direction = direction == 1001 ? -1 : 1;
            while (refetchRset.next()) {
                ROWID thisRowid = refetchRset.getROWID(1);
                boolean found = false;
                int thisRow = _beginIdx;
                while (!found && thisRow < _beginIdx + _realFetchSz * _direction) {
                    if (((ROWID)this.getCachedDatumValueAt(thisRow, 1)).stringValue(this.connection).equals(thisRowid.stringValue(this.connection))) {
                        found = true;
                        continue;
                    }
                    thisRow += _direction;
                }
                if (!found) continue;
                this.cacheCurrentRow(refetchRset, thisRow);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Datum getCachedDatumValueAt(int row, int column) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(row) + ", " + OracleLog.argument(column));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CachedRowElement cachedElement = null;
            try {
                cachedElement = (CachedRowElement)this.rsetCache.get(row, column);
            }
            catch (IOException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Datum datumValue = null;
            if (cachedElement != null) {
                datumValue = cachedElement.getDataAsDatum();
                byte[] value = cachedElement.getData();
                if (datumValue == null && value != null && value.length > 0) {
                    short form;
                    int colType = this.getInternalMetadata().getColumnType(column);
                    int colLength = this.getInternalMetadata().getColumnDisplaySize(column);
                    int sqlTypeCode = ((OracleResultSetMetaData)this.getInternalMetadata()).getDescription()[column - 1].internalType;
                    int max = this.scrollStmt.getMaxFieldSize();
                    if (max > 0 && max < colLength) {
                        colLength = max;
                    }
                    String sqlTypeName = null;
                    if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003) {
                        sqlTypeName = this.getInternalMetadata().getColumnTypeName(column);
                    }
                    datumValue = (form = this.resultSet.statement.accessors[column - 1].formOfUse) == 2 && (sqlTypeCode == 96 || sqlTypeCode == 1 || sqlTypeCode == 8 || sqlTypeCode == 112) ? SQLUtil.makeNDatum(this.connection, value, sqlTypeCode, sqlTypeName, form, colLength) : SQLUtil.makeDatum((OracleConnection)this.connection, value, sqlTypeCode, sqlTypeName, colLength);
                    cachedElement.setData(datumValue);
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumValue);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum = datumValue;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedValueAt(int row, int column, CachedRowElement value) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(row) + ", " + OracleLog.argument(column) + ", " + OracleLog.argument(value));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.rsetCache.put(row, column, value);
            }
            catch (IOException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedRowAt(int row) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(row));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                this.rsetCache.remove(row);
            }
            catch (IOException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + e2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needIdentifier(int type, int concur) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(concur));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (type == 1003 && concur == 1007 || type == 1004 && concur == 1007) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Return: true");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needCache(int type, int concur) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(concur));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (type == 1003 || type == 1004 && concur == 1007) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Return: true");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean supportRefreshRow(int type, int concur) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(type) + ", " + OracleLog.argument(concur));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (type == 1003 || type == 1004 && concur == 1007) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.FINER, "         Return: false");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Return: true");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, "         Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFirstUserColumnIndex() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.beginColumnIndex);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.beginColumnIndex;
            return n2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23 + "getCursorName");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        ScrollableResultSet.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.connection);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this.connection;
            return physicalConnection;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OracleStatement getOracleStatement() throws SQLException {
        try {
            OracleStatement __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement oracleStatement = __result__ = this.resultSet == null ? null : this.resultSet.getOracleStatement();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleStatement oracleStatement2 = __result__;
            return oracleStatement2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    ScrollableResultSet.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ScrollableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

