/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;
import oracle.sql.converter.CharacterSetMetaData;

public class SQLUtil {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;
    private static final int CLASS_NOT_FOUND = -1;
    private static final int CLASS_STRING = 0;
    private static final int CLASS_BOOLEAN = 1;
    private static final int CLASS_INTEGER = 2;
    private static final int CLASS_LONG = 3;
    private static final int CLASS_FLOAT = 4;
    private static final int CLASS_DOUBLE = 5;
    private static final int CLASS_BIGDECIMAL = 6;
    private static final int CLASS_DATE = 7;
    private static final int CLASS_TIME = 8;
    private static final int CLASS_TIMESTAMP = 9;
    private static final int TOTAL_CLASSES = 10;
    private static Hashtable classTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object SQLToJava(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, Class javaClass, Map map) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(sqlData) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(javaClass) + ", " + OracleLog.argument(map));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum datum = SQLUtil.makeDatum(connection, sqlData, sqlTypeCode, sqlTypeName, 0);
            Object ret = SQLUtil.SQLToJava(connection, datum, javaClass, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = ret;
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var13_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static CustomDatum SQLToJava(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, CustomDatumFactory factory) throws SQLException {
        CustomDatum customDatum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(sqlData) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(factory));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum datum = SQLUtil.makeDatum(connection, sqlData, sqlTypeCode, sqlTypeName, 0);
            CustomDatum ret = factory.create(datum, sqlTypeCode);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            customDatum = ret;
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return customDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ORAData SQLToJava(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, ORADataFactory factory) throws SQLException {
        ORAData oRAData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(sqlData) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(factory));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum datum = SQLUtil.makeDatum(connection, sqlData, sqlTypeCode, sqlTypeName, 0);
            ORAData ret = factory.create(datum, sqlTypeCode);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oRAData = ret;
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var12_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oRAData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OracleData SQLToJava(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, OracleDataFactory factory) throws SQLException {
        OracleData oracleData;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(sqlData) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(factory));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum datum = SQLUtil.makeDatum(connection, sqlData, sqlTypeCode, sqlTypeName, 0);
            OracleData ret = factory.create(datum.toJdbc(), sqlTypeCode);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleData = ret;
            Object var10_13 = null;
            if (!TRACE) return oracleData;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable2) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return oracleData;
        try {
            SQLUtil.logger().log(Level.FINER, "         Exit");
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return oracleData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object SQLToJava(OracleConnection connection, Datum datum, Class javaClass, Map map) throws SQLException {
        Object object;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(datum) + ", " + OracleLog.argument(javaClass) + ", " + OracleLog.argument(map));
                    object = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object ret_obj = null;
            if (datum instanceof STRUCT) {
                ret_obj = javaClass == null ? (map != null ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc()) : (map != null ? ((STRUCT)datum).toClass(javaClass, map) : ((STRUCT)datum).toClass(javaClass));
            } else if (javaClass == null) {
                ret_obj = datum.toJdbc();
            } else {
                int class_num = SQLUtil.classNumber(javaClass);
                switch (class_num) {
                    case 0: {
                        ret_obj = datum.stringValue();
                        break;
                    }
                    case 1: {
                        ret_obj = datum.longValue() != 0L;
                        break;
                    }
                    case 2: {
                        ret_obj = (int)datum.longValue();
                        break;
                    }
                    case 3: {
                        ret_obj = datum.longValue();
                        break;
                    }
                    case 4: {
                        ret_obj = Float.valueOf(datum.bigDecimalValue().floatValue());
                        break;
                    }
                    case 5: {
                        ret_obj = datum.bigDecimalValue().doubleValue();
                        break;
                    }
                    case 6: {
                        ret_obj = datum.bigDecimalValue();
                        break;
                    }
                    case 7: {
                        ret_obj = datum.dateValue();
                        break;
                    }
                    case 8: {
                        ret_obj = datum.timeValue();
                        break;
                    }
                    case 9: {
                        ret_obj = datum.timestampValue();
                        break;
                    }
                    default: {
                        ret_obj = datum.toJdbc();
                        if (javaClass.isInstance(ret_obj)) break;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 59invalid data conversion");
                                Object var7_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var7_10 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException __ex__ = DatabaseError.createSqlException(null, 59, "invalid data conversion");
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret_obj);
                    Object var9_13 = null;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = ret_obj;
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var13_20 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var13_18 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] JavaToSQL(OracleConnection connection, Object inObject, int sqlTypeCode, String sqlTypeName) throws SQLException {
        block34: {
            byte[] byArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(inObject) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName));
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (inObject != null) break block34;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Return: " + null);
                        Object var7_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                byArray = null;
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Exit");
                        Object var15_21 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var15_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return byArray;
        }
        Datum datum = null;
        if (inObject instanceof Datum) {
            datum = (Datum)inObject;
        } else if (inObject instanceof ORAData) {
            datum = ((ORAData)inObject).toDatum(connection);
        } else if (inObject instanceof CustomDatum) {
            datum = connection.toDatum((CustomDatum)inObject);
        } else if (inObject instanceof SQLData) {
            datum = STRUCT.toSTRUCT(inObject, connection);
        }
        if (datum != null) {
            if (!SQLUtil.checkDatumType(datum, sqlTypeCode, sqlTypeName)) {
                datum = null;
            }
        } else {
            datum = SQLUtil.makeDatum(connection, inObject, sqlTypeCode, sqlTypeName);
        }
        byte[] ret = null;
        if (datum != null) {
            ret = datum instanceof STRUCT ? ((STRUCT)datum).toBytes() : (datum instanceof ARRAY ? ((ARRAY)datum).toBytes() : (datum instanceof OPAQUE ? ((OPAQUE)datum).toBytes() : datum.shareBytes()));
        } else {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1attempt to convert a Datum to incompatible SQL type");
                    Object var9_26 = null;
                }
                catch (Throwable throwable) {
                    Object var9_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 1, "attempt to convert a Datum to incompatible SQL type");
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                Object var11_29 = null;
            }
            catch (Throwable throwable) {
                Object var11_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        byte[] byArray = ret;
        Object var13_15 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var15_19 = null;
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum makeDatum(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, int maxLen) throws SQLException {
        Datum datum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(sqlData) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(maxLen));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum ret_datum = null;
            short dbCharSet = connection.getDbCsId();
            short jdbcCharSet = connection.getJdbcCsId();
            int nlsChrSetRatio = CharacterSetMetaData.getRatio(jdbcCharSet, dbCharSet);
            switch (sqlTypeCode) {
                case 96: {
                    if (maxLen != 0 && maxLen < sqlData.length && nlsChrSetRatio == 1) {
                        ret_datum = new CHAR(sqlData, 0, maxLen, CharacterSet.make(connection.getJdbcCsId()));
                        break;
                    }
                    ret_datum = new CHAR(sqlData, CharacterSet.make(connection.getJdbcCsId()));
                    break;
                }
                case 1: 
                case 8: {
                    ret_datum = new CHAR(sqlData, CharacterSet.make(connection.getJdbcCsId()));
                    break;
                }
                case 2: 
                case 6: {
                    ret_datum = new NUMBER(sqlData);
                    break;
                }
                case 100: {
                    ret_datum = new BINARY_FLOAT(sqlData);
                    break;
                }
                case 101: {
                    ret_datum = new BINARY_DOUBLE(sqlData);
                    break;
                }
                case 23: 
                case 24: {
                    ret_datum = new RAW(sqlData);
                    break;
                }
                case 104: {
                    ret_datum = new ROWID(sqlData);
                    break;
                }
                case 102: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1need resolution: do we want to handle ResultSet?");
                            Object var10_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 1, "need resolution: do we want to handle ResultSet?");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                case 12: {
                    ret_datum = new DATE(sqlData);
                    break;
                }
                case 182: {
                    ret_datum = new INTERVALYM(sqlData);
                    break;
                }
                case 183: {
                    ret_datum = new INTERVALDS(sqlData);
                    break;
                }
                case 180: {
                    ret_datum = new TIMESTAMP(sqlData);
                    break;
                }
                case 181: {
                    ret_datum = new TIMESTAMPTZ(sqlData);
                    break;
                }
                case 231: {
                    ret_datum = new TIMESTAMPLTZ(sqlData);
                    break;
                }
                case 113: {
                    ret_datum = connection.createBlob(sqlData);
                    break;
                }
                case 112: {
                    ret_datum = connection.createClob(sqlData);
                    break;
                }
                case 114: {
                    ret_datum = connection.createBfile(sqlData);
                    break;
                }
                case 109: {
                    Object desc = TypeDescriptor.getTypeDescriptor(sqlTypeName, connection, sqlData, 0L);
                    switch (((TypeDescriptor)desc).getTypeCode()) {
                        case 2002: {
                            ret_datum = new STRUCT((StructDescriptor)desc, sqlData, connection);
                            break;
                        }
                        case 2008: {
                            ret_datum = new JAVA_STRUCT((StructDescriptor)desc, sqlData, connection);
                            break;
                        }
                        case 2003: {
                            ret_datum = new ARRAY((ArrayDescriptor)desc, sqlData, connection);
                            break;
                        }
                        case 2007: {
                            ret_datum = new OPAQUE((OpaqueDescriptor)desc, sqlData, connection);
                        }
                    }
                    break;
                }
                case 111: {
                    Object desc = SQLUtil.getTypeDescriptor(sqlTypeName, connection);
                    if (desc instanceof StructDescriptor) {
                        ret_datum = new REF((StructDescriptor)desc, (Connection)connection, sqlData);
                        break;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1program error: REF points to a non-STRUCT");
                            Object var12_19 = null;
                        }
                        catch (Throwable throwable) {
                            Object var12_20 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 1, "program error: REF points to a non-STRUCT");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1program error: invalid SQL type code");
                            Object var14_22 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_23 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 1, "program error: invalid SQL type code");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret_datum);
                    Object var16_25 = null;
                }
                catch (Throwable throwable) {
                    Object var16_26 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            datum = ret_datum;
            Object var18_28 = null;
        }
        catch (Throwable throwable) {
            Object var18_29 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var20_32 = null;
                }
                catch (Throwable throwable2) {
                    Object var20_33 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var20_30 = null;
            }
            catch (Throwable throwable) {
                Object var20_31 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum makeNDatum(OracleConnection connection, byte[] sqlData, int sqlTypeCode, String sqlTypeName, short form, int maxLen) throws SQLException {
        Datum datum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(sqlData) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(form) + ", " + OracleLog.argument(maxLen));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum ret_datum = null;
            switch (sqlTypeCode) {
                case 96: {
                    int len = maxLen * CharacterSetMetaData.getRatio(connection.getNCharSet(), 1);
                    if (maxLen != 0 && len < sqlData.length) {
                        ret_datum = new CHAR(sqlData, 0, maxLen, CharacterSet.make(connection.getNCharSet()));
                        break;
                    }
                    ret_datum = new CHAR(sqlData, CharacterSet.make(connection.getNCharSet()));
                    break;
                }
                case 1: 
                case 8: {
                    ret_datum = new CHAR(sqlData, CharacterSet.make(connection.getNCharSet()));
                    break;
                }
                case 112: {
                    ret_datum = connection.createClob(sqlData, form);
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1program error: invalid SQL type code");
                            Object var9_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 1, "program error: invalid SQL type code");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret_datum);
                    Object var11_16 = null;
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            datum = ret_datum;
            Object var13_19 = null;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var15_23 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var15_21 = null;
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum makeDatum(OracleConnection connection, Object inObject, int sqlTypeCode, String sqlTypeName) throws SQLException {
        Datum datum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(inObject) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + SQLUtil.makeDatum(connection, inObject, sqlTypeCode, sqlTypeName, false));
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            datum = SQLUtil.makeDatum(connection, inObject, sqlTypeCode, sqlTypeName, false);
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Datum makeDatum(OracleConnection connection, Object inObject, int sqlTypeCode, String sqlTypeName, boolean isNChar) throws SQLException {
        Datum datum;
        try {
            SQLException __ex__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(inObject) + ", " + OracleLog.argument(sqlTypeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(isNChar));
                    datum = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum ret_datum = null;
            switch (sqlTypeCode) {
                case 1: 
                case 8: 
                case 96: {
                    ret_datum = new CHAR(inObject, CharacterSet.make(isNChar ? connection.getNCharSet() : connection.getJdbcCsId()));
                    break;
                }
                case 2: 
                case 6: {
                    ret_datum = new NUMBER(inObject);
                    break;
                }
                case 100: {
                    if (inObject instanceof String) {
                        ret_datum = new BINARY_FLOAT((String)inObject);
                        break;
                    }
                    if (inObject instanceof Boolean) {
                        ret_datum = new BINARY_FLOAT((Boolean)inObject);
                        break;
                    }
                    ret_datum = new BINARY_FLOAT((Float)inObject);
                    break;
                }
                case 101: {
                    if (inObject instanceof String) {
                        ret_datum = new BINARY_DOUBLE((String)inObject);
                        break;
                    }
                    if (inObject instanceof Boolean) {
                        ret_datum = new BINARY_DOUBLE((Boolean)inObject);
                        break;
                    }
                    ret_datum = new BINARY_DOUBLE((Double)inObject);
                    break;
                }
                case 23: 
                case 24: {
                    ret_datum = new RAW(inObject);
                    break;
                }
                case 104: {
                    if (inObject instanceof String) {
                        ret_datum = new ROWID((String)inObject);
                        break;
                    }
                    if (!(inObject instanceof byte[])) break;
                    ret_datum = new ROWID((byte[])inObject);
                    break;
                }
                case 102: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1need resolution: do we want to handle ResultSet");
                            Object var8_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    __ex__ = DatabaseError.createSqlException(null, 1, "need resolution: do we want to handle ResultSet");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                case 12: {
                    ret_datum = new DATE(inObject);
                    break;
                }
                case 180: {
                    if (inObject instanceof TIMESTAMP) {
                        ret_datum = (Datum)inObject;
                        break;
                    }
                    if (inObject instanceof Timestamp) {
                        ret_datum = new TIMESTAMP((Timestamp)inObject);
                        break;
                    }
                    if (inObject instanceof Date) {
                        ret_datum = new TIMESTAMP((Date)inObject);
                        break;
                    }
                    if (inObject instanceof Time) {
                        ret_datum = new TIMESTAMP((Time)inObject);
                        break;
                    }
                    if (inObject instanceof DATE) {
                        ret_datum = new TIMESTAMP((DATE)inObject);
                        break;
                    }
                    if (inObject instanceof String) {
                        ret_datum = new TIMESTAMP((String)inObject);
                        break;
                    }
                    if (!(inObject instanceof byte[])) break;
                    ret_datum = new TIMESTAMP((byte[])inObject);
                    break;
                }
                case 181: {
                    if (inObject instanceof TIMESTAMPTZ) {
                        ret_datum = (Datum)inObject;
                        break;
                    }
                    if (inObject instanceof Timestamp) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (Timestamp)inObject);
                        break;
                    }
                    if (inObject instanceof Date) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (Date)inObject);
                        break;
                    }
                    if (inObject instanceof Time) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (Time)inObject);
                        break;
                    }
                    if (inObject instanceof DATE) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (DATE)inObject);
                        break;
                    }
                    if (inObject instanceof String) {
                        ret_datum = new TIMESTAMPTZ((Connection)connection, (String)inObject);
                        break;
                    }
                    if (!(inObject instanceof byte[])) break;
                    ret_datum = new TIMESTAMPTZ((byte[])inObject);
                    break;
                }
                case 231: {
                    if (inObject instanceof TIMESTAMPLTZ) {
                        ret_datum = (Datum)inObject;
                        break;
                    }
                    if (inObject instanceof Timestamp) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (Timestamp)inObject);
                        break;
                    }
                    if (inObject instanceof Date) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (Date)inObject);
                        break;
                    }
                    if (inObject instanceof Time) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (Time)inObject);
                        break;
                    }
                    if (inObject instanceof DATE) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (DATE)inObject);
                        break;
                    }
                    if (inObject instanceof String) {
                        ret_datum = new TIMESTAMPLTZ((Connection)connection, (String)inObject);
                        break;
                    }
                    if (!(inObject instanceof byte[])) break;
                    ret_datum = new TIMESTAMPLTZ((byte[])inObject);
                    break;
                }
                case 113: {
                    if (inObject instanceof BLOB) {
                        ret_datum = (Datum)inObject;
                    }
                    if (!(inObject instanceof byte[])) break;
                    ret_datum = new RAW((byte[])inObject);
                    break;
                }
                case 112: {
                    if (inObject instanceof CLOB) {
                        ret_datum = (Datum)inObject;
                    }
                    if (!(inObject instanceof String)) break;
                    CharacterSet chset = CharacterSet.make(isNChar ? connection.getNCharSet() : connection.getJdbcCsId());
                    ret_datum = new CHAR((String)inObject, chset);
                    break;
                }
                case 114: {
                    if (!(inObject instanceof BFILE)) break;
                    ret_datum = (Datum)inObject;
                    break;
                }
                case 109: {
                    if (!(inObject instanceof STRUCT) && !(inObject instanceof ARRAY) && !(inObject instanceof OPAQUE)) break;
                    ret_datum = (Datum)inObject;
                    break;
                }
                case 111: {
                    if (!(inObject instanceof REF)) break;
                    ret_datum = (Datum)inObject;
                    break;
                }
            }
            if (ret_datum == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1Unable to construct a Datum from the specified input");
                        Object var10_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                __ex__ = DatabaseError.createSqlException(null, 1, "Unable to construct a Datum from the specified input");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret_datum);
                    Object var12_15 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            datum = ret_datum;
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var16_22 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var16_20 = null;
            }
            catch (Throwable throwable) {
                Object var16_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return datum;
    }

    /*
     * Exception decompiling
     */
    private static int classNumber(Class inClass) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTypeDescriptor(String name, OracleConnection conn) throws SQLException {
        String qname;
        SQLName sqlName;
        Object descriptor;
        block27: {
            Object object;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(name) + ", " + OracleLog.argument(conn));
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                descriptor = null;
                sqlName = new SQLName(name, conn);
                qname = sqlName.getName();
                descriptor = conn.getDescriptor(qname);
                if (descriptor == null) break block27;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Return: " + descriptor);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                object = descriptor;
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Exit");
                        Object var14_20 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var14_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var14_16 = null;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return object;
        }
        OracleTypeADT otype = new OracleTypeADT(qname, (Connection)conn);
        otype.init(conn);
        OracleNamedType realType = otype.cleanup();
        switch (realType.getTypeCode()) {
            case 2003: {
                descriptor = new ArrayDescriptor(sqlName, (OracleTypeCOLLECTION)realType, (Connection)conn);
                break;
            }
            case 2002: 
            case 2008: {
                descriptor = new StructDescriptor(sqlName, (OracleTypeADT)realType, (Connection)conn);
                break;
            }
            case 2007: {
                descriptor = new OpaqueDescriptor(sqlName, (OracleTypeOPAQUE)realType, (Connection)conn);
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 1Unrecognized type code");
                        Object var8_25 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_26 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 1, "Unrecognized type code");
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        conn.putDescriptor(qname, descriptor);
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Return: " + descriptor);
                Object var10_30 = null;
            }
            catch (Throwable throwable) {
                Object var10_31 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        Object object = descriptor;
        Object var12_14 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var14_18 = null;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkDatumType(Datum datum, int sqlType, String sqlTypeName) throws SQLException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(datum) + ", " + OracleLog.argument(sqlType) + ", " + OracleLog.argument(sqlTypeName));
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            boolean ret = false;
            switch (sqlType) {
                case 1: 
                case 8: 
                case 96: {
                    ret = datum instanceof CHAR;
                    break;
                }
                case 2: 
                case 6: {
                    ret = datum instanceof NUMBER;
                    break;
                }
                case 100: {
                    ret = datum instanceof BINARY_FLOAT;
                    break;
                }
                case 101: {
                    ret = datum instanceof BINARY_DOUBLE;
                    break;
                }
                case 23: 
                case 24: {
                    ret = datum instanceof RAW;
                    break;
                }
                case 104: {
                    ret = datum instanceof ROWID;
                    break;
                }
                case 12: {
                    ret = datum instanceof DATE;
                    break;
                }
                case 180: {
                    ret = datum instanceof TIMESTAMP;
                    break;
                }
                case 181: {
                    ret = datum instanceof TIMESTAMPTZ;
                    break;
                }
                case 231: {
                    ret = datum instanceof TIMESTAMPLTZ;
                    break;
                }
                case 113: {
                    ret = datum instanceof BLOB;
                    break;
                }
                case 112: {
                    ret = datum instanceof CLOB;
                    break;
                }
                case 114: {
                    ret = datum instanceof BFILE;
                    break;
                }
                case 111: {
                    ret = datum instanceof REF && ((REF)datum).getBaseTypeName().equals(sqlTypeName);
                    break;
                }
                case 109: {
                    if (datum instanceof STRUCT) {
                        ret = ((STRUCT)datum).isInHierarchyOf(sqlTypeName);
                        break;
                    }
                    if (datum instanceof ARRAY) {
                        ret = ((ARRAY)datum).getSQLTypeName().equals(sqlTypeName);
                        break;
                    }
                    if (!(datum instanceof OPAQUE)) break;
                    ret = ((OPAQUE)datum).getSQLTypeName().equals(sqlTypeName);
                    break;
                }
                default: {
                    ret = false;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var6_8 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = ret;
            Object var8_11 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            SQLUtil.logger().log(Level.FINER, "         Exit");
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            SQLUtil.logger().log(Level.FINER, "         Exit");
            Object var10_13 = null;
            OracleLog.recursiveExit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean implementsInterface(Class clazz, Class interfaze) {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(clazz) + ", " + OracleLog.argument(interfaze));
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (clazz == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Return: false");
                        Object var5_9 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = false;
                Object var13_14 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var15_19 = null;
                    OracleLog.recursiveExit();
                    return bl2;
                }
                catch (Throwable throwable) {
                    Object var15_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (clazz == interfaze) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Return: true");
                        Object var7_34 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_35 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl3 = true;
                Object var13_15 = null;
                if (!TRACE) return bl3;
                if (!OracleLog.recursiveEnter()) return bl3;
                try {}
                catch (Throwable throwable) {
                    Object var15_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var15_21 = null;
                OracleLog.recursiveExit();
                return bl3;
            }
            Class<?>[] interfazes = clazz.getInterfaces();
            for (int i2 = 0; i2 < interfazes.length; ++i2) {
                if (!SQLUtil.implementsInterface(interfazes[i2], interfaze)) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Return: true");
                        Object var9_37 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_38 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl4 = true;
                Object var13_16 = null;
                if (!TRACE) return bl4;
                if (!OracleLog.recursiveEnter()) return bl4;
                try {}
                catch (Throwable throwable) {
                    Object var15_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var15_23 = null;
                OracleLog.recursiveExit();
                return bl4;
            }
            boolean __result__ = SQLUtil.implementsInterface(clazz.getSuperclass(), interfaze);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + __result__);
                    Object var11_40 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_41 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = __result__;
            Object var13_17 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_28 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            SQLUtil.logger().log(Level.FINER, "         Exit");
            Object var15_27 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var15_26 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        SQLUtil.logger().log(Level.FINER, "         Exit");
        Object var15_25 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum makeOracleDatum(OracleConnection connection, Object inObject, int typeCode, String sqlTypeName) throws SQLException {
        Datum datum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(inObject) + ", " + OracleLog.argument(typeCode) + ", " + OracleLog.argument(sqlTypeName));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + SQLUtil.makeOracleDatum(connection, inObject, typeCode, sqlTypeName, false));
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            datum = SQLUtil.makeOracleDatum(connection, inObject, typeCode, sqlTypeName, false);
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var11_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum makeOracleDatum(OracleConnection connection, Object inObject, int typeCode, String sqlTypeName, boolean isNChar) throws SQLException {
        Datum datum;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(inObject) + ", " + OracleLog.argument(typeCode) + ", " + OracleLog.argument(sqlTypeName) + ", " + OracleLog.argument(isNChar));
                    datum = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Datum ret = SQLUtil.makeDatum(connection, inObject, SQLUtil.getInternalType(typeCode), sqlTypeName, isNChar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            datum = ret;
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var12_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInternalType(int external_type) throws SQLException {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(external_type));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int ret = 0;
            switch (external_type) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    ret = 6;
                    break;
                }
                case 100: {
                    ret = 100;
                    break;
                }
                case 101: {
                    ret = 101;
                    break;
                }
                case 999: {
                    ret = 999;
                    break;
                }
                case 1: {
                    ret = 96;
                    break;
                }
                case 12: {
                    ret = 1;
                    break;
                }
                case -1: {
                    ret = 8;
                    break;
                }
                case 91: 
                case 92: {
                    ret = 12;
                    break;
                }
                case -100: 
                case 93: {
                    ret = 180;
                    break;
                }
                case -101: {
                    ret = 181;
                    break;
                }
                case -102: {
                    ret = 231;
                    break;
                }
                case -104: {
                    ret = 183;
                    break;
                }
                case -103: {
                    ret = 182;
                    break;
                }
                case -3: 
                case -2: {
                    ret = 23;
                    break;
                }
                case -4: {
                    ret = 24;
                    break;
                }
                case -8: {
                    ret = 104;
                    break;
                }
                case 2004: {
                    ret = 113;
                    break;
                }
                case 2005: {
                    ret = 112;
                    break;
                }
                case -13: {
                    ret = 114;
                    break;
                }
                case -10: {
                    ret = 102;
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    ret = 109;
                    break;
                }
                case 2006: {
                    ret = 111;
                    break;
                }
                default: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SQLUtil.logger().log(Level.SEVERE, "         Throwing SQLException: 4get_internal_type");
                            Object var4_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(null, 4, "get_internal_type");
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Return: " + ret);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = ret;
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.SQLUtil"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            block16: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SQLUtil.logger().log(Level.FINER, "         Enter: " + OracleLog.argument());
                        Object var2_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                classTable = new Hashtable(10);
                try {
                    classTable.put(Class.forName("java.lang.String"), 0);
                    classTable.put(Class.forName("java.lang.Boolean"), 1);
                    classTable.put(Class.forName("java.lang.Integer"), 2);
                    classTable.put(Class.forName("java.lang.Long"), 3);
                    classTable.put(Class.forName("java.lang.Float"), 4);
                    classTable.put(Class.forName("java.lang.Double"), 5);
                    classTable.put(Class.forName("java.math.BigDecimal"), 6);
                    classTable.put(Class.forName("java.sql.Date"), 7);
                    classTable.put(Class.forName("java.sql.Time"), 8);
                    classTable.put(Class.forName("java.sql.Timestamp"), 9);
                }
                catch (ClassNotFoundException e3) {
                    if (!TRACE || !OracleLog.recursiveEnter()) break block16;
                    try {
                        SQLUtil.logger().log(OracleLog.TRACE_10, "         Event: Unexpected ClassNotFoundException in static bloc");
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    SQLUtil.logger().log(Level.FINER, "         Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                SQLUtil.logger().log(Level.FINER, "         Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }
}

