/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 4096;
    DBConversion dbConversion;
    int conversion;
    InputStream istream;
    char[] buf;
    byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleConversionReader(DBConversion conv_object, InputStream istream, int conversion) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(conversion));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (conv_object == null || istream == null || conversion != 8 && conversion != 9) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var7_8 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            this.dbConversion = conv_object;
            this.conversion = conversion;
            this.istream = istream;
            this.count = 0;
            this.pos = 0;
            this.numUnconvertedBytes = 0;
            this.isClosed = false;
            this.nbytes = new int[1];
            if (conversion == 8) {
                this.byteBuf = new byte[2048];
                this.buf = new char[4096];
            } else if (conversion == 9) {
                this.byteBuf = new byte[4096];
                this.buf = new char[4096];
            }
            Object var9_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var11_13 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormOfUse(short csform) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(csform));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.csform = csform;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n2;
        block20: {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cbuf) + ", " + OracleLog.argument(off) + ", " + OracleLog.argument(len));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.needChars()) break block20;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n3 = -1;
            Object var11_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n3;
        }
        try {
            int start = off;
            int end = start + Math.min(len, cbuf.length - off);
            start += this.writeChars(cbuf, start, end - start);
            while (start < end && this.needChars()) {
                start += this.writeChars(cbuf, start, end - start);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (start - off));
                    Object var9_26 = null;
                }
                catch (Throwable throwable) {
                    Object var9_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = start - off;
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean needChars() throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                block39: {
                    if (!this.endOfStream) {
                        boolean __ex__;
                        Exception __ex__2;
                        try {
                            int bytes_read = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                            if (bytes_read == -1) {
                                this.endOfStream = true;
                                this.istream.close();
                                if (this.numUnconvertedBytes != 0) {
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 55);
                                            Object var4_9 = null;
                                            OracleLog.recursiveExit();
                                        }
                                        catch (Throwable throwable) {
                                            Object var4_10 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                    }
                                    __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55);
                                    __ex__2.fillInStackTrace();
                                    throw __ex__2;
                                }
                            }
                            if ((bytes_read += this.numUnconvertedBytes) <= 0) break block39;
                            switch (this.conversion) {
                                case 8: {
                                    this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, bytes_read, this.buf);
                                    break;
                                }
                                case 9: {
                                    this.nbytes[0] = bytes_read;
                                    this.count = this.csform == 2 ? this.dbConversion.NCHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length) : this.dbConversion.CHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
                                    this.numUnconvertedBytes = this.nbytes[0];
                                    for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                        this.byteBuf[i2] = this.byteBuf[bytes_read - this.numUnconvertedBytes + i2];
                                    }
                                    break;
                                }
                                default: {
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                                            Object var6_12 = null;
                                            OracleLog.recursiveExit();
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_13 = null;
                                            OracleLog.recursiveExit();
                                            throw throwable;
                                        }
                                    }
                                    __ex__2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                                    __ex__2.fillInStackTrace();
                                    throw __ex__2;
                                }
                            }
                            if (this.count <= 0) break block39;
                            this.pos = 0;
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                                    Object var8_15 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var8_16 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            __ex__ = true;
                        }
                        catch (SQLException e2) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                                    Object var10_34 = null;
                                    OracleLog.recursiveExit();
                                }
                                catch (Throwable throwable) {
                                    Object var10_35 = null;
                                    OracleLog.recursiveExit();
                                    throw throwable;
                                }
                            }
                            __ex__2 = DatabaseError.createIOException(e2);
                            __ex__2.fillInStackTrace();
                            throw __ex__2;
                        }
                        Object var16_18 = null;
                        if (!TRACE) return __ex__;
                        if (!OracleLog.recursiveEnter()) return __ex__;
                        try {
                            OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                            Object var18_22 = null;
                            OracleLog.recursiveExit();
                            return __ex__;
                        }
                        catch (Throwable throwable) {
                            Object var18_23 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        Object var12_37 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var12_38 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = false;
                Object var16_19 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {}
                catch (Throwable throwable) {
                    Object var18_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_24 = null;
                OracleLog.recursiveExit();
                return bl2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var14_40 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var14_41 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = true;
            Object var16_20 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var18_29 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var18_28 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var18_27 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var18_26 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeChars(char[] destbuf, int offset, int length) {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(destbuf) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int availableLength = Math.min(length, this.count - this.pos);
            System.arraycopy(this.buf, this.pos, destbuf, offset, availableLength);
            this.pos += availableLength;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + availableLength);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = availableLength;
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean ready() throws IOException {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.pos < this.count));
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.pos < this.count;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.isClosed) {
                this.isClosed = true;
                this.istream.close();
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void ensureOpen() throws IOException {
        try {
            block16: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                try {
                    if (!this.isClosed) break block16;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                            Object var4_6 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var8_12 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionReader.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleConversionReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

