/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleLog;

class OracleConversionInputStreamInternal
extends OracleConversionInputStream {
    boolean needReset = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleConversionInputStreamInternal(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize) {
        super(conv_object, istream, conversion, max_bytesize);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(istream) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_bytesize));
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var8_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_12 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_10 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionInputStreamInternal(DBConversion conv_object, Reader reader, int conversion, int max_charsize, short formOfUse) {
        super(conv_object, reader, conversion, max_charsize, formOfUse);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(conv_object) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(conversion) + ", " + OracleLog.argument(max_charsize) + ", " + OracleLog.argument(formOfUse));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] destbuf, int offset, int length) throws IOException {
        int n2;
        try {
            int ret;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(destbuf) + ", " + OracleLog.argument(offset) + ", " + OracleLog.argument(length));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.needReset) {
                if (this.istream != null && this.istream.markSupported()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionInputStreamInternal.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "End Of Stream reached , resetting for internally created stream." + this);
                            Object var7_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    this.istream.reset();
                    this.endOfStream = false;
                    this.totalSize = 0;
                    this.needReset = false;
                } else if (this.reader != null && this.reader.markSupported()) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionInputStreamInternal.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "End Of reader reached , resetting for internally created reader." + this);
                            Object var9_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    this.reader.reset();
                    this.endOfStream = false;
                    this.totalSize = 0;
                    this.needReset = false;
                }
            }
            if ((ret = super.read(destbuf, offset, length)) == -1) {
                this.needReset = true;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + ret);
                    Object var11_15 = null;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = ret;
            Object var13_18 = null;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_22 = null;
                }
                catch (Throwable throwable2) {
                    Object var15_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleConversionInputStreamInternal.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var15_20 = null;
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleConversionInputStreamInternal"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

