/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobWriter
extends Writer {
    DBConversion dbConversion;
    CLOB clob;
    long lobOffset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobWriter(CLOB clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobWriter(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize) + ", " + OracleLog.argument(beginOffset));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (clob == null || bufferSize <= 0 || clob.getJavaSqlConnection() == null || beginOffset < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException();
            }
            this.dbConversion = ((PhysicalConnection)clob.getInternalConnection()).conversion;
            this.clob = clob;
            this.lobOffset = beginOffset;
            this.charBuf = new char[bufferSize];
            this.nativeBuf = new byte[bufferSize * 3];
            this.count = 0;
            this.pos = 0;
            this.chunkSize = bufferSize;
            this.isClosed = false;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        try {
            int charsWritten;
            int start;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cbuf) + ", " + OracleLog.argument(off) + ", " + OracleLog.argument(len));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object object = this.lock;
            // MONITORENTER : object
            this.ensureOpen();
            int lengthToWrite = Math.min(len, cbuf.length - off);
            if (lengthToWrite >= 2 * this.chunkSize) {
                if (this.count > 0) {
                    this.flushBuffer();
                }
                try {
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, cbuf, off, lengthToWrite);
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var9_12 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_13 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Object var12_17 = null;
                if (!TRACE) return;
                if (!OracleLog.recursiveEnter()) return;
                try {
                    OracleClobWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var14_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int end = start + lengthToWrite;
            for (start = off; start < end; start += charsWritten, this.count += charsWritten) {
                charsWritten = Math.min(this.chunkSize - this.count, end - start);
                System.arraycopy(cbuf, start, this.charBuf, this.count, charsWritten);
                if (this.count < this.chunkSize) continue;
                this.flushBuffer();
            }
            // MONITOREXIT : object
            Object var12_18 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var14_25 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var14_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var14_23 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleClobWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var14_22 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.flushBuffer();
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.flushBuffer();
                this.isClosed = true;
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobWriter.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flushBuffer() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    if (this.count > 0) {
                        this.lobOffset += (long)this.clob.putChars(this.lobOffset, this.charBuf, 0, this.count);
                        this.count = 0;
                    }
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var4_6 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var7_10 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        try {
            block18: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (!this.isClosed) break block18;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                            Object var4_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobWriter.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            OracleConnection oracleConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    oracleConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                OracleConnection __result__ = this.clob.getInternalConnection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = __result__;
            }
            catch (Exception exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var6_21 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = null;
                Object var8_10 = null;
                if (!TRACE) return oracleConnection;
                if (!OracleLog.recursiveEnter()) return oracleConnection;
                try {}
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            Object var8_9 = null;
            if (!TRACE) return oracleConnection;
            if (!OracleLog.recursiveEnter()) return oracleConnection;
            try {
                OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobWriter.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobWriter"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

