/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobOutputStream
extends OutputStream {
    long lobOffset;
    CLOB clob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public OracleClobOutputStream(CLOB clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleClobOutputStream(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        try {
            PhysicalConnection pConnection;
            PhysicalConnection physicalConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(bufferSize) + ", " + OracleLog.argument(beginOffset));
                    physicalConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (clob == null || bufferSize <= 0 || beginOffset < 1L) {
                if (!TRACE) throw new IllegalArgumentException();
                if (!OracleLog.recursiveEnter()) throw new IllegalArgumentException();
                try {
                    OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                    Object var8_8 = null;
                    OracleLog.recursiveExit();
                    throw new IllegalArgumentException();
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.clob = clob;
            this.lobOffset = beginOffset;
            physicalConnection = pConnection = (PhysicalConnection)clob.getInternalConnection();
            synchronized (physicalConnection) {
                this.buf = pConnection.getByteBuffer(bufferSize);
            }
            this.count = 0;
            this.bufSize = bufferSize;
            this.isClosed = false;
            Object var11_11 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var13_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_13 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(int b2) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(b2));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.count >= this.bufSize) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)b2;
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_9 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void write(byte[] b2, int off, int len) throws IOException {
        try {
            int bytesWritten;
            int start;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(b2) + ", " + OracleLog.argument(off) + ", " + OracleLog.argument(len));
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            int lengthToWrite = Math.min(len, b2.length - off);
            if (lengthToWrite >= 2 * this.bufSize) {
                if (this.count > 0) {
                    this.flushBuffer();
                }
                try {
                    char[] charArr = new char[lengthToWrite];
                    for (int i2 = 0; i2 < lengthToWrite; ++i2) {
                        charArr[i2] = (char)b2[i2 + off];
                    }
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, charArr);
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var9_15 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_16 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                Object var13_18 = null;
                if (!TRACE) return;
                if (!OracleLog.recursiveEnter()) return;
                try {
                    OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_21 = null;
                    OracleLog.recursiveExit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var15_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int end = start + lengthToWrite;
            for (start = off; start < end; start += bytesWritten, this.count += bytesWritten) {
                bytesWritten = Math.min(this.bufSize - this.count, end - start);
                System.arraycopy(b2, start, this.buf, this.count, bytesWritten);
                if (this.count < this.bufSize) continue;
                this.flushBuffer();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    Object var11_30 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_31 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var13_19 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var15_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var15_23 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            this.flushBuffer();
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_8 = null;
            }
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.isClosed) {
                Object var11_4 = null;
                if (!TRACE) return;
                if (!OracleLog.recursiveEnter()) return;
                try {
                    OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var13_7 = null;
                    OracleLog.recursiveExit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var13_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                this.isClosed = true;
                this.flushBuffer();
                Object var4_16 = null;
            }
            catch (Throwable throwable) {
                PhysicalConnection pConnection;
                Object var4_17 = null;
                try {}
                catch (SQLException ea) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {}
                        catch (Throwable throwable2) {
                            Object var9_29 = null;
                            OracleLog.recursiveExit();
                            throw throwable2;
                        }
                        OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + ea);
                        Object var9_28 = null;
                        OracleLog.recursiveExit();
                    }
                    IOException __ex__ = DatabaseError.createIOException(ea);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                PhysicalConnection physicalConnection = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                synchronized (physicalConnection) {
                    if (this.buf == null) throw throwable;
                    pConnection.cacheBuffer(this.buf);
                    this.buf = null;
                    throw throwable;
                }
            }
            try {
                PhysicalConnection pConnection;
                PhysicalConnection physicalConnection = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                synchronized (physicalConnection) {
                    if (this.buf != null) {
                        pConnection.cacheBuffer(this.buf);
                        this.buf = null;
                    }
                }
            }
            catch (SQLException ea) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + ea);
                        Object var9_26 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var9_27 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                IOException __ex__ = DatabaseError.createIOException(ea);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var11_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable3) {
                Object var13_12 = null;
                OracleLog.recursiveExit();
                throw throwable3;
            }
            OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var13_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var13_10 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleClobOutputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var13_9 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flushBuffer() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            try {
                if (this.count > 0) {
                    char[] charArr = new char[this.count];
                    for (int i2 = 0; i2 < this.count; ++i2) {
                        charArr[i2] = (char)this.buf[i2];
                    }
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, charArr);
                    this.count = 0;
                }
            }
            catch (SQLException e2) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                IOException __ex__ = DatabaseError.createIOException(e2);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_14 = null;
            }
            catch (Throwable throwable2) {
                Object var8_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!TRACE || !OracleLog.recursiveEnter()) return;
        try {
            OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        try {
            block18: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (!this.isClosed) break block18;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                            Object var4_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            OracleConnection oracleConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    oracleConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                OracleConnection __result__ = this.clob.getInternalConnection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = __result__;
            }
            catch (Exception exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var6_21 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = null;
                Object var8_10 = null;
                if (!TRACE) return oracleConnection;
                if (!OracleLog.recursiveEnter()) return oracleConnection;
                try {}
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            Object var8_9 = null;
            if (!TRACE) return oracleConnection;
            if (!OracleLog.recursiveEnter()) return oracleConnection;
            try {
                OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobOutputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobOutputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

