/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected CLOB clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB clob) throws SQLException {
        this(clob, ((PhysicalConnection)clob.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB clob, int chunkSize) throws SQLException {
        this(clob, chunkSize, 1L);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobInputStream(CLOB clob, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(clob) + ", " + OracleLog.argument(chunkSize) + ", " + OracleLog.argument(beginOffset));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (clob == null || chunkSize <= 0 || beginOffset < 1L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                        Object var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException();
            }
            this.lobOffset = beginOffset;
            this.clob = clob;
            this.markedByte = -1L;
            this.endOfStream = false;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean needBytes(int howMany) throws IOException {
        block32: {
            block34: {
                block33: {
                    if (OracleClobInputStream.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                            var3_2 = null;
                        }
                        catch (Throwable var2_4) {
                            var3_3 = null;
                            OracleLog.recursiveExit();
                            throw var2_4;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    this.ensureOpen();
                    if (this.pos < this.count) break block32;
                    if (this.endOfStream) ** GOTO lbl85
                    if (howMany > this.currentBufferSize) {
                        this.currentBufferSize = Math.max(howMany, this.initialBufferSize);
                        var3_2 = pConnection = (PhysicalConnection)this.clob.getInternalConnection();
                        synchronized (var3_2) {
                            this.resizableBuffer = pConnection.getByteBuffer(this.currentBufferSize);
                            this.charBuf = pConnection.getCharBuffer(this.currentBufferSize);
                        }
                    }
                    this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                    for (i = 0; i < this.count; i += 1) {
                        this.resizableBuffer[i] = (byte)this.charBuf[i];
                    }
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count <= 0) break block33;
                    this.pos = 0;
                    this.lobOffset += (long)this.count;
                    if (OracleClobInputStream.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            var6_10 = null;
                        }
                        catch (Throwable var5_12) {
                            var6_11 = null;
                            OracleLog.recursiveExit();
                            throw var5_12;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    i = 1;
                    var14_13 = null;
                    if (OracleClobInputStream.TRACE == false) return (boolean)i;
                    if (!OracleLog.recursiveEnter()) return (boolean)i;
                    try {
                        OracleClobInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        var16_17 = null;
                    }
                    catch (Throwable var15_25) {
                        var16_18 = null;
                        OracleLog.recursiveExit();
                        throw var15_25;
                    }
                    OracleLog.recursiveExit();
                    return (boolean)i;
                }
                break block34;
                {
                    catch (SQLException e) {
                        if (OracleClobInputStream.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e);
                                var8_29 = null;
                            }
                            catch (Throwable var7_31) {
                                var8_30 = null;
                                OracleLog.recursiveExit();
                                throw var7_31;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        __ex__ = DatabaseError.createIOException(e);
                        __ex__.fillInStackTrace();
                        throw __ex__;
                    }
                }
            }
            if (OracleClobInputStream.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    var10_32 = null;
                }
                catch (Throwable var9_34) {
                    var10_33 = null;
                    OracleLog.recursiveExit();
                    throw var9_34;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var2_6 = false;
            var14_14 = null;
            if (OracleClobInputStream.TRACE == false) return var2_6;
            if (!OracleLog.recursiveEnter()) return var2_6;
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var16_19 = null;
            }
            catch (Throwable var15_26) {
                var16_20 = null;
                OracleLog.recursiveExit();
                throw var15_26;
            }
            OracleLog.recursiveExit();
            return var2_6;
        }
        try {
            if (OracleClobInputStream.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    var12_35 = null;
                }
                catch (Throwable var11_37) {
                    var12_36 = null;
                    OracleLog.recursiveExit();
                    throw var11_37;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            var2_8 = true;
            var14_15 = null;
            if (OracleClobInputStream.TRACE == false) return var2_8;
        }
        catch (Throwable var13_38) {
            var14_16 = null;
            if (!OracleClobInputStream.TRACE || !OracleLog.recursiveEnter()) throw var13_38;
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var16_23 = null;
            }
            catch (Throwable var15_28) {
                var16_24 = null;
                OracleLog.recursiveExit();
                throw var15_28;
            }
            OracleLog.recursiveExit();
            {
                throw var13_38;
            }
        }
        if (!OracleLog.recursiveEnter()) return var2_8;
        try {
            OracleClobInputStream.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var16_21 = null;
        }
        catch (Throwable var15_27) {
            var16_22 = null;
            OracleLog.recursiveExit();
            throw var15_27;
        }
        OracleLog.recursiveExit();
        return var2_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureOpen() throws IOException {
        try {
            block18: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                try {
                    if (!this.closed) break block18;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                            Object var4_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_10 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_16 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markSupported() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = true;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(readLimit));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (readLimit < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + DatabaseError.findMessage(196, null));
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
            }
            this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    public void markInternal(int readLimit) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.markedByte < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + DatabaseError.findMessage(195, null));
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new IOException(DatabaseError.findMessage(195, null));
            }
            this.lobOffset = this.markedByte;
            this.pos = this.count;
            this.endOfStream = false;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n2) throws IOException {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            long start = 0L;
            if ((long)(this.count - this.pos) >= n2) {
                this.pos = (int)((long)this.pos + n2);
                start += n2;
            } else {
                start += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long remainLen = 0L;
                    remainLen = this.clob.length() - this.lobOffset + 1L;
                    if (remainLen >= n2 - start) {
                        this.lobOffset += n2 - start;
                        start += n2 - start;
                    } else {
                        this.lobOffset += remainLen;
                        start += remainLen;
                    }
                }
                catch (SQLException e2) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + e2);
                            Object var8_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    IOException __ex__ = DatabaseError.createIOException(e2);
                    __ex__.fillInStackTrace();
                    throw __ex__;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + start);
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = start;
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobInputStream.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_17 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * Exception decompiling
     */
    public void close() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            OracleConnection oracleConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    oracleConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            try {
                OracleConnection __result__ = this.clob.getInternalConnection();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = __result__;
            }
            catch (Exception exc) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                        Object var6_21 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var6_22 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                oracleConnection = null;
                Object var8_10 = null;
                if (!TRACE) return oracleConnection;
                if (!OracleLog.recursiveEnter()) return oracleConnection;
                try {}
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            Object var8_9 = null;
            if (!TRACE) return oracleConnection;
            if (!OracleLog.recursiveEnter()) return oracleConnection;
            try {
                OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
                OracleLog.recursiveExit();
                return oracleConnection;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobInputStream.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

