/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class DateCommonBinder
extends Binder {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int ORACLE_DATE_CENTURY = 0;
    static final int ORACLE_DATE_YEAR = 1;
    static final int ORACLE_DATE_MONTH = 2;
    static final int ORACLE_DATE_DAY = 3;
    static final int ORACLE_DATE_HOUR = 4;
    static final int ORACLE_DATE_MIN = 5;
    static final int ORACLE_DATE_SEC = 6;
    static final int ORACLE_DATE_NANO1 = 7;
    static final int ORACLE_DATE_NANO2 = 8;
    static final int ORACLE_DATE_NANO3 = 9;
    static final int ORACLE_DATE_NANO4 = 10;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int SECOND_MILLISECOND = 1000;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    DateCommonBinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long floorDivide(long numerator, long denominator) {
        long l2;
        try {
            long __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(numerator) + ", " + OracleLog.argument(denominator));
                    Object var5_2 = null;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long l3 = __result__ = numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var11_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int floorDivide(int numerator, int denominator) {
        int n2;
        try {
            int __result__;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(numerator) + ", " + OracleLog.argument(denominator));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            int n3 = __result__ = numerator >= 0 ? numerator / denominator : (numerator + 1) / denominator - 1;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int floorDivide(int numerator, int denominator, int[] remainder) {
        block19: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(numerator) + ", " + OracleLog.argument(denominator) + ", " + OracleLog.argument(remainder));
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (numerator < 0) break block19;
                remainder[0] = numerator % denominator;
                int __result__ = numerator / denominator;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = __result__;
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                        Object var12_20 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var12_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var12_16 = null;
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        int quotient = (numerator + 1) / denominator - 1;
        remainder[0] = numerator - quotient * denominator;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + quotient);
                Object var8_25 = null;
            }
            catch (Throwable throwable) {
                Object var8_26 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = quotient;
        Object var10_14 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var12_18 = null;
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int floorDivide(long numerator, int denominator, int[] remainder) {
        block19: {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(numerator) + ", " + OracleLog.argument(denominator) + ", " + OracleLog.argument(remainder));
                        Object var5_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (numerator < 0L) break block19;
                remainder[0] = (int)(numerator % (long)denominator);
                int __result__ = (int)(numerator / (long)denominator);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                        Object var7_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                n2 = __result__;
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                        Object var13_20 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var13_21 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var13_16 = null;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return n2;
        }
        int quotient = (int)((numerator + 1L) / (long)denominator - 1L);
        remainder[0] = (int)(numerator - (long)(quotient * denominator));
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + quotient);
                Object var9_25 = null;
            }
            catch (Throwable throwable) {
                Object var9_26 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        int n3 = quotient;
        Object var11_14 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var13_18 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long zoneOffset(TimeZone zone, int year, int month, int day, int dow, int millisInDay) {
        long l2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(zone) + ", " + OracleLog.argument(year) + ", " + OracleLog.argument(month) + ", " + OracleLog.argument(day) + ", " + OracleLog.argument(dow) + ", " + OracleLog.argument(millisInDay));
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            long __result__ = zone.getOffset(year < 0 ? 0 : 1, year, month, day, dow, millisInDay);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            l2 = __result__;
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var13_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setOracleNanos(long nanos, byte[] oracleDate, int off) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(nanos) + ", " + OracleLog.argument(oracleDate) + ", " + OracleLog.argument(off));
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleDate[10 + off] = (byte)(nanos & 0xFFL);
            oracleDate[9 + off] = (byte)(nanos >> 8 & 0xFFL);
            oracleDate[8 + off] = (byte)(nanos >> 16 & 0xFFL);
            oracleDate[7 + off] = (byte)(nanos >> 24 & 0xFFL);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var9_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setOracleHMS(int millis, byte[] oracleDate, int off) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(millis) + ", " + OracleLog.argument(oracleDate) + ", " + OracleLog.argument(off));
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (millis < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(Level.SEVERE, "         Throwing RuntimeException: Assertion botch: negative time");
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new RuntimeException("Assertion botch: negative time");
            }
            oracleDate[6 + off] = (byte)((millis /= 1000) % 60 + 1);
            oracleDate[5 + off] = (byte)((millis /= 60) % 60 + 1);
            oracleDate[4 + off] = (byte)((millis /= 60) + 1);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var10_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int setOracleCYMD(long time, byte[] oracleDate, int off, OraclePreparedStatement stmt) throws SQLException {
        int n2;
        try {
            int march1;
            int dayOfWeek;
            boolean isLeap;
            int year;
            int dayOfYear;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(time) + ", " + OracleLog.argument(oracleDate) + ", " + OracleLog.argument(off) + ", " + OracleLog.argument(stmt));
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            TimeZone zone = stmt.getDefaultTimeZone(true);
            Calendar cal = stmt.cachedUTCUSCalendar;
            cal.setTimeInMillis(time);
            Calendar cal2 = stmt.getDefaultCalendar();
            cal2.setTimeInMillis(time);
            int Offset_UTC = cal2.get(15);
            long localMillis = time + (long)Offset_UTC;
            if (localMillis >= -12219292800000L) {
                int n1;
                int n4;
                int n100;
                int n400;
                long gregorianEpochDay = 2440588L + DateCommonBinder.floorDivide(localMillis, 86400000L) - 1721426L;
                if (gregorianEpochDay > 0L) {
                    n400 = (int)(gregorianEpochDay / 146097L);
                    dayOfYear = (int)(gregorianEpochDay % 146097L);
                    n100 = dayOfYear / 36524;
                    n4 = (dayOfYear %= 36524) / 1461;
                    n1 = (dayOfYear %= 1461) / 365;
                    dayOfYear %= 365;
                } else {
                    int[] rem = new int[1];
                    n400 = DateCommonBinder.floorDivide(gregorianEpochDay, 146097, rem);
                    n100 = DateCommonBinder.floorDivide(rem[0], 36524, rem);
                    n4 = DateCommonBinder.floorDivide(rem[0], 1461, rem);
                    n1 = DateCommonBinder.floorDivide(rem[0], 365, rem);
                    dayOfYear = rem[0];
                }
                year = 400 * n400 + 100 * n100 + 4 * n4 + n1;
                if (n100 == 4 || n1 == 4) {
                    dayOfYear = 365;
                } else {
                    ++year;
                }
                isLeap = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                dayOfWeek = (int)((gregorianEpochDay + 1L) % 7L);
            } else {
                long julianEpochDay = 2440588L + DateCommonBinder.floorDivide(localMillis, 86400000L) - 1721424L;
                year = (int)DateCommonBinder.floorDivide(4L * julianEpochDay + 1464L, 1461L);
                long january1 = 365 * (year - 1) + DateCommonBinder.floorDivide(year - 1, 4);
                dayOfYear = (int)(julianEpochDay - january1);
                isLeap = (year & 3) == 0;
                dayOfWeek = (int)((julianEpochDay - 1L) % 7L);
            }
            int correction = 0;
            int n3 = march1 = isLeap ? 60 : 59;
            if (dayOfYear >= march1) {
                correction = isLeap ? 1 : 2;
            }
            int month = (12 * (dayOfYear + correction) + 6) / 367;
            int date = dayOfYear - (isLeap ? LEAP_NUM_DAYS[month] : NUM_DAYS[month]) + 1;
            dayOfWeek += dayOfWeek < 0 ? 8 : 1;
            long days = localMillis / 86400000L;
            int millisInDay = (int)(localMillis - days * 86400000L);
            if (millisInDay < 0) {
                millisInDay = (int)((long)millisInDay + 86400000L);
            }
            long dstOffset = DateCommonBinder.zoneOffset(zone, year, month, date, dayOfWeek, millisInDay);
            if ((long)(millisInDay = (int)((long)millisInDay + (dstOffset -= (long)Offset_UTC))) >= 86400000L) {
                millisInDay = (int)((long)millisInDay - 86400000L);
                if (++date > (isLeap ? LEAP_MONTH_LENGTH[month] : MONTH_LENGTH[month])) {
                    date = 1;
                    if (++month == 12) {
                        month = 0;
                        ++year;
                    }
                }
            }
            if (year <= 0) {
                --year;
            }
            if (year > 9999 || year < -4712) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DateCommonBinder.logger().log(Level.SEVERE, "         Throwing SQLException: 268");
                        Object var23_29 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_30 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 268);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            oracleDate[0 + off] = (byte)(year / 100 + 100);
            oracleDate[1 + off] = (byte)(year % 100 + 100);
            oracleDate[2 + off] = (byte)(month + 1);
            oracleDate[3 + off] = (byte)date;
            int __result__ = millisInDay;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Return: " + __result__);
                    Object var25_35 = null;
                }
                catch (Throwable throwable) {
                    Object var25_36 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = __result__;
            Object var27_38 = null;
        }
        catch (Throwable throwable) {
            Object var27_39 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var29_42 = null;
                }
                catch (Throwable throwable2) {
                    Object var29_43 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateCommonBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var29_40 = null;
            }
            catch (Throwable throwable) {
                Object var29_41 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.DateCommonBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

