/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class DateBinder
extends DateCommonBinder {
    Binder theDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void init(Binder x) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(x));
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            x.type = (short)12;
            x.bytelen = 7;
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            DateBinder.logger().log(OracleLog.TRACE_30, "         Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            DateBinder.logger().log(OracleLog.TRACE_30, "         Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DateBinder() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            DateBinder.init(this);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Binder copyingBinder() {
        Binder binder;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.theDateCopyingBinder);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            binder = this.theDateCopyingBinder;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                    Object var16_15 = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Date[] dates = stmt.parameterDate[rank];
            Date value = dates[bindPosition];
            if (clearPriorBindValues) {
                dates[bindPosition] = null;
            }
            if (value == null) {
                bindIndicators[indoffset] = -1;
            } else {
                bindIndicators[indoffset] = 0;
                long millis = DateBinder.setOracleCYMD(value.getTime(), bindBytes, byteoffset, stmt);
                bindBytes[6 + byteoffset] = 1;
                bindBytes[5 + byteoffset] = 1;
                bindBytes[4 + byteoffset] = 1;
                bindIndicators[lenoffset] = (short)bytePitch;
            }
            Object var20_20 = null;
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var22_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                DateBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_22 = null;
            }
            catch (Throwable throwable) {
                Object var22_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.DateBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

