/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dcn;

import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.dcn.QueryChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.OracleLog;

public abstract class DatabaseChangeEvent
extends EventObject {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseChangeEvent(Object source) {
        block12: {
            super(source);
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block12;
                try {
                    DatabaseChangeEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(source));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        DatabaseChangeEvent.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    public abstract EventType getEventType();

    public abstract AdditionalEventType getAdditionalEventType();

    public abstract TableChangeDescription[] getTableChangeDescription();

    public abstract QueryChangeDescription[] getQueryChangeDescription();

    public abstract String getConnectionInformation();

    public abstract String getDatabaseName();

    public abstract int getRegistrationId();

    public abstract long getRegId();

    public abstract byte[] getTransactionId();

    public abstract String getTransactionId(boolean var1);

    public abstract String toString();

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.dcn");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.dcn.DatabaseChangeEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdditionalEventType {
        NONE(0),
        TIMEOUT(1),
        GROUPING(2);

        private final int code;

        private AdditionalEventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final AdditionalEventType getEventType(int code) {
            if (code == TIMEOUT.getCode()) {
                return TIMEOUT;
            }
            if (code == GROUPING.getCode()) {
                return GROUPING;
            }
            return NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        NONE(0),
        STARTUP(1),
        SHUTDOWN(2),
        SHUTDOWN_ANY(3),
        DEREG(5),
        OBJCHANGE(6),
        QUERYCHANGE(7);

        private final int code;

        private EventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final EventType getEventType(int code) {
            if (code == STARTUP.getCode()) {
                return STARTUP;
            }
            if (code == SHUTDOWN.getCode()) {
                return SHUTDOWN;
            }
            if (code == SHUTDOWN_ANY.getCode()) {
                return SHUTDOWN_ANY;
            }
            if (code == DEREG.getCode()) {
                return DEREG;
            }
            if (code == OBJCHANGE.getCode()) {
                return OBJCHANGE;
            }
            if (code == QUERYCHANGE.getCode()) {
                return QUERYCHANGE;
            }
            return NONE;
        }
    }
}

