/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.sdk.occa.report.definition;

import com.crystaldecisions12.client.helper.CloneUtil;
import com.crystaldecisions12.client.helper.XMLSerializationHelper;
import com.crystaldecisions12.sdk.occa.report.definition.FontStyle;
import com.crystaldecisions12.sdk.occa.report.definition.IFont;
import com.crystaldecisions12.sdk.occa.report.lib.IClone;
import com.crystaldecisions12.xml.serialization.IXMLSerializable;
import com.crystaldecisions12.xml.serialization.IXMLSerializationOptions;
import com.crystaldecisions12.xml.serialization.XMLConverter;
import com.crystaldecisions12.xml.serialization.XMLSerializationContext;
import com.crystaldecisions12.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.xml.sax.Attributes;

public class Font
implements IFont,
IClone,
IXMLSerializable,
IXMLSerializationOptions {
    private String iJ = "Times New Roman";
    private float iH = 10.0f;
    private boolean iE = false;
    private boolean iG = false;
    private boolean iK = false;
    private boolean iF = false;
    private int iI = 400;
    private short iL = 0;
    private FontStyle iC = FontStyle.Normal;
    private static final String iD = "FonStyle";

    public Font(IFont iFont) {
        iFont.copyTo(this, true);
    }

    public Font() {
    }

    public Object clone(boolean bl2) {
        Font font = new Font();
        this.copyTo(font, bl2);
        return font;
    }

    public void copyTo(Object object, boolean bl2) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof IFont)) {
            throw new ClassCastException();
        }
        IFont iFont = (IFont)object;
        iFont.setBold(this.iE);
        iFont.setItalic(this.iG);
        iFont.setUnderline(this.iK);
        iFont.setStrikethrough(this.iF);
        iFont.setWeight(this.iI);
        iFont.setName(this.iJ);
        iFont.setSize(this.iH);
        iFont.setCharset(this.iL);
        iFont.setFontStyle(this.iC);
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        return null;
    }

    public void endElement(String string, Map map) {
    }

    public boolean getBold() {
        return this.iC == FontStyle.Bold || this.iC == FontStyle.BoldItalic;
    }

    public boolean getItalic() {
        return this.iC == FontStyle.Italic || this.iC == FontStyle.BoldItalic;
    }

    public String getName() {
        return this.iJ;
    }

    public float getSize() {
        return this.iH;
    }

    public boolean getStrikethrough() {
        return this.iF;
    }

    public boolean getUnderline() {
        return this.iK;
    }

    public int getWeight() {
        return this.iI;
    }

    public boolean hasContent(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IFont)) {
            return false;
        }
        IFont iFont = (IFont)object;
        if (this.iE != iFont.getBold()) {
            return false;
        }
        if (this.iG != iFont.getItalic()) {
            return false;
        }
        if (this.iK != iFont.getUnderline()) {
            return false;
        }
        if (this.iF != iFont.getStrikethrough()) {
            return false;
        }
        if (this.iI != iFont.getWeight()) {
            return false;
        }
        if (this.iH != iFont.getSize()) {
            return false;
        }
        if (this.iL != iFont.getCharset()) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.iJ, iFont.getName())) {
            return false;
        }
        return this.iC == iFont.getFontStyle();
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
        if (string.equals("Name")) {
            this.iJ = string2;
        } else if (string.equals("Size.Low")) {
            this.iH = XMLConverter.getInteger(string2).floatValue() / 10000.0f;
        } else if (string.equals("Bold")) {
            this.setBold(XMLConverter.getBooleanValue(string2));
        } else if (string.equals("Italic")) {
            this.setItalic(XMLConverter.getBooleanValue(string2));
        } else if (string.equals("Underline")) {
            this.iK = XMLConverter.getBooleanValue(string2);
        } else if (string.equals("Strikethrough")) {
            this.iF = XMLConverter.getBooleanValue(string2);
        } else if (string.equals("Weight")) {
            this.iI = XMLConverter.getInt(string2);
        } else if (string.equals("Charset")) {
            this.iL = (short)XMLConverter.getInt(string2);
        } else if (string.equals(iD)) {
            this.setFontStyle(FontStyle.from_string(string2));
        }
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement("CrystalReports.Font", properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement("CrystalReports.Font");
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeTextElement("Name", this.getName(), null);
        xMLWriter.writeIntElement("Size.Low", (int)(this.iH * 10000.0f), null);
        xMLWriter.writeIntElement("Size.High", 0, null);
        xMLWriter.writeBooleanElement("Bold", this.iE, null);
        xMLWriter.writeBooleanElement("Italic", this.iG, null);
        xMLWriter.writeBooleanElement("Underline", this.iK, null);
        xMLWriter.writeBooleanElement("Strikethrough", this.iF, null);
        xMLWriter.writeIntElement("Weight", this.iI, null);
        xMLWriter.writeIntElement("Charset", this.iL, null);
        xMLWriter.writeEnumElement(iD, this.iC, null);
    }

    public void setBold(boolean bl2) {
        this.iE = bl2;
        this.k();
    }

    public void setItalic(boolean bl2) {
        this.iG = bl2;
        this.k();
    }

    private void k() {
        this.iC = this.iE && this.iG ? FontStyle.BoldItalic : (this.iE ? FontStyle.Bold : (this.iG ? FontStyle.Italic : FontStyle.Normal));
    }

    public void setName(String string) {
        this.iJ = string;
    }

    public void setSize(float f7) {
        this.iH = f7;
    }

    public void setStrikethrough(boolean bl2) {
        this.iF = bl2;
    }

    public void setUnderline(boolean bl2) {
        this.iK = bl2;
    }

    public void setWeight(int n2) {
        this.iI = n2;
    }

    public boolean skipWritingIdenticalObject() {
        return true;
    }

    public void startElement(String string, Map map, Attributes attributes) {
    }

    public short getCharset() {
        return this.iL;
    }

    public void setCharset(short s2) {
        this.iL = s2;
    }

    public FontStyle getFontStyle() {
        return this.iC;
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.iC = fontStyle;
        this.j();
    }

    private void j() {
        if (this.iC == FontStyle.BoldItalic) {
            this.iE = true;
            this.iG = true;
            this.iI = this.iI < 700 ? 700 : this.iI;
        } else if (this.iC == FontStyle.Bold) {
            this.iE = true;
            this.iG = false;
            this.iI = this.iI < 700 ? 700 : this.iI;
        } else if (this.iC == FontStyle.Italic) {
            this.iE = false;
            this.iG = true;
            this.iI = this.iI >= 700 ? 400 : this.iI;
        } else if (this.iC == FontStyle.Normal) {
            this.iE = false;
            this.iG = false;
            this.iI = this.iI >= 700 ? 400 : this.iI;
        }
    }
}

