/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas.functions.string;

import com.crystaldecisions12.reports.common.StringUtil;
import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.BooleanValue;
import com.crystaldecisions12.reports.common.value.DateTimeValue;
import com.crystaldecisions12.reports.common.value.DateValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.NumericValue;
import com.crystaldecisions12.reports.common.value.StringValue;
import com.crystaldecisions12.reports.common.value.TimeValue;
import com.crystaldecisions12.reports.formulas.FormatStringParser;
import com.crystaldecisions12.reports.formulas.FormulaEnvironment;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions12.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions12.reports.formulas.FormulaResources;
import com.crystaldecisions12.reports.formulas.FormulaValueReference;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import java.util.Locale;

class am
extends FormulaFunctionBase {
    public am(String string, String string2, FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
        super(string, string2, formulaFunctionArgumentDefinitionArray);
    }

    public boolean allowNullArguments() {
        return true;
    }

    public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        return FormulaValueType.string;
    }

    public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
        int n2 = formulaValueReferenceArray.length;
        CrystalAssert.a(n2 >= 1);
        FormulaValueReference formulaValueReference = formulaValueReferenceArray[0];
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.string) {
            return formulaValueReference.getFormulaValue();
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.bool) {
            BooleanValue booleanValue = (BooleanValue)formulaValueReference.getFormulaValue();
            if (booleanValue.getBoolean()) {
                return StringValue.fromString("True");
            }
            return StringValue.fromString("False");
        }
        Locale locale = formulaEnvironment.getFormulaClient().getLocale();
        if (formulaValueReference.getFormulaValueType().isNumeric()) {
            Object object;
            CharSequence charSequence;
            Object object2;
            double d10 = ((NumericValue)formulaValueReference.getFormulaValue()).getDouble();
            NumberFormat numberFormat = FormatterCache.new(locale);
            if (n2 == 1) {
                String string = numberFormat.format(d10);
                return StringValue.fromString(string);
            }
            DecimalFormat decimalFormat = FormatterCache.int(locale);
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
            int n3 = 2;
            boolean bl2 = false;
            String string = null;
            if (formulaValue.getFormulaValueType() == FormulaValueType.string) {
                string = ((StringValue)formulaValue).getString();
                bl2 = true;
                decimalFormat.setGroupingUsed(false);
                ++n3;
            } else {
                decimalFormat.setGroupingUsed(true);
            }
            String string2 = decimalFormat.format(d10);
            if (n3 <= n2) {
                object2 = formulaValueReferenceArray[n3 - 1].getFormulaValue();
                long l2 = ((NumberValue)object2).getLong();
                if (l2 < 0L) {
                    throw new FormulaFunctionArgumentException(FormulaResources.a(), "InvalidNumberOfDecimalPlaces", n3 - 1);
                }
                charSequence = bl2 ? new StringBuilder("##0") : new StringBuilder(",##0");
                if (l2 > 0L) {
                    ((StringBuilder)charSequence).append(".");
                    int n4 = 1;
                    while ((long)n4 <= l2) {
                        ((StringBuilder)charSequence).append("0");
                        ++n4;
                    }
                }
                decimalFormat.applyPattern(((StringBuilder)charSequence).toString());
                string2 = decimalFormat.format(d10);
                ++n3;
            }
            object2 = String.valueOf(decimalFormatSymbols.getGroupingSeparator());
            String string3 = object2;
            if (n3 <= n2) {
                object = formulaValueReferenceArray[n3 - 1].getFormulaValue();
                if (((FormulaValue)object).getFormulaValueType() == FormulaValueType.string) {
                    string3 = ((StringValue)object).getString();
                    if (!bl2) {
                        string2 = StringUtil.replace(string2, (String)object2, string3);
                    }
                }
                ++n3;
            }
            object = String.valueOf(decimalFormatSymbols.getDecimalSeparator());
            charSequence = object;
            if (n3 <= n2) {
                FormulaValue formulaValue2 = formulaValueReferenceArray[n3 - 1].getFormulaValue();
                if (formulaValue2.getFormulaValueType() == FormulaValueType.string) {
                    charSequence = ((StringValue)formulaValue2).getString();
                    if (!bl2) {
                        string2 = StringUtil.replace(string2, (String)object, (String)charSequence);
                    }
                }
                ++n3;
            }
            if (bl2 && (string2 = FormatStringParser.a(string, string3, (String)charSequence, string2)) == null) {
                throw new FormulaFunctionArgumentException(FormulaResources.a(), "BadNumberFormatString", 1);
            }
            return StringValue.fromString(string2);
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.date) {
            DateValue dateValue = (DateValue)formulaValueReference.getFormulaValue();
            String string = null;
            if (n2 >= 2) {
                FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
                String string4 = ((StringValue)formulaValue).getString();
                if (string4.length() > 0) {
                    FormatStringParser formatStringParser = new FormatStringParser();
                    string = formatStringParser.a(dateValue, string4);
                }
                if (string == null) {
                    throw new FormulaFunctionArgumentException(FormulaResources.a(), "BadDateFormatString", 1);
                }
            } else {
                Calendar calendar = Calendar.getInstance((Locale)locale);
                calendar.set(DateValue.getYear(dateValue), DateValue.getMonth(dateValue) - 1, DateValue.getDay(dateValue));
                string = FormatterCache.if(locale).format((Object)calendar);
            }
            return StringValue.fromString(string);
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.time) {
            TimeValue timeValue = (TimeValue)formulaValueReference.getFormulaValue();
            String string = null;
            if (n2 >= 2) {
                FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
                String string5 = ((StringValue)formulaValue).getString();
                DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                String string6 = stringArray[0];
                String string7 = stringArray[1];
                if (n2 >= 3) {
                    string6 = ((StringValue)formulaValueReferenceArray[2].getFormulaValue()).getString();
                }
                if (n2 >= 4) {
                    string7 = ((StringValue)formulaValueReferenceArray[3].getFormulaValue()).getString();
                }
                if (string5.length() > 0) {
                    FormatStringParser formatStringParser = new FormatStringParser();
                    string = formatStringParser.a(timeValue, string5, string6, string7);
                }
                if (string == null) {
                    throw new FormulaFunctionArgumentException(FormulaResources.a(), "BadTimeFormatString", 1);
                }
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.set(0, 0, 0, TimeValue.getHours(timeValue), TimeValue.getMinutes(timeValue), TimeValue.getWholeSeconds(timeValue));
                calendar.set(14, (int)(TimeValue.getNanoseconds(timeValue) / 1000000L));
                string = FormatterCache.for(locale).format((Object)calendar);
            }
            return StringValue.fromString(string);
        }
        if (formulaValueReference.getFormulaValueType() == FormulaValueType.dateTime) {
            DateTimeValue dateTimeValue = (DateTimeValue)formulaValueReference.getFormulaValue();
            String string = null;
            if (n2 >= 2) {
                FormulaValue formulaValue = formulaValueReferenceArray[1].getFormulaValue();
                String string8 = ((StringValue)formulaValue).getString();
                DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                String string9 = stringArray[0];
                String string10 = stringArray[1];
                if (n2 >= 3) {
                    string9 = ((StringValue)formulaValueReferenceArray[2].getFormulaValue()).getString();
                }
                if (n2 >= 4) {
                    string10 = ((StringValue)formulaValueReferenceArray[3].getFormulaValue()).getString();
                }
                if (string8.length() > 0) {
                    FormatStringParser formatStringParser = new FormatStringParser();
                    string = formatStringParser.a(dateTimeValue, string8, string9, string10);
                }
                if (string == null) {
                    throw new FormulaFunctionArgumentException(FormulaResources.a(), "BadDateTimeFormatString", 1);
                }
            } else {
                DateValue dateValue = null;
                TimeValue timeValue = null;
                if (dateTimeValue != null) {
                    dateValue = dateTimeValue.getDateValue();
                    timeValue = dateTimeValue.getTimeValue();
                }
                Calendar calendar = Calendar.getInstance((Locale)locale);
                calendar.set(DateValue.getYear(dateValue), DateValue.getMonth(dateValue) - 1, DateValue.getDay(dateValue), TimeValue.getHours(timeValue), TimeValue.getMinutes(timeValue), TimeValue.getWholeSeconds(timeValue));
                calendar.set(14, (int)(TimeValue.getNanoseconds(timeValue) / 1000000L));
                string = FormatterCache.a(locale).format((Object)calendar);
            }
            return StringValue.fromString(string);
        }
        CrystalAssert.a(false);
        return formulaValueReference.getFormulaValue();
    }
}

