/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas.functions.financial;

import com.crystaldecisions12.reports.common.value.ArrayValue;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.NumericValue;
import com.crystaldecisions12.reports.formulas.FormulaEnvironment;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions12.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions12.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions12.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions12.reports.formulas.FormulaResources;
import com.crystaldecisions12.reports.formulas.FormulaValueReference;
import com.crystaldecisions12.reports.formulas.functions.CommonArguments;
import com.crystaldecisions12.reports.formulas.functions.FormulaFunctionFactory;

class f
implements FormulaFunctionFactory {
    private static f el = new f();
    private static final FormulaFunctionArgumentDefinition[][] em = new FormulaFunctionArgumentDefinition[][]{{CommonArguments.currencyValuesArray, CommonArguments.financeRate, CommonArguments.reinvestRate}};
    private static FormulaFunctionDefinition[] en = new FormulaFunctionDefinition[]{new a(em[0])};

    private f() {
    }

    public static f aJ() {
        return el;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        return en[n2];
    }

    public int getNFunctionInstances() {
        return en.length;
    }

    private static class a
    extends FormulaFunctionBase {
        public a(FormulaFunctionArgumentDefinition[] formulaFunctionArgumentDefinitionArray) {
            super("MIRR", "mirr", formulaFunctionArgumentDefinitionArray);
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            if (formulaValueReferenceArray[0].getFormulaValue() != null) {
                FormulaValue[] formulaValueArray = ((ArrayValue)formulaValueReferenceArray[0].getFormulaValue()).getArray();
                boolean bl2 = false;
                boolean bl3 = false;
                for (int i2 = 0; i2 < formulaValueArray.length; ++i2) {
                    double d10 = ((NumericValue)formulaValueArray[i2]).getScaledDouble();
                    if (d10 < 0.0) {
                        bl3 = true;
                        continue;
                    }
                    if (bl2 || !(d10 > 0.0)) continue;
                    bl2 = true;
                }
                if (!bl2 || !bl3) {
                    String[] stringArray = new String[]{"MIRR"};
                    throw new FormulaFunctionArgumentException(FormulaResources.a(), "InvalidValuesArray", stringArray, 0);
                }
            }
            return FormulaValueType.number;
        }

        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            this.validate(formulaValueReferenceArray, formulaEnvironment);
            FormulaValue[] formulaValueArray = ((ArrayValue)formulaValueReferenceArray[0].getFormulaValue()).getArray();
            double d10 = ((NumberValue)formulaValueReferenceArray[1].getFormulaValue()).getDouble();
            double d11 = ((NumberValue)formulaValueReferenceArray[2].getFormulaValue()).getDouble();
            double d12 = 1.0;
            double d13 = 1.0;
            double d14 = 0.0;
            double d15 = 0.0;
            int n2 = formulaValueArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d16;
                double d17 = ((NumericValue)formulaValueArray[n2 - i2 - 1]).getScaledDouble();
                if (d17 > 0.0) {
                    d15 += d17 * d12;
                }
                if ((d16 = ((NumericValue)formulaValueArray[i2]).getScaledDouble()) < 0.0) {
                    d14 += d16 / d13;
                }
                d12 *= 1.0 + d11;
                d13 *= 1.0 + d10;
            }
            double d18 = Math.pow(-d15 / d14, 1.0 / (double)(n2 - 1)) - 1.0;
            return NumberValue.fromDouble(d18);
        }
    }
}

