/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.formulas;

import com.crystaldecisions12.reports.common.StringComparisonMethod;
import com.crystaldecisions12.reports.common.StringUtil;
import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.formulas.ArrayPool;
import com.crystaldecisions12.reports.formulas.BinaryOperatorNode;
import com.crystaldecisions12.reports.formulas.ConditionalNode;
import com.crystaldecisions12.reports.formulas.CustomFunctionDefinition;
import com.crystaldecisions12.reports.formulas.ExpressionNode;
import com.crystaldecisions12.reports.formulas.ExpressionNodeType;
import com.crystaldecisions12.reports.formulas.FieldExpression;
import com.crystaldecisions12.reports.formulas.FieldNode;
import com.crystaldecisions12.reports.formulas.FormulaClient;
import com.crystaldecisions12.reports.formulas.FormulaContext;
import com.crystaldecisions12.reports.formulas.FormulaDefinition;
import com.crystaldecisions12.reports.formulas.FormulaDefinitionBase;
import com.crystaldecisions12.reports.formulas.FormulaException;
import com.crystaldecisions12.reports.formulas.FormulaFunction;
import com.crystaldecisions12.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions12.reports.formulas.FormulaInfo;
import com.crystaldecisions12.reports.formulas.FormulaLanguageFunctionFilter;
import com.crystaldecisions12.reports.formulas.FormulaLanguageFunctionObject;
import com.crystaldecisions12.reports.formulas.FormulaLanguageFunctionObjectWrapper;
import com.crystaldecisions12.reports.formulas.FormulaLanguageMetadataContainer;
import com.crystaldecisions12.reports.formulas.FormulaLanguageObject;
import com.crystaldecisions12.reports.formulas.FormulaResources;
import com.crystaldecisions12.reports.formulas.FunctionManager;
import com.crystaldecisions12.reports.formulas.FunctionNode;
import com.crystaldecisions12.reports.formulas.MultiOperatorNode;
import com.crystaldecisions12.reports.formulas.NullFormulaContext;
import com.crystaldecisions12.reports.formulas.ParentNode;
import com.crystaldecisions12.reports.formulas.ValueNode;
import com.crystaldecisions12.reports.formulas.VariableNode;
import com.crystaldecisions12.reports.formulas.q;
import com.crystaldecisions12.reports.formulas.r;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class FormulaService {
    private FormulaClient if;
    private FunctionManager int;
    private Collator a;
    private ValueNode.a try = new ValueNode.a();
    private ArrayPool.a do = new ArrayPool.a();
    private ArrayPool.FormulaValues for = new ArrayPool.FormulaValues();
    private ArrayPool.b new = new ArrayPool.b();

    public static boolean isValidFormulaLanguageName(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 == 0 || !Character.isLetter(string.charAt(0)) && string.charAt(0) != '_') {
            return false;
        }
        if (string.equals("_")) {
            return false;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            char c10 = string.charAt(i2);
            if (Character.isLetter(c10) || Character.isDigit(c10) || c10 == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isReservedName(String string, FormulaInfo.Syntax syntax) {
        return q.a(string, syntax);
    }

    public boolean isDefinedFormulaLanguageName(String string) {
        String string2 = string.toLowerCase(r.W);
        return FormulaService.isReservedName(string2, null) || this.getFunctionManager().a(string2, FormulaInfo.Syntax.crystalSyntax) != null || this.getFunctionManager().a(string2, FormulaInfo.Syntax.basicSyntax) != null;
    }

    public FormulaService(FormulaClient formulaClient) {
        if (formulaClient == null) {
            throw new NullPointerException("A formula client interface must be given.");
        }
        this.if = formulaClient;
        this.int = new FunctionManager();
        this.a = Collator.getInstance();
    }

    public Comparator getStringComparator() {
        return this.getStringComparatorForMethod(this.if.getStringComparisonMethod());
    }

    public Comparator getStringComparatorForMethod(StringComparisonMethod stringComparisonMethod) {
        switch (stringComparisonMethod.value()) {
            case 1: {
                this.a.setStrength(1);
                break;
            }
            case 0: {
                this.a.setStrength(2);
                break;
            }
            default: {
                CrystalAssert.a(false);
                this.a.setStrength(1);
            }
        }
        return this.a;
    }

    public FormulaClient getClient() {
        return this.if;
    }

    public FunctionManager getFunctionManager() {
        return this.int;
    }

    public ExpressionNode parse(FormulaDefinitionBase formulaDefinitionBase) throws FormulaException {
        return this.parse(formulaDefinitionBase, true);
    }

    public ExpressionNode parse(FormulaDefinitionBase formulaDefinitionBase, boolean bl2) throws FormulaException {
        if (formulaDefinitionBase == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinitionBase.getFormulaInfo().a(bl2);
    }

    public ExpressionNode simplify(ExpressionNode expressionNode, FormulaDefinitionBase formulaDefinitionBase) throws FormulaException {
        if (formulaDefinitionBase == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinitionBase.getFormulaInfo().a(expressionNode, NullFormulaContext.instance);
    }

    public String toFormulaText(ExpressionNode expressionNode, FormulaInfo.Syntax syntax) throws FormulaException {
        if (expressionNode == null) {
            throw new NullPointerException("A parse tree must be given.");
        }
        if (syntax == null) {
            throw new NullPointerException("A syntax must be given.");
        }
        if (syntax != FormulaInfo.Syntax.crystalSyntax) {
            throw new UnsupportedOperationException("Only Crystal syntax is supported so far.");
        }
        try {
            return expressionNode.toFormulaText(syntax, 0);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new FormulaException(FormulaResources.a(), "StackOverflow", null);
        }
    }

    public void compile(FormulaDefinitionBase formulaDefinitionBase, FormulaContext formulaContext) throws FormulaException {
        if (formulaDefinitionBase == null) {
            throw new NullPointerException("A formula must be given.");
        }
        formulaDefinitionBase.getFormulaInfo().a(formulaContext);
    }

    public void convertFormula(FormulaDefinitionBase formulaDefinitionBase, FormulaInfo.Syntax syntax) throws FormulaException {
        FormulaInfo formulaInfo = formulaDefinitionBase.getFormulaInfo();
        if (formulaInfo.getSyntax() == syntax) {
            return;
        }
        ExpressionNode expressionNode = this.parse(formulaDefinitionBase);
        if (expressionNode != null) {
            try {
                if (formulaInfo.getSyntax() == FormulaInfo.Syntax.basicSyntax && expressionNode instanceof MultiOperatorNode) {
                    expressionNode = this.a((MultiOperatorNode)expressionNode);
                }
                formulaInfo.setText(this.toFormulaText(expressionNode, syntax), syntax);
            }
            catch (StackOverflowError stackOverflowError) {
                throw new FormulaException(FormulaResources.a(), "StackOverflow", formulaInfo);
            }
        } else {
            formulaDefinitionBase.getFormulaInfo().setText("", syntax);
        }
    }

    private ExpressionNode a(MultiOperatorNode multiOperatorNode) {
        if (multiOperatorNode == null) {
            return null;
        }
        a a10 = this.if(multiOperatorNode);
        if (a10.if()) {
            this.do(a10.a());
        }
        return a10.a();
    }

    private a if(ParentNode parentNode) {
        ExpressionNode expressionNode;
        a a10 = new a(parentNode);
        for (int i2 = 0; i2 < parentNode.size(); ++i2) {
            expressionNode = parentNode.get(i2);
            if (expressionNode == null || expressionNode.size() == 0) {
                a10.a(expressionNode);
                continue;
            }
            a10.a(this.if((ParentNode)expressionNode));
        }
        if (parentNode.getNodeType() == ExpressionNodeType.IfSequence) {
            ExpressionNode expressionNode2;
            ExpressionNode expressionNode3;
            int n2;
            FormulaValueType formulaValueType = null;
            expressionNode = a10.a();
            for (n2 = 0; n2 < parentNode.size(); ++n2) {
                expressionNode3 = ((ConditionalNode)((ParentNode)expressionNode).get(n2)).getStatement();
                if (!(expressionNode3 instanceof ParentNode) || expressionNode3.size() < 2) {
                    return a10;
                }
                expressionNode2 = ((ParentNode)expressionNode3).get(expressionNode3.size() - 1);
                if (expressionNode2 == null || expressionNode2.getNodeType() != ExpressionNodeType.Value || expressionNode2.getFormulaValueType() != FormulaValueType.bool) {
                    return a10;
                }
                ExpressionNode expressionNode4 = ((ParentNode)expressionNode3).get(expressionNode3.size() - 2);
                if (expressionNode4 == null || formulaValueType != null && formulaValueType != expressionNode4.getFormulaValueType()) {
                    return a10;
                }
                if (formulaValueType != null) continue;
                formulaValueType = expressionNode4.getFormulaValueType();
            }
            for (n2 = 0; n2 < a10.a().size(); ++n2) {
                expressionNode3 = (ConditionalNode)a10.a().get(n2);
                expressionNode2 = (ParentNode)((ConditionalNode)expressionNode3).getStatement();
                ((ParentNode)expressionNode2).remove(((ParentNode)expressionNode2).size() - 1);
                ((ParentNode)expressionNode2).for = formulaValueType;
                ((ConditionalNode)expressionNode3).for = formulaValueType;
            }
            a10.a().for = formulaValueType;
        }
        return a10;
    }

    private void do(ParentNode parentNode) {
        for (int i2 = 0; i2 < parentNode.size(); ++i2) {
            ExpressionNode expressionNode = parentNode.get(i2);
            if (expressionNode == null) continue;
            if (this.a(expressionNode)) {
                expressionNode = ((BinaryOperatorNode)expressionNode).getRightOperand();
                parentNode.set(i2, expressionNode);
            }
            if (expressionNode.size() == 0) {
                if (expressionNode.getNodeType() != ExpressionNodeType.VariableValue || !((VariableNode)expressionNode).case()) continue;
                parentNode.remove(i2);
                --i2;
                continue;
            }
            this.do((ParentNode)expressionNode);
        }
    }

    private boolean a(ExpressionNode expressionNode) {
        if (expressionNode == null) {
            return false;
        }
        if (expressionNode.getNodeType() != ExpressionNodeType.Assign) {
            return false;
        }
        ExpressionNode expressionNode2 = ((BinaryOperatorNode)expressionNode).getLeftOperand();
        return expressionNode2.getNodeType() == ExpressionNodeType.VariableReference && ((VariableNode)expressionNode2).case();
    }

    private boolean a(ParentNode parentNode) {
        for (int i2 = 0; i2 < parentNode.size(); ++i2) {
            ConditionalNode conditionalNode = (ConditionalNode)parentNode.get(i2);
            ExpressionNode expressionNode = conditionalNode.getStatement();
            if (!(expressionNode instanceof ParentNode)) {
                return false;
            }
            ExpressionNode expressionNode2 = ((ParentNode)expressionNode).get(expressionNode.size() - 1);
            if (expressionNode2 == null) {
                return false;
            }
            if (this.a(expressionNode2)) continue;
            if (expressionNode2.getNodeType() != ExpressionNodeType.IfSequence) {
                return false;
            }
            if (this.a((ParentNode)expressionNode2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuccessfullyCompiled(FormulaDefinitionBase formulaDefinitionBase, FormulaContext formulaContext) {
        if (formulaDefinitionBase.getFormulaInfo().hasValidCode()) {
            return true;
        }
        try {
            formulaDefinitionBase.compile(formulaContext);
            return true;
        }
        catch (FormulaException formulaException) {
            return false;
        }
    }

    public FieldExpression getFieldExpression(FormulaDefinition formulaDefinition, FormulaContext formulaContext, boolean bl2, FieldExpression.Options options) {
        if (formulaDefinition == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinition.getFormulaInfo().a(formulaContext, bl2, options);
    }

    public FormulaValue evaluate(FormulaDefinition formulaDefinition, FormulaContext formulaContext) throws FormulaException {
        if (formulaDefinition == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinition.getFormulaInfo().if(formulaContext);
    }

    public void publish(CustomFunctionDefinition customFunctionDefinition, String[] stringArray) {
        if (customFunctionDefinition == null) {
            throw new NullPointerException("A custom function must be given.");
        }
        customFunctionDefinition.getFormulaInfo().a(stringArray);
    }

    public void unpublish(CustomFunctionDefinition customFunctionDefinition) {
        if (customFunctionDefinition == null) {
            throw new NullPointerException("A custom function must be given.");
        }
        customFunctionDefinition.getFormulaInfo().for();
    }

    public FormulaLanguageObject[] getSyntaxes() {
        return FormulaLanguageMetadataContainer.try;
    }

    public FormulaLanguageObject[] getFormulaValueTypes() {
        return FormulaLanguageMetadataContainer.for;
    }

    public FormulaLanguageObject[] getFunctionTypes() {
        return FormulaLanguageMetadataContainer.if;
    }

    public FormulaLanguageObject[] getKeywords(FormulaInfo.Syntax syntax) {
        return q.a(syntax);
    }

    public FormulaLanguageFunctionObject[] getFunctions(FormulaLanguageFunctionFilter formulaLanguageFunctionFilter) {
        if (formulaLanguageFunctionFilter == null) {
            formulaLanguageFunctionFilter = new FormulaLanguageFunctionFilter();
        }
        ArrayList<FormulaLanguageFunctionObject> arrayList = new ArrayList<FormulaLanguageFunctionObject>();
        List list = this.int.getAllFunctionsForSyntax(formulaLanguageFunctionFilter.a);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormulaLanguageFunctionObject formulaLanguageFunctionObject = FormulaLanguageFunctionObjectWrapper.do((FormulaFunctionDefinition)list.get(i2));
            if (!this.a(formulaLanguageFunctionObject, formulaLanguageFunctionFilter)) continue;
            arrayList.add(formulaLanguageFunctionObject);
        }
        FormulaLanguageFunctionObject[] formulaLanguageFunctionObjectArray = new FormulaLanguageFunctionObject[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            formulaLanguageFunctionObjectArray[i3] = (FormulaLanguageFunctionObject)arrayList.get(i3);
        }
        return formulaLanguageFunctionObjectArray;
    }

    private boolean a(FormulaLanguageFunctionObject formulaLanguageFunctionObject, FormulaLanguageFunctionFilter formulaLanguageFunctionFilter) {
        int n2;
        FormulaInfo.Syntax[] syntaxArray;
        boolean bl2;
        if (formulaLanguageFunctionFilter.do != null && !StringUtil.equalsIgnoreCase(formulaLanguageFunctionFilter.do, formulaLanguageFunctionObject.getName(), r.W)) {
            return false;
        }
        if (formulaLanguageFunctionFilter.a != null) {
            bl2 = false;
            syntaxArray = formulaLanguageFunctionObject.getSyntaxes();
            for (n2 = 0; n2 < syntaxArray.length; ++n2) {
                if (formulaLanguageFunctionFilter.a != syntaxArray[n2]) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
        }
        if (formulaLanguageFunctionFilter.if != null) {
            bl2 = false;
            syntaxArray = formulaLanguageFunctionObject.getVisibleSyntaxes();
            for (n2 = 0; n2 < syntaxArray.length; ++n2) {
                if (formulaLanguageFunctionFilter.if != syntaxArray[n2]) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }

    public List getOperandsToBeRemoved(FormulaDefinitionBase formulaDefinitionBase, FormulaFunction formulaFunction) {
        ExpressionNode expressionNode = null;
        try {
            expressionNode = formulaDefinitionBase.getFormulaInfo().if();
            expressionNode = formulaDefinitionBase.getFormulaInfo().a(expressionNode);
        }
        catch (FormulaException formulaException) {
            CrystalAssert.a(false);
            return null;
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        this.a(expressionNode, formulaFunction, hashSet, hashSet2);
        ArrayList arrayList = new ArrayList();
        for (Object e10 : hashSet) {
            if (hashSet2.contains(e10)) continue;
            arrayList.add(e10);
        }
        return arrayList;
    }

    private void a(ExpressionNode expressionNode, FormulaFunction formulaFunction, Set set, Set set2) {
        block7: {
            block8: {
                block6: {
                    if (expressionNode == null) {
                        return;
                    }
                    if (!(expressionNode instanceof FieldNode)) break block6;
                    set2.add(((FieldNode)expressionNode).getField());
                    break block7;
                }
                if (!(expressionNode instanceof FunctionNode)) break block8;
                FunctionNode functionNode = (FunctionNode)expressionNode;
                if (functionNode.long == formulaFunction) {
                    for (int i2 = 0; i2 < functionNode.size(); ++i2) {
                        ExpressionNode expressionNode2 = functionNode.get(i2);
                        if (!(expressionNode2 instanceof FieldNode)) continue;
                        set.add(((FieldNode)expressionNode2).getField());
                    }
                } else {
                    for (int i3 = 0; i3 < functionNode.size(); ++i3) {
                        this.a(functionNode.get(i3), formulaFunction, set, set2);
                    }
                }
                break block7;
            }
            if (!(expressionNode instanceof ParentNode)) break block7;
            ParentNode parentNode = (ParentNode)expressionNode;
            for (int i4 = 0; i4 < parentNode.size(); ++i4) {
                this.a(parentNode.get(i4), formulaFunction, set, set2);
            }
        }
    }

    ValueNode.a if() {
        return this.try;
    }

    ArrayPool.a do() {
        return this.do;
    }

    public ArrayPool.FormulaValues getFormulaValueArrayPool() {
        return this.for;
    }

    ArrayPool.b a() {
        return this.new;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class a {
        private int do = 0;
        private ParentNode if;

        public a(ParentNode parentNode) {
            this.if = parentNode != null ? parentNode.if() : null;
        }

        public ParentNode a() {
            return this.if;
        }

        public boolean if() {
            if (this.do != 2) {
                return false;
            }
            ExpressionNode expressionNode = this.if.get(this.if.size() - 2);
            return FormulaService.this.a(expressionNode) || expressionNode.getNodeType() == ExpressionNodeType.IfSequence && FormulaService.this.a((ParentNode)expressionNode);
        }

        public void a(a a10) {
            this.if.add(a10.if);
            this.do += a10.do;
        }

        public void a(ExpressionNode expressionNode) {
            if (expressionNode != null && expressionNode.getNodeType() == ExpressionNodeType.VariableValue && ((VariableNode)expressionNode).case()) {
                ++this.do;
            }
            this.if.add(expressionNode);
        }
    }
}

