/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.value.ArrayValue;
import com.crystaldecisions12.reports.common.value.BooleanValue;
import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.CurrencyValue;
import com.crystaldecisions12.reports.common.value.FormulaValueType;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.RangeValue;
import com.crystaldecisions12.reports.common.value.StringValue;
import java.util.HashMap;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class FormulaValue
extends CrystalValue {
    private FormulaValueType for = null;
    private static Map do = new HashMap();
    private static final FormulaValue[] if = new FormulaValue[0];

    public final FormulaValueType getFormulaValueType() {
        if (this.for == null) {
            this.for = FormulaValueType.fromValueType(this.getValueType());
        }
        return this.for;
    }

    public static FormulaValue coerceToNumber(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToNumber();
    }

    public FormulaValue coerceToNumber() {
        return null;
    }

    public static FormulaValue coerceToCurrency(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToCurrency();
    }

    public FormulaValue coerceToCurrency() {
        return null;
    }

    public static FormulaValue coerceToBoolean(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToBoolean();
    }

    public FormulaValue coerceToBoolean() {
        return null;
    }

    public static FormulaValue coerceToDate(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToDate();
    }

    public FormulaValue coerceToDate() {
        return null;
    }

    public static FormulaValue coerceToTime(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToTime();
    }

    public FormulaValue coerceToTime() {
        return null;
    }

    public static FormulaValue coerceToDateTime(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToDateTime();
    }

    public FormulaValue coerceToDateTime() {
        return null;
    }

    public static FormulaValue coerceToString(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToString();
    }

    public FormulaValue coerceToString() {
        return null;
    }

    public static FormulaValue coerceToRange(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToRange();
    }

    public FormulaValue coerceToRange() {
        try {
            return RangeValue.fromSingleValue(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static FormulaValue coerceToArray(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToArray();
    }

    public FormulaValue coerceToArray() {
        return ArrayValue.fromSingleValue(this);
    }

    public static FormulaValue coerceToRangeArray(FormulaValue formulaValue) {
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToRangeArray();
    }

    public FormulaValue coerceToRangeArray() {
        FormulaValue formulaValue = this.coerceToRange();
        if (formulaValue == null) {
            return null;
        }
        return formulaValue.coerceToArray();
    }

    public static FormulaValue coerce(FormulaValue formulaValue, FormulaValueType formulaValueType) {
        if (formulaValue == null) {
            return null;
        }
        if (formulaValue.getFormulaValueType() == formulaValueType) {
            return formulaValue;
        }
        switch (formulaValueType.getBaseFormulaValueType().value()) {
            case 6: {
                formulaValue = formulaValue.coerceToNumber();
                break;
            }
            case 7: {
                formulaValue = formulaValue.coerceToCurrency();
                break;
            }
            case 8: {
                formulaValue = formulaValue.coerceToBoolean();
                break;
            }
            case 9: {
                formulaValue = formulaValue.coerceToDate();
                break;
            }
            case 10: {
                formulaValue = formulaValue.coerceToTime();
                break;
            }
            case 15: {
                formulaValue = formulaValue.coerceToDateTime();
                break;
            }
            case 11: {
                formulaValue = formulaValue.coerceToString();
                break;
            }
            default: {
                CrystalAssert.a(false);
                return null;
            }
        }
        if (formulaValue == null) {
            return null;
        }
        if (formulaValueType.isRange() && (formulaValue = formulaValue.coerceToRange()) == null) {
            return null;
        }
        if (formulaValueType.isArray() && (formulaValue = formulaValue.coerceToArray()) == null) {
            return null;
        }
        if (formulaValue.getFormulaValueType() == formulaValueType) {
            return formulaValue;
        }
        return null;
    }

    public static FormulaValue makeZeroValue(FormulaValueType formulaValueType) {
        FormulaValue formulaValue;
        if (do.containsKey(formulaValueType)) {
            return (FormulaValue)do.get(formulaValueType);
        }
        if (formulaValueType.isArray()) {
            formulaValue = ArrayValue.fromArray(if, formulaValueType.getNonArrayFormulaValueType());
        } else {
            switch (formulaValueType.getBaseFormulaValueType().value()) {
                case 6: {
                    formulaValue = NumberValue.zero;
                    break;
                }
                case 7: {
                    formulaValue = CurrencyValue.zero;
                    break;
                }
                case 8: {
                    formulaValue = BooleanValue.FALSE;
                    break;
                }
                case 9: 
                case 10: 
                case 15: {
                    formulaValue = null;
                    break;
                }
                case 11: {
                    formulaValue = StringValue.empty;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
            if (formulaValueType.isRange()) {
                formulaValue = FormulaValue.coerceToRange(formulaValue);
            }
        }
        do.put(formulaValueType, formulaValue);
        return formulaValue;
    }
}

