/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.NumberUtil;
import com.crystaldecisions12.reports.common.StringUtil;
import com.crystaldecisions12.reports.common.value.BooleanValue;
import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.FormatterCache;
import com.crystaldecisions12.reports.common.value.FormulaValue;
import com.crystaldecisions12.reports.common.value.NumberValue;
import com.crystaldecisions12.reports.common.value.NumericValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CurrencyValue
extends NumericValue {
    public static final CurrencyValue zero = new CurrencyValue(0.0, true);
    public static final CurrencyValue one = new CurrencyValue(100.0, true);
    public static final CurrencyValue two = new CurrencyValue(200.0, true);
    public static final CurrencyValue ten = new CurrencyValue(1000.0, true);

    private CurrencyValue(double d10, boolean bl2) {
        super(d10, bl2);
    }

    static CurrencyValue if(double d10, boolean bl2) {
        if (d10 == zero.getScaledDouble()) {
            return zero;
        }
        if (d10 == one.getScaledDouble()) {
            return one;
        }
        if (d10 == two.getScaledDouble()) {
            return two;
        }
        if (d10 == ten.getScaledDouble()) {
            return ten;
        }
        return new CurrencyValue(d10, bl2);
    }

    public static CurrencyValue fromScaledDouble(double d10) {
        return CurrencyValue.if(d10, false);
    }

    public static CurrencyValue fromScaledLong(long l2) {
        return CurrencyValue.if(l2, NumberUtil.a(l2));
    }

    public static CurrencyValue fromDouble(double d10) {
        return CurrencyValue.fromScaledDouble(d10 * 100.0);
    }

    public static CurrencyValue fromLong(long l2) {
        return CurrencyValue.if((double)l2 * 100.0, NumberUtil.if(l2));
    }

    public static CurrencyValue fromNumberValue(NumberValue numberValue) {
        return CurrencyValue.if(numberValue.getScaledDouble(), numberValue.f);
    }

    public FormulaValue coerceToNumber() {
        return NumberValue.fromCurrencyValue(this);
    }

    public FormulaValue coerceToCurrency() {
        return this;
    }

    public FormulaValue coerceToBoolean() {
        return this.getScaledDouble() == 0.0 ? BooleanValue.FALSE : BooleanValue.TRUE;
    }

    public ValueType getValueType() {
        return ValueType.case;
    }

    public String toString() {
        return "c" + super.toString();
    }

    public static CrystalValue fromFormattedString(Locale locale, String string) throws ParseException {
        if (string == null) {
            return null;
        }
        String string2 = string;
        string2 = string2.trim();
        DecimalFormat decimalFormat = FormatterCache.do(locale);
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        String string3 = decimalFormatSymbols.getCurrencySymbol();
        String string4 = StringUtil.removeNegativeSymbol(string2 = StringUtil.removeCurrencySymbol(string2, string3));
        boolean bl2 = string4.compareTo(string2) != 0;
        NumberFormat numberFormat = FormatterCache.new(locale);
        Number number = numberFormat.parse(string4);
        double d10 = number.doubleValue();
        if (bl2) {
            d10 = -d10;
        }
        return CurrencyValue.fromDouble(d10);
    }
}

