/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.value;

import com.crystaldecisions12.reports.common.value.CrystalValue;
import com.crystaldecisions12.reports.common.value.ValueType;
import java.awt.Color;
import java.util.Comparator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ColourValue
extends CrystalValue
implements Comparable {
    public static final int noGDIColour = -1;
    public static final int gdiBlack = 0;
    public static final int gdiMaroon = 128;
    public static final int gdiGreen = 32768;
    public static final int gdiOlive = 32896;
    public static final int gdiNavy = 0x800000;
    public static final int gdiPurple = 0x800080;
    public static final int gdiTeal = 0x808000;
    public static final int gdiGray = 0x808080;
    public static final int gdiSilver = 0xC0C0C0;
    public static final int gdiRed = 255;
    public static final int gdiLime = 65280;
    public static final int gdiYellow = 65535;
    public static final int gdiBlue = 0xFF0000;
    public static final int gdiFuchsia = 0xFF00FF;
    public static final int gdiAqua = 0xFFFF00;
    public static final int gdiWhite = 0xFFFFFF;
    public static final ColourValue noColour = null;
    public static final int rgbBlack = 0;
    public static final int rgbMaroon = 0x800000;
    public static final int rgbGreen = 32768;
    public static final int rgbOlive = 0x808000;
    public static final int rgbNavy = 128;
    public static final int rgbPurple = 0x800080;
    public static final int rgbTeal = 32896;
    public static final int rgbGray = 0x808080;
    public static final int rgbSilver = 0xC0C0C0;
    public static final int rgbRed = 0xFF0000;
    public static final int rgbLime = 65280;
    public static final int rgbYellow = 0xFFFF00;
    public static final int rgbBlue = 255;
    public static final int rgbFuchsia = 0xFF00FF;
    public static final int rgbAqua = 65535;
    public static final int rgbWhite = 0xFFFFFF;
    public static final ColourValue black = new ColourValue(new Color(0));
    public static final ColourValue maroon = new ColourValue(new Color(0x800000));
    public static final ColourValue green = new ColourValue(new Color(32768));
    public static final ColourValue olive = new ColourValue(new Color(0x808000));
    public static final ColourValue navy = new ColourValue(new Color(128));
    public static final ColourValue purple = new ColourValue(new Color(0x800080));
    public static final ColourValue teal = new ColourValue(new Color(32896));
    public static final ColourValue gray = new ColourValue(new Color(0x808080));
    public static final ColourValue silver = new ColourValue(new Color(0xC0C0C0));
    public static final ColourValue red = new ColourValue(new Color(0xFF0000));
    public static final ColourValue lime = new ColourValue(new Color(65280));
    public static final ColourValue yellow = new ColourValue(new Color(0xFFFF00));
    public static final ColourValue blue = new ColourValue(new Color(255));
    public static final ColourValue fuchsia = new ColourValue(new Color(0xFF00FF));
    public static final ColourValue aqua = new ColourValue(new Color(65535));
    public static final ColourValue white = new ColourValue(new Color(0xFFFFFF));
    private final Color B;

    private ColourValue(Color color) {
        if (color == null) {
            throw new NullPointerException("The colour value cannot be null.");
        }
        this.B = color;
    }

    public static ColourValue fromColor(Color color) {
        if (color == null) {
            return null;
        }
        ColourValue colourValue = ColourValue.do(color.getRGB());
        if (colourValue != null) {
            return colourValue;
        }
        return new ColourValue(color);
    }

    public static ColourValue fromRGB(int n2, int n3, int n4) {
        return ColourValue.fromRGB(((n2 & 0xFF) << 16) + ((n3 & 0xFF) << 8) + (n4 & 0xFF));
    }

    public static ColourValue fromRGB(int n2) {
        ColourValue colourValue = ColourValue.do(n2);
        if (colourValue != null) {
            return colourValue;
        }
        return new ColourValue(new Color(n2));
    }

    public static ColourValue fromColorRef(int n2) {
        if (n2 == -1) {
            return null;
        }
        return ColourValue.fromRGB(ColourValue.getRGBFromColorRef(n2));
    }

    public Color getColor() {
        return this.B;
    }

    public static Color getColor(ColourValue colourValue) {
        if (colourValue == null) {
            return null;
        }
        return colourValue.B;
    }

    public int getRGB() {
        return this.B.getRGB() & 0xFFFFFF;
    }

    public int getRed() {
        return this.B.getRed();
    }

    public int getGreen() {
        return this.B.getGreen();
    }

    public int getBlue() {
        return this.B.getBlue();
    }

    public int getColorRef() {
        return ColourValue.getColorRefFromColor(this.B);
    }

    public static int getColorRef(ColourValue colourValue) {
        if (colourValue == null) {
            return -1;
        }
        return ColourValue.getColorRefFromColor(colourValue.B);
    }

    public static Color getColorFromRGB(int n2, int n3, int n4) {
        return ColourValue.getColorFromRGB(((n2 & 0xFF) << 16) + ((n3 & 0xFF) << 8) + (n4 & 0xFF));
    }

    public static Color getColorFromRGB(int n2) {
        ColourValue colourValue = ColourValue.do(n2);
        if (colourValue != null) {
            return colourValue.B;
        }
        return new Color(n2);
    }

    private static ColourValue do(int n2) {
        switch (n2 & 0xFFFFFF) {
            case 0: {
                return black;
            }
            case 0x800000: {
                return maroon;
            }
            case 32768: {
                return green;
            }
            case 0x808000: {
                return olive;
            }
            case 128: {
                return navy;
            }
            case 0x800080: {
                return purple;
            }
            case 32896: {
                return teal;
            }
            case 0x808080: {
                return gray;
            }
            case 0xC0C0C0: {
                return silver;
            }
            case 0xFF0000: {
                return red;
            }
            case 65280: {
                return lime;
            }
            case 0xFFFF00: {
                return yellow;
            }
            case 255: {
                return blue;
            }
            case 0xFF00FF: {
                return fuchsia;
            }
            case 65535: {
                return aqua;
            }
            case 0xFFFFFF: {
                return white;
            }
        }
        return null;
    }

    public static Color getColorFromColorRef(int n2) {
        if (n2 == -1) {
            return null;
        }
        return ColourValue.getColorFromRGB(ColourValue.getRGBFromColorRef(n2));
    }

    public static int getRGBFromColorRef(int n2) {
        if (n2 == -1) {
            throw new IllegalArgumentException("The COLORREF cannot be 'noGDIColour'.");
        }
        int n3 = (n2 & 0xFF) << 16 | n2 & 0xFF00 | (n2 & 0xFF0000) >> 16;
        return n3;
    }

    public static int getColorRefFromColor(Color color) {
        if (color == null) {
            return -1;
        }
        return ColourValue.getColorRefFromRGB(color.getRGB());
    }

    public static int getColorRefFromRGB(int n2, int n3, int n4) {
        return (n2 & 0xFF) + ((n3 & 0xFF) << 8) + ((n4 & 0xFF) << 16);
    }

    public static int getColorRefFromRGB(int n2) {
        return ColourValue.getColorRefFromRGB((n2 & 0xFF0000) >> 16, (n2 & 0xFF00) >> 8, n2 & 0xFF);
    }

    public ValueType getValueType() {
        return ValueType.Y;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.B.equals(((ColourValue)object).B);
    }

    public int compareTo(Object object) {
        return ColourValue.a(this.B.getRGB(), ((ColourValue)object).B.getRGB());
    }

    public int compareTo(Object object, Comparator comparator) {
        return this.compareTo(object);
    }

    public int hashCode() {
        return this.B.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("c(");
        switch (this.B.getRGB() & 0xFFFFFF) {
            case 0: {
                stringBuilder.append("black");
                break;
            }
            case 0x800000: {
                stringBuilder.append("maroon");
                break;
            }
            case 32768: {
                stringBuilder.append("green");
                break;
            }
            case 0x808000: {
                stringBuilder.append("olive");
                break;
            }
            case 128: {
                stringBuilder.append("navy");
                break;
            }
            case 0x800080: {
                stringBuilder.append("purple");
                break;
            }
            case 32896: {
                stringBuilder.append("teal");
                break;
            }
            case 0x808080: {
                stringBuilder.append("gray");
                break;
            }
            case 0xC0C0C0: {
                stringBuilder.append("silver");
                break;
            }
            case 0xFF0000: {
                stringBuilder.append("red");
                break;
            }
            case 65280: {
                stringBuilder.append("lime");
                break;
            }
            case 0xFFFF00: {
                stringBuilder.append("yellow");
                break;
            }
            case 255: {
                stringBuilder.append("blue");
                break;
            }
            case 0xFF00FF: {
                stringBuilder.append("fuchsia");
                break;
            }
            case 65535: {
                stringBuilder.append("aqua");
                break;
            }
            case 0xFFFFFF: {
                stringBuilder.append("white");
                break;
            }
            default: {
                stringBuilder.append(this.B);
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

