/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.lib;

import com.crystaldecisions.sdk.occa.report.lib.ClonableMap;
import com.crystaldecisions.sdk.occa.report.lib.ControllableMixin;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.IControllable;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllableMap<K, V>
extends ClonableMap<K, V>
implements IControllable {
    private final ControllableMixin m_controllableMixin = new ControllableMixin(this);

    public ControllableMap(Map<? extends K, ? extends V> m2) {
        super(m2);
    }

    public ControllableMap() {
    }

    @Override
    public void doControllerModification(Object newObject) throws ReportSDKException {
        assert (this.isDirectlyControllable());
    }

    @Override
    public void enumerateMembers(IMemberVisitor visitor) {
        for (Object key : super.keySet()) {
            Object value = super.get(key);
            if (!(value instanceof IClone)) continue;
            super.put(key, visitor.visit((IClone)value, true));
        }
    }

    @Override
    public ControllableMixin getControllableMixin() {
        return this.m_controllableMixin;
    }

    @Override
    public boolean isDirectlyControllable() {
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetWrapper(super.entrySet());
    }

    @Override
    public Set<K> keySet() {
        return new SetWrapper(super.keySet());
    }

    @Override
    public Collection<V> values() {
        return new CollectionWrapper(super.values());
    }

    @Override
    public void clear() {
        this.m_controllableMixin.makeChange(new IChange(){

            public void run() {
                ControllableMap.super.clear();
            }
        });
    }

    @Override
    public V put(final K key, final V value) {
        Object oldValue = this.get(key);
        this.m_controllableMixin.makeChange(new IChange(){

            public void run() {
                ControllableMap.super.put(key, value);
            }
        });
        return oldValue;
    }

    @Override
    public void putAll(final Map<? extends K, ? extends V> t2) {
        this.m_controllableMixin.makeChange(new IChange(){

            public void run() {
                ControllableMap.super.putAll(t2);
            }
        });
    }

    @Override
    public V remove(final Object key) {
        Object oldValue = this.get(key);
        this.m_controllableMixin.makeChange(new IChange(){

            public void run() {
                ControllableMap.super.remove(key);
            }
        });
        return oldValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionWrapper<W>
    extends AbstractSet<W> {
        private final Collection<W> m_baseCollection;

        CollectionWrapper(Collection<W> baseSet) {
            this.m_baseCollection = baseSet;
        }

        @Override
        public Iterator<W> iterator() {
            return new IteratorWrapper<W>(this.m_baseCollection.iterator());
        }

        @Override
        public int size() {
            return this.m_baseCollection.size();
        }

        @Override
        public boolean add(final W o2) {
            boolean changed = this.m_baseCollection.contains(o2);
            ControllableMap.this.m_controllableMixin.makeChange(new IChange(){

                public void run() {
                    CollectionWrapper.this.m_baseCollection.add(o2);
                }
            });
            return changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetWrapper<W>
    extends AbstractSet<W> {
        private final Set<W> m_baseSet;

        SetWrapper(Set<W> baseSet) {
            this.m_baseSet = baseSet;
        }

        @Override
        public Iterator<W> iterator() {
            return new IteratorWrapper<W>(this.m_baseSet.iterator());
        }

        @Override
        public int size() {
            return this.m_baseSet.size();
        }

        @Override
        public boolean add(final W o2) {
            boolean changed = this.m_baseSet.contains(o2);
            ControllableMap.this.m_controllableMixin.makeChange(new IChange(){

                public void run() {
                    SetWrapper.this.m_baseSet.add(o2);
                }
            });
            return changed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorWrapper<W>
    implements Iterator<W> {
        private final Iterator<W> m_baseIterator;

        IteratorWrapper(Iterator<W> baseIterator) {
            this.m_baseIterator = baseIterator;
        }

        @Override
        public boolean hasNext() {
            return this.m_baseIterator.hasNext();
        }

        @Override
        public W next() {
            return this.m_baseIterator.next();
        }

        @Override
        public void remove() {
            ControllableMap.this.m_controllableMixin.makeChange(new IChange(){

                public void run() {
                    IteratorWrapper.this.m_baseIterator.remove();
                }
            });
        }
    }
}

