/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas.functions.array;

import com.crystaldecisions.reports.common.value.ArrayValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.formulas.ArrayPool;
import com.crystaldecisions.reports.formulas.FormulaEnvironment;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentDefinition;
import com.crystaldecisions.reports.formulas.FormulaFunctionArgumentException;
import com.crystaldecisions.reports.formulas.FormulaFunctionBase;
import com.crystaldecisions.reports.formulas.FormulaFunctionCallException;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaInfo;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FormulaValueReference;
import com.crystaldecisions.reports.formulas.FormulaValueUtil;
import com.crystaldecisions.reports.formulas.functions.CommonArguments;
import com.crystaldecisions.reports.formulas.functions.FormulaFunctionFactory;

class a
implements FormulaFunctionFactory {
    private static final FormulaFunctionFactory cL = new a();
    public static final FormulaFunctionDefinition cM = new a("MakeArray", "makearray");
    public static final FormulaFunctionDefinition cN = new a("Array", "array", FormulaInfo.Syntax.basicSyntax);

    private a() {
    }

    public static FormulaFunctionFactory R() {
        return cL;
    }

    public int getNFunctionInstances() {
        return 2;
    }

    public FormulaFunctionDefinition getFunctionInstance(int n2) {
        switch (n2) {
            case 0: {
                return cM;
            }
            case 1: {
                return cN;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private static class a
    extends FormulaFunctionBase {
        private static final FormulaFunctionArgumentDefinition[] N = new FormulaFunctionArgumentDefinition[]{CommonArguments.remainingValues};

        public a(String string, String string2) {
            super(string, string2, N);
        }

        public a(String string, String string2, FormulaInfo.Syntax syntax) {
            super(string, string2, N, false, syntax, true);
        }

        public boolean allowNullArguments() {
            return true;
        }

        public FormulaValueType validate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            if (formulaValueReferenceArray.length < 1) {
                throw new FormulaFunctionCallException("JRC00002270", "", FormulaResources.a(), "NotEnoughArguments");
            }
            FormulaValueType formulaValueType = formulaValueReferenceArray[0].getFormulaValueType();
            for (int i2 = 1; i2 < formulaValueReferenceArray.length; ++i2) {
                FormulaValueType formulaValueType2 = formulaValueReferenceArray[i2].getFormulaValueType();
                if (formulaValueType2.isArray()) {
                    throw new FormulaFunctionArgumentException("JRC00002271", "", FormulaResources.a(), "NoArraysInArrays", i2);
                }
                if ((formulaValueType = FormulaValueUtil.a(formulaValueType, formulaValueType2)) != null) continue;
                throw new FormulaFunctionArgumentException("JRC00002272", "", FormulaResources.a(), "IncompatibleMakeArrayTypes", i2);
            }
            return formulaValueType.getArrayFormulaValueType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormulaValue evaluate(FormulaValueReference[] formulaValueReferenceArray, FormulaEnvironment formulaEnvironment) throws FormulaFunctionCallException {
            FormulaValueType formulaValueType = this.validate(formulaValueReferenceArray, formulaEnvironment).getNonArrayFormulaValueType();
            FormulaValue[] formulaValueArray = ArrayPool.do(formulaValueReferenceArray.length, formulaEnvironment);
            try {
                for (int i2 = 0; i2 < formulaValueReferenceArray.length; ++i2) {
                    FormulaValue formulaValue = formulaValueReferenceArray[i2].getFormulaValue();
                    formulaValueArray[i2] = FormulaValue.coerce((FormulaValue)formulaValue, (FormulaValueType)formulaValueType);
                }
                ArrayValue arrayValue = ArrayValue.fromArray((FormulaValue[])formulaValueArray);
                return arrayValue;
            }
            finally {
                ArrayPool.a(formulaValueArray, formulaEnvironment);
            }
        }
    }
}

