/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.formulas;

import com.crystaldecisions.reports.common.StringUtil;
import com.crystaldecisions.reports.common.asserts.CrystalAssert;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.FormulaValue;
import com.crystaldecisions.reports.common.value.FormulaValueType;
import com.crystaldecisions.reports.formulas.ArrayPool;
import com.crystaldecisions.reports.formulas.BinaryOperatorNode;
import com.crystaldecisions.reports.formulas.ConditionalNode;
import com.crystaldecisions.reports.formulas.CustomFunctionDefinition;
import com.crystaldecisions.reports.formulas.ExpressionNode;
import com.crystaldecisions.reports.formulas.ExpressionNodeType;
import com.crystaldecisions.reports.formulas.FieldExpression;
import com.crystaldecisions.reports.formulas.FieldNode;
import com.crystaldecisions.reports.formulas.FormulaClient;
import com.crystaldecisions.reports.formulas.FormulaContext;
import com.crystaldecisions.reports.formulas.FormulaDefinition;
import com.crystaldecisions.reports.formulas.FormulaDefinitionBase;
import com.crystaldecisions.reports.formulas.FormulaException;
import com.crystaldecisions.reports.formulas.FormulaFunction;
import com.crystaldecisions.reports.formulas.FormulaFunctionDefinition;
import com.crystaldecisions.reports.formulas.FormulaInfo;
import com.crystaldecisions.reports.formulas.FormulaLanguageFunctionFilter;
import com.crystaldecisions.reports.formulas.FormulaLanguageFunctionObject;
import com.crystaldecisions.reports.formulas.FormulaLanguageFunctionObjectWrapper;
import com.crystaldecisions.reports.formulas.FormulaLanguageMetadataContainer;
import com.crystaldecisions.reports.formulas.FormulaLanguageObject;
import com.crystaldecisions.reports.formulas.FormulaParser;
import com.crystaldecisions.reports.formulas.FormulaResources;
import com.crystaldecisions.reports.formulas.FunctionManager;
import com.crystaldecisions.reports.formulas.FunctionNode;
import com.crystaldecisions.reports.formulas.MultiOperatorNode;
import com.crystaldecisions.reports.formulas.NullFormulaContext;
import com.crystaldecisions.reports.formulas.NullVerifierContext;
import com.crystaldecisions.reports.formulas.OperandField;
import com.crystaldecisions.reports.formulas.ParentNode;
import com.crystaldecisions.reports.formulas.ValueNode;
import com.crystaldecisions.reports.formulas.VariableNode;
import com.crystaldecisions.reports.formulas.o;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormulaService {
    private final FormulaClient a;
    private final FunctionManager for;
    private final ValueNode.a new = new ValueNode.a();
    private final ArrayPool.a if = new ArrayPool.a();
    private final ArrayPool.FormulaValues do = new ArrayPool.FormulaValues();
    private final ArrayPool.b int = new ArrayPool.b();

    public static List<FormulaDefinitionBase> makeFormulaListInEvaluationOrder(Collection<? extends FormulaDefinitionBase> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<FormulaDefinitionBase> arrayList = new ArrayList<FormulaDefinitionBase>();
        LinkedHashSet<FormulaDefinitionBase> linkedHashSet = new LinkedHashSet<FormulaDefinitionBase>(collection);
        while (linkedHashSet.size() > 0) {
            FormulaService.a((FormulaDefinitionBase)linkedHashSet.iterator().next(), linkedHashSet, arrayList);
        }
        return arrayList;
    }

    private static void a(FormulaDefinitionBase formulaDefinitionBase, Set<FormulaDefinitionBase> set, List<FormulaDefinitionBase> list) {
        if (!set.remove(formulaDefinitionBase)) {
            return;
        }
        for (OperandField operandField : formulaDefinitionBase.getFormulaInfo().getOperandFields()) {
            if (!(operandField instanceof FormulaDefinitionBase)) continue;
            FormulaService.a((FormulaDefinitionBase)operandField, set, list);
        }
        list.add(formulaDefinitionBase);
    }

    public static boolean isValidFormulaLanguageName(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        if (n2 == 0 || !Character.isLetter(string.charAt(0)) && string.charAt(0) != '_') {
            return false;
        }
        if (string.equals("_")) {
            return false;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            char c10 = string.charAt(i2);
            if (Character.isLetter(c10) || Character.isDigit(c10) || c10 == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isReservedName(String string, FormulaInfo.Syntax syntax) {
        return o.a(string, syntax);
    }

    public boolean isDefinedFormulaLanguageName(String string) {
        String string2 = string.toLowerCase(FormulaParser.H);
        return FormulaService.isReservedName(string2, null) || this.getFunctionManager().a(string2, FormulaInfo.Syntax.crystalSyntax) != null || this.getFunctionManager().a(string2, FormulaInfo.Syntax.basicSyntax) != null;
    }

    public FormulaService(FormulaClient formulaClient, FunctionManager functionManager) {
        if (formulaClient == null) {
            throw new NullPointerException("A formula client interface must be given.");
        }
        this.a = formulaClient;
        this.for = functionManager == null ? new FunctionManager() : functionManager;
    }

    public FormulaService(FormulaClient formulaClient) {
        this(formulaClient, null);
    }

    public FormulaClient getClient() {
        return this.a;
    }

    public FunctionManager getFunctionManager() {
        return this.for;
    }

    public ExpressionNode parse(FormulaDefinitionBase formulaDefinitionBase) throws FormulaException {
        return this.parse(formulaDefinitionBase, true);
    }

    public ExpressionNode parse(FormulaDefinitionBase formulaDefinitionBase, boolean bl2) throws FormulaException {
        if (formulaDefinitionBase == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinitionBase.getFormulaInfo().a(bl2);
    }

    public FormulaValue simplifyToValue(ExpressionNode expressionNode, FormulaContext formulaContext) throws FormulaException {
        b b10 = new b(this);
        return b10.getFormulaInfo().a(expressionNode, formulaContext, null, null);
    }

    public FormulaValue simplifyToValue(ExpressionNode expressionNode) throws FormulaException {
        return this.simplifyToValue(expressionNode, NullFormulaContext.instance);
    }

    public ExpressionNode simplify(ExpressionNode expressionNode, FormulaDefinitionBase formulaDefinitionBase) throws FormulaException {
        if (formulaDefinitionBase == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinitionBase.getFormulaInfo().a(expressionNode, NullFormulaContext.instance);
    }

    public String toFormulaText(ExpressionNode expressionNode, FormulaInfo.Syntax syntax) throws FormulaException {
        if (expressionNode == null) {
            throw new NullPointerException("A parse tree must be given.");
        }
        if (syntax == null) {
            throw new NullPointerException("A syntax must be given.");
        }
        if (syntax != FormulaInfo.Syntax.crystalSyntax) {
            throw new UnsupportedOperationException("Only Crystal syntax is supported so far.");
        }
        try {
            return expressionNode.toFormulaText(syntax, 0);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new FormulaException("JRC00000435", "", FormulaResources.a(), "StackOverflow", null);
        }
    }

    public void compile(FormulaDefinitionBase formulaDefinitionBase, FormulaContext formulaContext) throws FormulaException {
        if (formulaDefinitionBase == null) {
            throw new NullPointerException("A formula must be given.");
        }
        formulaDefinitionBase.getFormulaInfo().a(formulaContext);
    }

    public void convertFormula(FormulaDefinitionBase formulaDefinitionBase, FormulaInfo.Syntax syntax) throws FormulaException {
        FormulaInfo formulaInfo = formulaDefinitionBase.getFormulaInfo();
        if (formulaInfo.getSyntax() == syntax) {
            return;
        }
        ExpressionNode expressionNode = this.parse(formulaDefinitionBase);
        if (expressionNode != null) {
            try {
                if (formulaInfo.getSyntax() == FormulaInfo.Syntax.basicSyntax && expressionNode instanceof MultiOperatorNode) {
                    expressionNode = this.a((MultiOperatorNode)expressionNode);
                }
                formulaInfo.setText(this.toFormulaText(expressionNode, syntax), syntax);
            }
            catch (StackOverflowError stackOverflowError) {
                throw new FormulaException("JRC00000436", "", FormulaResources.a(), "StackOverflow", formulaInfo);
            }
        } else {
            formulaDefinitionBase.getFormulaInfo().setText("", syntax);
        }
    }

    public static boolean isNull(CrystalValue crystalValue, OperandField operandField, FormulaContext formulaContext, FormulaFunctionDefinition formulaFunctionDefinition) throws OperandField.NullNotAllowedException {
        if (crystalValue != null) {
            return false;
        }
        if (operandField == null) {
            return true;
        }
        if (operandField instanceof OperandField.VerifyNullOperandField) {
            return ((OperandField.VerifyNullOperandField)operandField).a(formulaFunctionDefinition);
        }
        return !(formulaContext instanceof NullVerifierContext) || !((NullVerifierContext)formulaContext).treatNullAsNonNull(operandField);
    }

    private ExpressionNode a(MultiOperatorNode multiOperatorNode) {
        if (multiOperatorNode == null) {
            return null;
        }
        a a10 = this.do(multiOperatorNode);
        if (a10.if()) {
            this.if(a10.a());
        }
        return a10.a();
    }

    private a do(ParentNode parentNode) {
        ExpressionNode expressionNode;
        a a10 = new a(parentNode);
        for (int i2 = 0; i2 < parentNode.size(); ++i2) {
            expressionNode = parentNode.get(i2);
            if (expressionNode == null || expressionNode.size() == 0) {
                a10.a(expressionNode);
                continue;
            }
            a10.if(this.do((ParentNode)expressionNode));
        }
        if (parentNode.getNodeType() == ExpressionNodeType.IfSequence) {
            ExpressionNode expressionNode2;
            ExpressionNode expressionNode3;
            int n2;
            FormulaValueType formulaValueType = null;
            expressionNode = a10.a();
            for (n2 = 0; n2 < parentNode.size(); ++n2) {
                expressionNode3 = ((ConditionalNode)((ParentNode)expressionNode).get(n2)).getStatement();
                if (!(expressionNode3 instanceof ParentNode) || expressionNode3.size() < 2) {
                    return a10;
                }
                expressionNode2 = ((ParentNode)expressionNode3).get(expressionNode3.size() - 1);
                if (expressionNode2 == null || expressionNode2.getNodeType() != ExpressionNodeType.Value || expressionNode2.getFormulaValueType() != FormulaValueType.bool) {
                    return a10;
                }
                ExpressionNode expressionNode4 = ((ParentNode)expressionNode3).get(expressionNode3.size() - 2);
                if (expressionNode4 == null || formulaValueType != null && formulaValueType != expressionNode4.getFormulaValueType()) {
                    return a10;
                }
                if (formulaValueType != null) continue;
                formulaValueType = expressionNode4.getFormulaValueType();
            }
            for (n2 = 0; n2 < a10.a().size(); ++n2) {
                expressionNode3 = (ConditionalNode)a10.a().get(n2);
                expressionNode2 = (ParentNode)((ConditionalNode)expressionNode3).getStatement();
                ((ParentNode)expressionNode2).remove(((ParentNode)expressionNode2).size() - 1);
                ((ParentNode)expressionNode2).try = formulaValueType;
                ((ConditionalNode)expressionNode3).try = formulaValueType;
            }
            ((a)a10).a().try = formulaValueType;
        }
        return a10;
    }

    private void if(ParentNode parentNode) {
        for (int i2 = 0; i2 < parentNode.size(); ++i2) {
            ExpressionNode expressionNode = parentNode.get(i2);
            if (expressionNode == null) continue;
            if (this.a(expressionNode)) {
                expressionNode = ((BinaryOperatorNode)expressionNode).getRightOperand();
                parentNode.set(i2, expressionNode);
            }
            if (expressionNode.size() == 0) {
                if (expressionNode.getNodeType() != ExpressionNodeType.VariableValue || !((VariableNode)expressionNode).else()) continue;
                parentNode.remove(i2);
                --i2;
                continue;
            }
            this.if((ParentNode)expressionNode);
        }
    }

    private boolean a(ExpressionNode expressionNode) {
        if (expressionNode == null) {
            return false;
        }
        if (expressionNode.getNodeType() != ExpressionNodeType.Assign) {
            return false;
        }
        ExpressionNode expressionNode2 = ((BinaryOperatorNode)expressionNode).getLeftOperand();
        return expressionNode2.getNodeType() == ExpressionNodeType.VariableReference && ((VariableNode)expressionNode2).else();
    }

    private boolean a(ParentNode parentNode) {
        for (int i2 = 0; i2 < parentNode.size(); ++i2) {
            ConditionalNode conditionalNode = (ConditionalNode)parentNode.get(i2);
            ExpressionNode expressionNode = conditionalNode.getStatement();
            if (!(expressionNode instanceof ParentNode)) {
                return false;
            }
            ExpressionNode expressionNode2 = ((ParentNode)expressionNode).get(expressionNode.size() - 1);
            if (expressionNode2 == null) {
                return false;
            }
            if (this.a(expressionNode2)) continue;
            if (expressionNode2.getNodeType() != ExpressionNodeType.IfSequence) {
                return false;
            }
            if (this.a((ParentNode)expressionNode2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuccessfullyCompiled(FormulaDefinitionBase formulaDefinitionBase, FormulaContext formulaContext) {
        if (formulaDefinitionBase.getFormulaInfo().hasValidCode()) {
            return true;
        }
        try {
            formulaDefinitionBase.compile(formulaContext);
            return true;
        }
        catch (FormulaException formulaException) {
            return false;
        }
    }

    public FieldExpression getFieldExpression(FormulaDefinition formulaDefinition, FormulaContext formulaContext, boolean bl2, FieldExpression.Options options) {
        if (formulaDefinition == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinition.getFormulaInfo().a(formulaContext, bl2, options);
    }

    public FormulaValue evaluate(FormulaDefinition formulaDefinition, FormulaContext formulaContext) throws FormulaException {
        if (formulaDefinition == null) {
            throw new NullPointerException("A formula must be given.");
        }
        return formulaDefinition.getFormulaInfo().do(formulaContext);
    }

    public void publish(CustomFunctionDefinition customFunctionDefinition, String[] stringArray) {
        if (customFunctionDefinition == null) {
            throw new NullPointerException("A custom function must be given.");
        }
        customFunctionDefinition.getFormulaInfo().a(stringArray);
    }

    public void unpublish(CustomFunctionDefinition customFunctionDefinition) {
        if (customFunctionDefinition == null) {
            throw new NullPointerException("A custom function must be given.");
        }
        customFunctionDefinition.getFormulaInfo().a();
    }

    public FormulaLanguageObject[] getSyntaxes() {
        return FormulaLanguageMetadataContainer.try;
    }

    public FormulaLanguageObject[] getFormulaValueTypes() {
        return FormulaLanguageMetadataContainer.for;
    }

    public FormulaLanguageObject[] getFunctionTypes() {
        return FormulaLanguageMetadataContainer.if;
    }

    public FormulaLanguageObject[] getKeywords(FormulaInfo.Syntax syntax) {
        return o.a(syntax);
    }

    public FormulaLanguageFunctionObject[] getFunctions(FormulaLanguageFunctionFilter formulaLanguageFunctionFilter) {
        FormulaLanguageFunctionFilter formulaLanguageFunctionFilter2 = formulaLanguageFunctionFilter;
        if (formulaLanguageFunctionFilter2 == null) {
            formulaLanguageFunctionFilter2 = new FormulaLanguageFunctionFilter();
        }
        ArrayList<FormulaLanguageFunctionObject> arrayList = new ArrayList<FormulaLanguageFunctionObject>();
        List<FormulaFunctionDefinition> list = this.for.getAllFunctionsForSyntax(formulaLanguageFunctionFilter2.a);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FormulaLanguageFunctionObject formulaLanguageFunctionObject = FormulaLanguageFunctionObjectWrapper.if(list.get(i2));
            if (!this.a(formulaLanguageFunctionObject, formulaLanguageFunctionFilter2)) continue;
            arrayList.add(formulaLanguageFunctionObject);
        }
        FormulaLanguageFunctionObject[] formulaLanguageFunctionObjectArray = new FormulaLanguageFunctionObject[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            formulaLanguageFunctionObjectArray[i3] = (FormulaLanguageFunctionObject)arrayList.get(i3);
        }
        return formulaLanguageFunctionObjectArray;
    }

    private boolean a(FormulaLanguageFunctionObject formulaLanguageFunctionObject, FormulaLanguageFunctionFilter formulaLanguageFunctionFilter) {
        FormulaInfo.Syntax[] syntaxArray;
        boolean bl2;
        if (formulaLanguageFunctionFilter.do != null && !StringUtil.equalsIgnoreCase((String)formulaLanguageFunctionFilter.do, (String)formulaLanguageFunctionObject.getName(), (Locale)FormulaParser.H)) {
            return false;
        }
        if (formulaLanguageFunctionFilter.a != null) {
            bl2 = false;
            for (FormulaInfo.Syntax syntax : syntaxArray = formulaLanguageFunctionObject.getSyntaxes()) {
                if (formulaLanguageFunctionFilter.a != syntax) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
        }
        if (formulaLanguageFunctionFilter.if != null) {
            bl2 = false;
            for (FormulaInfo.Syntax syntax : syntaxArray = formulaLanguageFunctionObject.getVisibleSyntaxes()) {
                if (formulaLanguageFunctionFilter.if != syntax) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }

    public List getOperandsToBeRemoved(FormulaDefinitionBase formulaDefinitionBase, FormulaFunction formulaFunction) {
        ExpressionNode expressionNode = null;
        try {
            expressionNode = formulaDefinitionBase.getFormulaInfo().try();
            expressionNode = formulaDefinitionBase.getFormulaInfo().if(expressionNode);
        }
        catch (FormulaException formulaException) {
            CrystalAssert.ASSERT((boolean)false);
            return null;
        }
        HashSet<OperandField> hashSet = new HashSet<OperandField>();
        HashSet<OperandField> hashSet2 = new HashSet<OperandField>();
        this.a(expressionNode, formulaFunction, hashSet, hashSet2);
        ArrayList<OperandField> arrayList = new ArrayList<OperandField>();
        for (OperandField operandField : hashSet) {
            if (hashSet2.contains(operandField)) continue;
            arrayList.add(operandField);
        }
        return arrayList;
    }

    private void a(ExpressionNode expressionNode, FormulaFunction formulaFunction, Set<OperandField> set, Set<OperandField> set2) {
        block7: {
            block8: {
                block6: {
                    if (expressionNode == null) {
                        return;
                    }
                    if (!(expressionNode instanceof FieldNode)) break block6;
                    set2.add(((FieldNode)expressionNode).getField());
                    break block7;
                }
                if (!(expressionNode instanceof FunctionNode)) break block8;
                FunctionNode functionNode = (FunctionNode)expressionNode;
                if (functionNode.c == formulaFunction) {
                    for (int i2 = 0; i2 < functionNode.size(); ++i2) {
                        ExpressionNode expressionNode2 = functionNode.get(i2);
                        if (!(expressionNode2 instanceof FieldNode)) continue;
                        set.add(((FieldNode)expressionNode2).getField());
                    }
                } else {
                    for (int i3 = 0; i3 < functionNode.size(); ++i3) {
                        this.a(functionNode.get(i3), formulaFunction, set, set2);
                    }
                }
                break block7;
            }
            if (!(expressionNode instanceof ParentNode)) break block7;
            ParentNode parentNode = (ParentNode)expressionNode;
            for (int i4 = 0; i4 < parentNode.size(); ++i4) {
                this.a(parentNode.get(i4), formulaFunction, set, set2);
            }
        }
    }

    ValueNode.a a() {
        return this.new;
    }

    ArrayPool.a do() {
        return this.if;
    }

    public ArrayPool.FormulaValues getFormulaValueArrayPool() {
        return this.do;
    }

    ArrayPool.b if() {
        return this.int;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class b
    implements FormulaDefinitionBase {
        private final FormulaService nh;
        private final FormulaInfo ng;

        public b(FormulaService formulaService) {
            this.nh = formulaService;
            this.ng = new FormulaInfo(formulaService, this);
            this.ng.setText("", FormulaInfo.Syntax.crystalSyntax);
        }

        @Override
        public FormulaInfo getFormulaInfo() {
            return this.ng;
        }

        @Override
        public void compile(FormulaContext formulaContext) throws FormulaException {
            this.nh.compile(this, formulaContext);
        }

        @Override
        public FormulaValueType getRequiredFormulaValueType() {
            return FormulaValueType.unknown;
        }

        @Override
        public void formulaInfoUpdated() {
        }

        @Override
        public FormulaValueType getFormulaValueType() {
            return this.ng.getFormulaValueType();
        }

        @Override
        public String getFormulaForm() {
            return "{@Dummy Formula}";
        }

        @Override
        public boolean isCustomFunction() {
            return false;
        }

        @Override
        public Set<FormulaValueType> getAllowedFormulaValueTypes() {
            HashSet<FormulaValueType> hashSet = new HashSet<FormulaValueType>();
            hashSet.add(this.getRequiredFormulaValueType());
            return hashSet;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class a {
        private int do = 0;
        private ParentNode if;

        private a(ParentNode parentNode) {
            this.if = parentNode != null ? parentNode.if() : null;
        }

        private ParentNode a() {
            return this.if;
        }

        private boolean if() {
            if (this.do != 2) {
                return false;
            }
            ExpressionNode expressionNode = this.if.get(this.if.size() - 2);
            return FormulaService.this.a(expressionNode) || expressionNode.getNodeType() == ExpressionNodeType.IfSequence && FormulaService.this.a((ParentNode)expressionNode);
        }

        private void if(a a10) {
            this.if.add(a10.if);
            this.do += a10.do;
        }

        private void a(ExpressionNode expressionNode) {
            if (expressionNode != null && expressionNode.getNodeType() == ExpressionNodeType.VariableValue && ((VariableNode)expressionNode).else()) {
                ++this.do;
            }
            this.if.add(expressionNode);
        }
    }
}

