/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common.archive;

import com.crystaldecisions.reports.common.CommonResources;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.BadSchemaException;
import com.crystaldecisions.reports.common.archive.FutureReportVersionException;
import com.crystaldecisions.reports.common.archive.IGetObjectForId;
import com.crystaldecisions.reports.common.archive.ITslvInputRecordArchive;
import com.crystaldecisions.reports.common.archive.InputRecordArchive;
import com.crystaldecisions.reports.common.archive.RecordInfo;
import com.crystaldecisions.reports.common.archive.RecordType;
import com.crystaldecisions.reports.common.archive.ReportOlderThanVersion9Exception;
import com.crystaldecisions.reports.common.archive.TslvRecord;
import com.crystaldecisions.reports.common.archive.TslvRecordNotFoundException;
import com.crystaldecisions.reports.common.encryption.EncryptionInfo;
import com.crystaldecisions.reports.common.filemanagement.UTF8Codec;
import com.crystaldecisions.reports.common.value.BinaryValue;
import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.ColourValue;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.StringValue;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TslvInputRecordArchive
extends InputRecordArchive
implements ITslvInputRecordArchive {
    private int k = 0;
    private InputStream d = null;
    private InputStream m = null;
    private DataInputStream f = null;
    private boolean o = false;
    private boolean i = true;
    private boolean n = false;
    private int j = 0;
    private long h = 0L;
    private boolean e = false;
    private static final int l = 2000;
    private byte[] g = new byte[2000];

    public TslvInputRecordArchive(InputStream inputStream, int n2) {
        this.d = inputStream;
        this.m = new InputStream(){

            public int available() throws IOException {
                return TslvInputRecordArchive.this.d.available();
            }

            public void close() throws IOException {
                TslvInputRecordArchive.this.d.close();
            }

            public long skip(long l2) throws IOException {
                return TslvInputRecordArchive.this.d.skip(l2);
            }

            public int read(byte[] byArray, int n2, int n3) throws IOException {
                int n4 = TslvInputRecordArchive.this.d.read(byArray, n2, n3);
                int n5 = n2;
                int n6 = n2 + n4;
                while (n5 < n6) {
                    int n7 = n5++;
                    byArray[n7] = (byte)(byArray[n7] ^ TslvInputRecordArchive.this.j);
                }
                return n4;
            }

            public int read() throws IOException {
                int n2 = TslvInputRecordArchive.this.d.read();
                if (n2 == -1) {
                    return -1;
                }
                return n2 ^ TslvInputRecordArchive.this.j;
            }
        };
        this.f = new DataInputStream(this.m);
        this.k = n2;
    }

    public int getDefaultSchema() {
        return this.k;
    }

    public void close() throws ArchiveException {
        super.close();
        try {
            if (this.f != null) {
                this.f.close();
            }
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001502", "", iOException);
        }
    }

    private void if(boolean bl2) {
        this.o = bl2;
    }

    public boolean getUseSimpleEncryption() {
        return this.o;
    }

    public boolean getReadStringsUsingEnhancedFormat() {
        return this.i;
    }

    public boolean getReadObjectIDs() {
        return this.n;
    }

    public void setReadObjectIDs(boolean bl2) {
        this.n = bl2;
    }

    public boolean get32bitEnums() {
        return this.e;
    }

    public void set32bitEnums(boolean bl2) {
        this.e = bl2;
    }

    protected TslvRecord do() throws ArchiveException {
        if (this.b.empty()) {
            assert (false);
            throw new ArchiveException("JRC00001503", "", CommonResources.getFactory(), "NoCurrentRecord");
        }
        assert (this.b.peek() instanceof TslvRecord);
        return (TslvRecord)this.b.peek();
    }

    public EncryptionInfo loadStreamHeader(int n2) throws ArchiveException {
        RecordInfo recordInfo = new RecordInfo();
        RecordType recordType = this.loadAnyRecord(recordInfo);
        if (recordType.if != 65535 || recordInfo.a > n2) {
            if (recordType.if == 100) {
                throw new ReportOlderThanVersion9Exception("JRC00001504", "");
            }
            throw new FutureReportVersionException("JRC00001505", "");
        }
        EncryptionInfo encryptionInfo = new EncryptionInfo();
        encryptionInfo.int = this.loadBoolean();
        encryptionInfo.a = this.loadInt16u();
        encryptionInfo.for = this.loadBoolean();
        if (encryptionInfo.int) {
            byte[] byArray = new byte[16];
            for (int i2 = 0; i2 < 16; ++i2) {
                byArray[i2] = (byte)this.loadInt8u();
            }
            encryptionInfo.if = byArray;
        }
        if (this.getNBytesLeftInRecord() > 0) {
            encryptionInfo.do = this.loadBoolean();
        }
        this.skipRestOfRecord();
        return encryptionInfo;
    }

    public RecordType loadAnyRecord(RecordInfo recordInfo, int n2) throws ArchiveException {
        RecordType recordType = this.loadAnyRecord(recordInfo);
        if (recordInfo.a > n2) {
            throw new BadSchemaException("JRC99999999", null, CommonResources.getFactory(), "BadSchema");
        }
        return recordType;
    }

    public RecordType loadAnyRecord(RecordInfo recordInfo) throws ArchiveException {
        try {
            int n2 = this.f.readUnsignedByte();
            int n3 = this.f.readUnsignedByte();
            this.h += 2L;
            int n4 = 0;
            n4 = (n2 & 0x80) != 0 ? ((n2 & 0x40) != 0 ? 4 : 2) : ((n2 & 0x40) != 0 ? 1 : 0);
            boolean bl2 = (n2 & 0x20) != 0;
            boolean bl3 = this.i = (n2 & 0x10) != 0;
            assert (this.i);
            this.if((n2 & 8) != 0);
            boolean bl4 = (n2 & 4) != 0;
            int n5 = 0;
            if (bl4) {
                n5 = this.f.readUnsignedShort();
                this.h += 2L;
            } else {
                n5 = ((n2 & 3) << 8) + n3;
            }
            int n6 = this.getDefaultSchema();
            if (bl2) {
                n6 = this.f.readUnsignedShort();
                this.h += 2L;
            }
            int n7 = 0;
            switch (n4) {
                case 0: {
                    n7 = 0;
                    break;
                }
                case 1: {
                    n7 = this.loadInt8u(null);
                    break;
                }
                case 2: {
                    n7 = this.loadInt16u(null);
                    break;
                }
                case 4: {
                    n7 = this.loadInt32(null);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.getUseSimpleEncryption()) {
                this.j ^= n5 & 0xFF;
            }
            TslvRecord tslvRecord = this.a(n6);
            tslvRecord.if = this.h;
            tslvRecord.int = n4;
            tslvRecord.do = this.getUseSimpleEncryption() ? n5 & 0xFF : 0;
            tslvRecord.for = n7;
            this.if(tslvRecord);
            int n8 = 0;
            if (this.n) {
                n8 = this.loadInt32(null);
            }
            if (recordInfo != null) {
                recordInfo.a = n6;
                recordInfo.if = n8;
            }
            return new RecordType(n5);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001506", "", iOException);
        }
    }

    public RecordInfo loadRecord(int n2) throws ArchiveException {
        RecordType recordType = new RecordType(n2);
        return this.a(recordType);
    }

    public RecordInfo loadNextRecord(RecordType recordType, int n2, RecordType recordType2) throws ArchiveException {
        RecordInfo recordInfo = new RecordInfo();
        RecordType recordType3 = this.loadAnyRecord(recordInfo);
        while (!recordType3.equals(recordType)) {
            if (recordType3.equals(recordType2)) {
                throw new TslvRecordNotFoundException("JRC00001507");
            }
            this.skipRestOfRecord();
            recordType3 = this.loadAnyRecord(recordInfo);
        }
        if (recordInfo.a > n2) {
            throw new BadSchemaException("JRC00001508", "", CommonResources.getFactory(), "BadSchema");
        }
        return recordInfo;
    }

    public RecordInfo loadNextRecord(int n2, int n3, int n4) throws ArchiveException {
        return this.loadNextRecord(new RecordType(n2), n3, new RecordType(n4));
    }

    public void skipRestOfRecord() throws ArchiveException {
        TslvRecord tslvRecord = this.do();
        this.j ^= tslvRecord.do;
        int n2 = tslvRecord.for;
        long l2 = this.h;
        long l3 = tslvRecord.if;
        assert (l2 >= l3);
        assert (l2 - l3 < Integer.MAX_VALUE);
        int n3 = (int)(l2 - l3);
        if (n3 > n2) {
            throw new ArchiveException("JRC00001509", "", CommonResources.getFactory(), "ReadPastEndOfRecord");
        }
        if (n3 < n2) {
            this.if(n2 - n3);
        }
        this.if();
    }

    public int getNBytesLeftInRecord() throws ArchiveException {
        TslvRecord tslvRecord = this.do();
        long l2 = this.h;
        if (l2 < tslvRecord.if) {
            return tslvRecord.for;
        }
        int n2 = (int)(l2 - tslvRecord.if);
        if (n2 > tslvRecord.for) {
            return 0;
        }
        return tslvRecord.for - n2;
    }

    protected void if(int n2) throws ArchiveException {
        try {
            int n3 = this.f.skipBytes(n2);
            if (n3 < n2) {
                throw new ArchiveException("JRC00001510", "", CommonResources.getFactory(), "UnexpectedEndOfFile");
            }
            this.h += (long)n3;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001511", "", iOException);
        }
    }

    public int loadCollection(RecordType recordType) throws ArchiveException {
        return this.loadInt32(null);
    }

    public void skipRestOfCollection() throws ArchiveException {
    }

    public String loadString(String string) throws ArchiveException {
        return this.loadString();
    }

    public String loadString() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001512", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            if (this.i) {
                int n2 = this.f.readInt();
                this.h += 4L;
                switch (n2) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        int n3 = this.f.readUnsignedByte();
                        assert (n3 == 0);
                        ++this.h;
                        return "";
                    }
                }
                if (this.g.length < n2) {
                    this.g = new byte[n2];
                }
                this.f.readFully(this.g, 0, n2);
                this.h += (long)n2;
                return TslvInputRecordArchive.UtfDecode(this.g, n2 - 1);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                int n4 = this.f.readUnsignedByte();
                ++this.h;
                if (n4 == 0) break;
                byteArrayOutputStream.write(n4);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return TslvInputRecordArchive.UtfDecode(byArray, byArray.length);
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001513", "", iOException);
        }
    }

    public void skipString() throws ArchiveException {
        try {
            if (this.i) {
                int n2 = this.f.readInt();
                this.h += 4L;
                this.f.skipBytes(n2);
                this.h += (long)n2;
            } else {
                int n3;
                do {
                    n3 = this.f.readUnsignedByte();
                    ++this.h;
                } while (n3 != 0);
            }
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001514", "", iOException);
        }
    }

    public int loadInt8s(String string) throws ArchiveException {
        return this.loadInt8s();
    }

    public int loadInt8s() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001515", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            byte by2 = this.f.readByte();
            ++this.h;
            return by2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001516", "", iOException);
        }
    }

    public int loadInt8u(String string) throws ArchiveException {
        return this.loadInt8u();
    }

    public int loadInt8u() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001517", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            int n2 = this.f.readUnsignedByte();
            ++this.h;
            return n2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001518", "", iOException);
        }
    }

    public int loadInt16s(String string) throws ArchiveException {
        return this.loadInt16s();
    }

    public int loadInt16s() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001519", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            short s2 = this.f.readShort();
            this.h += 2L;
            return s2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001520", "", iOException);
        }
    }

    public int loadInt16u(String string) throws ArchiveException {
        return this.loadInt16u();
    }

    public int loadInt16u() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001521", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            int n2 = this.f.readUnsignedShort();
            this.h += 2L;
            return n2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001522", "", iOException);
        }
    }

    public int loadInt32(String string) throws ArchiveException {
        return this.loadInt32();
    }

    public int loadInt32() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001523", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            int n2 = this.f.readInt();
            this.h += 4L;
            return n2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001524", "", iOException);
        }
    }

    public long loadInt64(String string) throws ArchiveException {
        return this.loadInt64();
    }

    public long loadInt64() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001525", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            long l2 = this.f.readLong();
            this.h += 8L;
            return l2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001526", "", iOException);
        }
    }

    public double loadDouble(String string) throws ArchiveException {
        return this.loadDouble();
    }

    public double loadDouble() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001527", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            double d10 = this.f.readDouble();
            this.h += 8L;
            return d10;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001528", "", iOException);
        }
    }

    public boolean loadBoolean(String string) throws ArchiveException {
        return this.loadBoolean();
    }

    public boolean loadBoolean() throws ArchiveException {
        int n2 = this.loadInt16u();
        return n2 > 0;
    }

    public int loadInt16Compressed(String string) throws ArchiveException {
        return this.loadInt16Compressed();
    }

    public int loadInt16Compressed() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001529", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            int n2 = this.f.readUnsignedByte();
            ++this.h;
            if ((n2 & 0x80) != 0) {
                n2 = ((n2 & 0x7F) << 8) + this.f.readUnsignedByte();
                ++this.h;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001530", "", iOException);
        }
    }

    public int loadInt32Compressed(String string) throws ArchiveException {
        return this.loadInt32Compressed();
    }

    public int loadInt32Compressed() throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001531", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            int n2 = this.f.readUnsignedShort();
            this.h += 2L;
            if ((n2 & 0x8000) != 0) {
                n2 = ((n2 & Short.MAX_VALUE) << 16) + this.f.readUnsignedShort();
                this.h += 2L;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001532", "", iOException);
        }
    }

    public byte[] loadBinary(String string) throws ArchiveException {
        int n2 = this.loadInt32();
        return this.loadBlock(n2);
    }

    public byte[] loadBlock(int n2) throws ArchiveException {
        if (this.f == null) {
            throw new ArchiveException("JRC00001533", "", CommonResources.getFactory(), "InvalidInputStream");
        }
        try {
            if (n2 == 0) {
                return new byte[0];
            }
            byte[] byArray = new byte[n2];
            this.f.readFully(byArray);
            this.h += (long)n2;
            return byArray;
        }
        catch (IOException iOException) {
            throw new ArchiveException("JRC00001534", "", iOException);
        }
    }

    public int loadEnum() throws ArchiveException {
        if (this.e) {
            return this.loadInt32(null);
        }
        return this.loadInt16Compressed(null);
    }

    public int loadEnum(String string, Map map) throws ArchiveException {
        return this.loadEnum();
    }

    public CrystalValue loadValue(String string, IGetObjectForId iGetObjectForId) throws ArchiveException {
        return this.loadValue(iGetObjectForId);
    }

    public CrystalValue loadValue(IGetObjectForId iGetObjectForId) throws ArchiveException {
        int n2 = this.loadInt16u();
        switch (n2) {
            case 0: 
            case 1: {
                return null;
            }
            case 16: {
                return NumberValue.fromLong((long)this.loadInt8s());
            }
            case 17: {
                return NumberValue.fromLong((long)this.loadInt8u());
            }
            case 2: {
                return NumberValue.fromLong((long)this.loadInt16s());
            }
            case 18: {
                return NumberValue.fromLong((long)this.loadInt16u());
            }
            case 3: 
            case 10: 
            case 19: 
            case 22: 
            case 23: {
                return NumberValue.fromLong((long)this.loadInt32());
            }
            case 4: {
                return NumberValue.fromDouble((double)this.loadDouble());
            }
            case 5: {
                return NumberValue.fromDouble((double)this.loadDouble());
            }
            case 6: {
                double d10 = this.loadInt64();
                return CurrencyValue.fromDouble((double)(d10 /= 10000.0));
            }
            case 7: {
                double d11 = this.loadDouble();
                return DateTimeValue.fromOleDate((double)d11);
            }
            case 8: {
                return StringValue.fromString((String)this.loadString());
            }
            case 11: {
                return BooleanValue.fromBoolean((boolean)this.loadBoolean());
            }
            case 14: {
                this.loadInt8u();
                this.loadInt8u();
                this.loadInt32();
                this.loadInt64();
                assert (false) : "BigDecimal not supported.";
                return NumberValue.fromDouble((double)0.0);
            }
            case 8209: {
                return BinaryValue.fromByteArray((byte[])this.loadBinary(null));
            }
            case 9: 
            case 13: {
                this.loadInt32();
                assert (false) : "Unable to support COM interfaces";
                return null;
            }
        }
        assert (false);
        return null;
    }

    public Color loadColour(String string) throws ArchiveException {
        return this.loadColour();
    }

    public Color loadColour() throws ArchiveException {
        int n2 = this.loadInt32();
        return ColourValue.getColorFromColorRef((int)n2);
    }

    public static String UtfDecode(byte[] byArray, int n2) {
        int n3;
        char[] cArray = new char[n2];
        try {
            n3 = UTF8Codec.decode((byte[])byArray, (int)0, (int)n2, (char[])cArray, (int)0);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            System.err.println("Can't UTF decode \"" + byArray + "\".");
            uTFDataFormatException.printStackTrace();
            return null;
        }
        return new String(cArray, 0, n3);
    }
}

