/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.Margins;
import com.crystaldecisions.reports.common.SaveLoadException;
import com.crystaldecisions.reports.common.TwipPoint;
import com.crystaldecisions.reports.common.TwipSize;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.ITslvInputRecordArchive;
import com.crystaldecisions.reports.common.archive.ITslvOutputRecordArchive;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class TwipRect {
    public final int for;
    public final int do;
    public final int if;
    public final int a;

    public TwipRect(int n2, int n3, int n4, int n5) {
        this.for = n2;
        this.do = n3;
        this.if = n4 < n2 ? n2 : n4;
        this.a = n5 < n3 ? n3 : n5;
    }

    public TwipRect(TwipRect twipRect) {
        this(twipRect.for, twipRect.do, twipRect.if, twipRect.a);
    }

    public TwipRect() {
        this(0, 0, 0, 0);
    }

    public TwipRect(TwipPoint twipPoint, TwipPoint twipPoint2) {
        this(twipPoint.x, twipPoint.y, twipPoint2.x, twipPoint2.y);
    }

    public TwipRect(TwipPoint twipPoint, TwipSize twipSize) {
        this(twipPoint.x, twipPoint.y, twipPoint.x + twipSize.cx, twipPoint.y + twipSize.cy);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TwipRect twipRect = (TwipRect)object;
        return this.for == twipRect.for && this.do == twipRect.do && this.if == twipRect.if && this.a == twipRect.a;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.for;
        n2 = 37 * n2 + this.do;
        n2 = 37 * n2 + this.if;
        n2 = 37 * n2 + this.a;
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TwipRect:<left=");
        stringBuilder.append(this.for);
        stringBuilder.append("><top=");
        stringBuilder.append(this.do);
        stringBuilder.append("><width=");
        stringBuilder.append(this.char());
        stringBuilder.append("><height=");
        stringBuilder.append(this.goto());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public int try() {
        return this.for;
    }

    public int byte() {
        return this.do;
    }

    public int int() {
        return this.if;
    }

    public int do() {
        return this.a;
    }

    public int char() {
        return this.if - this.for;
    }

    public int goto() {
        return this.a - this.do;
    }

    public TwipPoint new() {
        return new TwipPoint(this.for, this.do);
    }

    public TwipPoint a() {
        return new TwipPoint(this.for, this.a);
    }

    public TwipPoint else() {
        return new TwipPoint(this.if, this.do);
    }

    public TwipPoint case() {
        return new TwipPoint(this.if, this.a);
    }

    public TwipSize if() {
        return new TwipSize(this.char(), this.goto());
    }

    public boolean a(TwipPoint twipPoint) {
        return twipPoint.x >= this.for && twipPoint.x < this.if && twipPoint.y >= this.do && twipPoint.y < this.a;
    }

    public boolean for() {
        return this.for >= this.if || this.do >= this.a;
    }

    public boolean a(TwipRect twipRect) {
        return !this.for() && !twipRect.for() && this.for < twipRect.if && this.do < twipRect.a && this.if > twipRect.for && this.a > twipRect.do;
    }

    public TwipRect a(TwipSize twipSize) {
        return this.a(twipSize.cx, twipSize.cy);
    }

    public TwipRect a(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this;
        }
        return new TwipRect(this.for + n2, this.do + n3, this.if + n2, this.a + n3);
    }

    public TwipRect if(TwipSize twipSize) {
        return this.if(twipSize.cx, twipSize.cy);
    }

    public TwipRect if(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this;
        }
        return new TwipRect(this.for, this.do, this.if + n2, this.a + n3);
    }

    public TwipRect if(Margins margins) {
        if (!margins.isValid() || !margins.hasNonZeroMargins()) {
            return this;
        }
        return new TwipRect(this.for - margins.getLeft(), this.do - margins.getTop(), this.if + margins.getRight(), this.a + margins.getBottom());
    }

    public TwipRect a(Margins margins) {
        if (!margins.isValid() || !margins.hasNonZeroMargins()) {
            return this;
        }
        return new TwipRect(this.for + margins.getLeft(), this.do + margins.getTop(), this.if - margins.getRight(), this.a - margins.getBottom());
    }

    public void a(ITslvOutputRecordArchive iTslvOutputRecordArchive) throws SaveLoadException, ArchiveException {
        iTslvOutputRecordArchive.storeInt32Compressed(this.for);
        iTslvOutputRecordArchive.storeInt32Compressed(this.do);
        iTslvOutputRecordArchive.storeInt32Compressed(this.if);
        iTslvOutputRecordArchive.storeInt32Compressed(this.a);
    }

    public static TwipRect a(ITslvInputRecordArchive iTslvInputRecordArchive) throws SaveLoadException, ArchiveException {
        int n2 = iTslvInputRecordArchive.loadInt32Compressed();
        int n3 = iTslvInputRecordArchive.loadInt32Compressed();
        int n4 = iTslvInputRecordArchive.loadInt32Compressed();
        int n5 = iTslvInputRecordArchive.loadInt32Compressed();
        return new TwipRect(n2, n3, n4, n5);
    }

    public TwipRect a(int n2, int n3, int n4, int n5) {
        return new TwipRect(this.for + n2, this.do + n3, this.if - n4, this.a - n5);
    }

    public TwipRect if(TwipRect twipRect) {
        if (twipRect == null) {
            return this;
        }
        int n2 = Math.min(this.do, twipRect.do);
        int n3 = Math.max(this.a, twipRect.a);
        int n4 = Math.min(this.for, twipRect.for);
        int n5 = Math.max(this.if, twipRect.if);
        return new TwipRect(n4, n2, n5, n3);
    }

    public TwipRect do(int n2) {
        return new TwipRect(this.for, n2, this.if, this.a);
    }

    public TwipRect for(int n2) {
        return new TwipRect(this.for, this.do, this.if, n2);
    }

    public TwipRect if(int n2) {
        return new TwipRect(n2, this.do, this.if, this.a);
    }

    public TwipRect a(int n2) {
        return new TwipRect(this.for, this.do, n2, this.a);
    }
}

