/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.SaveLoadException;
import com.crystaldecisions.reports.common.TwipRect;
import com.crystaldecisions.reports.common.archive.ArchiveException;
import com.crystaldecisions.reports.common.archive.IInputArchive;
import com.crystaldecisions.reports.common.archive.IOutputArchive;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Margins {
    public static final Margins INVALID_MARGINS = new Margins(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    public static final Margins ZERO_MARGINS = new Margins(0, 0, 0, 0);
    public static final Margins DEFAULT_MARGINS = new Margins(720, 720, 720, 720);
    public static final Margins DEFAULT_PAGE_MARGINS = new Margins(260, 260, 260, 260);
    private static final int if = 360;
    private final int do;
    private final int int;
    private final int for;
    private final int a;

    public Margins(int n2, int n3, int n4, int n5) {
        this.do = n2;
        this.int = n3;
        this.for = n4;
        this.a = n5;
    }

    public Margins(Margins margins) {
        this.do = margins.do;
        this.int = margins.int;
        this.for = margins.for;
        this.a = margins.a;
    }

    public String toString() {
        return "left=" + this.do + ", right=" + this.int + ", top=" + this.for + ", bottom=" + this.a;
    }

    public int getLeft() {
        return this.do;
    }

    public int getRight() {
        return this.int;
    }

    public int getTop() {
        return this.for;
    }

    public int getBottom() {
        return this.a;
    }

    public int getWidth() {
        return this.do + this.int;
    }

    public int getHeight() {
        return this.for + this.a;
    }

    public boolean isValid() {
        return this.do != Integer.MIN_VALUE && this.int != Integer.MIN_VALUE && this.for != Integer.MIN_VALUE && this.a != Integer.MIN_VALUE;
    }

    public boolean hasNonZeroMargins() {
        return this.do > 0 || this.int > 0 || this.for > 0 || this.a > 0;
    }

    public Margins combine(Margins margins) {
        if (margins.isValid()) {
            return margins;
        }
        int n2 = margins.do == Integer.MIN_VALUE ? this.do : margins.do;
        int n3 = margins.int == Integer.MIN_VALUE ? this.int : margins.int;
        int n4 = margins.for == Integer.MIN_VALUE ? this.for : margins.for;
        int n5 = margins.a == Integer.MIN_VALUE ? this.a : margins.a;
        return new Margins(n2, n3, n4, n5);
    }

    public Margins imposeMinMargin() {
        int n2 = this.do <= 0 ? 360 : this.do;
        int n3 = this.int <= 0 ? 360 : this.int;
        int n4 = this.for <= 0 ? 360 : this.for;
        int n5 = this.a <= 0 ? 360 : this.a;
        return new Margins(n2, n3, n4, n5);
    }

    public Margins imposeZeroMargin() {
        int n2 = this.do <= 0 ? 0 : this.do;
        int n3 = this.int <= 0 ? 0 : this.int;
        int n4 = this.for <= 0 ? 0 : this.for;
        int n5 = this.a <= 0 ? 0 : this.a;
        return new Margins(n2, n3, n4, n5);
    }

    public static TwipRect MarginsToTwipRect(Margins margins) {
        return new TwipRect(margins.do, margins.for, margins.int, margins.a);
    }

    public static Margins TwipRectToMargins(TwipRect twipRect) {
        return new Margins(twipRect.for, twipRect.if, twipRect.do, twipRect.a);
    }

    public void store(IOutputArchive iOutputArchive) throws SaveLoadException, ArchiveException {
        iOutputArchive.storeInt32(this.do);
        iOutputArchive.storeInt32(this.int);
        iOutputArchive.storeInt32(this.for);
        iOutputArchive.storeInt32(this.a);
    }

    public static Margins Load(IInputArchive iInputArchive) throws SaveLoadException, ArchiveException {
        int n2 = iInputArchive.loadInt32();
        int n3 = iInputArchive.loadInt32();
        int n4 = iInputArchive.loadInt32();
        int n5 = iInputArchive.loadInt32();
        return new Margins(n2, n3, n4, n5);
    }

    public int hashCode() {
        int n2 = this.a;
        n2 = 31 * n2 + this.do;
        n2 = 31 * n2 + this.int;
        n2 = 31 * n2 + this.for;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Margins)) {
            return false;
        }
        Margins margins = (Margins)object;
        return this.a == margins.a && this.do == margins.do && this.int == margins.int && this.for == margins.for;
    }
}

