/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.client.helper;

import com.crystaldecisions.client.helper.a;
import com.crystaldecisions.sdk.occa.report.definition.AreaSectionKind;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.xml.sax.Attributes;

public final class XMLSerializationHelper {
    private static final String new = "crs:Report";
    private static final String a = "crs:Page";
    private static final String for = "crs:Group";
    private static final String try = "crs:Details";
    private static final String int = "crs:Header";
    private static final String do = "crs:Footer";
    private static final String if = "crs:Details";
    public static final String AREATYPE_TAG = "AreaType";
    public static final String AREAPAIRTYPE_TAG = "AreaPairType";
    public static final String CRYSTALREPORTSNAMESPACEALIAS = "xmlns:crs";
    public static final String CRYSTALREPORTSNAMESPACE = "urn:crystal-reports:schemas";
    public static final String XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String XMLSCHEMA_REPORT = "http://www.crystaldecisions.com/report";
    public static final String VERSION = "2";

    public static Properties getHeaderAttributes(String string) {
        a a10 = new a();
        a10.setProperty("xmlns", XMLSCHEMA_REPORT);
        a10.setProperty("xmlns:xsi", XMLSCHEMA_INSTANCE);
        a10.setProperty("xmlns:xsd", XMLSCHEMA);
        a10.setProperty("xsi:type", string);
        a10.setProperty("version", VERSION);
        return a10;
    }

    public static Object getVariantObject(String string, Attributes attributes) {
        return XMLSerializationHelper.getVariantObject(string, attributes, null);
    }

    public static Object getVariantObject(String string, Attributes attributes, Map map) {
        String string2 = attributes.getValue("VariantType");
        if (string2 == null) {
            string2 = attributes.getValue("xsi:type");
        }
        if (string2.equals("String")) {
            return string;
        }
        if (string2.equals("Integer")) {
            return XMLConverter.getInteger(string);
        }
        if (string2.equals("Boolean")) {
            return XMLConverter.getBoolean(string);
        }
        if (string2.equals("Double")) {
            return XMLConverter.getDouble(string);
        }
        if (string2.equals("Currency")) {
            return XMLConverter.getDouble(string);
        }
        if (string2.equals("dateTime")) {
            TimeZone timeZone = null;
            if (map.containsKey("CLIENT_TIMEZONE_DESP")) {
                timeZone = TimeZone.getTimeZone((String)map.get("CLIENT_TIMEZONE_DESP"));
            }
            return XMLConverter.getDate(string, timeZone);
        }
        return null;
    }

    public static AreaSectionKind readAreaSectionKind(String string, String string2, Attributes attributes) {
        AreaSectionKind areaSectionKind = AreaSectionKind.invalid;
        if (string == null || string.length() == 0) {
            return areaSectionKind;
        }
        if (string.equalsIgnoreCase(new)) {
            if (string2.equalsIgnoreCase(int)) {
                areaSectionKind = AreaSectionKind.reportHeader;
            } else if (string2.equalsIgnoreCase(do)) {
                areaSectionKind = AreaSectionKind.reportFooter;
            }
        } else if (string.equalsIgnoreCase(a)) {
            if (string2.equalsIgnoreCase(int)) {
                areaSectionKind = AreaSectionKind.pageHeader;
            } else if (string2.equalsIgnoreCase(do)) {
                areaSectionKind = AreaSectionKind.pageFooter;
            }
        } else if (string.equalsIgnoreCase(for)) {
            if (string2.equalsIgnoreCase(int)) {
                areaSectionKind = AreaSectionKind.groupHeader;
            } else if (string2.equalsIgnoreCase(do)) {
                areaSectionKind = AreaSectionKind.groupFooter;
            }
        } else if (string.equalsIgnoreCase("crs:Details") && string2.equalsIgnoreCase("crs:Details")) {
            areaSectionKind = AreaSectionKind.detail;
        }
        return areaSectionKind;
    }

    public static void writeAreaSectionKind(XMLWriter xMLWriter, AreaSectionKind areaSectionKind, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string;
        String string2;
        switch (areaSectionKind.value()) {
            case 1: {
                string2 = new;
                string = int;
                break;
            }
            case 2: {
                string2 = a;
                string = int;
                break;
            }
            case 3: {
                string2 = for;
                string = int;
                break;
            }
            case 4: {
                string2 = "crs:Details";
                string = "crs:Details";
                break;
            }
            case 5: {
                string2 = for;
                string = do;
                break;
            }
            case 7: {
                string2 = a;
                string = do;
                break;
            }
            case 8: {
                string2 = new;
                string = do;
                break;
            }
            default: {
                return;
            }
        }
        xMLWriter.writeTextElement(AREAPAIRTYPE_TAG, string2, null);
        xMLWriter.writeTextElement(AREATYPE_TAG, string, null);
    }

    public static void writeVariantObject(XMLWriter xMLWriter, String string, Object object, XMLSerializationContext xMLSerializationContext) throws IOException {
        a a10 = new a();
        if (object == null) {
            a10.setProperty("VariantType", "Nothing");
            xMLWriter.writeStartElement(string, a10);
            xMLWriter.writeEndElement(string);
            return;
        }
        if (object instanceof Integer || object instanceof Byte || object instanceof Short) {
            a10.setProperty("VariantType", "Integer");
        } else if (object instanceof Number) {
            a10.setProperty("VariantType", "Double");
        } else if (object instanceof Boolean) {
            a10.setProperty("VariantType", "Boolean");
        } else if (object instanceof String) {
            a10.setProperty("VariantType", "String");
        } else if (object instanceof Date || object instanceof Calendar) {
            a10.setProperty("xsi:type", "dateTime");
        }
        xMLWriter.writeStartElement(string, a10);
        if (object instanceof Number) {
            xMLWriter.writeText(object.toString());
        } else if (object instanceof Boolean) {
            xMLWriter.writeText((Boolean)object == true ? "1" : "0");
        } else if (object instanceof String) {
            xMLWriter.writeText((String)object);
        } else if (object instanceof Date) {
            xMLWriter.writeText(XMLConverter.getDateString((Date)object, xMLWriter.getSaveTimeZone()));
        } else if (object instanceof Calendar) {
            xMLWriter.writeText(XMLConverter.getCalendarString((Calendar)object));
        }
        xMLWriter.writeEndElement(string);
    }
}

