/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.crystalreports.viewer.core;

import com.businessobjects.crystalreports.viewer.core.CoreStrings;
import com.businessobjects.crystalreports.viewer.core.ExportFormatInfo;
import com.businessobjects.crystalreports.viewer.core.InfoPrompter;
import com.businessobjects.crystalreports.viewer.core.RecordConsumer;
import com.businessobjects.crystalreports.viewer.core.RecordRequest;
import com.businessobjects.crystalreports.viewer.core.ReportChannelFactory;
import com.businessobjects.crystalreports.viewer.core.ReportClient;
import com.businessobjects.crystalreports.viewer.core.SortSpecification;
import com.businessobjects.crystalreports.viewer.core.http.HTTPReportChannel;
import com.businessobjects.crystalreports.viewer.core.m;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public abstract class ReportChannel {
    public static final int v6AristotlePE = 1536;
    public static final int v7SocratesPE = 1792;
    public static final int v7SocratesSlip1PE = 1793;
    public static final int v8SerengetiPE = 2048;
    public static final int v85ZebraPE = 2128;
    public static final int v85McKinleyPE = 2144;
    public static final int v9ApolloPE = 2304;
    public static final int v9PatagoniaPE = 2336;
    public static final int v10NewtonPE = 2560;
    public static final int v11CB1PE = 2816;
    public static final int v115JupiterPE = 2896;
    public static final int v118BailyPE = 2944;
    public static final int v119MercuryPE = 2960;
    public static final int v12TitanPE = 3072;
    public static final int v13SaturnPE = 3328;
    protected ReportClient reportClient;
    protected InfoPrompter infoPrompter;
    private static transient short a;
    protected transient short thisViewerGenerationN;
    protected transient int peVersionN = 1536;
    protected String reportName = "";
    protected String reportTitle = "";
    public static final int toCrystalReport = 0;
    public static final int toMSWord = 1;
    public static final int toMSExcelFormattedData = 2;
    public static final int toRTF = 3;
    public static final int toPDF = 4;
    public static final int toMSExcelDataOnly = 5;
    public static final int toMSWordEditable = 6;
    public static final int toCSV = 7;

    public static ReportChannel[] getReportChannels(ReportClient reportClient, Specification[] specificationArray, boolean bl2) {
        if (specificationArray == null) {
            return null;
        }
        ReportChannel[] reportChannelArray = new ReportChannel[specificationArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < specificationArray.length; ++i2) {
            reportChannelArray[i2] = ReportChannel.getReportChannel(reportClient, specificationArray[i2], bl2);
            if (reportChannelArray[i2] == null) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        return reportChannelArray;
    }

    public static ReportChannel getReportChannel(ReportClient reportClient, Specification specification, boolean bl2) {
        if (specification.reportName == null) {
            return null;
        }
        boolean bl3 = reportClient.getDocumentURL() != null;
        boolean bl4 = false;
        try {
            URL uRL = new URL(specification.reportName);
            if (uRL.getProtocol().startsWith("http")) {
                bl4 = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        boolean bl5 = bl4;
        if (specification.serverParameters != null && specification.serverParameters.length() > 0) {
            bl5 = true;
        } else if (reportClient.isRunningInBrowser() && bl3) {
            bl5 = true;
        }
        if (bl5) {
            return new HTTPReportChannel(reportClient, specification, bl2);
        }
        if (specification.reportSource != null) {
            try {
                Class<?> clazz = Class.forName("com.businessobjects.crystalreports.viewer.core.rs.RSReportChannelFactory");
                ReportChannelFactory reportChannelFactory = (ReportChannelFactory)clazz.newInstance();
                return reportChannelFactory.newReportChannel(reportClient, specification, bl2);
            }
            catch (Exception exception) {
                reportClient.showErrorMessage(exception.getMessage());
                return null;
            }
        }
        if (specification.reportName.length() == 0) {
            return null;
        }
        if (specification.reportName.endsWith(".rpt") || specification.reportName.endsWith(".RPT")) {
            try {
                Class<?> clazz = Class.forName("com.businessobjects.crystalreports.viewer.core.jrc.JRCReportChannelFactory");
                ReportChannelFactory reportChannelFactory = (ReportChannelFactory)clazz.newInstance();
                return reportChannelFactory.newReportChannel(reportClient, specification, bl2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return new m(reportClient, specification.reportName, specification.reportTitle);
        }
        catch (Exception exception) {
            reportClient.showErrorMessage(exception.getMessage());
            return null;
        }
    }

    public InfoPrompter getInfoPrompter() {
        return this.infoPrompter;
    }

    public void setInfoPrompter(InfoPrompter infoPrompter) {
        this.infoPrompter = infoPrompter;
    }

    public static short getViewerGenerationN() {
        return a;
    }

    public static void updateViewerGenerationN() {
        a = (short)Math.floor(Math.random() * 1000.0);
    }

    public int getPEVersionN() {
        return this.peVersionN;
    }

    public synchronized void updatePEVersionN(int n2) {
        if (n2 > this.peVersionN) {
            this.peVersionN = n2;
        }
    }

    protected ReportChannel(ReportClient reportClient, String string, String string2) {
        this.reportClient = reportClient;
        this.setReportName(string);
        this.setReportTitle(string2);
        this.reset();
    }

    public void reset() {
        this.peVersionN = 1536;
        ReportChannel.updateViewerGenerationN();
        this.thisViewerGenerationN = a;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String string) {
        this.reportName = string == null ? "" : string;
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String string) {
        this.reportTitle = string == null ? "" : string;
    }

    public abstract String getReportParameters();

    public abstract boolean setReportParameters(String var1);

    public abstract String getServerParameters();

    public boolean canGetSetSelectionFormula() {
        return true;
    }

    public abstract String getSelectionFormula();

    public abstract boolean setSelectionFormula(String var1);

    public boolean canGetSetGroupSelectionFormula() {
        return true;
    }

    public abstract String getGroupSelectionFormula();

    public abstract boolean setGroupSelectionFormula(String var1);

    public void changeSort(SortSpecification sortSpecification) {
    }

    public void setPromptOnRefresh(boolean bl2) {
    }

    public boolean canGetPage() {
        return true;
    }

    public boolean canGetBetterPage() {
        return false;
    }

    public boolean canGetTotaller() {
        return true;
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canGetLastPageN() {
        return true;
    }

    public boolean canRefreshData() {
        return true;
    }

    public boolean canSearchForText() {
        return true;
    }

    public boolean canSearchForRecord() {
        return true;
    }

    public boolean canDrillDownOnChart() {
        return true;
    }

    public boolean canGetExportInfo() {
        return true;
    }

    public boolean canExport() {
        return true;
    }

    public boolean canExportDrillDown() {
        return false;
    }

    public boolean canExportSubreport() {
        return false;
    }

    public boolean canExportToFormat(int n2, boolean bl2) {
        return true;
    }

    public boolean canExportPageRange() {
        return false;
    }

    public boolean canExportPageRangeToFormat(int n2) {
        if (!this.canExportPageRange()) {
            return false;
        }
        switch (n2) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
        }
        return true;
    }

    public Vector getExportFormatInfo(boolean bl2) {
        CoreStrings coreStrings = this.reportClient.getCoreStrings();
        Vector<ExportFormatInfo> vector = new Vector<ExportFormatInfo>();
        if (this.canExportToFormat(0, bl2)) {
            vector.addElement(new ExportFormatInfo(0, coreStrings.formatCrystalReport, ".rpt", this.canExportPageRangeToFormat(0)));
        }
        if (this.canExportToFormat(4, bl2)) {
            vector.addElement(new ExportFormatInfo(4, coreStrings.formatPDF, ".pdf", this.canExportPageRangeToFormat(4)));
        }
        if (this.canExportToFormat(2, bl2)) {
            vector.addElement(new ExportFormatInfo(2, coreStrings.formatMSExcelFormattedData, ".xls", this.canExportPageRangeToFormat(2)));
        }
        if (this.canExportToFormat(5, bl2)) {
            vector.addElement(new ExportFormatInfo(5, coreStrings.formatMSExcelDataOnly, ".xls", this.canExportPageRangeToFormat(5)));
        }
        if (this.canExportToFormat(1, bl2)) {
            vector.addElement(new ExportFormatInfo(1, coreStrings.formatMSWord, ".rtf", this.canExportPageRangeToFormat(1)));
        }
        if (this.canExportToFormat(6, bl2)) {
            vector.addElement(new ExportFormatInfo(6, coreStrings.formatMSWordEditable, ".rtf", this.canExportPageRangeToFormat(6)));
        }
        if (this.canExportToFormat(3, bl2)) {
            vector.addElement(new ExportFormatInfo(3, coreStrings.formatRTF, ".rtf", this.canExportPageRangeToFormat(3)));
        }
        if (this.canExportToFormat(7, bl2)) {
            vector.addElement(new ExportFormatInfo(7, coreStrings.formatCSV, ".csv", this.canExportPageRangeToFormat(7)));
        }
        return vector;
    }

    public abstract void startRequest(RecordRequest var1, RecordConsumer var2);

    public String getExportStreamDefinition(RecordRequest recordRequest) {
        return null;
    }

    public void shutDown() {
    }

    public static class Specification {
        public Object reportSource;
        public String reportName;
        public String reportTitle;
        public String reportParameters;
        public String selectionFormula;
        public String serverParameters;

        public Specification(Object object, String string, String string2, String string3, String string4, String string5) {
            this.reportSource = object;
            this.reportName = string;
            this.reportTitle = string2;
            this.reportParameters = string3;
            this.selectionFormula = string4;
            this.serverParameters = string5;
        }
    }
}

