/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.settings;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.KeyObject;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFilter {
    CVOMHelper cvom = null;
    private static HashSet<Attr> filterAttrs = new HashSet();
    private static HashSet<Attr> filterSeriesGroupAttrs = new HashSet();
    private static Map<Integer, Set<Attr>> permittedKeys = new HashMap<Integer, Set<Attr>>();
    private static Map<Integer, Set<String>> permittedGraphicIDsForObjIDs = new HashMap<Integer, Set<String>>();
    private static Map<Attr, Set<String>> permittedGraphicIDsForAttrs = new HashMap<Attr, Set<String>>();

    private static void addConditionallyPermittedObjectIDs(List<Integer> objIDs, List<String> graphicIDs) {
        for (Integer i : objIDs) {
            Set<String> graphicIDset = permittedGraphicIDsForObjIDs.get(i);
            if (graphicIDset == null) {
                graphicIDset = new HashSet<String>(graphicIDs);
                permittedGraphicIDsForObjIDs.put(i, graphicIDset);
                continue;
            }
            graphicIDset.addAll(graphicIDs);
        }
    }

    private static void addConditionallyPermittedAttr(Attr attr, String graphicID) {
        Set<String> graphicIDs = permittedGraphicIDsForAttrs.get(attr);
        if (graphicIDs == null) {
            graphicIDs = new HashSet<String>();
            permittedGraphicIDsForAttrs.put(attr, graphicIDs);
        }
        graphicIDs.add(graphicID);
    }

    private static void addPermittedKeys(List<Integer> objectIDs, List<Attr> attrs) {
        for (int objectID : objectIDs) {
            QuickFilter.addPermittedKeys(objectID, attrs);
        }
    }

    private static void addPermittedKeys(List<Integer> objectIDs, Attr attr) {
        for (int objectID : objectIDs) {
            QuickFilter.addPermittedKeys(objectID, attr);
        }
    }

    private static void addPermittedKeys(int objectID, List<Attr> attrs) {
        for (Attr attr : attrs) {
            QuickFilter.addPermittedKeys(objectID, attr);
        }
    }

    private static void addPermittedKeys(int objectID, Attr attr) {
        Set<Attr> attrs = permittedKeys.get(objectID);
        if (attrs == null) {
            attrs = new HashSet<Attr>();
            permittedKeys.put(objectID, attrs);
        }
        attrs.add(attr);
    }

    public QuickFilter(CVOMHelper cvom) {
        this.cvom = cvom;
    }

    boolean keyFilter(KeyObject key) {
        Attr attr = key.getAttr();
        if (!this.permittedKey(key)) {
            return true;
        }
        if (filterAttrs.contains(attr)) {
            return true;
        }
        IdentObj id = key.getIdentObj();
        int objID = id.getObjectID();
        switch (objID) {
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 611: 
            case 612: 
            case 613: 
            case 614: 
            case 615: 
            case 683: 
            case 684: 
            case 685: 
            case 686: 
            case 687: 
            case 688: 
            case 689: 
            case 690: 
            case 691: 
            case 692: 
            case 693: 
            case 694: 
            case 695: 
            case 696: 
            case 697: 
            case 698: 
            case 756: 
            case 757: 
            case 758: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 777: 
            case 778: 
            case 2007: 
            case 2012: 
            case 2013: 
            case 2014: 
            case 2015: 
            case 2016: 
            case 2017: {
                return true;
            }
        }
        if (key.getAttr() == Attr.TextString) {
            switch (objID) {
                case 14: 
                case 514: 
                case 518: 
                case 524: 
                case 528: 
                case 532: 
                case 568: {
                    return true;
                }
            }
        }
        if (!id.isSERIES_NA() || !id.isGROUP_NA()) {
            switch (objID) {
                case 504: {
                    return true;
                }
            }
            if (filterSeriesGroupAttrs.contains(attr)) {
                return true;
            }
        }
        return false;
    }

    private final boolean permittedKey(KeyObject key) {
        Attr attr = key.getAttr();
        int objID = key.getIdentObj().getObjectID();
        Set<Attr> attrs = permittedKeys.get(objID);
        if (attrs == null || !attrs.contains(attr)) {
            return false;
        }
        String graphicID = this.cvom.graphSettings.getId();
        Set<String> permittedGraphicIDsForObjID = permittedGraphicIDsForObjIDs.get(objID);
        if (permittedGraphicIDsForObjID == null || permittedGraphicIDsForObjID.contains(graphicID)) {
            Set<String> permittedGraphicIDsForAttr = permittedGraphicIDsForAttrs.get(attr);
            return permittedGraphicIDsForAttr == null || permittedGraphicIDsForAttr.contains(graphicID);
        }
        return false;
    }

    static {
        filterAttrs.add(Attr.PaintObject);
        filterAttrs.add(Attr.GroupLabel);
        filterAttrs.add(Attr.SeriesLabel);
        filterAttrs.add(Attr.AxisAssignment);
        filterAttrs.add(Attr.GradientPinLeftColor);
        filterAttrs.add(Attr.GradientPinRightColor);
        filterAttrs.add(Attr.GradientNumPins);
        filterAttrs.add(Attr.GradientPinPosition);
        filterAttrs.add(Attr.IgnoreSeries);
        filterAttrs.add(Attr.SeriesType);
        filterAttrs.add(Attr.ForceSeriesAbsolute);
        filterAttrs.add(Attr.CurveFitType);
        filterAttrs.add(Attr.Forecast);
        filterAttrs.add(Attr.LineDash);
        filterAttrs.add(Attr.IsPercentFormat);
        filterAttrs.add(Attr.GradientDirection);
        filterAttrs.add(Attr.GradientNumPins);
        filterAttrs.add(Attr.GradientPinLeftColor);
        filterAttrs.add(Attr.GradientPinPosition);
        filterAttrs.add(Attr.GradientPinRightColor);
        filterAttrs.add(Attr.TextureBGColor);
        filterAttrs.add(Attr.TextureDisplayMode);
        filterAttrs.add(Attr.TextureFlipMode);
        filterAttrs.add(Attr.TextureURL);
        filterSeriesGroupAttrs.add(Attr.PieSliceDetach);
        filterSeriesGroupAttrs.add(Attr.MarkerSize);
        filterSeriesGroupAttrs.add(Attr.MarkerShape);
        ArrayList<Attr> fontAttrs = new ArrayList<Attr>();
        ArrayList<Integer> axisIDs = new ArrayList<Integer>();
        ArrayList<Integer> axisGridIDs = new ArrayList<Integer>();
        ArrayList<Integer> textStringIDs = new ArrayList<Integer>();
        axisIDs.add(2001);
        axisIDs.add(2002);
        axisIDs.add(2003);
        axisIDs.add(2004);
        axisIDs.add(2005);
        axisIDs.add(2006);
        textStringIDs.add(5);
        textStringIDs.add(4);
        textStringIDs.add(3);
        textStringIDs.add(8);
        textStringIDs.add(9);
        textStringIDs.add(10);
        textStringIDs.add(6);
        textStringIDs.add(7);
        textStringIDs.add(11);
        textStringIDs.add(514);
        textStringIDs.add(518);
        textStringIDs.add(524);
        textStringIDs.add(528);
        textStringIDs.add(532);
        textStringIDs.add(568);
        axisGridIDs.add(1017);
        axisGridIDs.add(1018);
        axisGridIDs.add(1015);
        axisGridIDs.add(1016);
        axisGridIDs.add(1013);
        axisGridIDs.add(1014);
        axisGridIDs.add(2506);
        axisGridIDs.add(2507);
        axisGridIDs.add(515);
        axisGridIDs.add(516);
        axisGridIDs.add(519);
        axisGridIDs.add(520);
        axisGridIDs.add(525);
        axisGridIDs.add(526);
        axisGridIDs.add(529);
        axisGridIDs.add(530);
        axisGridIDs.add(533);
        axisGridIDs.add(534);
        axisGridIDs.add(569);
        axisGridIDs.add(570);
        fontAttrs.add(Attr.FontSizeInPoints);
        fontAttrs.add(Attr.FontName);
        fontAttrs.add(Attr.FillColor);
        fontAttrs.add(Attr.FontSizeAbsolute);
        fontAttrs.add(Attr.FontSizeVC);
        fontAttrs.add(Attr.FontStyle);
        fontAttrs.add(Attr.TransparentFillColor);
        QuickFilter.addPermittedKeys(2000, Attr.UsePGSDKTimeScaleAxis);
        QuickFilter.addPermittedKeys(2000, Attr.UseTimeScaleAxis);
        QuickFilter.addPermittedKeys(2000, Attr.DocumentHeightInTwips);
        QuickFilter.addPermittedKeys(2000, Attr.DocumentWidthInTwips);
        QuickFilter.addPermittedKeys(2000, Attr.DepthRadius);
        QuickFilter.addPermittedKeys(2000, Attr.PieDepth);
        QuickFilter.addPermittedKeys(2000, Attr.PieTilt);
        QuickFilter.addPermittedKeys(546, Attr.LeftInset);
        QuickFilter.addPermittedKeys(546, Attr.RightInset);
        QuickFilter.addPermittedKeys(546, Attr.TopInset);
        QuickFilter.addPermittedKeys(546, Attr.BottomInset);
        QuickFilter.addPermittedKeys(14, fontAttrs);
        QuickFilter.addPermittedKeys(textStringIDs, fontAttrs);
        QuickFilter.addPermittedKeys(12, Attr.Display);
        QuickFilter.addPermittedKeys(2000, Attr.LegendLabelType);
        QuickFilter.addPermittedKeys(2000, Attr.RiserWidth);
        QuickFilter.addPermittedKeys(1, Attr.FillColor);
        QuickFilter.addPermittedKeys(1, Attr.TransparentFillColor);
        QuickFilter.addPermittedKeys(2000, Attr.MarkerDisplay);
        QuickFilter.addPermittedKeys(2, Attr.PlaceResize);
        QuickFilter.addPermittedKeys(textStringIDs, Attr.TextString);
        QuickFilter.addPermittedKeys(axisGridIDs, Attr.Display);
        QuickFilter.addPermittedKeys(axisIDs, Attr.ScaleMaxAuto);
        QuickFilter.addPermittedKeys(axisIDs, Attr.ScaleMinAuto);
        QuickFilter.addPermittedKeys(axisIDs, Attr.ScaleMax);
        QuickFilter.addPermittedKeys(axisIDs, Attr.ScaleMin);
        QuickFilter.addPermittedKeys(axisIDs, Attr.ScaleMustIncludeZero);
        QuickFilter.addPermittedKeys(axisIDs, Attr.GridStep);
        QuickFilter.addPermittedKeys(axisIDs, Attr.GridStepAuto);
        QuickFilter.addPermittedKeys(2004, Attr.DataTextFormat);
        QuickFilter.addPermittedKeys(528, Attr.TextFormat);
        QuickFilter.addPermittedKeys(504, Attr.DataTextTemplate);
        QuickFilter.addPermittedKeys(2000, Attr.DataTextTemplateBubble);
        QuickFilter.addPermittedKeys(2000, Attr.DataTextTemplateScatter);
        QuickFilter.addPermittedKeys(2000, Attr.DataTextTemplateHiLo);
        QuickFilter.addPermittedKeys(2000, Attr.LegendPosition);
        ArrayList<Integer> O2axis = new ArrayList<Integer>(5);
        O2axis.add(9);
        O2axis.add(2002);
        O2axis.add(518);
        O2axis.add(519);
        O2axis.add(520);
        ArrayList<String> O2graphicIDs = new ArrayList<String>(3);
        O2graphicIDs.add("pfjgraphics/xy");
        O2graphicIDs.add("pfjgraphics/3d");
        O2graphicIDs.add("pfjgraphics/scatter");
        QuickFilter.addConditionallyPermittedObjectIDs(O2axis, O2graphicIDs);
        QuickFilter.addConditionallyPermittedAttr(Attr.PieDepth, "pfjgraphics/proportional");
        QuickFilter.addConditionallyPermittedAttr(Attr.PieTilt, "pfjgraphics/proportional");
        QuickFilter.addConditionallyPermittedAttr(Attr.RiserWidth, "pfjgraphics/xy");
        QuickFilter.addConditionallyPermittedAttr(Attr.RiserWidth, "pfjgraphics/scatter");
        QuickFilter.addConditionallyPermittedAttr(Attr.RiserWidth, "pfjgraphics/3d");
        QuickFilter.addConditionallyPermittedAttr(Attr.RiserWidth, "pfjgraphics/gantt");
        QuickFilter.addConditionallyPermittedAttr(Attr.RiserWidth, "pfjgraphics/stock");
        QuickFilter.addConditionallyPermittedAttr(Attr.DataTextTemplateScatter, "pfjgraphics/scatter");
        QuickFilter.addConditionallyPermittedAttr(Attr.DataTextTemplateBubble, "pfjgraphics/bubble");
        QuickFilter.addConditionallyPermittedAttr(Attr.DataTextTemplateHiLo, "pfjgraphics/stock");
        QuickFilter.addConditionallyPermittedAttr(Attr.LegendLabelType, "pfjgraphics/proportional");
    }
}

