/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility;

import java.awt.Point;
import java.awt.Polygon;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LineSegment {
    private final Point point1;
    private final Point point2;

    LineSegment(Point point1, Point point2) {
        this.point1 = point1;
        this.point2 = point2;
    }

    LineSegment(Polygon polygon, int i) {
        int npoints = polygon.npoints;
        int index1 = i % npoints;
        int index2 = (i + 1) % npoints;
        this.point1 = new Point(polygon.xpoints[index1], polygon.ypoints[index1]);
        this.point2 = new Point(polygon.xpoints[index2], polygon.ypoints[index2]);
    }

    public Point getPoint1() {
        return this.point1;
    }

    public Point getPoint2() {
        return this.point2;
    }

    public boolean equals(Object object) {
        LineSegment segment = (LineSegment)object;
        Point point1 = segment.getPoint1();
        Point point2 = segment.getPoint2();
        return this.point1.equals(point1) && this.point2.equals(point2) || this.point2.equals(point1) && this.point1.equals(point2);
    }

    public int hashCode() {
        return this.point1.hashCode() ^ this.point2.hashCode();
    }

    public LineSegment removeAdjacentSegment(List<LineSegment> segments) {
        for (int i = 0; i < segments.size(); ++i) {
            LineSegment segment = segments.get(i);
            if (!this.isAdjacentSegment(segment)) continue;
            segments.remove(i);
            if (this.point2.equals(segment.getPoint2())) {
                segment = this.getReversedSegment(segment);
            }
            return segment;
        }
        return null;
    }

    private boolean isAdjacentSegment(LineSegment segment) {
        Point point1 = segment.getPoint1();
        Point point2 = segment.getPoint2();
        return (this.point2.equals(point1) || this.point2.equals(point2) || this.point1.equals(point1) || this.point1.equals(point2)) && !segment.equals(this);
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.point1.x + "," + this.point1.y + ")--" + "(" + this.point2.x + "," + this.point2.y + ")";
    }

    public LineSegment getReversedSegment(LineSegment segment) {
        return new LineSegment(segment.getPoint2(), segment.getPoint1());
    }
}

