/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.export;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.PatternTable;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.UniversalPictureStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.IAdvFormatStructExporter;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PerspectiveBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.AxisInfo;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.Dict;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.GraphType3TF;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceMode;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.AnnotationType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.text.Format;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PerspectiveHandler {
    private final Perspective m_p;
    private final JGraphType m_jgt;
    private final GraphType3TF m_gt3TF;
    public static final double xRevScale = 1.0239375;
    public static final double yRevScale = 1.0239375;
    private static final short default_short = 0;
    private static final short default_short_2 = 2;

    PerspectiveHandler(Perspective p) {
        this.m_p = p;
        this.m_jgt = this.m_p.getJGraphType();
        this.m_gt3TF = GraphType3TF.getGraphType3TF(this.m_jgt.getIntegerGraphType());
    }

    public short toShort(boolean val) {
        return (short)(val ? 1 : 0);
    }

    short getGraphType() {
        return this.m_gt3TF.getMajor();
    }

    short getGraphSubType() {
        return this.m_gt3TF.getMinor();
    }

    short getDataFormatID() {
        return this.m_gt3TF.getDataFormat();
    }

    String getGraphName() {
        short gt = this.getGraphType();
        if (gt < 0 || gt > Dict.GraphTypes.length) {
            System.err.println("WARNING: wrong graph type");
            return "";
        }
        return Dict.GraphTypes[gt];
    }

    Rectangle getDataRange() {
        Rectangle res = this.m_p.getDataRect();
        return res;
    }

    IdentObj getDefaultLine() {
        return IdentObj.GLOBAL;
    }

    IdentObj getDefaultFont() {
        return IdentObj.GLOBAL;
    }

    double getDataValue(int nPage, int nRow, int nCol) {
        double dValue = this.m_p.getDataAsDouble(nRow, nCol);
        return dValue;
    }

    short getAXISLINES_ON_TOP() {
        return 0;
    }

    short getB3DLEGENDWANTED() {
        return 0;
    }

    short getBMANUALPICTOGRAPHSCALE() {
        return 0;
    }

    short getBSHOW_DATATABLE() {
        return 0;
    }

    short getBSHOW_LEGEND_QUALITYOBJECT() {
        return 0;
    }

    short getBSHOW_QUALITYOBJECT() {
        return 0;
    }

    short getBSHOWVOLUME_STOCKCHART() {
        return 0;
    }

    short getDEFAULT_LEGEND_POSITION() {
        return 2;
    }

    short getDLOOK_BAXISSWAP() {
        return 0;
    }

    short getDLOOK_BCOLREVERSE() {
        return 0;
    }

    short getDLOOK_BCOMPLEXDATARANGE() {
        return 0;
    }

    short getDLOOK_BROWREVERSE() {
        return 0;
    }

    short getDLOOK_BVERTFORMAT() {
        return 0;
    }

    short getDLOOK_BXYY() {
        return 0;
    }

    short getDLOOK_CFOOTNOTE() {
        return 0;
    }

    short getDLOOK_CGROUPSHEADER() {
        return 0;
    }

    short getDLOOK_CGROUPSTITLE() {
        return 0;
    }

    short getDLOOK_CSERIESHEADER() {
        return 0;
    }

    short getDLOOK_CSERIESTITLE() {
        return 0;
    }

    short getDLOOK_CSUBTITLE() {
        return 0;
    }

    short getDLOOK_CTITLE() {
        return 0;
    }

    short getDLOOK_CY1TITLE() {
        return 0;
    }

    short getDLOOK_CY2TITLE() {
        return 0;
    }

    short getDLOOK_CY3TITLE() {
        return 0;
    }

    short getDLOOK_CY4TITLE() {
        return 0;
    }

    short getDLOOK_NDATAFORMATID() {
        return 0;
    }

    short getDLOOK_NSTDFORMATLBL() {
        return 0;
    }

    short getDLOOK_NSTDFORMATSUM() {
        return 0;
    }

    short getDLOOK_RFOOTNOTE() {
        return 0;
    }

    short getDLOOK_RGROUPSHEADER() {
        return 0;
    }

    short getDLOOK_RGROUPSTITLE() {
        return 0;
    }

    short getDLOOK_RSERIESHEADER() {
        return 0;
    }

    short getDLOOK_RSERIESTITLE() {
        return 0;
    }

    short getDLOOK_RSUBTITLE() {
        return 0;
    }

    short getDLOOK_RTITLE() {
        return 0;
    }

    short getDLOOK_RY1TITLE() {
        return 0;
    }

    short getDLOOK_RY2TITLE() {
        return 0;
    }

    short getDLOOK_RY3TITLE() {
        return 0;
    }

    short getDLOOK_RY4TITLE() {
        return 0;
    }

    short getGRAPH_BADJUSTFRAMEFORY1TITLE() {
        return 0;
    }

    short getGRAPH_BAUTOCOLORBYROW() {
        if (this.m_p.getColorMode() == 0) {
            return 1;
        }
        return 0;
    }

    short getGRAPH_BCONNECTSTACKBARS() {
        return this.toShort(this.m_p.getDisplay(Identity.StackedConnectorLines));
    }

    short getGRAPH_BNEEDDRYRUN() {
        return 0;
    }

    short getGRAPH_BW() {
        return 0;
    }

    short getGRAPH_BWARNING() {
        return 0;
    }

    short getGRAPH_DPIRESOLUTION() {
        return 0;
    }

    short getGRAPH_NERRORCLASS() {
        return 0;
    }

    short getGRAPH_NERRORID() {
        return 0;
    }

    short getGRAPH_NPAGE() {
        return 0;
    }

    short getGRAPH_NPREVGRAPHITEM() {
        return 0;
    }

    short getGRAPH_NPREVGRAPHMENU() {
        return 0;
    }

    short getGRAPH_NQDRTHRESHOLD() {
        return 0;
    }

    short getGRAPH_NUNDOSTATUS() {
        return 0;
    }

    short getGRAPH_PPA_LEGEND_MARKER_LAYOUT() {
        return 0;
    }

    short getGRAPH_RESOLUTIONUNITS() {
        return 0;
    }

    short getGRAPH_UPDATE3D() {
        return 0;
    }

    short getGRIDLINES_ON_TOP() {
        return 0;
    }

    short getIGNOREDEPTHINFRAME() {
        return 0;
    }

    short getLEGEND_MARKER_ORIENTATION() {
        return 0;
    }

    short getLEGEND_ROWS() {
        return 0;
    }

    short getLOCKED_LEGEND() {
        return 0;
    }

    short getLOCKEDSIZE() {
        return 0;
    }

    short getADV3D_2DDOFRAMEFOOT() {
        return 0;
    }

    short getADV3D_2DDOMARGINS() {
        return 0;
    }

    short getADV3D_ANTIALIAS() {
        return 0;
    }

    short getADV3D_DO3DCHART() {
        return 0;
    }

    short getADV3D_DO3DTITLES() {
        return 0;
    }

    short getADV3D_DROPSHADOW() {
        return 0;
    }

    short getADV3D_HIFIOBJS() {
        return 0;
    }

    short getADV3D_LOFTSHAPE() {
        return 0;
    }

    short getADV3D_PEDGETYPE() {
        return 0;
    }

    short getADV3D_PFEELERTYPE() {
        return 0;
    }

    short getADV3D_PTINTLABELS() {
        return 0;
    }

    short getADV3D_TEMP() {
        return 0;
    }

    short getAutoshading() {
        return this.toShort(this.m_p.getAutoshading());
    }

    short getBCOLORBYROW() {
        int colorMode = this.m_p.getColorMode();
        if (colorMode == 0) {
            colorMode = this.m_p.getEffectiveColorModeEstimate();
        }
        switch (colorMode) {
            default: {
                return 1;
            }
            case 2: 
        }
        return 0;
    }

    short getBCURVECOLORASSERIES() {
        return this.toShort(this.m_p.getTrendlineSettings().getColorAsSeries());
    }

    short getBFROMZERO() {
        return 0;
    }

    short getBISBIPOLAR() {
        return this.toShort(this.m_gt3TF.getIsBiPolar());
    }

    short getBISDUALY() {
        return this.toShort(this.m_gt3TF.getIsDualY());
    }

    short getBLEGENDWANTED() {
        return this.toShort(this.m_p.getLegendDisplay());
    }

    short getBSHOWERRORBARS() {
        return 0;
    }

    short getBSHOWERRORBARS_X() {
        return 0;
    }

    short getBSICMOVAVG() {
        return this.toShort(this.m_p.getTrendlineSettings().getSciMovAvg());
    }

    short getBUNIFORMRISERBORDERS() {
        return 1;
    }

    short getBUNIFORMRISERSHAPES() {
        return 0;
    }

    short getDRAWBASE() {
        return this.toShort(this.m_p.getScaleFromZero());
    }

    short getERISERSHAPE() {
        return 0;
    }

    short getGRAPHBYWHAT() {
        return 0;
    }

    short getISSAFEANGLE() {
        return 0;
    }

    short getMISCHIGH() {
        return 0;
    }

    short getNAREA() {
        return 0;
    }

    short getNCURCOLOR() {
        return 0;
    }

    short getNCURVEMOVING() {
        return (short)this.m_p.getTrendlineSettings().getCurveMoving();
    }

    short getNCURVESMOOTH() {
        return (short)this.m_p.getTrendlineSettings().getSmoothFactor();
    }

    short getNCURVEVERT() {
        return 0;
    }

    short getND() {
        return this.m_jgt.is3DType() ? (short)3 : 2;
    }

    short getNENDGRPTHICK() {
        return 0;
    }

    short getNERRORBARSIZE() {
        return 0;
    }

    short getNFRAMETABLEHIGH() {
        return 0;
    }

    short getNFRAMETABLELOW() {
        return 0;
    }

    short getNGRAPHTYPE() {
        return 0;
    }

    short getNINTERGRPTHICK() {
        return 0;
    }

    short getNINTRAGRPTHICK() {
        return 0;
    }

    short getNLEGENDELEMENTS() {
        return (short)this.m_p.getLegendMarkersPerRow();
    }

    short getNLEGENDLAYOUT() {
        switch (this.m_p.getLegendLabelType()) {
            case 1: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    short getNMARKERSIZE() {
        return 0;
    }

    short getNSHOWQDRLABELS() {
        short show = 0;
        if (this.m_p.dataTextTemplateMatchesMacro("[Y]") || this.m_p.dataTextTemplateMatchesMacro("[X]") || this.m_p.dataTextTemplateMatchesMacro("[DATA]") || this.m_p.dataTextTemplateMatchesMacro("[TIME]")) {
            show = (short)(show | 1);
        }
        if (this.m_p.dataTextTemplateMatchesMacro("[OPEN]") || this.m_p.dataTextTemplateMatchesMacro("[CLOSE]") || this.m_p.dataTextTemplateMatchesMacro("[HIGH]") || this.m_p.dataTextTemplateMatchesMacro("[LOW]")) {
            show = (short)(show | 5);
        }
        if (this.m_p.dataTextTemplateMatchesMacro("[SERIES]")) {
            show = (short)(show | 2);
        }
        if (this.m_p.dataTextTemplateMatchesMacro("[SIZE]")) {
            show = (short)(show | 0x10);
        }
        if (!this.m_p.getStackedDataValueSum()) {
            show = (short)(show | 4);
        }
        if (this.m_p.getPercentValueFormat() == 1) {
            show = (short)(show | 0x20);
        }
        if (this.m_p.getShowTotalsDisplay()) {
            show = (short)(show | 8);
        }
        if (this.m_p.getDisplay(Identity.DataTextStackedTotalOnTop)) {
            show = (short)(show | 8);
        }
        show = (short)(show | 0x100);
        return show;
    }

    short getNTCBOXES() {
        return 0;
    }

    short getNTCFONTS() {
        return 0;
    }

    short getPICTQUALITY() {
        return 0;
    }

    short getRISERDROPNESS() {
        return 0;
    }

    short getTEXTQUALITY() {
        return 0;
    }

    short getWANTAUTOFIT() {
        return 0;
    }

    short getWIREFRAME() {
        return 0;
    }

    short getXPAN() {
        return (short)this.m_p.getCubePanX();
    }

    short getYPAN() {
        return (short)this.m_p.getCubePanY();
    }

    Point3d get3DViewerPoint() {
        return new Point3d(this.m_p.getCubeViewerX(), this.m_p.getCubeViewerY(), -this.m_p.getCubeViewerZ());
    }

    Point3d getCubeSize() {
        return new Point3d(this.m_p.getCubeSizeX(), this.m_p.getCubeSizeY(), this.m_p.getCubeSizeZ());
    }

    Point3d getCubeWallThickness() {
        return new Point3d(this.m_p.getCubeWallThickX(), this.m_p.getCubeWallThickY(), this.m_p.getCubeWallThickZ());
    }

    double[][] get3DTransformMatrix() {
        double[][] m = new double[4][3];
        Matrix3d r = this.m_p.getCubeRotationMatrix();
        m[0][0] = r.m00;
        m[0][1] = r.m01;
        m[0][2] = -r.m02;
        m[1][0] = r.m10;
        m[1][1] = r.m11;
        m[1][2] = -r.m12;
        m[2][0] = -r.m20;
        m[2][1] = -r.m21;
        m[2][2] = r.m22;
        m[3][0] = this.m_p.getCubeTranslationX();
        m[3][1] = this.m_p.getCubeTranslationY();
        m[3][2] = -this.m_p.getCubeTranslationZ();
        return m;
    }

    short getPIE_EXTRUSION_MODE() {
        return 0;
    }

    short getPOLAR_CONNECT_FIRSTLAST() {
        return 0;
    }

    short getREVERSE_PROGRESSION_ARROW() {
        return 0;
    }

    short getSERIES_LABELS_ON_CHART() {
        return 0;
    }

    short getSHOW_PROGRESSION_ARROW() {
        return 0;
    }

    short getSHOW_QUALITYAXIS_X() {
        return 0;
    }

    short getSHOW_QUALITYAXIS_Y1() {
        return 0;
    }

    short getSHOW_QUALITYAXIS_Y2() {
        return 0;
    }

    short getSPLITY_POSITION() {
        return 0;
    }

    short getSTRING_ENCODING() {
        return 0;
    }

    short getSYMBOLSTYLE_STOCKCHART() {
        return 0;
    }

    short getTCLOOK_BCOLMARKERS() {
        return 0;
    }

    short getTCLOOK_BEXTENDEDSTRIPES() {
        return 0;
    }

    short getTCLOOK_BROWMARKERS() {
        return 0;
    }

    short getTCLOOK_BUNIFORMCOLS() {
        return 0;
    }

    short getTCLOOK_BUNIFORMROWS() {
        return 0;
    }

    short getTCLOOK_NACTIVESTRIPES() {
        return 0;
    }

    short getTCLOOK_NCOLORSKIP() {
        return 0;
    }

    short getTCLOOK_NLINESKIP() {
        return 0;
    }

    short getTCLOOK_STRIPESTYLE() {
        return 0;
    }

    short getTEXTOBJECT_NTCTEXTS() {
        return 0;
    }

    short getTHUMBNAIL_IMAGEPIXELHEIGHT() {
        return 0;
    }

    short getTHUMBNAIL_IMAGEPIXELWIDTH() {
        return 0;
    }

    short getVDM_BSYMMETRIC() {
        return 0;
    }

    short getVDM_NDIMENSIONCOUNT() {
        return 0;
    }

    short getVDM_NPAGECOUNT() {
        return 0;
    }

    short getVDM_VERSION() {
        return 0;
    }

    short getVOLUMESTYLE_STOCKCHART() {
        return 0;
    }

    Color STUB_getColor() {
        return Color.gray;
    }

    short STUB_getPattern() {
        return 0;
    }

    short getSerDepLookCount() {
        return 1;
    }

    String getTextString(IdentObj id) {
        return this.m_p.getTextString(id);
    }

    String getTitle() {
        return this.m_p.getTextString(Identity.Title);
    }

    String getSubTitle() {
        return this.m_p.getTextString(Identity.Subtitle);
    }

    String getFootnote() {
        return this.m_p.getTextString(Identity.Footnote);
    }

    String getO1Title() {
        return this.m_p.getTextString(Identity.O1Title);
    }

    String getO2Title() {
        return this.m_p.getTextString(Identity.O2Title);
    }

    String getX1Title() {
        return this.m_p.getTextString(Identity.X1Title);
    }

    String getY1Title() {
        return this.m_p.getTextString(Identity.Y1Title);
    }

    String getY2Title() {
        return this.m_p.getTextString(Identity.Y2Title);
    }

    String getY3Title() {
        return this.m_p.getTextString(Identity.Y3Title);
    }

    String getY4Title() {
        return this.m_p.getTextString(Identity.Y4Title);
    }

    String getX1Label() {
        return this.m_p.getTextString(Identity.X1Label);
    }

    String getY1Label() {
        return this.m_p.getTextString(Identity.Y1Label);
    }

    String getY2Label() {
        return this.m_p.getTextString(Identity.Y2Label);
    }

    String getY3Label() {
        return this.m_p.getTextString(Identity.Y3Label);
    }

    String getSeriesLabel(int page, int series) {
        return this.m_p.getSeriesLabel(series);
    }

    String getGroupLabel(int page, int group) {
        return this.m_p.getGroupLabel(group);
    }

    IdentObj getTitleID() {
        return Identity.Title;
    }

    IdentObj getSubTitleID() {
        return Identity.Subtitle;
    }

    IdentObj getFootnoteID() {
        return Identity.Footnote;
    }

    IdentObj getLegendTitleID() {
        return Identity.LegendTitle;
    }

    IdentObj getHeader1Font() {
        if (this.m_jgt.isGaugeType()) {
            return this.m_p.getGaugeTitle();
        }
        if (this.m_jgt.isPieType()) {
            return Identity.PieGroupLabel;
        }
        if (this.m_jgt.isFunnelType()) {
            return Identity.FunnelGroupLabel;
        }
        return this.m_p.getGroup(0);
    }

    IdentObj getHeader2Font() {
        if (this.m_p.isX1AxisPresent()) {
            return Identity.X1Label;
        }
        return Identity.O1Label;
    }

    IdentObj getHeader3Font() {
        return Identity.Y2Label;
    }

    IdentObj getHeader4Font() {
        return Identity.LegendText;
    }

    IdentObj getLabel1Font() {
        if (this.m_jgt.isPieType()) {
            return Identity.PieSliceLabel;
        }
        if (this.m_jgt.isFunnelType()) {
            return Identity.FunnelSliceLabel;
        }
        return Identity.DataText;
    }

    IdentObj getLabel2Font() {
        if (this.m_jgt.isBubble()) {
            return Identity.X1Label;
        }
        if (this.m_jgt.isPieType()) {
            return Identity.PieSliceValueLabel;
        }
        if (this.m_jgt.isFunnelType()) {
            return Identity.FunnelValueLabel;
        }
        return Identity.X1Label;
    }

    IdentObj getLabel3Font() {
        if (this.m_jgt.isPieType()) {
            return Identity.PieRingLabel;
        }
        if (this.m_jgt.isGaugeType()) {
            return this.m_p.getGaugeLabel();
        }
        return Identity.Y1Label;
    }

    IdentObj getX1TitleID() {
        return Identity.X1Title;
    }

    IdentObj getY1TitleID() {
        return Identity.Y1Title;
    }

    IdentObj getY2TitleID() {
        return Identity.Y2Title;
    }

    IdentObj getY3TitleID() {
        return Identity.Y3Title;
    }

    IdentObj getY4TitleID() {
        return Identity.Y4Title;
    }

    IdentObj getO1orX1TitleID() {
        if (this.m_p.isO1AxisPresent()) {
            return Identity.O1Title;
        }
        return Identity.X1Title;
    }

    IdentObj getO1TitleID() {
        return Identity.O1Title;
    }

    IdentObj getO2TitleID() {
        return Identity.O2Title;
    }

    IdentObj getY1AxisID() {
        return Identity.Y1Axis;
    }

    IdentObj getY2AxisID() {
        return Identity.Y2Axis;
    }

    IdentObj getY3AxisID() {
        return Identity.Y3Axis;
    }

    IdentObj getY4AxisID() {
        return Identity.Y4Axis;
    }

    IdentObj getX1AxisID() {
        return Identity.X1Axis;
    }

    IdentObj getO1AxisID() {
        return Identity.O1Axis;
    }

    IdentObj getO2AxisID() {
        return Identity.O2Axis;
    }

    IdentObj getY1AxisLineID() {
        return Identity.Y1AxisLine;
    }

    IdentObj getY2AxisLineID() {
        return Identity.Y2AxisLine;
    }

    IdentObj getY3AxisLineID() {
        return Identity.Y3AxisLine;
    }

    IdentObj getY4AxisLineID() {
        return Identity.Y4AxisLine;
    }

    IdentObj getX1AxisLineID() {
        return Identity.X1AxisLine;
    }

    IdentObj getO1AxisLineID() {
        return Identity.O1AxisLine;
    }

    IdentObj getO2AxisLineID() {
        return Identity.O2AxisLine;
    }

    IdentObj getY1LabelID() {
        return Identity.Y1Label;
    }

    IdentObj getY2LabelID() {
        return Identity.Y2Label;
    }

    IdentObj getY3LabelID() {
        return Identity.Y3Label;
    }

    IdentObj getY4LabelID() {
        return Identity.Y4Label;
    }

    IdentObj getX1LabelID() {
        return Identity.X1Label;
    }

    IdentObj getO1LabelID() {
        return Identity.O1Label;
    }

    IdentObj getO2LabelID() {
        return Identity.O2Label;
    }

    IdentObj getY1MajorGridID() {
        return Identity.Y1MajorGrid;
    }

    IdentObj getY2MajorGridID() {
        return Identity.Y2MajorGrid;
    }

    IdentObj getY3MajorGridID() {
        return Identity.Y3MajorGrid;
    }

    IdentObj getY4MajorGridID() {
        return Identity.Y4MajorGrid;
    }

    IdentObj getX1MajorGridID() {
        return Identity.X1MajorGrid;
    }

    IdentObj getO1MajorGridID() {
        return Identity.O1MajorGrid;
    }

    IdentObj getO2MajorGridID() {
        return Identity.O2MajorGrid;
    }

    IdentObj getY1MinorGridID() {
        return Identity.Y1MinorGrid;
    }

    IdentObj getY2MinorGridID() {
        return Identity.Y2MinorGrid;
    }

    IdentObj getY3MinorGridID() {
        return Identity.Y3MinorGrid;
    }

    IdentObj getY4MinorGridID() {
        return Identity.Y4MinorGrid;
    }

    IdentObj getX1MinorGridID() {
        return Identity.X1MinorGrid;
    }

    IdentObj getO1MinorGridID() {
        return Identity.O1MinorGrid;
    }

    IdentObj getO2MinorGridID() {
        return Identity.O2MinorGrid;
    }

    IdentObj getY1ZeroLineID() {
        return Identity.Y1ZeroLine;
    }

    IdentObj getY2ZeroLineID() {
        return Identity.Y2ZeroLine;
    }

    IdentObj getY3ZeroLineID() {
        return Identity.Y3ZeroLine;
    }

    IdentObj getY4ZeroLineID() {
        return Identity.Y4ZeroLine;
    }

    IdentObj getX1ZeroLineID() {
        return Identity.X1ZeroLine;
    }

    IdentObj getO1ZeroLineID() {
        return IdentObj.GLOBAL;
    }

    IdentObj getO2ZeroLineID() {
        return IdentObj.GLOBAL;
    }

    IdentObj getCubeRiserGridX() {
        return Identity.CubeRiserGridX;
    }

    IdentObj getCubeRiserGridY() {
        return Identity.CubeRiserGridY;
    }

    IdentObj getCubeRiserGridZ() {
        return Identity.CubeRiserGridZ;
    }

    double getLineWidthInPoints(IdentObj id) {
        double width = this.m_p.getLineWidthPts(id);
        if (width <= 0.0 && this.m_p.getDisplay(id)) {
            return 0.33;
        }
        return width;
    }

    float getFontSizeInPoints(IdentObj id) {
        return this.m_p.getFontSizeInPoints(id);
    }

    float getFontSizeInPixels(IdentObj id) {
        if (!this.m_p.getFontSizeAbsolute(id)) {
            VC theVC = this.m_p.getVC();
            return theVC.virtToDestHeight(this.m_p.getFontSizeVC(id));
        }
        return this.m_p.getFontSize(id);
    }

    short getFontSizeVC(IdentObj id) {
        if (this.m_p.getFontSizeAbsolute(id)) {
            double fontSizeTwips = this.m_p.getFontSizeInPoints(id) * 20.0f;
            double fontSizeVC = fontSizeTwips / (double)this.m_p.getDocumentHeightInTwips() * 32000.0 * 1.0239375;
            return (short)fontSizeVC;
        }
        return (short)((double)this.m_p.getFontSizeVC(id) * 1.0239375);
    }

    Color getFillColor(IdentObj id) {
        return this.m_p.getFillColor(id);
    }

    boolean getDisplay(IdentObj id) {
        return this.m_p.getDisplay(id);
    }

    short getFont3DDisplay(IdentObj id, int nIndex) {
        if (id.equals(Identity.Y1Label) && nIndex == 2 && this.m_p.getY1AxisSide() == 1) {
            return 0;
        }
        if (id.equals(Identity.Y1Label) && nIndex == 3 && this.m_p.getY1AxisSide() == 0) {
            return 0;
        }
        return this.toShort(this.m_p.getDisplay(id));
    }

    short getDisplayVal(IdentObj id) {
        return this.toShort(this.m_p.getDisplay(id));
    }

    Color getBorderColor(IdentObj id) {
        return this.m_p.getBorderColor(id);
    }

    short getTextFace(IdentObj id) {
        int style = this.m_p.getFontStyle(id);
        short style3tf = 0;
        if (0 != (style & 1)) {
            style3tf = (short)(style3tf | 2);
        }
        if (0 != (style & 2)) {
            style3tf = (short)(style3tf | 1);
        }
        if (0 != (style & 4)) {
            style3tf = (short)(style3tf | 4);
        }
        if (this.m_p.getTextStrikethrough(id)) {
            style3tf = (short)(style3tf | 8);
        }
        return style3tf;
    }

    short getTextRotation(IdentObj id) {
        switch (this.m_p.getTextRotation(id)) {
            case 1: {
                return 8;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 64;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 128;
            }
        }
        return 0;
    }

    short getTextJustHoriz(IdentObj id) {
        return (short)this.m_p.getTextJustHoriz(id);
    }

    short getTextJustVert(IdentObj id) {
        return (short)this.m_p.getTextJustVert(id);
    }

    String getFontName(IdentObj id) {
        return this.m_p.getFontName(id);
    }

    int getNumTotalSeries() {
        return this.m_p.getNumTotalSeries();
    }

    int getSeriesLooping() {
        return this.m_p.getSeriesLooping();
    }

    short getDepthRadius() {
        return (short)this.m_p.getDepthRadius();
    }

    short getDataLineThickness() {
        return (short)this.m_p.getDataLineThickness();
    }

    IdentObj getSeriesID(short series) {
        return this.m_p.getSeries(series);
    }

    Color getSeriesColor(short series) {
        return this.m_p.getFillColor(this.m_p.getSeries(series));
    }

    Color getSeriesBorderColor(short series) {
        return this.m_p.getBorderColor(this.m_p.getSeries(series));
    }

    IdentObj getChartBackground() {
        return Identity.ChartBackground;
    }

    short getAxisSide(IdentObj id) {
        return (short)this.m_p.getAxisSide(id);
    }

    short getTickStep(IdentObj id) {
        return (short)this.m_p.getTickStep(id);
    }

    double getGridStep(IdentObj id) {
        return this.m_p.getGridStep(id);
    }

    boolean getGridStepAuto(IdentObj id) {
        return this.m_p.getGridStepAuto(id);
    }

    short getAxisDescending(IdentObj id) {
        if (id.equals(Identity.X1Axis) && this.m_jgt.isGaugeType()) {
            return this.toShort(this.m_p.getGaugeDescending());
        }
        return this.toShort(this.m_p.getAxisDescending(id));
    }

    double getLabelStagger(IdentObj id) {
        return this.toShort(this.m_p.getLabelStagger(id));
    }

    short getDisplay3DLeftWall() {
        return this.toShort(this.m_p.getDisplay3DLeftWall());
    }

    short getDisplay3DRightWall() {
        return this.toShort(this.m_p.getDisplay3DRightWall());
    }

    short getDisplay3DFloor() {
        return this.toShort(this.m_p.getDisplay3DFloor());
    }

    short getGrid3DLeftWallDisplayY() {
        return this.toShort(this.m_p.getGrid3DLeftWallDisplayY());
    }

    short getGrid3DLeftWallDisplayZ() {
        return this.toShort(this.m_p.getGrid3DLeftWallDisplayZ());
    }

    short getGrid3DFloorDisplayX() {
        return this.toShort(this.m_p.getGrid3DFloorDisplayX());
    }

    short getGrid3DFloorDisplayZ() {
        return this.toShort(this.m_p.getGrid3DFloorDisplayZ());
    }

    short getGrid3DRightWallDisplayX() {
        return this.toShort(this.m_p.getGrid3DRightWallDisplayX());
    }

    short getGrid3DRightWallDisplayY() {
        return this.toShort(this.m_p.getGrid3DRightWallDisplayY());
    }

    int getMaxNumAnnotations() {
        return this.m_p.getMaxNumAnnotations();
    }

    IdentObj getAnnotation(int index) {
        return this.m_p.getAnnotation(index);
    }

    IdentObj getColorByHeight() {
        return Identity.ColorByHeight;
    }

    Color getGradientPinRightColor(IdentObj id, int nIndex) {
        return this.m_p.getGradientPinRightColor(id, nIndex);
    }

    Color getGradientPinLeftColor(IdentObj id, int nIndex) {
        return this.m_p.getGradientPinLeftColor(id, nIndex);
    }

    short getBLADepth() {
        return (short)this.m_p.getDepthRadius();
    }

    short getBLADepthAngle() {
        return (short)this.m_p.getDepthAngle();
    }

    short getColorMode() {
        short colorModel;
        switch (this.m_p.getColorMode()) {
            case 1: {
                colorModel = 1;
                break;
            }
            case 2: {
                colorModel = 2;
                break;
            }
            case 3: {
                colorModel = 4;
                break;
            }
            case 0: {
                colorModel = (short)this.m_p.getEffectiveColorModeEstimate();
                break;
            }
            default: {
                colorModel = 1;
            }
        }
        return colorModel;
    }

    short getAxisSwap() {
        return this.toShort(!this.m_p.getSeriesAreRows());
    }

    short getReverseSeries() {
        return this.toShort(this.m_p.getReverseSeries());
    }

    short getReverseGroups() {
        return this.toShort(this.m_p.getReverseGroups());
    }

    short getDataTextPosition(IdentObj id) {
        short position;
        if (id.equals(this.getO1AxisID()) || id.equals(this.getO2AxisID())) {
            return 0;
        }
        int pfjPosition = id.equals(this.getX1AxisID()) ? this.m_p.getDataTextPositionSecondary() : this.m_p.getDataTextPosition();
        switch (pfjPosition) {
            case 1: {
                position = 4;
                break;
            }
            case 3: {
                position = 3;
                break;
            }
            case 4: {
                position = 0;
                break;
            }
            case 5: {
                position = 2;
                break;
            }
            case 8: {
                position = 1;
                break;
            }
            default: {
                position = 0;
            }
        }
        return position;
    }

    boolean getUseTextBackgroundColor(IdentObj id) {
        return this.m_p.getUseTextBackgroundColor(id);
    }

    Color getTextBackgroundColor(IdentObj id) {
        return this.m_p.getTextBackgroundColor(id);
    }

    short getScaleEnd(IdentObj idLabel) {
        short scaleEnd = 0;
        if (this.m_p.getExcludeMinLabel(idLabel)) {
            scaleEnd = (short)(scaleEnd | 2);
        }
        if (this.m_p.getExcludeMaxLabel(idLabel)) {
            scaleEnd = (short)(scaleEnd | 1);
        }
        return scaleEnd;
    }

    short getDataLineType(int nSeriesID) {
        short nDataLineType = 0;
        if (this.m_p.getMarkerDisplay(nSeriesID)) {
            nDataLineType = (short)(nDataLineType | 1);
        }
        if (!(this.m_jgt.isScatter() || this.m_jgt.isBubble() || this.m_jgt.isPolar())) {
            if (this.m_p.getConnectLineMarkers(nSeriesID)) {
                nDataLineType = (short)(nDataLineType | 2);
            } else if (this.m_jgt.isScatter() && this.m_p.getConnectScatterMarkers()) {
                nDataLineType = (short)(nDataLineType | 2);
            }
        }
        return nDataLineType;
    }

    short getRiserShape(int series) {
        switch (this.m_p.getMarkerShape(this.m_p.getSeries(series))) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.m_p.getBorderType(this.m_p.getLegendMarker(series)) == 3) {
                    return 41;
                }
                if (this.m_p.getBorderType(this.m_p.getLegendMarker(series)) == 2) {
                    return 40;
                }
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 13;
            }
            case 8: {
                return 17;
            }
            case 9: {
                return 18;
            }
            case 10: {
                return 27;
            }
            case 11: {
                return 25;
            }
            case 12: {
                return 7;
            }
            case 13: {
                return 37;
            }
            case 14: {
                return 38;
            }
            case 15: {
                return 32;
            }
            case 16: {
                return 48;
            }
            case 17: {
                return 10;
            }
            case 18: {
                return 2;
            }
        }
        return 1;
    }

    boolean getSquareMarkers() {
        return true;
    }

    boolean getAutofit(IdentObj id) {
        return this.m_p.getAutofit(id);
    }

    boolean getLogScale(IdentObj id) {
        return this.m_p.getLogScale(id);
    }

    double getScaleMin(IdentObj id) {
        return this.m_p.getScaleMin(id);
    }

    double getScaleMax(IdentObj id) {
        return this.m_p.getScaleMax(id);
    }

    short getManualScale(IdentObj id) {
        if (this.m_p.getScaleMinAuto(id)) {
            if (this.m_p.getScaleMaxAuto(id)) {
                return 0;
            }
            return 3;
        }
        if (this.m_p.getScaleMaxAuto(id)) {
            return 2;
        }
        return 1;
    }

    short getScaleFromZero() {
        return this.toShort(!this.m_p.getScaleFromZero());
    }

    short getAutoExcludeZero(IdentObj id) {
        return this.toShort(!this.m_p.getScaleMustIncludeZero(id));
    }

    short getShowOffScale(IdentObj id) {
        return this.toShort(this.m_p.getDisplayOffScale(id));
    }

    Rectangle getRect(IdentObj id) {
        return this.m_p.getRect(id);
    }

    Rectangle getShiftedRect(IdentObj id) {
        Rectangle r = new Rectangle(this.m_p.getRect(id));
        if (this.m_jgt.wantDepthEffect()) {
            int depthAngle = this.m_p.getDepthAngle();
            int depthRadius = this.m_p.getDepthRadius();
            double radius = depthRadius * 10;
            int dx = (int)(radius * Math.cos((double)depthAngle * (Math.PI / 180)));
            int dy = (int)(radius * Math.sin((double)depthAngle * (Math.PI / 180)));
            r.x -= dx;
            r.y -= dy;
        }
        return r;
    }

    IdentObj getFrame() {
        if (this.m_jgt.isPieType()) {
            return Identity.PieFrame;
        }
        return Identity.Frame;
    }

    IdentObj getLegendArea() {
        return Identity.LegendArea;
    }

    IdentObj getArea2DObject(short index) {
        switch (index) {
            case 1: {
                return Identity.ChartBackground;
            }
            case 2: {
                return Identity.LegendArea;
            }
            case 3: {
                return this.getFrame();
            }
            case 28: {
                return Identity.CubeFloor;
            }
        }
        return IdentObj.GLOBAL;
    }

    IdentObj getFont3DObject(short index) {
        switch (index) {
            case 0: {
                return Identity.O2Label;
            }
            case 1: {
                return Identity.O1Label;
            }
            case 2: {
                return Identity.Y1Label;
            }
            case 3: {
                return Identity.Y1Label;
            }
            case 4: {
                return Identity.O2Title;
            }
            case 5: {
                return Identity.O1Title;
            }
            case 6: {
                return Identity.Y1Title;
            }
            case 7: {
                return Identity.Y2Title;
            }
        }
        return Identity.Y1Label;
    }

    IdentObj getLine2DObject(short index) {
        switch (index) {
            case 0: {
                return Identity.ChartBackground;
            }
            case 2: {
                return Identity.FrameSeparator;
            }
            case 21: {
                return this.getFrame();
            }
            case 35: {
                return Identity.LegendArea;
            }
            case 30: {
                return Identity.X1AxisLine;
            }
            case 25: {
                return this.shouldSwapMajorMinorGridlines(Identity.O1MajorGrid) ? Identity.O1MinorGrid : Identity.O1MajorGrid;
            }
            case 27: {
                return this.shouldSwapMajorMinorGridlines(Identity.O1MinorGrid) ? Identity.O1MajorGrid : Identity.O1MinorGrid;
            }
            case 33: {
                return Identity.O2AxisLine;
            }
            case 7: {
                return Identity.O2MajorGrid;
            }
            case 8: {
                return Identity.O2MinorGrid;
            }
            case 9: {
                return Identity.X1MajorGrid;
            }
            case 10: {
                return Identity.X1MinorGrid;
            }
            case 13: {
                return Identity.X1ZeroLine;
            }
            case 31: {
                return Identity.Y1AxisLine;
            }
            case 5: {
                return Identity.Y1MajorGrid;
            }
            case 6: {
                return Identity.Y1MinorGrid;
            }
            case 11: {
                return Identity.Y1ZeroLine;
            }
            case 32: {
                return Identity.Y2AxisLine;
            }
            case 26: {
                return Identity.Y2MajorGrid;
            }
            case 28: {
                return Identity.Y2MinorGrid;
            }
            case 12: {
                return Identity.Y2ZeroLine;
            }
            case 19: {
                return Identity.CubeRiserGridY;
            }
            case 29: {
                return Identity.CubeFloor;
            }
            case 22: {
                return Identity.O1MajorGrid;
            }
            case 24: {
                return Identity.O2MajorGrid;
            }
        }
        return IdentObj.GLOBAL;
    }

    int getCurveFitType(int nIndex) {
        return this.m_p.getTrendlineSettings().getTrendlineType(nIndex).ordinal();
    }

    short getCurveFitPolynomialOrder(int index) {
        return (short)this.m_p.getTrendlineSettings().getPolynomialOrder(index);
    }

    short getCurveFitEquationDisplay(int series) {
        return this.toShort(this.m_p.getTrendlineSettings().getDisplayEquation(series));
    }

    short getMarkerSize(int index) {
        return (short)(30 * this.m_p.getMarkerSize(index));
    }

    short getDummy3(int series) {
        return this.toShort(this.m_p.getDisplay(this.m_p.getDataText(series)));
    }

    short getGridStyle(IdentObj id) {
        return (short)(this.m_p.getGridStyle(id) + 1);
    }

    short getRiserType3D(int seriesIndex) {
        if (this.m_jgt.is3DType()) {
            boolean isDefaultRiser;
            int seriesType = this.m_p.getSeriesType(seriesIndex);
            int graphType = this.m_jgt.getIntegerGraphType();
            boolean bl = isDefaultRiser = seriesType == PerspectiveBase.RiserType3D.Default.ordinal();
            if (seriesType == PerspectiveBase.RiserType3D.Bar3D.ordinal() || graphType == 0 && isDefaultRiser) {
                return 0;
            }
            if (seriesType == PerspectiveBase.RiserType3D.ColumnArea.ordinal() || graphType == 9 && isDefaultRiser) {
                return 1;
            }
            if (seriesType == PerspectiveBase.RiserType3D.ColumnLine.ordinal() || graphType == 10 && isDefaultRiser) {
                return 2;
            }
            if (seriesType == PerspectiveBase.RiserType3D.Cube.ordinal() || graphType == 4 && isDefaultRiser) {
                return 4;
            }
            if (seriesType == PerspectiveBase.RiserType3D.CutCorner.ordinal() || graphType == 131 && isDefaultRiser) {
                return 5;
            }
            if (seriesType == PerspectiveBase.RiserType3D.Sphere.ordinal() || graphType == 11 && isDefaultRiser) {
                return 6;
            }
            if (seriesType == PerspectiveBase.RiserType3D.Octagon.ordinal() || graphType == 2 && isDefaultRiser) {
                return 9;
            }
            if (seriesType == PerspectiveBase.RiserType3D.Pyramid.ordinal() || graphType == 1 && isDefaultRiser) {
                return 10;
            }
            if (seriesType == PerspectiveBase.RiserType3D.RowArea.ordinal() || graphType == 6 && isDefaultRiser) {
                return 11;
            }
            if (seriesType == PerspectiveBase.RiserType3D.RowLine.ordinal() || graphType == 7 && isDefaultRiser) {
                return 12;
            }
        }
        return 0;
    }

    short getRiserType(int seriesIndex) {
        boolean isAreaRiser;
        boolean isBarRiser = this.m_p.getSeriesType(this.m_p.getSeries(seriesIndex)) == 1;
        boolean isLineRiser = this.m_p.getSeriesType(this.m_p.getSeries(seriesIndex)) == 2;
        boolean bl = isAreaRiser = this.m_p.getSeriesType(this.m_p.getSeries(seriesIndex)) == 3;
        if (this.m_jgt.isLineType()) {
            if (isLineRiser) {
                return 0;
            }
            if (isBarRiser) {
                return 1;
            }
            if (isAreaRiser) {
                return 2;
            }
        } else if (this.m_jgt.isBarType()) {
            if (isLineRiser) {
                return 1;
            }
            if (isBarRiser) {
                return 0;
            }
            if (isAreaRiser) {
                return 2;
            }
        } else if (this.m_jgt.isAreaType()) {
            if (isLineRiser) {
                return 1;
            }
            if (isBarRiser) {
                return 2;
            }
            if (isAreaRiser) {
                return 0;
            }
        }
        return 0;
    }

    short getGridCount(IdentObj id) {
        return (short)this.m_p.getGridCount(id);
    }

    short getLabelSkip(IdentObj idAxis) {
        return (short)(this.m_p.getSkipCount(idAxis) == 0 ? 0 : this.m_p.getSkipCount(idAxis) + 1);
    }

    short getOrdLabelMode(IdentObj idAxis) {
        switch (this.m_p.getAutoSkip(idAxis)) {
            case 1: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    short getRiserBarGroupSpacing() {
        return (short)this.m_p.getRiserBarGroupSpacing();
    }

    short getIntraGrpThick() {
        return (short)(100 - this.m_p.getRiserWidth());
    }

    short getStockOpenTicksDisplay() {
        return this.toShort(this.m_p.getStockOpenTicksDisplay());
    }

    short getStockCloseTicksDisplay() {
        return this.toShort(this.m_p.getStockCloseTicksDisplay());
    }

    short getStockRiserWidth() {
        return (short)this.m_p.getStockRiserWidthVC();
    }

    short getStockTickWidth() {
        return (short)this.m_p.getStockTickWidthVC();
    }

    short getStockTickHeight() {
        return (short)this.m_p.getStockTickHeightVC();
    }

    short getRiserWidth() {
        return (short)(500 * this.m_p.getRiserWidth() / 10);
    }

    short getRiserWidthNew() {
        int percent = this.m_p.getRiserWidth();
        Rectangle frame = this.m_p.getRect(this.getFrame());
        int series = !this.m_jgt.isStockType() ? this.m_p.getViewableGroupsStock() : this.m_p.getViewableGroups();
        if (series == 0) {
            series = 8;
        }
        return (short)((double)(frame.width / series * percent / 100) * 1.0239375);
    }

    short getDTXTItem() {
        if (this.m_p.getDataTextTemplateHiLo().compareTo("[HIGH]") == 0) {
            return 0;
        }
        if (this.m_p.getDataTextTemplateHiLo().compareTo("[LOW]") == 0) {
            return 1;
        }
        if (this.m_p.getDataTextTemplateHiLo().compareTo("[OPEN]") == 0) {
            return 2;
        }
        if (this.m_p.getDataTextTemplateHiLo().compareTo("[CLOSE]") == 0) {
            return 3;
        }
        return 0;
    }

    short getDeleted(IdentObj idSeries) {
        if (this.m_jgt.isPieType()) {
            return this.toShort(this.m_p.getPieSliceDelete(idSeries));
        }
        return 0;
    }

    IdentObj getSeries(int series) {
        return this.m_p.getSeries(series);
    }

    IdentObj getPieLabel() {
        return Identity.PieGroupLabel;
    }

    short getPieDepth() {
        return (short)(30 * this.m_p.getPieDepth());
    }

    short getPieRotate() {
        if (this.m_jgt.isFunnelType()) {
            return (short)this.m_p.getPieRotate();
        }
        return (short)((450 - this.m_p.getPieRotate()) % 360);
    }

    short getPieRingTotalDisplay() {
        return this.toShort(this.m_p.getPieRingTotalDisplay());
    }

    short getPiesPerRow() {
        return (short)this.m_p.getPiesPerRow();
    }

    short getPieRingSize() {
        return (short)this.m_p.getPieRingSize();
    }

    short getPieTilt() {
        return (short)this.m_p.getPieTilt();
    }

    short getDisplayBarAsPictograph() {
        return this.toShort(this.m_p.getDisplayBarAsPictograph());
    }

    short getEffectType(IdentObj id) {
        switch (this.m_p.getFillType(id)) {
            case 3: {
                return 4;
            }
            case 2: {
                return 14;
            }
        }
        return 0;
    }

    short getGradientAngle(IdentObj id) {
        switch (this.m_p.getGradientDirection(id)) {
            case 1: {
                return 0;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 225;
            }
            case 6: {
                return 135;
            }
            case 7: {
                return 315;
            }
            case 8: {
                return 45;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 0;
            }
            case 14: {
                return 0;
            }
        }
        return 0;
    }

    short getWashDir(IdentObj id) {
        switch (this.m_p.getGradientDirection(id)) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 9;
            }
            case 14: {
                return 11;
            }
        }
        return 2;
    }

    short getWashType(IdentObj id) {
        return 1;
    }

    short getPlacePosition(IdentObj id) {
        switch (this.m_p.getPlacePosition(id)) {
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case -1: {
                return 0;
            }
        }
        return 1;
    }

    short getLegendMarkerPosition() {
        switch (this.m_p.getLegendMarkerPosition()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    short getAxisAssignment(int series) {
        return (short)this.m_p.getAxisAssignment(series);
    }

    short getDualAxisSplitPosition() {
        return (short)this.m_p.getDualAxisSplitPosition();
    }

    boolean getTransparentFillColor(IdentObj id) {
        return this.m_p.getTransparentFillColor(id);
    }

    boolean getTransparentBorderColor(IdentObj id) {
        return this.m_p.getTransparentBorderColor(id);
    }

    int getPieSliceDetach(int nIndex) {
        if (this.m_jgt.isFunnelType()) {
            return this.m_p.getFunnelVertExplosionFactor();
        }
        return this.m_p.getPieSliceDetach(nIndex);
    }

    short getAnnotationNodeType(IdentObj annot) {
        AnnotationType at = this.m_p.getAnnotationType(annot);
        switch (at) {
            case RECTANGLE: {
                return 6;
            }
            case ARC: {
                return 12;
            }
        }
        return (short)at.ordinal();
    }

    short getNumAnnotations() {
        return (short)this.m_p.getNumAnnotations();
    }

    Object getAnnotationObject(IdentObj annot, int num) {
        return this.m_p.getAnnotationObject(annot, num);
    }

    short getNumAnnotationObjects(IdentObj annot) {
        return (short)this.m_p.getNumAnnotationObjects(annot);
    }

    short getArrowHeadLength(IdentObj annot) {
        return (short)this.m_p.getArrowHeadLength(annot);
    }

    short getAnnotationOrder(IdentObj annot) {
        return (short)this.m_p.getAnnotationOrder(annot);
    }

    short getConnectScatterMarkers() {
        return this.toShort(this.m_p.getConnectScatterMarkers());
    }

    short getAutoSkip(IdentObj id) {
        return (short)this.m_p.getAutoSkip(id);
    }

    short getSkipBegin(IdentObj id) {
        return (short)this.m_p.getSkipBegin(id);
    }

    short getSkipCount(IdentObj axisID, AxisInfo axisInfo) {
        if (this.m_jgt.is3DType() && axisID.equals(Identity.X1Axis)) {
            return (short)this.m_p.getSkipCount(Identity.O2Label);
        }
        return (short)this.m_p.getSkipCount(axisInfo.getLabel());
    }

    short getShowPieLabel(int seriesIndex) {
        short nShow = 0;
        if (!this.m_jgt.isFunnelType()) {
            if (this.m_p.getDisplay(this.m_p.getPieSliceLabel(seriesIndex))) {
                nShow = (short)(nShow | 2);
            }
            if (this.m_p.getDisplay(this.m_p.getPieSliceValueLabel(seriesIndex))) {
                nShow = (short)(nShow | 1);
            }
            if (this.m_p.getPieValueFormat() == 0) {
                nShow = (short)(nShow | 0x20);
            }
        } else {
            if (this.m_p.getDisplay(Identity.FunnelSliceLabel)) {
                nShow = (short)(nShow | 2);
            }
            if (this.m_p.getDisplay(Identity.FunnelValueLabel)) {
                nShow = (short)(nShow | 1);
            }
            if (this.m_p.getPieValueFormat() == 0) {
                nShow = (short)(nShow | 0x20);
            }
        }
        return nShow;
    }

    short getPlaceDataLabel() {
        switch (this.m_p.getPieSliceLabelPosition()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 5;
            }
        }
        return 0;
    }

    short getPlaceValueLabel() {
        switch (this.m_p.getPieSliceValueLabelPosition()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 5;
            }
        }
        return 0;
    }

    short getLabelStdFormat(IdentObj idlabel) {
        return 1;
    }

    IdentObj getDataText() {
        return Identity.DataText;
    }

    short getMajorHashMode(IdentObj id) {
        return 1;
    }

    IdentObj getFrameSeparator() {
        return Identity.FrameSeparator;
    }

    short getPieDisplayFeelers(int seriesIndex) {
        if (!this.m_jgt.isFunnelType()) {
            return this.toShort(this.m_p.getDisplay(this.m_p.getPieFeelerLine(seriesIndex)));
        }
        return this.toShort(this.m_p.getDisplay(Identity.FunnelFeeler));
    }

    IdentObj getPieRingLabel() {
        return Identity.PieRingLabel;
    }

    public short getIsVerticalDataFormat() {
        return this.toShort(this.m_jgt.isScatter() || this.m_jgt.isBubble() || this.m_jgt.isStockType() || this.m_jgt.isGanttType());
    }

    public short getPattern(IdentObj id) {
        Paint paint = this.m_p.getPaintObject(id);
        if (paint != null && TexturePaint.class.isInstance(paint)) {
            return PatternTable.getPatternNumber((TexturePaint)paint, this.m_p.getFillColor(id));
        }
        return 0;
    }

    public Color getPatternColor(IdentObj id) {
        Paint paint = this.m_p.getPaintObject(id);
        if (paint != null && TexturePaint.class.isInstance(paint)) {
            return PatternTable.getPatternColor((TexturePaint)paint, this.m_p.getFillColor(id));
        }
        return new Color(0, 0, 0);
    }

    public short getOrdSpace() {
        return this.m_p.getExtendToFrameEdge() ? (short)1 : 0;
    }

    public short getY1DTXTAxisTemplateID() {
        if (this.m_p.isChartBubble()) {
            return 8;
        }
        return 0;
    }

    public short getMinBubbleSize() {
        return (short)(this.m_p.getMinBubbleSize() * 30.0);
    }

    public short getMaxBubbleSize() {
        return (short)(this.m_p.getMaxBubbleSize() * 30.0);
    }

    public short getGradientOffsetX(IdentObj id) {
        int offset;
        switch (this.m_p.getGradientDirection(id)) {
            case 9: 
            case 14: {
                return 50;
            }
            case 11: 
            case 13: {
                return 100;
            }
            case 10: 
            case 12: {
                return 0;
            }
        }
        short angle = this.getGradientAngle(id);
        double pinpos = this.m_p.getGradientPinPosition(id, 1);
        switch (angle % 180) {
            default: {
                offset = (int)(pinpos * 100.0 + 0.5);
                break;
            }
            case 45: {
                offset = (int)(pinpos * 100.0 + 0.5);
                break;
            }
            case 90: {
                offset = 0;
                break;
            }
            case 135: {
                offset = (int)(pinpos * 100.0 + 0.5);
            }
        }
        return (short)offset;
    }

    public short getGradientOffsetY(IdentObj id) {
        int offset;
        switch (this.m_p.getGradientDirection(id)) {
            case 9: 
            case 14: {
                return 50;
            }
            case 12: 
            case 13: {
                return 100;
            }
            case 10: 
            case 11: {
                return 0;
            }
        }
        short angle = this.getGradientAngle(id);
        double pinpos = this.m_p.getGradientPinPosition(id, 1);
        switch (angle % 180) {
            default: {
                offset = 0;
                break;
            }
            case 45: {
                offset = (int)(100.0 - (pinpos * 100.0 + 0.5));
                break;
            }
            case 90: {
                offset = (int)(pinpos * 100.0 + 0.5);
                break;
            }
            case 135: {
                offset = (int)(pinpos * 100.0 + 0.5);
            }
        }
        return (short)offset;
    }

    public short getGradientWashType(IdentObj id) {
        int numpins = this.m_p.getGradientNumPins(id);
        if (numpins > 2) {
            return 3;
        }
        return 1;
    }

    public short getGradientAdvWashType(IdentObj id) {
        switch (this.m_p.getGradientDirection(id)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 14;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 9;
            }
            case 14: {
                return 10;
            }
        }
        return 14;
    }

    public Color getWashColor(IdentObj id, int i) {
        boolean swap = false;
        switch (this.m_p.getGradientDirection(id)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                swap = true;
            }
        }
        if (i == 0 && !swap || i == 1 && swap) {
            return this.m_p.getGradientPinLeftColor(id, 1);
        }
        return this.m_p.getGradientPinRightColor(id, 0);
    }

    public double getGaugeMajorTickRelativeTickLength() {
        return this.m_p.getGaugeMajorTickRelativeTickLength();
    }

    public short getGaugeStopAngle() {
        return (short)this.m_p.getGaugeStopAngle();
    }

    public short getGaugeStartAngle() {
        return (short)this.m_p.getGaugeStartAngle();
    }

    public boolean isGaugeType() {
        return this.m_jgt.isGaugeType();
    }

    public IdentObj getGaugeMajorTick() {
        return this.m_p.getGaugeMajorTick();
    }

    public IdentObj getGaugeMinorTick() {
        return this.m_p.getGaugeMinorTick();
    }

    public IdentObj getGaugeBand(int i) {
        switch (i + 1) {
            default: {
                return this.m_p.getGaugeBand1();
            }
            case 2: {
                return this.m_p.getGaugeBand2();
            }
            case 3: {
                return this.m_p.getGaugeBand3();
            }
            case 4: {
                return this.m_p.getGaugeBand4();
            }
            case 5: 
        }
        return this.m_p.getGaugeBand5();
    }

    double getGaugeBandMin(IdentObj band) {
        return this.m_p.getGaugeBandMin(band);
    }

    double getGaugeBandMax(IdentObj band) {
        return this.m_p.getGaugeBandMax(band);
    }

    private static double toDate1900(double date) {
        double fDate = 0.0;
        int nCurrentMonthIndex = 0;
        int nStop = 0;
        int NUMBER_OF_DAYS_IN_4_YEARS = 1461;
        int[] MonthLookup = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        GregorianCalendar d = new GregorianCalendar();
        d.setTimeInMillis((long)date);
        int nYear = d.get(1);
        int nMonth = d.get(2) + 1;
        int nDay = d.get(5);
        if (nYear < 1900) {
            nYear = 1900;
        }
        int n4YearCount = (nYear -= 1900) / 4;
        fDate += (double)(n4YearCount * NUMBER_OF_DAYS_IN_4_YEARS);
        int numOrdYears = nYear % 4;
        if (nMonth > 12 || nMonth < 1) {
            nMonth = 1;
        }
        nStop += --nMonth + 12 * numOrdYears;
        for (nCurrentMonthIndex = 0; nCurrentMonthIndex < nStop; ++nCurrentMonthIndex) {
            fDate += (double)MonthLookup[nCurrentMonthIndex];
        }
        if (nDay > MonthLookup[nStop] || nDay < 1) {
            nDay = 1;
        }
        return fDate += (double)nDay;
    }

    public short getUseTimeScaleAxis() {
        return this.toShort(this.m_p.getUseTimeScaleAxis() || this.m_p.getUsePGSDKTimeScaleAxis());
    }

    public short getXYData() {
        return this.toShort(this.m_p.getUseNumericScaleAxis());
    }

    public double getTimeAxisMinimum(IdentObj axisID) {
        if (this.m_p.getUsePGSDKTimeScaleAxis()) {
            return PerspectiveHandler.toDate1900(this.m_p.getScaleMin(axisID));
        }
        return PerspectiveHandler.toDate1900(this.m_p.getStartDate());
    }

    public double getTimeAxisMaximum(IdentObj axisID) {
        if (this.m_p.getUsePGSDKTimeScaleAxis()) {
            return PerspectiveHandler.toDate1900(this.m_p.getScaleMax(axisID));
        }
        return PerspectiveHandler.toDate1900(this.m_p.getEndDate());
    }

    private short toUnit(int u) {
        switch (u) {
            default: {
                return 0;
            }
            case 6: {
                return 1;
            }
            case 8: 
        }
        return 2;
    }

    public short getLevelInterval(int i) {
        return this.toUnit(this.m_p.getLevelInterval(i));
    }

    public short getMajorGridTickInterval(IdentObj obj) {
        return this.toUnit(this.m_p.getMajorGridTickInterval());
    }

    public short getMinorGridTickInterval(IdentObj obj) {
        return this.toUnit(this.m_p.getMinorGridTickInterval());
    }

    public short getAutomaticMinimum(IdentObj axisID) {
        return this.toShort(this.m_p.getScaleMinAuto(axisID));
    }

    public short getAutomaticMaximum(IdentObj axisID) {
        return this.toShort(this.m_p.getScaleMaxAuto(axisID));
    }

    public short getFancyBoxStyle(IdentObj id) {
        if (id == null) {
            return 0;
        }
        int fancyBoxStyle = this.m_p.getBorderType(id);
        switch (fancyBoxStyle) {
            case 3: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    public short getFancyBoxAreaDestID(short nDestID) {
        short nID = 0;
        switch (nDestID) {
            case 1019: {
                nID = 12015;
                break;
            }
            case 2015: {
                nID = 12016;
                break;
            }
            case 2016: {
                nID = 12017;
                break;
            }
            case 2017: {
                nID = 12018;
                break;
            }
            case 2018: {
                nID = 12019;
                break;
            }
            case 2019: {
                nID = 12020;
                break;
            }
            case 2020: {
                nID = 12021;
                break;
            }
            case 2021: {
                nID = 12022;
                break;
            }
            case 2022: {
                nID = 12023;
                break;
            }
            case 2023: {
                nID = 12024;
                break;
            }
            case 2024: {
                nID = 12025;
                break;
            }
            case 2025: {
                nID = 12026;
                break;
            }
            case 2026: {
                nID = 12027;
                break;
            }
            case 2027: {
                nID = 12028;
                break;
            }
            case 2107: {
                nID = 12029;
                break;
            }
            case 2147: {
                nID = 12030;
                break;
            }
            case 1044: {
                nID = 12031;
                break;
            }
            case 1050: {
                nID = 12032;
                break;
            }
            case 3043: {
                nID = 3048;
                break;
            }
            case 12171: {
                nID = 30527;
                break;
            }
            default: {
                nID = 0;
            }
        }
        return nID;
    }

    public short getFancyBoxLineDestID(short nDestID) {
        short nID = 0;
        switch (nDestID) {
            case 1019: {
                nID = 12115;
                break;
            }
            case 2015: {
                nID = 12116;
                break;
            }
            case 2016: {
                nID = 12117;
                break;
            }
            case 2017: {
                nID = 12118;
                break;
            }
            case 2018: {
                nID = 12119;
                break;
            }
            case 2019: {
                nID = 12120;
                break;
            }
            case 2020: {
                nID = 12121;
                break;
            }
            case 2021: {
                nID = 12122;
                break;
            }
            case 2022: {
                nID = 12123;
                break;
            }
            case 2023: {
                nID = 12124;
                break;
            }
            case 2024: {
                nID = 12125;
                break;
            }
            case 2025: {
                nID = 12126;
                break;
            }
            case 2026: {
                nID = 12127;
                break;
            }
            case 2027: {
                nID = 12128;
                break;
            }
            case 2107: {
                nID = 12129;
                break;
            }
            case 2147: {
                nID = 12130;
                break;
            }
            case 1044: {
                nID = 12131;
                break;
            }
            case 1050: {
                nID = 12132;
                break;
            }
            case 3043: {
                nID = 3047;
                break;
            }
            case 12171: {
                nID = 3056;
                break;
            }
            default: {
                nID = 0;
            }
        }
        return nID;
    }

    public IdentObj getTextBoxID(IdentObj id) {
        if (id.equals(this.getTitleID())) {
            return Identity.TitleBox;
        }
        if (id.equals(this.getSubTitleID())) {
            return Identity.SubtitleBox;
        }
        if (id.equals(this.getFootnoteID())) {
            return Identity.FootnoteBox;
        }
        if (id.equals(this.getX1TitleID())) {
            return Identity.X1TitleBox;
        }
        if (id.equals(this.getY1TitleID())) {
            return Identity.Y1TitleBox;
        }
        if (id.equals(this.getY2TitleID())) {
            return Identity.Y2TitleBox;
        }
        if (id.equals(this.getDataText())) {
            return Identity.DataTextBox;
        }
        if (id.equals(Identity.PieSliceLabel)) {
            return Identity.PieSliceLabelBox;
        }
        if (id.equals(Identity.PieSliceValueLabel)) {
            return Identity.PieSliceValueLabelBox;
        }
        if (id.equals(Identity.FunnelSliceLabel)) {
            return Identity.FunnelSliceLabelBox;
        }
        if (id.equals(Identity.FunnelValueLabel)) {
            return Identity.FunnelValueLabelBox;
        }
        if (id.equals(Identity.PieGroupLabel)) {
            return Identity.PieGroupLabelBox;
        }
        if (id.equals(Identity.FunnelGroupLabel)) {
            return Identity.FunnelGroupLabelBox;
        }
        return null;
    }

    public short getLineStyle(IdentObj id) {
        return (short)this.m_p.getPGSDKLineStyle(id);
    }

    public short getMajorUnitAuto(IdentObj majorGridID) {
        return this.m_p.getGridUnitAuto(majorGridID) ? (short)1 : 0;
    }

    public short getMinorUnitAuto(IdentObj minorGridID) {
        return this.m_p.getGridUnitAuto(minorGridID) ? (short)1 : 0;
    }

    public short getMajorInterval(IdentObj majorGridID) {
        return (short)this.m_p.getGridUnitCount(majorGridID);
    }

    public short getMinorInterval(IdentObj minorGridID) {
        return (short)this.m_p.getGridUnitCount(minorGridID);
    }

    public Iterator<UniversalPictureStruct> getPicturesIterator() {
        return this.m_p.getPictureTableIterator();
    }

    public String getTextureName(IdentObj id) {
        return this.m_p.getTexture(id);
    }

    public short getPictScale(IdentObj id) {
        int val = this.m_p.getTextureDisplayMode(id);
        if (val == 2) {
            return 1;
        }
        if (val == 0) {
            return 4;
        }
        if (val == 1) {
            return 0;
        }
        return 0;
    }

    public short getPictFlip(IdentObj id) {
        int val = this.m_p.getTextureFlipMode(id);
        if (val == 1) {
            return 2;
        }
        if (val == 2) {
            return 1;
        }
        return 0;
    }

    public AxisInfo getTimeAxisInfo() {
        IdentObj id = this.getX1AxisID();
        if (this.m_jgt.isGanttType()) {
            id = this.getY1AxisID();
        }
        return AxisInfo.getAxisInfo(this, id);
    }

    public short getGaugeThickness() {
        return (short)this.m_p.getGaugeBandThicknessVC();
    }

    public IdentObj getGaugeBackground() {
        return this.m_p.getGaugeBackground();
    }

    public IdentObj getSubFrame() {
        return Identity.SubFrame;
    }

    public boolean shouldSwapMajorMinorGridlines(IdentObj objectID) {
        if (objectID.getObjectID() == 515 || objectID.getObjectID() == 516) {
            return this.m_p.pgsdkToPfjO1MajorMinorGridlinesSwapped();
        }
        return false;
    }

    public short get3TFCreationRevision() {
        return (short)this.m_p.get3TFCreationRevision();
    }

    public short get3TFCreationSubRevision() {
        return (short)this.m_p.get3TFCreationSubRevision();
    }

    public short getFrameResize() {
        return (short)PlaceMode.toInt(this.m_p.getPlaceResize(this.m_p.getCurrentFrame()));
    }

    public Insets getInsets(IdentObj id) {
        return this.m_p.getInsets(id);
    }

    public Rectangle getBICurveText(int series) {
        return this.m_p.getRect(TrendlineSettings.getEquationText(series));
    }

    public short getDummy5(Set<Integer> curveSet) {
        int dummy5 = 0;
        if (curveSet.contains(TrendlineType.FIT_QUADRATIC.ordinal())) {
            dummy5 = 1;
        } else if (curveSet.contains(TrendlineType.FIT_MODHYPERBOLIC.ordinal())) {
            dummy5 = 2;
        } else if (curveSet.contains(TrendlineType.FIT_RATIONAL.ordinal())) {
            dummy5 = 4;
        } else if (curveSet.contains(TrendlineType.FIT_LOGQUADRATIC.ordinal())) {
            dummy5 = 8;
        } else if (curveSet.contains(TrendlineType.FIT_HYPERBOLIC.ordinal())) {
            dummy5 = 16;
        } else if (curveSet.contains(TrendlineType.FIT_MODEXPONENTIAL.ordinal())) {
            dummy5 = 32;
        }
        return (short)dummy5;
    }

    public short getShowCorr(int series) {
        return this.toShort(this.m_p.getDisplay(TrendlineSettings.getCorrelationText(series)));
    }

    public Set<Integer> getSeriesCurveSet(int series) {
        HashSet<Integer> curveSet = new HashSet<Integer>();
        TrendlineSettings trendlines = this.m_p.getTrendlineSettings();
        for (TrendlineType line : TrendlineType.values()) {
            if (trendlines.getTrendlineType(series, line) == TrendlineType.FIT_NONE) continue;
            curveSet.add(new Integer(line.ordinal()));
        }
        return curveSet;
    }

    public int getNullBehaviorMask() {
        int mask = 0;
        if (this.m_p.getBreakAbsoluteLines()) {
            mask |= 1;
        }
        if (this.m_p.getBreakStackedLines()) {
            mask |= 2;
        }
        return mask;
    }

    public IdentObj getUserLine(int number) {
        return this.m_p.getUserLine(number);
    }

    public double getUserLineValue(IdentObj id) {
        return this.m_p.getUserLineValue(id);
    }

    public short getUserLineAxis(IdentObj id) {
        int pfjAxisID = this.m_p.getUserLineAxis(id);
        switch (pfjAxisID) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    public int getAutoPlacementMask() {
        return this.m_p.getAutoPlacmentMask();
    }

    public boolean is3DChart() {
        return this.m_jgt.is3DType();
    }

    public boolean isBubble() {
        return this.m_jgt.isBubble();
    }

    public boolean isStockType() {
        return this.m_jgt.isStockType();
    }

    public AdvFormatStruct getAdvFormat(Format fmt) {
        if (fmt instanceof IAdvFormatStructExporter) {
            return ((IAdvFormatStructExporter)((Object)fmt)).toAdvFormatStruct();
        }
        assert (false) : "Unrecognized Format type.  Cannot convert to AdvFormatStruct";
        return null;
    }

    public Format getDataTextFormat(IdentObj id) {
        return this.m_p.getDataTextFormat(id);
    }

    public Format getTextFormat(IdentObj id) {
        return this.m_p.getTextFormat(id);
    }
}

