/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.ICurveFit;

class FitModExponential
implements ICurveFit {
    private static final int NUM_COEFFS = 2;

    FitModExponential() {
    }

    public double compute(double x, double[] a) {
        assert (a.length >= 3);
        assert (FP.nonzero(x));
        double y = a[1] * Math.exp(a[2] / x);
        return y;
    }

    public void eval(double x, double[] a) {
        assert (a.length >= 3);
        assert (FP.nonzero(x));
        a[1] = 1.0;
        a[2] = 1.0 / x;
    }

    public int numCoeffs() {
        return 2;
    }

    public double transformY(double y) {
        return Math.log(y);
    }

    public double invTransformCoeff(int ia, double a) {
        if (ia == 1) {
            return Math.exp(a);
        }
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) {
        assert (strCoeffs.length >= 3);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " / x";
        return "y = " + strTerm1 + " * exp(" + strTerm2 + ")";
    }
}

