/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MarkerTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class MarkerObj {
    private IdentObj m_id;
    private MarkerTemplate m_template;
    private Point m_center;
    private int m_markerSizeX;
    private int m_markerSizeY;
    private IBlackBox m_bb;
    private Rectangle m_rClip = null;
    private boolean m_Draw;
    private Rectangle m_boundingBox;
    private IDrawContainer drawContainer;
    private String m_szRefLabel;

    public static Dimension getMarkerSize(MarkerTemplate template, Dimension markerSize) {
        MarkerObj mo = new MarkerObj(null, null, template, null, markerSize, null, null, false, false, false);
        return mo.m_boundingBox.getSize();
    }

    public MarkerObj(IDrawContainer container, IdentObj id, MarkerTemplate template, Point center, Dimension markerSize, IBlackBox blackBox, Rectangle rClip, boolean bLimitSize, boolean bBeveledMarker, boolean draw) {
        if (center == null) {
            center = new Point(0, 0);
        }
        this.m_markerSizeX = markerSize.width;
        this.m_markerSizeY = markerSize.height;
        if (this.m_markerSizeX < 0 || bLimitSize && this.m_markerSizeX > 100) {
            throw new IllegalArgumentException();
        }
        if (this.m_markerSizeY < 0 || bLimitSize && this.m_markerSizeY > 100) {
            throw new IllegalArgumentException();
        }
        this.m_id = id;
        this.m_template = template;
        this.m_center = center;
        this.m_bb = blackBox;
        this.m_rClip = rClip;
        this.drawContainer = container;
        this.m_Draw = draw;
        this.calc();
    }

    public void calc() {
        switch (this.m_template.getMarkerType()) {
            case 0: {
                break;
            }
            case 4: {
                this.calcRefPolygon();
                break;
            }
            case 3: {
                this.calcPolygon();
                break;
            }
            case 1: {
                this.calcRect();
                break;
            }
            case 2: {
                this.calcOval();
                break;
            }
            default: {
                throw new RuntimeException("MarkerObj - unknown markerType = " + this.m_template.getMarkerType());
            }
        }
    }

    public void calcOval() {
        Rectangle scaledRect = new Rectangle(this.m_template.getRect().x * this.m_markerSizeX / 100, this.m_template.getRect().y * this.m_markerSizeY / 100, this.m_template.getRect().width * this.m_markerSizeX / 100, this.m_template.getRect().height * this.m_markerSizeY / 100);
        scaledRect.translate(this.m_center.x, this.m_center.y);
        this.m_boundingBox = scaledRect;
        if (this.m_Draw) {
            DrawFactory.createOval(this.drawContainer, this.m_id, scaledRect, this.m_bb, this.m_rClip);
        }
    }

    public void calcPolygon() {
        Polygon scaledPolygon = new Polygon();
        Polygon markerPolygon = this.m_template.getPolygon();
        if (markerPolygon.npoints < 3) {
            throw new RuntimeException("MarkerObj.calcPolygon polygons has too few sides (" + markerPolygon.npoints + ")");
        }
        for (int i = 0; i < this.m_template.getPolygon().npoints; ++i) {
            int x = markerPolygon.xpoints[i] * this.m_markerSizeX / 100 + this.m_center.x;
            int y = markerPolygon.ypoints[i] * this.m_markerSizeY / 100 + this.m_center.y;
            scaledPolygon.addPoint(x, y);
        }
        this.m_boundingBox = scaledPolygon.getBounds();
        if (this.m_Draw) {
            DrawFactory.createPolygon(this.drawContainer, this.m_id, scaledPolygon, this.m_bb, this.m_rClip);
        }
    }

    public void calcRect() {
        Rectangle scaledRect = new Rectangle(this.m_template.getRect().x * this.m_markerSizeX / 100, this.m_template.getRect().y * this.m_markerSizeY / 100, this.m_template.getRect().width * this.m_markerSizeX / 100, this.m_template.getRect().height * this.m_markerSizeY / 100);
        scaledRect.translate(this.m_center.x, this.m_center.y);
        this.m_boundingBox = scaledRect;
        if (this.m_Draw) {
            AnnotationBox.calcBorderedBox(((Detectiv)this.drawContainer).getPerspective(), this.m_id, scaledRect, this.m_bb, this.m_rClip);
        }
    }

    public void calcRefPolygon() {
        Polygon scaledPolygon = new Polygon();
        int y = 0;
        double fLineWidth = this.m_template.getLineWidth();
        int lineWidthVC = this.m_template.getLineWidthVC();
        Polygon markerPolygon = this.m_template.getPolygon();
        if (markerPolygon.npoints < 3) {
            throw new RuntimeException("MarkerObj.calcPolygon polygons has too few sides (" + markerPolygon.npoints + ")");
        }
        int[] Markerx = new int[4];
        int[] Markery = new int[4];
        for (int i = 0; i < markerPolygon.npoints; ++i) {
            int x = markerPolygon.xpoints[i] * this.m_markerSizeX / 100 + this.m_center.x;
            y = markerPolygon.ypoints[i] * lineWidthVC / 2 + this.m_center.y;
            Markerx[i] = x;
            Markery[i] = y;
            scaledPolygon.addPoint(x, y);
        }
        this.m_boundingBox = scaledPolygon.getBounds();
        if (this.m_Draw) {
            Java2DLine line = new Java2DLine(((Detectiv)this.drawContainer).getPerspective());
            line.createLine(this.m_id, this.m_id, Markerx[0] - 100, Markery[2], Markerx[1] + 100, Markery[2], this.m_bb, null, fLineWidth);
        }
    }

    public void setReferenceLabel(String str) {
        this.m_szRefLabel = str;
    }

    public String getReferenceLabel() {
        return this.m_szRefLabel;
    }
}

