/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ProportionalChart;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_Base;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.LegendMarkersLabels;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.place.PlaceUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utilities.MathUtilities;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility.RectangleUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendObj {
    public static final int LAYOUT_VERT = 0;
    public static final int LAYOUT_HORZ = 1;
    public static final int LAYOUT_AUTO = 2;
    public static final int FREE_FLOAT = -1;
    public static final int AUTO = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int TOP = 4;
    public static final int RIGHT_TOP = 5;
    public static final int RIGHT_BOTTOM = 6;
    public static final int LEFT_TOP = 7;
    public static final int LEFT_BOTTOM = 8;
    public static final int BOTTOM_LEFT = 9;
    public static final int BOTTOM_RIGHT = 10;
    public static final int TOP_LEFT = 11;
    public static final int TOP_RIGHT = 12;
    private static final int legendMargin = 200;

    private LegendObj() {
    }

    public static final void calc(Perspective p) {
        int numLabels = LegendMarkersLabels.getNumLabels(p);
        if (numLabels <= 0) {
            return;
        }
        Dimension dMinSize = LegendObj.getMinCellSize(p);
        Dimension maxLegendRowCol = LegendObj.getMaxLegendRowsCols(p, dMinSize);
        float fontSize = p.getFontSizeInPoints(Identity.LegendText);
        boolean shouldAutoAdjustFontHeight = p.getLegendPosition() != -1 && p.getFontSizeAbsolute(Identity.LegendText);
        float MIN_FONT_HEIGHT = 3.5f;
        double decrementValue = Math.max(0.25, MathUtilities.quantize((fontSize - MIN_FONT_HEIGHT) / 20.0f, 4.0));
        while (shouldAutoAdjustFontHeight && numLabels > maxLegendRowCol.height * maxLegendRowCol.width && fontSize > MIN_FONT_HEIGHT) {
            fontSize = (float)MathUtilities.quantize((double)fontSize - decrementValue, 4.0);
            fontSize = Math.max(fontSize, MIN_FONT_HEIGHT);
            p.setFontSizeInPoints(Identity.LegendText, fontSize);
            dMinSize = LegendObj.getMinCellSize(p);
            maxLegendRowCol = LegendObj.getMaxLegendRowsCols(p, dMinSize);
        }
        Rectangle rLegend = LegendObj.getLegendRect(p, dMinSize);
        p.setLegendRect(rLegend);
        if (!p.getPDECalc()) {
            LegendObj.draw(p);
            LegendMarkersLabels.draw(p, dMinSize);
        }
    }

    public static final int getHSpacing(Perspective p) {
        return 200;
    }

    public static final int getMarkerSpacing(Perspective p) {
        return 0;
    }

    static final int getVSpacing(Perspective p) {
        int markerPos = p.getLegendMarkerPosition();
        int fontSize = TextUtil.getFontSizeHeightVC(p, Identity.LegendText);
        int vSpacing = 0;
        switch (markerPos) {
            default: 
        }
        vSpacing = fontSize / 5;
        return vSpacing;
    }

    public static final boolean isLabelBeside(Perspective p) {
        int markerPos = p.getLegendMarkerPosition();
        boolean isLabelBeside = false;
        switch (markerPos) {
            case 0: 
            case 1: 
            case 4: {
                isLabelBeside = true;
            }
        }
        return isLabelBeside;
    }

    public static final Dimension getMaxLegendLabel(Perspective p) {
        ITextStyle labelTextStyle = TextStyleObjFactory.newTextStyleObj(p, Identity.LegendText);
        Dimension maxDimension = PlaceUtilities.getTextDim(p, Identity.LegendText, "The TestString Hello XX", 32000, labelTextStyle);
        int maxWidth = (int)((double)maxDimension.width * 31.0 / 30.0);
        if (LegendObj.isExtendedLegend(p)) {
            maxWidth = 32000;
        }
        Dimension d = PlaceUtilities.getDimLargestLabelVC(p, Identity.LegendText, maxWidth);
        return d;
    }

    static final int getMarkerSize(Perspective p) {
        int fontSize = TextUtil.getFontSizeHeightVC(p, Identity.LegendText);
        return fontSize;
    }

    static final Dimension getMinCellSize(Perspective p) {
        Dimension d = LegendObj.getMaxLegendLabel(p);
        int width = 0;
        int height = 0;
        if (LegendObj.isLabelBeside(p)) {
            width = d.width + LegendObj.getMarkerSize(p) + LegendObj.getMarkerSpacing(p);
            height = d.height + LegendObj.getVSpacing(p);
        } else {
            width = d.width;
            height = d.height + LegendObj.getMarkerSize(p) + LegendObj.getVSpacing(p);
        }
        if (LegendObj.isExtendedLegend(p)) {
            int legendLabelType = p.getLegendLabelType();
            if (legendLabelType == 1 || legendLabelType == 3) {
                List<String> percentageStrings = LegendObj.calcLegendPercentages(p);
                int maxWidthPercentagesVC = LegendObj.getMaxWidth(p, percentageStrings);
                width = width + maxWidthPercentagesVC + 200;
            }
            if (legendLabelType == 2 || legendLabelType == 3) {
                List<String> m_vectStrValues = LegendObj.calcLegendValues(p);
                int maxWidthValuesVC = LegendObj.getMaxWidth(p, m_vectStrValues);
                width = width + maxWidthValuesVC + 200;
            }
        }
        return new Dimension(width, height);
    }

    private static int getMaxWidth(Perspective p, List<String> vStrings) {
        IdentObj idLegendText = new IdentObj(14);
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(p, idLegendText);
        int maxWidth = 0;
        for (String s : vStrings) {
            Dimension d = PlaceUtilities.getTextDim(p, idLegendText, s, textStyle);
            if (d.width <= maxWidth) continue;
            maxWidth = d.width;
        }
        return maxWidth;
    }

    private static final Dimension getCellSize(Perspective p, Dimension dMinCellSize) {
        int minWidth = dMinCellSize.width;
        int minHeight = dMinCellSize.height;
        Dimension cellSize = new Dimension(minWidth, minHeight);
        return cellSize;
    }

    static final Rectangle getCellRect(Perspective p, int index, Dimension dMinSize) {
        int yPadding;
        index -= LegendObj.getSeriesStart(p);
        Dimension cellSize = LegendObj.getCellSize(p, dMinSize);
        Rectangle rLegend = p.getLegendRect();
        int legendX = rLegend.x;
        int numCols = LegendObj.getNumCols(p, dMinSize);
        int numRows = LegendObj.getNumRows(p, dMinSize);
        boolean auto = p.getLegendAutomatic();
        int col = index % numCols;
        int row = index / numCols;
        int xPadding = LegendObj.getHSpacing(p) * col;
        if (auto) {
            yPadding = LegendObj.getVSpacing(p) * row;
        } else {
            int usedArea = rLegend.height - numRows * cellSize.height;
            yPadding = numRows == 1 ? 0 : usedArea / (numRows - 1);
            yPadding *= row;
        }
        int top = rLegend.y + rLegend.height;
        int x = col * cellSize.width + legendX + xPadding + p.getVC().getAspectAdjustedX(200);
        int y = top - cellSize.height * (row + 1) - yPadding - p.getVC().getAspectAdjustedY(200);
        return new Rectangle(x, y, cellSize.width, cellSize.height);
    }

    public static final Rectangle getLegendRect(Perspective p, Dimension dMinSize) {
        Rectangle r = p.getLegendRect();
        int topLeftX = r.x;
        int topLeftY = r.y + r.height;
        if (p.getLegendAutomatic()) {
            Dimension cellSize = LegendObj.getCellSize(p, dMinSize);
            int numCols = LegendObj.getNumCols(p, dMinSize);
            int numRows = LegendObj.getNumRows(p, dMinSize);
            int xPadding = LegendObj.getHSpacing(p) * (numCols - 1);
            int yPadding = LegendObj.getVSpacing(p) * (numRows - 1);
            int width = numCols * cellSize.width + xPadding + 2 * p.getVC().getAspectAdjustedX(200);
            int height = numRows * cellSize.height + yPadding + 2 * p.getVC().getAspectAdjustedY(200);
            r.setFrameFromDiagonal(topLeftX, topLeftY, topLeftX + width, topLeftY - height);
        }
        int pos = p.getLegendPosition();
        Rectangle frame = LegendObj.getWorkingAreaRectangle(p);
        r = RectangleUtil.positionRect(pos, frame, r);
        r.setLocation(r.x, r.y);
        return new Rectangle(r.x, r.y, r.width, r.height);
    }

    static Rectangle getWorkingAreaRectangle(Perspective p) {
        Rectangle rTitle;
        IdentObj id;
        Rectangle frame = new Rectangle(-16000, -16000, 32000, 32000);
        if (p.getDisplay(Identity.Title)) {
            id = Identity.Title;
            rTitle = p.getRect(id);
            RectangleUtil.subtract(frame, rTitle.height + 500, 4);
        }
        if (p.getDisplay(Identity.Subtitle)) {
            id = Identity.Subtitle;
            rTitle = p.getRect(id);
            RectangleUtil.subtract(frame, rTitle.height + 500, 4);
        }
        if (p.getDisplay(Identity.Footnote)) {
            id = Identity.Footnote;
            rTitle = p.getRect(id);
            RectangleUtil.subtract(frame, rTitle.height + 500, 1);
        } else {
            RectangleUtil.subtract(frame, 1000, 1);
        }
        if (p.getLegendPosition() == -1) {
            Rectangle r = p.getLegendRect();
            int topFrame = frame.y + frame.height;
            int manualTop = r.y + r.height;
            if (topFrame > manualTop) {
                frame.height = Math.max(0, frame.height - (topFrame - manualTop));
            }
        }
        return frame;
    }

    public static final boolean isDataScrollerActive() {
        return false;
    }

    public static final boolean canScrollLegend() {
        return false;
    }

    static Dimension getMaxLegendRowsCols(Perspective p, Dimension dMinSize) {
        Dimension maxDimension = new Dimension();
        int orientation = LegendObj.getLegendOrientation(p);
        Rectangle frame = LegendObj.getWorkingAreaRectangle(p);
        if (orientation == 0) {
            maxDimension.width = (int)((double)frame.width * 0.4);
            maxDimension.height = frame.height;
        } else if (orientation == 1) {
            maxDimension.width = frame.width;
            maxDimension.height = (int)((double)frame.height * 0.33);
        } else if (orientation == 2) {
            int legendPositionX = p.getLegendRect().x;
            int legendPositionY = p.getLegendRect().y + p.getLegendRect().height;
            maxDimension.width = Math.max(16000 - legendPositionX, 0);
            maxDimension.height = Math.max(16000 + legendPositionY, 0);
        } else {
            throw new RuntimeException("Not Implemented!!!!");
        }
        int maxCols = Math.max(maxDimension.width / (dMinSize.width + LegendObj.getHSpacing(p)), 1);
        int maxRows = Math.max(maxDimension.height / (dMinSize.height + LegendObj.getVSpacing(p)), 1);
        return new Dimension(maxCols, maxRows);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Dimension getNumRowsCols(Perspective p, Dimension dMinSize) {
        int numCols = p.getLegendMarkersPerRow();
        int numRows = 0;
        int orientation = LegendObj.getLegendOrientation(p);
        int numItems = LegendObj.getNumDrawItemsInLegend(p);
        Dimension maxLegendRowsCols = LegendObj.getMaxLegendRowsCols(p, dMinSize);
        int maxRows = maxLegendRowsCols.height;
        int maxCols = maxLegendRowsCols.width;
        if (numCols == 0) {
            if (orientation == 0) {
                numCols = LegendObj.calcSingleRowCol(numItems, maxRows, maxCols);
                numRows = LegendObj.calcSingleRowCol(numItems, numCols, maxRows);
                return new Dimension(numCols, numRows);
            } else {
                if (orientation != 1 && orientation != 2) throw new RuntimeException("Not Implemented!!!");
                numRows = LegendObj.calcSingleRowCol(numItems, maxCols, maxRows);
                numCols = LegendObj.calcSingleRowCol(numItems, numRows, maxCols);
            }
            return new Dimension(numCols, numRows);
        } else {
            numCols = Math.max(1, Math.min(maxCols, numCols));
            numRows = Math.max(1, LegendObj.calcSingleRowCol(numItems, numCols, maxRows));
        }
        return new Dimension(numCols, numRows);
    }

    private static int calcSingleRowCol(int numTotalItems, int numItemsPerGroup, int maxSubdividedGroups) {
        int numGroups = numTotalItems / numItemsPerGroup;
        if (numTotalItems % numItemsPerGroup > 0) {
            ++numGroups;
        }
        return Math.min(maxSubdividedGroups, numGroups);
    }

    static int getNumCols(Perspective p, Dimension dMinSize) {
        Dimension dimensionCount = LegendObj.getNumRowsCols(p, dMinSize);
        return dimensionCount.width;
    }

    static final int getNumRows(Perspective p, Dimension dMinSize) {
        Dimension dimensionCount = LegendObj.getNumRowsCols(p, dMinSize);
        return dimensionCount.height;
    }

    public static final int getLegendOrientation(Perspective p) {
        int legendOrientation = p.getLegendOrient();
        if (legendOrientation == 2) {
            int pos = p.getLegendPosition();
            switch (pos) {
                case 0: {
                    boolean isTallerThanWide;
                    Rectangle legendRect = p.getLegendRect();
                    boolean bl = isTallerThanWide = legendRect.height > legendRect.width;
                    if (isTallerThanWide) {
                        legendOrientation = 0;
                        break;
                    }
                    legendOrientation = 1;
                    break;
                }
                case 1: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    legendOrientation = 1;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    legendOrientation = 0;
                }
            }
        }
        if (LegendObj.isExtendedLegend(p)) {
            legendOrientation = 0;
        }
        return legendOrientation;
    }

    private static final void draw(Perspective p) {
        IdentObj legendAreaId = Identity.LegendArea;
        AnnotationBox.calcBorderedBox(p, legendAreaId, p.getLegendRect(), true);
    }

    public static final int getSeriesStart(Perspective p) {
        int nSeriesStart = p.getLegendSeriesStart();
        if (nSeriesStart < 0) {
            nSeriesStart = 0;
        }
        return nSeriesStart;
    }

    public static final int getSeriesRange(Perspective p) {
        int offset = LegendObj.getSeriesStart(p);
        int count = p.getLegendSeriesCount();
        int numItems = LegendObj.getNumItemsInLegend(p);
        if (count == 0) {
            count = numItems;
        }
        return offset + count;
    }

    public static final int getNumDrawItemsInLegend(Perspective p) {
        int numItems = p.getLegendSeriesCount();
        if (numItems == 0) {
            numItems = LegendObj.getNumItemsInLegend(p);
            int nSeriesStart = LegendObj.getSeriesStart(p);
            if ((numItems -= nSeriesStart) < 0) {
                numItems = 0;
            }
        }
        return numItems;
    }

    public static final int getNumItemsInLegend(Perspective p) {
        int numItems = p.getLegendSeriesCount();
        if (numItems == 0) {
            numItems = LegendMarkersLabels.getNumLabels(p);
        } else if (LegendObj.isExtendedLegend(p)) {
            ++numItems;
        }
        return numItems;
    }

    public static final void toString(Perspective p) {
        System.out.println("num items = " + LegendObj.getNumItemsInLegend(p));
        System.out.println("num draw items = " + LegendObj.getNumDrawItemsInLegend(p));
        System.out.println("start index = " + LegendObj.getSeriesStart(p));
        System.out.println("range = " + LegendObj.getSeriesRange(p));
        System.out.println("legend orientation = " + LegendObj.getLegendOrientation(p));
        System.out.println("getLegendOrient in look = " + p.getLegendOrient());
        Dimension dMinSize = LegendObj.getMinCellSize(p);
        int cols = LegendObj.getNumCols(p, dMinSize);
        System.out.println("num cols = " + cols);
        System.out.println("num rows = " + LegendObj.getNumRows(p, dMinSize));
        System.out.println("rect = " + p.getLegendRect());
        System.out.println("cell size = " + LegendObj.getCellSize(p, dMinSize));
        System.out.println("min cell size = " + dMinSize);
        System.out.println("marker size = " + LegendObj.getMarkerSize(p));
        System.out.println("max label size = " + LegendObj.getMaxLegendLabel(p));
        System.out.println("isLabelBeside = " + LegendObj.isLabelBeside(p));
        System.out.println("h spacing = " + LegendObj.getHSpacing(p));
        System.out.println("v spacing = " + LegendObj.getVSpacing(p));
        System.out.println("marker spacing = " + LegendObj.getMarkerSpacing(p));
    }

    public static boolean isExtendedLegend(Perspective perspective) {
        JGraphType jgt = perspective.getJGraphType();
        if (perspective.getLegendLabelType() <= 0) {
            return false;
        }
        if (jgt.isPieType()) {
            if (jgt.isMultiPieType()) {
                return perspective.getNumTotalGroups() == 1;
            }
            return true;
        }
        if (jgt.isFunnelType()) {
            return perspective.getNumTotalGroups() == 1;
        }
        return false;
    }

    static final List<String> calcLegendValues(Perspective p) {
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(p, p.getAccess());
        int numSeries = sEnum.size();
        ArrayList<String> values = new ArrayList<String>(numSeries);
        ProportionalChart chart = null;
        JChart_Base graph = p.getGraphObject();
        if (!(graph instanceof ProportionalChart)) {
            return values;
        }
        chart = (ProportionalChart)((Object)graph);
        Format format = null;
        format = p.getPieValueFormat() == 0 ? NumberFormat.getInstance() : chart.getTextFormat();
        for (int iSeries = 0; iSeries < numSeries; ++iSeries) {
            boolean sliceExists = false;
            for (int idx = 0; idx < chart.getNPieces(); ++idx) {
                if (chart.getNthPieceSeries(idx) != iSeries || chart.getNthPieceGroup(idx) != 0) continue;
                sliceExists = true;
                values.add(format.format(chart.getNthPieceValue(idx)));
                break;
            }
            if (sliceExists) continue;
            values.add(format.format(0));
        }
        values.add(format.format(chart.getTotal()));
        return values;
    }

    static final List<String> calcLegendPercentages(Perspective p) {
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(p, p.getAccess());
        int numSeries = sEnum.size();
        ArrayList<String> percentages = new ArrayList<String>(numSeries);
        ProportionalChart chart = null;
        JChart_Base graph = p.getGraphObject();
        if (!(graph instanceof ProportionalChart)) {
            return percentages;
        }
        chart = (ProportionalChart)((Object)graph);
        Format format = null;
        if (p.getPieValueFormat() == 0) {
            format = p.getY1DataTextFormat();
        } else {
            NumberFormat numformat = NumberFormat.getPercentInstance();
            numformat.setMinimumFractionDigits(1);
            numformat.setMaximumFractionDigits(1);
            format = numformat;
        }
        for (int iSeries = 0; iSeries < numSeries; ++iSeries) {
            boolean sliceExists = false;
            if (chart.getNPieces() > 0) {
                int currGroup = chart.getNthPieceGroup(0);
                for (int idx = 0; idx < chart.getNPieces(); ++idx) {
                    int s = chart.getNthPieceSeries(idx);
                    int g = chart.getNthPieceGroup(idx);
                    if (s != iSeries || g != currGroup) continue;
                    sliceExists = true;
                    percentages.add(format.format(chart.getNthPiecePercent(idx)));
                    break;
                }
            }
            if (sliceExists) continue;
            percentages.add(format.format(0));
        }
        percentages.add(format.format(1));
        return percentages;
    }
}

