/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataTextPosition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Bar2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Standard;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IHistogramAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.Format;

class JChart_2D_Hist
extends JChart_2D_Standard {
    private int[] m_buckets;
    private int m_numBuckets;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Hist(perspective);
        }
    };

    private JChart_2D_Hist(Perspective perspective) {
        super(perspective);
    }

    public void calc() {
        super.calc();
        this.m_bar2D = new Bar2D(this.m_Perspective, this.getDrawContainer(), this.wantDepthEffect() ? this.m_depth2D : null);
        this.calcDataLabels();
        this.drawRisers();
        this.drawUserLines();
        this.drawDataLabels();
    }

    protected Rectangle calcDataValuePosition(int s, int bucket, int nDataTextPosition, int nDataTextPositionSecondary, Dimension dimLabel) {
        DataTextPosition dataTextPos = new DataTextPosition(nDataTextPosition, nDataTextPositionSecondary, this.m_Perspective.getJGraphType(), this.getFrame().getDepthOffset(1.0), this.getBaseCoord(0), this.getCoords(s, bucket), 0, dimLabel, this.m_depth2D.getSeriesFrontOffset(0), this.m_buckets[bucket], 0.0, 0.0, this.m_bHorz, !this.getY1Axis().isDescending(), this.m_Perspective.getDataTextAngle(s, bucket), this.m_Perspective.getDataTextRadius(s, bucket), this.m_bIsComboWithNonBar, 0, false, false);
        return dataTextPos.calcPosition();
    }

    protected void calcDataLabels() {
        int series = 0;
        for (int bucket = 0; bucket < this.m_numBuckets; ++bucket) {
            if (!this.m_DataLabels.wantDataLabel(series, bucket)) continue;
            this.m_DataLabels.setDataValue(this.m_buckets[bucket], series, bucket);
            this.m_DataLabels.setDataText(this.getDataString(this.m_buckets[bucket], series, bucket), series, bucket);
        }
    }

    protected String getDataString(double value, int s, int b) {
        String template = this.m_Perspective.getDataTextTemplate(s, b);
        String resultString = this.getY1Axis().getDataTextFormat().format(value);
        resultString = TextUtil.ReplaceMacro(template, "[DATA]", resultString);
        resultString = TextUtil.ReplaceMacro(resultString, "[SERIES]", this.m_Perspective.getSeriesLabel(s));
        Format format = this.getX1Axis().getLabelFormat();
        String intervalStart = format.format(this.getX1HistAxis().getIntervalStart(b));
        String intervalStop = format.format(this.getX1HistAxis().getIntervalStop(b));
        String intervalString = "[" + intervalStart + ", " + intervalStop + "]";
        resultString = TextUtil.ReplaceMacro(resultString, "[INTERVAL]", intervalString);
        return resultString;
    }

    private void calcBuckets() {
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        double fValue = 0.0;
        this.m_numBuckets = this.getX1HistAxis().getNumIntervals() - 1;
        this.m_buckets = new int[this.m_numBuckets];
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            block1: while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                boolean bDataOK = true;
                DatumObj dObj = this.getDataValue(s, g);
                fValue = dObj.value;
                bDataOK = dObj.m_bOK;
                if (!bDataOK) continue;
                for (int nInterval = 0; nInterval < this.m_numBuckets; ++nInterval) {
                    if (!(fValue >= this.getX1HistAxis().getIntervalStart(nInterval)) || !(fValue < this.getX1HistAxis().getIntervalStop(nInterval))) continue;
                    int n = nInterval;
                    this.m_buckets[n] = this.m_buckets[n] + 1;
                    continue block1;
                }
            }
        }
    }

    protected Point getCoords(int s, int g) {
        int low = this.getX1HistAxis().getLowIntervalCoord(g);
        int high = this.getX1HistAxis().getHighIntervalCoord(g);
        int center = (low + high) / 2;
        int extent = (int)this.getY1Axis().getValueCoord(this.m_buckets[g]);
        if (this.m_bHorz) {
            return new Point(extent, center);
        }
        return new Point(center, extent);
    }

    protected INumericAxis createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, false, null);
        return AxisFactory.createHistogramAxis(this.m_Perspective, this.getDataView(), AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
    }

    protected INumericAxis createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        this.calcBuckets();
        MinMaxObj y1MinMaxObj = this.findHistLimits();
        return AxisFactory.createHistogramAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
    }

    private IHistogramAxis getX1HistAxis() {
        return (IHistogramAxis)this.getX1Axis();
    }

    private void drawRisers() {
        boolean bDescendingX1 = this.getX1Axis().isDescending();
        boolean bDescendingY1 = this.getY1Axis().isDescending();
        for (int bucket = 0; bucket < this.m_numBuckets; ++bucket) {
            int top;
            int bottom;
            int right;
            int left;
            IBlackBox blackBox = this.assignSeriesColor(0, bucket);
            int low = this.getX1HistAxis().getLowIntervalCoord(bucket);
            int high = this.getX1HistAxis().getHighIntervalCoord(bucket);
            if (this.m_gt.isOrientHorz()) {
                left = (int)this.getY1Axis().getValueCoord(bDescendingY1 ? (double)this.m_buckets[bucket] : 0.0);
                right = (int)this.getY1Axis().getValueCoord(bDescendingY1 ? 0.0 : (double)this.m_buckets[bucket]);
                bottom = bDescendingX1 ? high : low;
                top = bDescendingX1 ? low : high;
            } else {
                bottom = (int)this.getY1Axis().getValueCoord(bDescendingY1 ? (double)this.m_buckets[bucket] : 0.0);
                top = (int)this.getY1Axis().getValueCoord(bDescendingY1 ? 0.0 : (double)this.m_buckets[bucket]);
                left = bDescendingX1 ? high : low;
                right = bDescendingX1 ? low : high;
            }
            Rectangle rVirt = new Rectangle(left, bottom, Math.abs(right - left), Math.abs(top - bottom));
            this.m_bar2D.draw(0, bucket, rVirt, blackBox, this.m_rClip);
        }
    }

    private MinMaxObj findHistLimits() {
        int max = 0;
        for (int i = 0; i < this.m_numBuckets; ++i) {
            if (this.m_buckets[i] <= max) continue;
            max = this.m_buckets[i];
        }
        return new MinMaxObj(0.0, max);
    }

    public boolean wantLegend() {
        return false;
    }
}

