/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;

public class GraphicsUtil {
    public static int NONE = -1;
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int TOP_LEFT = 2;
    public static final int TOP_RIGHT = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 5;
    public static final int BOTTOM = 6;
    public static final int BOTTOM_LEFT = 7;
    public static final int BOTTOM_RIGHT = 8;
    public static final Insets DEFAULT_INSETS = new Insets(200, 200, 200, 200);
    public static final Insets DEFAULT_BORDER_WIDTH = new Insets(0, 0, 0, 0);
    public static final int DEFAULT_LINE_WIDTH = 1;

    public static Polygon toPolygon(Shape shape) throws NullPointerException {
        double FLATNESS = 1.0;
        FlatteningPathIterator pi = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        Polygon p = new Polygon();
        while (!pi.isDone()) {
            double[] seg = new double[6];
            int segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    p.addPoint((int)seg[0], (int)seg[1]);
                    break;
                }
                case 1: {
                    p.addPoint((int)seg[0], (int)seg[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal seg type : " + segType);
                }
            }
            pi.next();
        }
        return p;
    }

    public static void translatePointByOrientation(Rectangle aRect, int theOrientation) {
        int width = 0;
        int height = 0;
        switch (theOrientation) {
            case 0: {
                width = aRect.width / 2;
                height = aRect.height / 2;
                aRect.x -= width;
                aRect.y -= height;
                break;
            }
            case 1: {
                width = aRect.width / 2;
                aRect.x -= width;
                break;
            }
            case 2: {
                aRect.x -= aRect.width;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                height = aRect.height / 2;
                aRect.y -= height;
                aRect.x -= aRect.width;
                break;
            }
            case 5: {
                height = aRect.height / 2;
                aRect.y -= height;
                break;
            }
            case 6: {
                width = aRect.width / 2;
                aRect.x -= width;
                aRect.y -= aRect.height;
                break;
            }
            case 7: {
                aRect.x -= aRect.width;
                aRect.y -= aRect.height;
                break;
            }
            case 8: {
                aRect.y -= aRect.height;
                break;
            }
        }
    }

    public static Point getLinkPointByOrientation(Rectangle aRect, int theOrientation) {
        Rectangle rect = new Rectangle(aRect);
        int width = 0;
        int height = 0;
        switch (theOrientation) {
            case 0: {
                width = rect.width / 2;
                height = rect.height / 2;
                rect.x += width;
                rect.y += height;
                break;
            }
            case 1: {
                width = rect.width / 2;
                rect.x += width;
                rect.y += rect.height;
                break;
            }
            case 2: {
                rect.y += rect.height;
                break;
            }
            case 3: {
                rect.x += rect.width;
                rect.y += rect.height;
                break;
            }
            case 4: {
                height = rect.height / 2;
                rect.y += height;
                break;
            }
            case 5: {
                height = rect.height / 2;
                rect.y += height;
                rect.x += rect.width;
                break;
            }
            case 6: {
                width = rect.width / 2;
                rect.x += width;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                rect.x += rect.width;
                break;
            }
        }
        return rect.getLocation();
    }

    public static void shiftLocationByBox(Rectangle aRect, int theOrientation) {
        switch (theOrientation) {
            case 0: {
                break;
            }
            case 1: {
                aRect.y += aRect.height;
                break;
            }
            case 2: {
                aRect.x -= aRect.width;
                aRect.y += aRect.height;
                break;
            }
            case 3: {
                aRect.x += aRect.width;
                aRect.y += aRect.height;
                break;
            }
            case 4: {
                aRect.x -= aRect.width;
                break;
            }
            case 5: {
                aRect.x += aRect.width;
                break;
            }
            case 6: {
                aRect.y -= aRect.height;
                break;
            }
            case 7: {
                aRect.x -= aRect.width;
                aRect.y -= aRect.height;
                break;
            }
            case 8: {
                aRect.x += aRect.width;
                aRect.y -= aRect.height;
                break;
            }
        }
    }

    public static void correctAdjustedRectPositionRelativeToOrientation(Rectangle aRect, int offset, int theOrientation) {
        switch (theOrientation) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                aRect.y += offset / 2;
                break;
            }
            case 5: {
                aRect.y += offset / 2;
                break;
            }
            case 6: {
                aRect.y += offset;
                break;
            }
            case 7: {
                aRect.y += offset;
                break;
            }
            case 8: {
                aRect.y += offset;
                break;
            }
        }
    }

    public static Color darker(Color startColor, Color endColor, double tintValue) {
        int red = startColor.getRed();
        int green = startColor.getGreen();
        int blue = startColor.getBlue();
        int tintRed = endColor.getRed();
        int tintGreen = endColor.getGreen();
        int tintBlue = endColor.getBlue();
        int resultRed = GraphicsUtil.lerp(red, tintRed, tintValue);
        int resultGreen = GraphicsUtil.lerp(green, tintGreen, tintValue);
        int resultBlue = GraphicsUtil.lerp(blue, tintBlue, tintValue);
        return new Color(resultRed, resultGreen, resultBlue);
    }

    public static Color brighten(Color color, double v) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        r = Math.min(r + (int)((double)(255 - r) * v), 255);
        g = Math.min(g + (int)((double)(255 - g) * v), 255);
        b = Math.min(b + (int)((double)(255 - b) * v), 255);
        return new Color(r, g, b);
    }

    private static int lerp(int startColorVal, int endColorVal, double tintVal) {
        return (int)((double)startColorVal + (double)(endColorVal - startColorVal) * tintVal);
    }
}

