/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;

class DetLine
extends DetObj {
    private Point m_pt1;
    private Point m_pt2;
    private BasicStroke penStroke;

    DetLine(IDrawContainer container, IdentObj id, int x1, int y1, int x2, int y2, IBlackBox blackBox, Stroke stroke, Rectangle clipRect) {
        super(container, id, blackBox, clipRect);
        this.m_pt1 = new Point(x1, y1);
        this.m_pt2 = new Point(x2, y2);
        this.penStroke = (BasicStroke)stroke;
    }

    public Point getBeginPoint() {
        return new Point(this.m_pt1);
    }

    public Point getEndPoint() {
        return new Point(this.m_pt2);
    }

    public void hilite(Graphics2D g, VC vc) {
        Point pt1 = vc.virtToDest(new Point(this.m_pt1.x, this.m_pt1.y));
        Point pt2 = vc.virtToDest(new Point(this.m_pt2.x, this.m_pt2.y));
        g.setXORMode(Color.yellow);
        g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
        g.setPaintMode();
    }

    public void paintIt(Graphics2D g, VC vc) {
        this.blackBox.paintLine(g, vc.virtToDest(this.m_pt1), vc.virtToDest(this.m_pt2), this.penStroke);
    }

    public Shape getShape() {
        return new Line2D.Double(this.m_pt1, this.m_pt2);
    }
}

